/*
 * Model a collection of derived tags and a TagcollFilter to add them to a
 * collection
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/DerivedTags.h>
#include <tagcoll/coll/simple.h>


namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::tests;

struct tagcoll_derivedtags_shar {
};
TESTGRP(tagcoll_derivedtags);


template<> template<>
void to::test<1>()
{
	std::string input_coll(
			"a: coffee, milk\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar\n"
			);
	std::string output_coll(
			"a: coffee, milk, cappuccino\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar, sweet_cappuccino\n"
			);
	coll::Simple<string, string> result;
	DerivedTags derivations;

	derivations.add("cappuccino", Expression("coffee && milk && !sugar"));
	derivations.add("sweet_cappuccino", Expression("coffee && milk && sugar"));

	parseCollection(input_coll, addDerived(derivations, inserter(result)));

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

template<> template<>
void to::test<2>()
{
	std::string input_coll(
			"a: coffee, milk, cappuccino\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar, sweet_cappuccino\n"
			);
	std::string output_coll(
			"a: coffee, milk\n"
			"b: coffee\n"
			"c: milk\n"
			"d: coffee, milk, sugar\n"
			);
	coll::Simple<string, string> result;
	DerivedTags derivations;

	derivations.add("cappuccino", Expression("coffee && milk && !sugar"));
	derivations.add("sweet_cappuccino", Expression("coffee && milk && sugar"));

	parseCollection(input_coll, removeDerived(derivations, inserter(result)));

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

}

#include <tagcoll/TextFormat.tcc>
#include <tagcoll/tests/test-utils.tcc>

// vim:set ts=4 sw=4:
