#ifndef TAGCOLL_TDB_READONLY_DISK_INDEX_H
#define TAGCOLL_TDB_READONLY_DISK_INDEX_H

/** \file
 * Fast index for tag data, using a read-only database
 */

/*
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/TDBDiskIndex.h>
#include <tagcoll/PatchCollection.h>

namespace Tagcoll
{

/**
 * TDBDiskIndex operating on a read-only database, and storing the changes in a
 * PatchList.
 */
template<class ITEM, class TAG>
class TDBReadonlyDiskIndex : public PatchCollection<ITEM, TAG>
{
protected:
	TDBDiskIndex<ITEM, TAG> diskColl;

public:
	/**
	 * Create a new TDBDiskIndex
	 *
	 * @param pkgidx
	 *   The file name of the package index
	 * @param tagidx
	 *   The file name of the tag index
	 * @param fromitem, fromtag, toitem, totag
	 *   The Converter-s used to convert ITEMS and TAGS to and from strings.
	 *   If 0 is passed, this TDBDiskIndex will only be able to work with
	 *   string items and string tags.
	 */
	TDBReadonlyDiskIndex(
			const std::string& pkgidx,
			const std::string& tagidx,
			Converter<ITEM, std::string>& fromitem,
			Converter<TAG, std::string>& fromtag,
			Converter<std::string, ITEM>& toitem,
			Converter<std::string, TAG>& totag) :
		PatchCollection<ITEM, TAG>(diskColl),
		diskColl(pkgidx, tagidx, fromitem, fromtag, toitem, totag, false) {}
	virtual ~TDBReadonlyDiskIndex() {}
};

};

// vim:set ts=4 sw=4:
#endif
