#ifndef STDIOPARSERINPUT_H
#define STDIOPARSERINPUT_H

/** \file
 * Parser input using libc standard I/O functions
 */

/*
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/ParserBase.h>
#include <stdio.h>

#include <string>

namespace Tagcoll {

/**
 * Parser input using libc standard I/O functions
 */
class StdioParserInput : public ParserInput
{
protected:
	std::string _file;
	int _line;
	FILE* _in;
	bool _close_on_exit;
	
public:
	StdioParserInput(FILE* in, const std::string& fname, int line = 1) throw ();
	StdioParserInput(const std::string& fname) throw (FileException);
	virtual ~StdioParserInput() throw ();
	
	virtual const std::string& fileName() const throw () { return _file; }
	virtual int lineNumber() const throw () { return _line; }

	virtual int nextChar() throw (ParserInputException);
	virtual void pushChar(int c) throw (ParserInputException);
};

}

// vim:set ts=4 sw=4:
#endif
