/*
 * Consumer interface for a stream of tagged items
 *
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/Consumer.h>

#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
template class Consumer<std::string, std::string>;
}
#endif

#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

namespace tut {
using namespace tut_tagcoll;

struct tagcoll_consumer_shar {
};
TESTGRP(tagcoll_consumer);

template<> template<>
void to::test<1>()
{
	TestConsumer<string, string> cons;
	OpSet<string> tags;

	cons.consume("1");
	ensure(cons.items == 1);
	ensure(cons.tags == 0);

	cons.consume("1");
	ensure(cons.items == 2);
	ensure(cons.tags == 0);

	tags += "1";
	cons.consume("1", tags);
	ensure(cons.items == 3);
	ensure(cons.tags == 1);

	tags += "2";
	cons.consume("1", tags);
	ensure(cons.items == 4);
	ensure(cons.tags == 3);

	cons.consume(tags, tags);
	ensure(cons.items == 6);
	ensure(cons.tags == 7);
}

}

// vim:set ts=4 sw=4:
#endif
