/*
  * original code by  onemen
 */
var tabmixAddonManager;
try {
 Components.utils.import("resource://gre/modules/AddonManager.jsm");
 tabmixAddonManager = true;
 } catch(ex) {}

/*
 *  functions to disable incompatible extensions
 *  original code by mrtech local_install.js ,
 *                   code modified by onemen 2006-01-13
 *                   code modified by onemen 2010-03-22 - work with new AddonManager for firefox 3.7
 */
var tabmix_checkCompatibility = {
  DISABLE: 0,
  CANCEL: 1,
  DISABLE_AND_RESTART: 2,
  window: null,
  showList: null,
  callbackDialog: null,
  list: null,

  start: function TMP_EX_onStartup(aWindow, aShowList, aCallbackDialog) {
    this.window = aWindow || window;
    this.showList = aShowList;
    this.callbackDialog = aCallbackDialog;
    this.list = [];

    if (tabmixAddonManager)
      this.getIncompatibleList_New();
    else
      this.getIncompatibleList();
  },

  // for new AddonManager since Firefox 3.7 date ???????
  getIncompatibleList_New: function TMP_EX_getIncompatibleList_New() {
    function isPending(aAddon, aAction) {
      var action = AddonManager["PENDING_" + aAction.toUpperCase()];
      return !!(aAddon.pendingOperations & action);
    }

    var guid_list = this.getList();
    var self = this;
    AddonManager.getAddonsByTypes(["extension"], function(aAddonsList) {
      for (let i = 0; i < aAddonsList.length; i++) {
        let addon = aAddonsList[i];
        if (addon.id.toLowerCase() in  guid_list) {
          let disabled = addon.userDisabled;
          if ((!disabled && !isPending(addon, "disable") && !isPending(addon, "uninstall")) ||
                  (disabled && isPending(addon, "enable"))) {
            self.list.push({_name: addon.name, id: addon.id, _version: addon.version, toString:function() {return this._name.toLowerCase();}});
            if (!self.showList)
              break;
          }
        }
      }
      self.showResult();
    });
  },

  getIncompatibleList: function TMP_EX_getIncompatibleList() {
    var RDFService = Cc["@mozilla.org/rdf/rdf-service;1"]
               .getService(Ci.nsIRDFService);
    var Container = Cc["@mozilla.org/rdf/container;1"]
               .getService(Ci.nsIRDFContainer);
    var extensionDS = Cc["@mozilla.org/extensions/manager;1"]
               .getService(Ci.nsIExtensionManager).datasource;
    var root = "urn:mozilla:item:";

    try { // in ff 1.0.x we can get error at startup
      Container.Init(extensionDS, RDFService.GetResource(root + "root"));
    } catch (e) {
      tmLog("error in getExtensions " + e);
      return [];
    }

    function prop(elm, str) {
      var arc = RDFService.GetResource("http://www.mozilla.org/2004/em-rdf#" + str);
      var target = extensionDS.GetTarget(elm, arc, true);
      if (target instanceof Ci.nsIRDFLiteral ||
              target instanceof Ci.nsIRDFInt)
        return target.Value;
      return null;
    }

    var elements = Container.GetElements();
    var guid_list = this.getList();

    while (elements.hasMoreElements()) {
      var element=elements.getNext().QueryInterface(Ci.nsIRDFResource);
      var id = element.Value.replace(root, "");
      if (typeof guid_list[id.toLowerCase()] != "undefined") {
        var opType = prop(element, "opType");
        var disabled = prop(element, "userDisabled");
        if ((!disabled && opType != "needs-disable" && opType != "needs-uninstall") ||
                ( disabled && opType == "needs-enable")) {
          var name = prop(element, "name");
          this.list.push({_name: name, id: id, _version:prop(element, "version"), toString:function() {return this._name.toLowerCase();}});
        }
      }
    }
    this.showResult();
  },

  showResult: function TMP_EX_showResult() {
    let listNotEmpty = this.list.length > 0;
    let result = this.DISABLE;
    if (this.showList && listNotEmpty) {
      // we don't get here from TMP otion dialog unles the list was not empty
      result = this.warnAboutIncompatible();
      if (result != this.CANCEL)
        this.doDisable(result);
    }

     // show/hide Error panel in Tabmix Options Dialog
    if (this.callbackDialog) {
      let hideButton = this.showList ? result != this.CANCEL : !listNotEmpty;
      this.window.gIncompatiblePane.hide_IncompatibleNotice(hideButton, this.showList);
    }
  },

  doDisable: function TMP_EX_doDisable(aResult) {
    var list = this.list;
    if (tabmixAddonManager) {
      list.forEach(function(aAddonToDisable) {
        AddonManager.getAddon(aAddonToDisable.id, function(aAddon) {
          aAddon.userDisabled = true;
        })
      });
    }
    else {
      var extensionManager = Cc["@mozilla.org/extensions/manager;1"]
                               .getService(Ci.nsIExtensionManager);
      for ( i = 0; i < list.length; i++ ) {
        try{
          extensionManager.disableItem(list[i].id);
        } catch(e) {
          tmLog("error while disabled " + list[i]._name);
        }
      }

      var dataSource = extensionManager.datasource.QueryInterface(Ci.nsIRDFRemoteDataSource);
      if (dataSource)
        dataSource.Flush();
    }

    this.restart(aResult == this.DISABLE_AND_RESTART);
  },

  warnAboutIncompatible: function TMP_EX_warnAboutIncompatible() {
    var list = this.list;
    try {
      list.sort();
    } catch(ex) { }

    var outStr = "";
    for ( let i = 0; i < list.length; i++ ) {
      let name = list[i]._name;
      name = name.charAt(0).toUpperCase() + name.substr(1);
      outStr += " - " + name + " " + list[i]._version + "\n";
    }

    var showatStart = gTabmixPrefs.getBoolPref("extensions.tabmix.disableIncompatible")
    var chkBoxState = showatStart ? CHECKBOX_CHECKED : CHECKBOX_UNCHECKED;

    var bundleID = "tmp-string-bundle"
    var _stingBundle = document.getElementById(bundleID);
    var title = _stingBundle.getString("incompatible.title");
    var msg = _stingBundle.getString("incompatible.msg0") + "\n"
            + _stingBundle.getString("incompatible.msg1") + "\n\n" + outStr + "\n\n";
    var chkBoxLabel = _stingBundle.getString("incompatible.chkbox.label");
    var buttons = [SessionManager.setLabel("incompatible.button0", bundleID),
            SessionManager.setLabel("incompatible.button1", bundleID)];
    buttons.push(SessionManager.setLabel("incompatible.button2", bundleID));

    var result = TM_PromptService([BUTTON_EXTRA1, HIDE_MENUANDTEXT, chkBoxState],[title, msg, "", chkBoxLabel, buttons.join("\n")], this.window);
    if (result.checked != showatStart) {
      gTabmixPrefs.setBoolPref("extensions.tabmix.disableIncompatible", result.checked);
      gTabmixPrefs.savePrefFile(null); // store the pref immediately
    }

    return result.button;
  },

  restart: function TMP_EX_restart(aRestart) {
    if (aRestart && canQuitApplication()) {
      var appStartup = Ci.nsIAppStartup;
      Cc["@mozilla.org/toolkit/app-startup;1"]
                  .getService(appStartup).quit(appStartup.eRestart | appStartup.eAttemptQuit);
    }
    else {
      let _stingBundle = document.getElementById("tmp-string-bundle");
      let title = _stingBundle.getString("incompatible.title");
      let msg = _stingBundle.getString("incompatible.msg2");
      let buttons = ["", SessionManager.setLabel("sm.button.continue")].join("\n");
      TM_PromptService([BUTTON_CANCEL, HIDE_MENUANDTEXT, HIDE_CHECKBOX],[title, msg, "", "", buttons], this.window);
    }
  },

  getList: function TMP_EX_getList() {
    var guid_list = {};
/*
  // for test
    guid_list['{95e8e4c1-75e2-421c-bebc-f171a874ecdb}'] = true;
    guid_list['{9669cc8f-b388-42fe-86f4-cb5e7f5a8bdc}'] = true;
    guid_list['{1280606b-2510-4fe0-97ef-9b5a22eafe80}'] = true;
    guid_list['{03721830-b4cb-11d9-9669-0800200c9a66}'] = true;
    guid_list['{34681369-ed38-40f5-ac4f-54788aad065c}'] = true;
    guid_list['{c671b520-abe9-11d8-8ebc-000c6e787bf7}'] = true;
    guid_list['{c8500d90-d72d-11d9-8cd5-0800200c9a66}'] = true;
    guid_list['{d10d0bf8-f5b5-c8b4-a8b2-2b9879e08c5d}'] = true;
    guid_list['{d650973c-0444-4ac7-9d00-19e3613c83b9}'] = true;
    guid_list['{da677c80-7714-11de-8a39-0800200c9a66}'] = true;
    guid_list['{de5809e0-2b07-11dd-bd0b-0800200c9a66}'] = true;
    guid_list['{eda7b1d7-f793-4e03-b074-e6f303317fb0}'] = true;
    guid_list['cfxec@triton'] = true;
    guid_list['chromifox@altmusictv.com'] = true;
    guid_list['crystalfox_qute@bigredbrent'] = true;
    guid_list['ie8@fox.theme'] = true;
    guid_list['inspector@mozilla.org'] = true;
    guid_list['silvermel@pardal.de'] = true;
    guid_list['winstripemodern35@webdesigns.ms11.net'] = true;
    guid_list['winstriperealfox@thunderseb.be'] = true;
    guid_list['{dc572301-7619-498c-a57d-39143191b318}'] = true;
    return guid_list;
*/
//   guid_list['inspector@mozilla.org'] = true;
    /*
     *  The following extensions are integrated or incompatible with Tab Mix Plus
     *
     *  Add extensions ID in lowercase.
     */
    guid_list['{00bdd586-51fb-4b06-9c23-af2fb7609bf3}'] = true;   //   Basics
    guid_list['{b98719b3-76d6-4bec-aeed-3ab542b23bd7}'] = true;   //   BlankLast
    guid_list['{47921160-3085-4023-a145-8ec466babfba}'] = true;   //   Click2Tab
    guid_list['{b0f9cad2-ebae-4685-b518-d3d9b41ea183}'] = true;   //   Close Tab On Double Click
    guid_list['ctc@clav.mozdev.org'] = true;                      //   CTC
    guid_list['{61ed2a9a-39eb-4aaf-bd14-06dfbe8880c3}'] = true;   //   Duplicate Tab
    guid_list['flowtabs'] = true;                                 //   Flowing Tabs
    guid_list['{cd2b821e-19f9-40a7-ac5c-08d6c197fc43}'] = true;   //   FLST
    guid_list['{68e5dd30-a659-4987-99f9-eaf21f9d4140}'] = true;   //   LastTab
    guid_list['minit@dorando'] = true;                            //   MiniT
    guid_list['minit-drag'] = true;                               //   miniT-drag
    guid_list['minit-tabscroll@dorando'] = true;                  //   miniT-tabscroll
    guid_list['new-tab-button-on-tab-bar@mikegoodspeed.com']  = true;   //   new tab button on tab bar
    guid_list['{66e978cd-981f-47df-ac42-e3cf417c1467}'] = true;   //   new tab homepage
    guid_list['newtaburl@sogame.cat'] = true;                     //   NewTabURL
    guid_list['{4b2867d9-2973-42f3-bd9b-5ad30127c444}'] = true;   //   Petite Tabbrowser Extensions
    guid_list['{888d99e7-e8b5-46a3-851e-1ec45da1e644}'] = true;   //   ReloadEvery
    guid_list['{aede9b05-c23c-479b-a90e-9146ed62d377}'] = true;   //   Reload Tab On Double-Click
    guid_list['{492aa940-beaa-11d8-9669-0800200c9a66}'] = true;   //   Scrollable Tabs
    guid_list['{eb922232-fd76-4eb0-bd5a-c1cba4238343}'] = true;   //   Single Window
    guid_list['{149c6cc6-ec62-4ebd-b719-3c2e867930c7}'] = true;   //   Stack style tabs
    guid_list['supert@studio17.wordpress.com'] = true;            //   superT
    guid_list['tabbin'] = true;                                   //   Tab Bin
    guid_list['{43520b8f-4107-4351-ac64-9bcc5eea24b9}'] = true;   //   Tab Clicking Options
    guid_list['{bea6d1a7-882d-425f-bc75-944e0063ff3b}'] = true;   //   Tab Mix [original one]
    guid_list['tabtowindow@sogame.cat'] = true;                   //   Tab to window
    guid_list['tabx@clav.mozdev.org'] = true;                     //   Tab X
    guid_list['{0b0b0da8-08ba-4bc6-987c-6bc9f4d8a81e}'] = true;   //   Tabbrowser Extensions
    guid_list['{9b9d2aaa-ae26-4447-a7a1-633a32b19ddd}'] = true;   //   Tabbrowser Preferences
    guid_list['tabdrag'] = true;                                  //   tabdrag-for-tablib
    guid_list['tabfx@chaosware.net'] = true;                      //   TabFX
    guid_list['tabsopenrelative@jomel.me.uk'] = true;             //   Tabs open ralative
    guid_list['tablib'] = true;                                   //   tablib
    guid_list['{328bbe91-cb86-40b0-a3fd-2b39969f9faa}'] = true;   //   Undo Close Tab
    guid_list['undoclosetab@dorando'] = true;                     //   Undo Close Tab
    guid_list['{99ec6690-8bb1-11da-a72b-0800200c9a66}'] = true;   //   Unread Tabs
    // updated 2009-08-01
    guid_list['undoclosedtabsbutton@supernova00.biz'] = true;     //   Undo closed button
    guid_list['remove-new-tab-button@forerunnerdesigns.com'] = true;//   Remove new tab button
    guid_list['last-tab-close-button@victor.sacharin'] = true;    //   Last tab close button
    return guid_list;
  }
}

// Look for RSS/Atom News Reader
function TMP_LookForRSS() {
   if ("gotoLink" in window)
      TMP_wizzrss.init();

   if ("openNewsfox" in window)
      TMP_Newsfox.init();

   if ("RSSTICKER" in window)
      TMP_RSSTICKER.init();
}

var TMP_RSSTICKER = {
   init : function ()  {
     eval("RSSTICKER.writeFeed ="+RSSTICKER.writeFeed.toString().replace(
       'tbb.setAttribute("onclick"',
       'tbb.setAttribute("onclick", "this.onClick(event);");\
        tbb.setAttribute("_onclick"'
     ).replace(
       'tbb.onContextOpen =',
       'tbb.onContextOpen = TMP_RSSTICKER.onContextOpen; \
        tbb.onClick = TMP_RSSTICKER.onClick; \
        tbb._onContextOpen ='
     ));
   },

   onClick : function (event) {
     if (event.ctrlKey) {
       this.markAsRead(true);
     }
     else if ((this.parent.alwaysOpenInNewTab && (event.which == 1)) || (event.which == 2)) {
       this.onContextOpen("tab");
     }
     else if (event.which == 1) {
       this.onContextOpen();
     }
   },

   onContextOpen : function (target) {
     if (!target) {
       if (TMP_whereToOpen(null).lock)
         this.parent.browser.openInNewTab(this.href);
       else
         window._content.document.location.href = this.href;
     }
     else if (target == "window") {
       if (gSingleWindowMode)
         this.parent.browser.openInNewTab(this.href);
       else
         window.open(this.href);
     }
     else if (target == "tab") {
       this.parent.browser.openInNewTab(this.href);
     }

     this.markAsRead();
   }
}

// prevent Wizz RSS from load pages in locked tabs
var TMP_wizzrss = {
   init : function ()  {
      var codeToReplace = /getContentBrowser\(\).loadURI|contentBrowser.loadURI/;
      const newCode = "TMP_wizzrss.openURI";
      var _functions = ["addFeedbase","validate","gohome","tryagain","promptStuff","promptStuff",
                        "doSearch","viewLog","renderItem","playEnc","renderAllEnc","playAllEnc",
                        "gotoLink","gotoLink","itemLinkClick","itemLinkClick","itemListClick"];

      _functions.forEach(
         function(_function) {
            if (_function in window)
               eval("window." + _function + " ="+ window[_function].toString()
                  .replace(codeToReplace,newCode));
         }
      );
   },

   openURI : function (uri)  {
      var w = Components.classes['@mozilla.org/appshell/window-mediator;1']
                                 .getService(Components.interfaces.nsIWindowMediator)
                                 .getMostRecentWindow("navigator:browser");
      // we get here from other extension use getBrowser() for Firefox 3.0
      var tabBrowser = w.getBrowser();

      var openNewTab = w.TMP_whereToOpen(true).lock;
      if (openNewTab) {
         var theBGPref = !readPref("WizzRSSFocusTab", false, 2);
         if (gIsFirefox36)
           tabBrowser.loadOneTab(uri, {inBackground: theBGPref});
         else
           tabBrowser.loadOneTab(uri, null, null, null, theBGPref);
      }
      else
         tabBrowser.loadURI(uri);
   }
}

// prevent Newsfox from load pages in locked tabs
var TMP_Newsfox = {
   init : function ()  {
      eval("openNewsfox ="+openNewsfox.toString().replace(
         'if (newTab) {',
         'newTab = newTab || TMP_whereToOpen(null).lock; \ $&'
      ));
   }
}

var TMP_TabGroupsManager = {
  init: function (tabBar) {
    // for firefox 3.0
    tabBar.__defineGetter__("lastTabVisible", function () {return TabGroupsManagerApiForTMPVer1.lastTabVisible;});

    // replace gBrowser.tabContainer.lastChild with current group lastChild
    var selectedGroupLastChild = "TabGroupsManagerApiVer1.lastTab";
    eval("tabBar.adjustNewtabButtonvisibility ="+tabBar.adjustNewtabButtonvisibility.toString().replace(
      /this\.lastChild/g, selectedGroupLastChild
    ));

    var _getter = tabBar.__lookupGetter__("lastTabRowNumber");
    eval("_getter ="+_getter.toString().replace("this.lastChild", selectedGroupLastChild));
    tabBar.__defineGetter__("lastTabRowNumber", _getter);

    var selectedGroupTabs = "TabGroupsManagerApiVer1.visibleTabs";
    eval("tabBar.adjustScrollTabsRight ="+tabBar.adjustScrollTabsRight.toString().replace(
      /this\.childNodes/g, selectedGroupTabs
    ));

    eval("tabBar.rowScroll ="+tabBar.rowScroll.toString().replace("this.childNodes", selectedGroupTabs));

    _getter = tabBar.__lookupGetter__("collapsedTabs");
    var _setter = tabBar.__lookupSetter__("collapsedTabs");
    tabBar.__defineGetter__("collapsedTabs", _getter);
    eval("_setter ="+_setter.toString().replace("this.childNodes", selectedGroupTabs));
    tabBar.__defineSetter__("collapsedTabs", _setter);

    tabBar.__defineGetter__("topTabY", this._getTopTabY);

    // only allow to show tabs from the current group
    eval("tabBar.isTabVisible="+tabBar.isTabVisible.toString().replace(
      'this.childNodes', selectedGroupTabs
    ).replace(
      '{',
      '{aIndex = TabGroupsManagerApiVer1.getIndexInSelectedGroupFrom_tPos(aIndex);'
    ));

    eval("tabBar.ensureTabIsVisible="+tabBar.ensureTabIsVisible.toString().replace(
      'this.childNodes', selectedGroupTabs
    ).replace(
      'const tabs',
      'aIndex = TabGroupsManagerApiVer1.getIndexInSelectedGroupFrom_tPos(aIndex); $&'
    ));

    eval("tabBar._notifyBackgroundTab="+tabBar._notifyBackgroundTab.toString().replace(
      'this.childNodes', selectedGroupTabs
    ).replace(
      'this.selectedIndex >= this.collapsedTabs',
      'TabGroupsManagerApiVer1.getIndexInSelectedGroupFrom_tPos(this.selectedIndex) >= this.collapsedTabs'
    ));

    // make scrool button show hidden tabs only from the current group
    eval("createCommonList="+createCommonList.toString().replace(
      'tabs = gBrowser.tabs;',
      'tabs = side ? ' + selectedGroupTabs + ' : gBrowser.tabs;'
    ));

    eval("TMP_Places.openGroup="+TMP_Places.openGroup.toString().replace("tabBar.childNodes", selectedGroupTabs));

    eval("toggleUnderlineTabsLabel="+toggleUnderlineTabsLabel.toString().replace('tabBar.childNodes', selectedGroupTabs));

    eval("TMP_eventListener.onTabOpen="+TMP_eventListener.onTabOpen.toString().replace(
      'this.onTabOpen_updateTabBar(aTab);',
      'try {if (TabGroupsManager.apiEnabled) TabGroupsManager.eventListener.onTabOpen(aEvent);} catch(e) { }'
    ));

    eval("TMP_eventListener.onTabClose="+TMP_eventListener.onTabClose.toString().replace(
      'this.onTabClose_updateTabBar(aTab);',
      'try {TabGroupsManager.eventListener.onTabClose(aEvent);} catch(e) { }'
    ));

    eval("TMP_eventListener.onTabClose_updateTabBar="+TMP_eventListener.onTabClose_updateTabBar.toString().replace(
      'aTab._tPos < tabBar.collapsedTabs',
      'TabGroupsManagerApiVer1.getIndexInSelectedGroupFromTab(aTab) < tabBar.collapsedTabs'
    ));

    eval("TabDNDObserver.onDragOver="+TabDNDObserver.onDragOver.toString().replace(
      'this.getNewIndex(event)',
      'TMP_TabGroupsManager._getDNDIndex(event)'
    ));

    eval("TabDNDObserver.onDrop="+TabDNDObserver.onDrop.toString().replace(
      'this.getNewIndex(event)',
      'TMP_TabGroupsManager._getDNDIndex(event)'
    ).replace(
      'oldIndex < firstVisibleIndex',
      'TabGroupsManagerApiVer1.getIndexInSelectedGroupFrom_tPos(oldIndex) < firstVisibleIndex'
    ).replace(
      'gBrowser.tabs[firstVisibleIndex - 1]',
      selectedGroupTabs + '[firstVisibleIndex - 1]'
    ));

    eval("TabDNDObserver.onDragEnd="+TabDNDObserver.onDragEnd.toString().replace('tabBar.childNodes', selectedGroupTabs));

    eval("TabDNDObserver.onDragExit="+TabDNDObserver.onDragExit.toString().replace(
      'if (target)',
      'if (target && !(/^TabGroupsManager/.test(target.id)))'
    ));

    eval("TabDNDObserver.getNewIndex="+TabDNDObserver.getNewIndex.toString().replace(
      'tabBar.childNodes', selectedGroupTabs
    ).replace(
      /event\.target\._tPos/g,
      'TabGroupsManagerApiVer1.getIndexInSelectedGroupFromTab(event.target)'
    ).replace(
      /isTabVisible\(i\)/g,
      'isTabVisible(tabs[i]._tPos)'
    ));

    eval("getRowHeight="+getRowHeight.toString().replace(
      'tabBar.childNodes', selectedGroupTabs
    ).replace(
      /tabBar\.lastChild/g, selectedGroupLastChild
    ));

    eval("tabBarWidthChange="+tabBarWidthChange.toString().replace(
      'tabBar.childNodes', selectedGroupTabs
    ).replace(
      'tabBar.ensureTabIsVisible(index);',
      'tabBar.ensureTabIsVisible(tabs[index]._tPos);'
    ).replace(
      'tabBar.lastChild', selectedGroupLastChild
    ));

    eval("tabBar.adjustTabstrip="+tabBar.adjustTabstrip.toString().replace(
      'this.lastChild', selectedGroupLastChild
    ).replace(
      'this.firstChild', 'TabGroupsManagerApiVer1.firstTab'
    ));

    // **************************** for Session Manager ****************************
    eval("SessionData.getTabProperties="+SessionData.getTabProperties.toString().replace(
      'return tabProperties;',
      'if (aTab.group && aTab.group.id) \
         tabProperties += " tabgroups-data=" + encodeURI(aTab.group.id + " " + aTab.group.name); \
       $&'
    ));

    eval("SessionManager.saveOneWindow="+SessionManager.saveOneWindow.toString().replace(
      'if (caller == "windowbackup")',
      <![CDATA[
        this.saveAllGroupsData(null, rdfNodeThisWindow);
        $&
      ]]>
    ));

    eval("SessionManager.loadOneWindow="+SessionManager.loadOneWindow.toString().replace(
      'var lastSelectedIndex = restoreSelect ? this.getIntValue(rdfNodeWindow, "selectedIndex") : 0;',
      '$&\
       var [_restoreSelect, _lastSelectedIndex] = [restoreSelect, lastSelectedIndex];\
       [restoreSelect, lastSelectedIndex] = [false, 0];'
    ).replace(
      'var selectedTabLoaded;',
      <![CDATA[
        try {
          let jsonText = this.getLiteralValue(rdfNodeWindow, "tgm_jsonText");
          if (jsonText)
            TMP_ClosedTabs.ss.setWindowValue(window, "TabGroupsManagerAllGroupsData", decodeURI(jsonText));
          TabGroupsManager.session.groupRestored = 0;
          TabGroupsManager.session.restoreGroupsAndSleepingGroupsAndClosedGroups();
        } catch (ex) {TMP_ASSERT(ex);}
        $&
      ]]>
    ).replace(
      'if (this.saveClosedtabs)',
      <![CDATA[
        if (_restoreSelect && (overwrite || (!concatenate && !currentTabIsBalnk)))
          this.updateSelected(newIndex + _lastSelectedIndex, overwrite || caller=="firstwindowopen" || caller=="windowopenebytabmix");
        $&
      ]]>
    ));

    eval("SessionManager.loadOneTab="+SessionManager.loadOneTab.toString().replace(
      'var savedHistory = this.loadTabHistory(rdfNodeSession, webNav.sessionHistory);',
      <![CDATA[
        $&
        try {
          var tabgroupsData = TMP_SessionStore._getAttribute({xultab: tabProperties}, "tabgroups-data");
          if (tabgroupsData) {
            let [groupId, groupName] = tabgroupsData.split(" ");
            TMP_ClosedTabs.ss.setTabValue(aTab, "TabGroupsManagerGroupId", groupId);
            TMP_ClosedTabs.ss.setTabValue(aTab, "TabGroupsManagerGroupName", groupName);
          }
          TabGroupsManager.session.moveTabToGroupBySessionStore(aTab);
        } catch (ex) {TMP_ASSERT(ex);}
      ]]>
    ));

    eval("SessionManager.setNC_TM="+SessionManager.setNC_TM.toString().replace(
      'for',
      'rdfLabels.push("tgm_jsonText");\
       $&'
    ));

    SessionManager.saveAllGroupsData = this._saveAllGroupsData;
  },

  _getTopTabY: function () {
    return this.tabstripInnerbox.boxObject.y + TMP_getStyle(this.tabstripInnerbox, "paddingTop");
  },

  // get _tPos from group index
  _getDNDIndex: function (aEvent) {
    var indexInGroup = TabDNDObserver.getNewIndex(aEvent);
    var lastIndex = TabGroupsManagerApiVer1.visibleTabs.length - 1;
    if (indexInGroup < 0 || indexInGroup > lastIndex)
      indexInGroup = lastIndex;
    return TabGroupsManagerApiVer1.visibleTabs[indexInGroup]._tPos;
  },

  // for TabGroupsManager use
  tabmixSessionsManager: function () {
    return gTabmixPrefs.getBoolPref("extensions.tabmix.sessions.manager") &&
        (!TMP_SessionStore.isAfterRestart() || "tabmixdata" in window)
  },

  // for TabGroupsManager use
  _saveAllGroupsData: function (jsonText, windowNode) {
    if (!this.enableBackup && !windowNode)
      return;
    try {
      let value = jsonText || TMP_ClosedTabs.ss.getWindowValue(window, "TabGroupsManagerAllGroupsData");
      if (!windowNode)
        windowNode = gThisWin;
      this.setLiteral(windowNode, "tgm_jsonText", encodeURI(value));
      this.saveStateDelayed();
    } catch (ex) {
      TMP_ASSERT(ex);
    }
  }

}
