/*
 * tabmix.js
 *
 * original code by Hemiola SUN, further developed by onemen and CPU
 */
var gIsFirefox35;
var gIsFirefox36;
var gIsFirefox37;

function TM_init() {
  document.getElementById("goPopup").addEventListener("popupshowing", TMP_Places.historyMenuItemsTitle, false);
  // history menu open in new tab if the curren tab is locked
  var historyMenu = document.getElementById("goPopup").parentNode;
  if (historyMenu)
    historyMenu.setAttribute("oncommand", "TMP_Places.historyMenu(event);");

  // disable the "Open New Window action in Single Window Mode...
  var cmdNewWindow = document.getElementById("cmd_newNavigator");
  var originalNewNavigator = cmdNewWindow.getAttribute("oncommand");
  cmdNewWindow.setAttribute("oncommand","if (gSingleWindowMode) BrowserOpenTab(); else {" + originalNewNavigator + "}");

  if (gIsFirefox37) {
    let closeButton = document.getElementById("tabs-closebutton");
    if (closeButton)
      closeButton.setAttribute("onclick","if (event.button == 1) TMP_ClosedTabs.undoCloseTab();");
  }
  else {
    // replace browser handlers with ours so it recognizes when tabs are acted on
    gBrowser.onTabBarDblClick = TM_onTabBarDblClick;
    gBrowser.onTabClick = TM_checkClick;
  }

  if(gBrowser.moveTabTo)
    gBrowser.moveTabTo = gBrowser.TMmoveTabTo;

  gBrowser.closedTabs = [];

  gBrowser.onresize = tabBarWidthChange;
  document.getElementById("contentAreaContextMenu").addEventListener("popupshowing", TM_checkContentMenu, false);

  // override some of All-in-One Gestures function
  // override the duplicate tab function
  if (typeof aioDupTab == 'function')
    aioDupTab = function() { gBrowser.duplicateTab(gBrowser.mCurrentTab); };

  //override the duplicate in new window function
  if (typeof aioDupWindow == 'function')
    aioDupWindow = function() { gBrowser.duplicateInWindow(gBrowser.mCurrentTab); };

  //override the aioCloseWindow function
  if (typeof aioCloseWindow == 'function')
    aioCloseWindow = BrowserTryToCloseWindow;

  window.setTimeout(TMP_delayedStartup, 0);

  //Browser:Home open in new tab if the curren tab is locked
  window.BrowserHome = TM_BrowserHome;

  // add call to TMP_Sanitizer
  // nsBrowserGlue.js use loadSubScript to load Sanitizer so we need to add this here
  var cmd = document.getElementById("Tools:Sanitize");
  if (cmd)
    cmd.setAttribute("oncommand", cmd.getAttribute("oncommand") + " TMP_Sanitizer.tryToSanitize();");

  // if sessionStore disabled use TMP command
  window.undoCloseTab = function ct_window_undoCloseTab(aIndex, aWhere) {
    return TMP_ClosedTabs.undoCloseTab(aIndex, aWhere);
  };

  // clone autoreload popup
  let popup = document.getElementById("autoreload_popup");
  let clonePopup = popup.cloneNode(true);
  clonePopup.removeAttribute("id");
  let menu = document.getElementById("tm-autoreload_menu");
  if (menu)
    menu.appendChild(popup);
  let tabMenu = document.getElementById("tm-autoreloadTab_menu");
  if (tabMenu) {
    clonePopup.setAttribute("onpopupshowing", "onAutoReloadPopupShowing(this, gBrowser.mContextTab);")
    tabMenu.appendChild(clonePopup);
  }

  if (gBrowser.tabContainer.orient == "horizontal") {
    let tabBar = gBrowser.tabContainer;
    let stripIsHidden = gTabmixPrefs.getBoolPref("browser.tabs.autoHide") && !gBrowser.getStripVisibility();
    if (gIsFirefox37) {
      // In XP default theme new tab button is the highest object in the tab strip
      if (stripIsHidden)
        gBrowser.setStripVisibilityTo(true);
      let newtabButton = document.getAnonymousElementByAttribute(tabBar, "class", "tabs-newtab-button");
      let newtabButtonPlaceHolder = document.getAnonymousElementByAttribute(tabBar, "anonid", "newtab-button-place-holder");
      TMP_setItem("TabsToolbar", "onStartNewTabButton", true);
      newtabButtonPlaceHolder.setAttribute("height", newtabButton.parentNode.boxObject.height);
      TMP_setItem("TabsToolbar", "onStartNewTabButton", null);
      if (stripIsHidden)
        gBrowser.setStripVisibilityTo(false);
    }
    else {
      // In XP default theme alltabs-button is the highest object in the tab strip
      // we need a place-holder for the height in case the user hide alltabs-buttin
      var alltabsButton = document.getAnonymousElementByAttribute(tabBar, "anonid", "alltabs-button");
      var alltabsPlaceHolder = document.getAnonymousElementByAttribute(tabBar, "id", "alltabs-place-holder");
      if (alltabsButton && alltabsPlaceHolder) {// mAllTabsButton removed from gBrowser in firefox 3.5 by bug 347930
        if (stripIsHidden)
          gBrowser.setStripVisibilityTo(true);
        alltabsPlaceHolder.setAttribute("height", alltabsButton.parentNode.boxObject.height);
        if (stripIsHidden)
          gBrowser.setStripVisibilityTo(false);
      }
    }
  }

  // we eval navigator-toolbox customizeDone in TMP_delayedStartup
  TMP_BrowserToolboxCustomizeDone();

  // Look for RSS/Atom News Reader
  TMP_LookForRSS();
}

function TMP_delayedStartup() {
  SessionManager.init();
  TMP_ClosedTabs.setButtonDisableState();
  gBrowser.tabContainer.nextTab = 1;
  // convert session.rdf to SessionManager extension format
  convertSession.startup();

  // set title at startup if we not use session manager
  // startup page or home page load before bookmarks service
  var i;
  if (gTabmixPrefs.getBoolPref("extensions.tabmix.titlefrombookmark")) {
    for (i = 0; i < gBrowser.mPanelContainer.childNodes.length ; i++) {
      var aBrowser = gBrowser.getBrowserAtIndex(i);
      var aUrl = aBrowser.contentDocument.baseURI;
      aUrl = (aUrl) ? aUrl : aBrowser.currentURI.spec ;
      var bookMarkName = getTitleFromBookmark(aUrl);
      if (bookMarkName && aBrowser.contentDocument.title != bookMarkName)
        aBrowser.contentDocument.title = bookMarkName;
    }
  }

  var toolbox = document.getElementById("navigator-toolbox");
  window._OriginalToolboxCustomizeDone = toolbox.customizeDone;
  toolbox.customizeDone = function TMP_customizeDone(aToolboxChanged) {
    window._OriginalToolboxCustomizeDone(aToolboxChanged);
    try {
      if (_bottomPosition) {
         _bottomPosition = null;
         gTMPprefObserver.tabBarPositionChanged(1);
      }

      if (aToolboxChanged) {
        TMP_BrowserToolboxCustomizeDone();
        if (gIsFirefox37) {
          tabBarScrollStatus();
          checkBeforeAndAfter();
        }
      }
      // if tabmix option dialog is open update visible buttons and set focus if needed
      var optionWindow = gWindowManager.getMostRecentWindow("mozilla:tabmixopt");
      if (optionWindow) {
        optionWindow.toolbarButtons(window);
        if ("_tabmixCustomizeToolbar" in optionWindow) {
          delete optionWindow._tabmixCustomizeToolbar;
          optionWindow.focus();
        }
      }
    } catch (ex) {TMP_ASSERT(ex, "error in TMP_BrowserToolboxCustomizeDone");}
  };

  // when we open bookmark in new window
  // get bookmark itemId and url - for use in getBookmarkTitle
  if ("bookMarkIds" in window) {
    var items = window.bookMarkIds.split("|");
    for (i = 0; i < items.length ; i++) {
      if (items[i] && items[i] > -1)
        gBrowser.tabs[i].setAttribute("tabmix_bookmarkId", items[i]);
    }
    delete window.bookMarkIds;
  }

  if (gIsFirefox37) {
    // we repaet this after delay in case some extension change tabContext menu id
    let alltabsButton = document.getElementById("alltabs-button");
    if (alltabsButton)
      alltabsButton.setAttribute("context", gBrowser.mTabContainer.getAttribute("context"));
  }
}

var TMP_eventListener = {
  init: function TMP_EL_init(aTabContainer) {
    window.addEventListener("load", this, false);
    window.addEventListener("DOMContentLoaded", this, false);

   /*
    * Session Manager extesion add tabs too soon for us to check isTabVisible properly
    * we get wrong scrollstatus at startup
    * we add flag to use in tabBrowser.tabContainer.isTabVisible
    */
    aTabContainer.setAttribute("SM_restart", true);

    aTabContainer.addEventListener("SSTabRestoring", this, true);
    aTabContainer.addEventListener("SSTabClosing", this, true);
    aTabContainer.addEventListener("TabOpen", this, true);
    aTabContainer.addEventListener("TabClose", this, true);
    aTabContainer.addEventListener("TabSelect", this, true);
    // add event for mouse scrolling on tab bar, necessary for linux
    aTabContainer.addEventListener("DOMMouseScroll", this, false);
    if (/^Linux/.test(navigator.platform)) {
       if (gIsFirefox37)
          document.getElementById("TabsToolbar").addEventListener("DOMMouseScroll", this, false);
       else
          document.getElementById("navigator-toolbox").addEventListener("DOMMouseScroll", this, false);
    }
  },

  handleEvent: function TMP_EL_handleEvent(aEvent) {
    switch (aEvent.type) {
      case "SSTabRestoring":
        this.onSSTabRestoring(aEvent);
        break;
      case "SSTabClosing":
        this.onSSTabClosing(aEvent);
        break;
      case "TabOpen":
        this.onTabOpen(aEvent);
        break;
      case "TabClose":
        this.onTabClose(aEvent);
        break;
      case "TabSelect":
        this.onTabSelect(aEvent);
        break;
      case "DOMMouseScroll":
        this.onTabBarScroll(aEvent);
        break;
      case "DOMContentLoaded":
        this.onContentLoaded(aEvent);
        break;
      case "load":
        try {
          this.onWindowOpen(aEvent);
        } catch (ex) {TMP_ASSERT(ex);}
        break;
      case "unload":
        this.onWindowClose(aEvent);
        break;
      case "fullscreen":
        this.onFullScreen(false);
        break;
    }
  },

 /*
  *  we use this event to run this code befor load event
  *  before TMP version 0.3.8.3 we used to run this code from TMP_beforStartup
  *  that called from tabcontainer constractur
  */
  onContentLoaded: function TMP_EL_onContentLoaded() {
    window.removeEventListener("DOMContentLoaded", this, false);

    // 2010-04-10 fix bug in TreeStyleTab
    if ("TreeStyleTabService" in window &&
               "overrideExtensionsOnInitAfter" in TreeStyleTabService) {
      // there is a bug in TreeStyleTabService.overrideExtensionsOnInitAfter
      eval('TreeStyleTabService.overrideExtensionsOnInitAfter = '+ TreeStyleTabService.overrideExtensionsOnInitAfter.toSource().replace(
        'this.updateTabDNDObserver(TabDNDObserver);',
        'this.updateTabDNDObserver(gBrowser);'
      ));
    }

    // prevent faviconize use its own adjustTabstrip
    if ("faviconize" in window && "override" in faviconize) {
      faviconize.override.adjustTabstrip = function() { };
      // chage adjustTabstrip
      // getBrowser() here is for Firefox 3 we get here before BrowserStartup
      // from Firefox 3.5 window have getter for gBrowser
      let  tabbrowser = getBrowser();
      eval("tabbrowser.tabContainer.adjustTabstrip ="+tabbrowser.tabContainer.adjustTabstrip.toString().replace(
        'var width = tab.getBoundingClientRect().width;',
        '$& \
         let dir = this._isRTLScrollbox ? 1 : -1; \
         let i = this._isRTLScrollbox ? 1 : this.childNodes.length - 2; \
         for(tab; tab = this.childNodes.item(i); i += dir) { \
           if (!tab.hasAttribute("faviconized")) { \
             width = tab.boxObject.width; \
             break; \
           } \
         } '
      ));
    }

    // fix bug in backgroundsaver extension
    // that extension use function with the name getBoolPref
    // we replace it back here
    if ("bgSaverInit" in window && "getBoolPref" in window &&
            getBoolPref.toString().indexOf("return bgSaverPref.prefHasUserValue(sName)") != -1) {
       if (gIsFirefox37) {
          window.getBoolPref = function getBoolPref ( prefname, def ) {
             try {
                return Services.prefs.getBoolPref(prefname);
             }
             catch(er) { return def; }
          }
       }
       else {
          window.getBoolPref = function getBoolPref ( prefname, def ) {
             try {
                var pref = Components.classes["@mozilla.org/preferences-service;1"]
                          .getService(Components.interfaces.nsIPrefBranch);
                return pref.getBoolPref(prefname);
             }
             catch(er) { return def; }
          }
       }
    }

    // we call this here before some other extensions (like Highlander) change handleLinkClick
    // don't call openNewWindowWith when we are in single window mode
    // look in tablib.js for openNewWindowWith eval
    eval("handleLinkClick ="+handleLinkClick.toString().replace(
       'if (event.shiftKey)',
       'if (gSingleWindowMode && event.shiftKey) { \
           openNewTabWith(href, doc, null, event, false); \
           event.stopPropagation(); \
           return true; \
        } \
        $&'
    ).replace(
       'if (tab)',
       'if (gSingleWindowMode || tab)'
    ));

  },

  onWindowOpen: function TMP_EL_onWindowOpen() {
    window.removeEventListener("load", this, false);
    window.addEventListener("unload", this, false);
    window.addEventListener("fullscreen", this, true);

    // don't load tabmix into undock sidebar opened by ezsidebar extension
    var wintype = window.document.documentElement.getAttribute("windowtype");
    if (wintype == "mozilla:sidebar") return;

    // replace old Settings.
    // we must call this before any other tabmix function
    gTMPprefObserver.updateSettings();

    // init tabmix functions
    try {
      tablib.init();
    } catch (ex) {TMP_ASSERT(ex);}
    try {
      TMP_Places.init();
    } catch (ex) {TMP_ASSERT(ex);}
    try {
      TM_init();
    } catch (ex) {TMP_ASSERT(ex);}
    try {
      TMP_LastTab.init();
    } catch (ex) {TMP_ASSERT(ex);}
    try {
      TMP_TBP_init();
    } catch (ex) {TMP_ASSERT(ex);}
    try {
      TMP_DragAndDrop_init();
    } catch (ex) {TMP_ASSERT(ex);}

    //this window open form _restoreTab we use it only when sessionStore is off
    // we can drop this some day soon
    if ("tabmix_afterTabduplicated" in window && window.tabmix_afterTabduplicated && "tabmix_duplicatData" in window && window.tabmix_duplicatData)
      NW_waitForSessionHistory();

    var tabBar = gBrowser.tabContainer;

    if (gIsFirefox35) {
      // save mTabsNewtabButton width
      let lwtheme = document.getElementById("main-window").getAttribute("lwtheme");
      tabBar._newTabButtonWidth = lwtheme ? 31 : tabBar.mTabsNewtabButton.boxObject.width;
    }

    // fix bug in new tab button on right extension when we use multi row
    if ("newTabButtons" in window) {
      var newbuttonRight = document.getAnonymousElementByAttribute(tabBar, "id", "tabs-newbutton-right");
      var newbuttonEnd = document.getAnonymousElementByAttribute(tabBar, "id", "tabs-newbutton-end");
      if (newbuttonRight && newbuttonEnd)
         newbuttonEnd.parentNode.insertBefore(newbuttonRight, newbuttonEnd);
    }

   /*
    * Session Manager extesion add tabs too soon for us to check isTabVisible properly
    * we get wrong scrollstatus at startup
    * we add flag to use in tabBrowser.tabContainer.isTabVisible
    */
    if ("gSessionManager" in window && TMP_SessionStore.isAfterRestart())
      setTimeout(function (_tabBar) { _tabBar.removeAttribute("SM_restart"); }, 0, tabBar);
    else
      tabBar.removeAttribute("SM_restart");

    if (gIsFirefox37)
        gBrowser.mTabDropIndicatorBar = gBrowser.tabContainer._tabDropIndicator.parentNode;
    if (/^Mac/.test(navigator.platform)) {
      tabBar.setAttribute("Mac", "true");
     /*
      * get Mac drop indicator marginBottom ,   Mac default thme have marginBottom: -24px
      *
      * with TreeStyleTab extension vertical tabbar mTabDropIndicatorBar.firstChild is null
      */
      var ib = gBrowser.mTabDropIndicatorBar;
      if (ib && ib.firstChild) {
        TabDNDObserver.marginBottom = TMP_getStyle(ib.firstChild, "marginBottom");
      }
    }

    var skin = gTabmixPrefs.getCharPref("general.skins.selectedSkin");
    if (skin=="classic/1.0") {
      if (/^Mac/.test(navigator.platform))
        tabBar.setAttribute("classic", "v3Mac");
      else if (/^Linux/.test(navigator.platform)) {
        tabBar.setAttribute("classic", "v3Linux");
        tabBar.setAttribute("platform", "linux");
      }
      else {
        if (gIsFirefox37) {
          let aero = navigator.oscpu == "Windows NT 6.1"
          tabBar.setAttribute("classic37",  aero ? "v37aero" : "v37");
        }
        else
          tabBar.setAttribute("classic", "v3");
        tabBar.setAttribute("platform", "xp");
      }
    }
    else {
      //XXX need to add theme list here
      var themes = /^(iPoxRemix|Ie8fox|Vfox3)/;
      if (themes.test(skin)) {
        // add backgroundrepeat Attribute for theme for use in multi-row
        tabBar.setAttribute("backgroundrepeat" , true);
      }
    }

    // for new tab icon on context menu
    if (gIsFirefox37 && tabBar.getAttribute("platform") == "xp")
      TMP_setItem("context_newTab", "platform", "xp37");
    else
      TMP_setItem("context_newTab", "platform", tabBar.getAttribute("platform"));

    if (gIsFirefox35)
       tabBar.setAttribute("platform", "v35");

    // don't remove maybe some themes use this with Tabmix
    tabBar.setAttribute("tabmix_firefox3" , true);

    switch (skin) {
      case "cfxe": //  Chromifox Extreme
      case "cfxec":
        tabBar.setAttribute("tabmix_skin" , "cfxec");
        break;
      case "Vfox3":
      case "phoenityaura": // Phoenity Aura
        tabBar.setAttribute("tabmix_skin" , skin);
        break;
    }

    if (gSingleWindowMode)
      gTMPprefObserver.setSingleWindowUI();

    gTMPprefObserver.setMenuIcons();
    gTMPprefObserver.toggleKey("key_tm_slideShow", "extensions.tabmix.disableF8Key");
    gTMPprefObserver.toggleKey("key_tm_toggleFLST", "extensions.tabmix.disableF9Key");
    try {
      gTMPprefObserver.createColorRules();
    } catch (ex) {TMP_ASSERT(ex);}
    gTMPprefObserver.tabCloseButton();

    var position = tabxPrefs.getIntPref("newTabButton.position");
    gTMPprefObserver.changeNewTabButtonSide(position);
    TMP_ClosedTabs.setButtonType(tabxPrefs.getBoolPref("undoCloseButton.menuonly"));

    gHideTabBar = tabxPrefs.getIntPref("hideTabbar");
   /*
    *  In the first time TMP is running we need to match extensions.tabmix.hideTabbar to browser.tabs.autoHide.
    *  extensions.tabmix.hideTabbar default is 1 "Hide tabbar when i have only one tab"
    *  if browser.tabs.autoHide is false we need to make sure extensions.tabmix.hideTabbar is set to 0 "Never Hide tabbar:
    */
    if (!gTabmixPrefs.getBoolPref("browser.tabs.autoHide") && gHideTabBar == 1) {
      gHideTabBar = 0;
      tabxPrefs.setIntPref("hideTabbar", gHideTabBar);
    }
    else
      gTMPprefObserver.setAutoHidePref();

    window.setTimeout(function () {
      // initialize the value of "gTabBarWidth"
      gTabBarWidth = gBrowser.tabContainer.boxObject.width;
      // only hide the tabbar after we catch the width
      if (gHideTabBar == 2)
        TMP_setStripVisibilityTo(false);
    }, 100);

    var newPosition = tabxPrefs.getIntPref("tabBarPosition");
    if (newPosition == 1)
      gTMPprefObserver.tabBarPositionChanged(newPosition);

    // make sure "extensions.tabmix.undoClose" is true if "browser.sessionstore.max_tabs_undo" is not zero
    var sessionstoreUndoClose = gTabmixPrefs.getIntPref("browser.sessionstore.max_tabs_undo") > 0;
    if (sessionstoreUndoClose != tabxPrefs.getBoolPref("undoClose"))
      tabxPrefs.setBoolPref("undoClose", sessionstoreUndoClose);

    // progressMeter on tabs
    var progressMeterOnTabs = TMP_getBoolPref(tabxBranch, "progressMeter", true);
    tabBar.setAttribute("progressMeter", progressMeterOnTabs);
    document.getElementById("statusbar-progresspanel").
        setAttribute("hidden", TMP_getBoolPref(tabxBranch, "noprogress",false) && progressMeterOnTabs);

    TMupdateSettings(true);

    // tabmix Options in Tools menu
    document.getElementById("tabmix-menu").hidden = !tabxPrefs.getBoolPref("optionsToolMenu");

    SessionManager.updateSettings();
  },

  onSSTabRestoring: function TMP_EL_onSSTabRestoring(aEvent) {
    var aTab = aEvent.target;

    if (aTab.hasAttribute("_locked")) {
      if (aTab.getAttribute("_locked") == "true")
        aTab.setAttribute("locked", "true");
      else
        aTab.removeAttribute("locked");
    }

    // this function run before tab load, so onTabReloaded will run when onStateChange get STATE_STOP
    var reloadData = aTab.getAttribute("reload-data");
    if (reloadData) {
      reloadData = reloadData.split(" ");
      setupAutoReload(aTab);
      aTab.autoReloadEnabled = true;
      aTab.autoReloadURI = reloadData[0];
      aTab.autoReloadTime = reloadData[1];
    }
  },

  onSSTabClosing: function TMP_EL_onSSTabClosing(aEvent) {
    var aTab = aEvent.target;

    var browser = gBrowser.getBrowserForTab(aTab);
    var iconURL = browser.mIconURL;
    if (aTab.hasAttribute("busy") || aTab.getAttribute("image") != iconURL) {
      aTab.removeAttribute("busy");
      if (iconURL)
        aTab.setAttribute("image", iconURL);
      else if (!(/^https?:/.test(browser.currentURI.spec)))
        gBrowser.useDefaultIcon(aTab);
    }

    // fixed in sessionStore for firefox 3.5
    if (!gIsFirefox35 && aTab.label == gBrowser.mStringBundle.getString("tabs.loading"))
      gBrowser.setTabTitle(aTab);
  },

  onFullScreen: function TMP_EL_onFullScreen(aPositionChanged) {
    // add fullscr-bottom-toggler when tabbar is on the bottom
    var fullScrToggler = document.getElementById("fullscr-bottom-toggler");
    if (gTabbarPosition == 1 && (!window.fullScreen || aPositionChanged)) {
      if (!fullScrToggler) {
        fullScrToggler = document.createElement("toolbar");
        fullScrToggler.id = "fullscr-bottom-toggler";
        fullScrToggler.setAttribute("customizable", "false");
        if (gIsFirefox37)
          document.getElementById("tabmix-bottom-toolbox").appendChild(fullScrToggler);
        else {
          let _toolbox = document.createElement("toolbox");
          _toolbox.appendChild(fullScrToggler);
          gBrowser.mTabBox.insertBefore(_toolbox, gBrowser.mTabBox.firstChild);
        }
        eval("FullScreen.mouseoverToggle ="+FullScreen.mouseoverToggle.toString().replace(
          'document.getElementById("fullscr-toggler").setAttribute("moz-collapsed", aShow);',
          '$& \
           document.getElementById("fullscr-bottom-toggler").setAttribute("moz-collapsed", aShow);'
        ));
      }
      fullScrToggler.addEventListener("mouseover", FullScreen._expandCallback, false);
      fullScrToggler.addEventListener("dragenter", FullScreen._expandCallback, false);
      fullScrToggler.setAttribute("moz-collapsed", "false");
      fullScrToggler.setAttribute("inFullscreen", "true");
    }
    else if (fullScrToggler && window.fullScreen) {
      fullScrToggler.removeEventListener("mouseover", FullScreen._expandCallback, false);
      fullScrToggler.removeEventListener("dragenter", FullScreen._expandCallback, false);
      fullScrToggler.removeAttribute("inFullscreen");
      if (FullScreen._isChromeCollapsed)
        document.getElementById("fullscr-bottom-toggler").setAttribute("moz-collapsed", "true");
    }
  },

  // Function to catch when new tabs are created and update tab icons if needed
  // In addition clicks and doubleclick events are trapped.
  onTabOpen: function TMP_EL_onTabOpen(aEvent) {
    var aTab = aEvent.target;
    if ( alwaysNewTab == 1 )
      aTab.setAttribute("locked", "true");

    this.onTabOpen_updateTabBar(aTab);
  },

  // TGM extention use it
  onTabOpen_updateTabBar: function TMP_EL_onTabOpen_updateTabBar(aTab) {
    //XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
    if (!gBrowser.tabContainer.hasAttribute("hideunderline") && !gBrowser.tabContainer._timeout) {
      gBrowser.tabContainer._timeout = window.setTimeout( function(tabBar) {
        toggleUnderlineTabsLabel();
        if (tabBar._timeout) {
          clearTimeout(tabBar._timeout);
          tabBar._timeout = null;
        }
      }, 50, gBrowser.tabContainer);
    }

    if (gBrowser.tabContainer.getAttribute("multibar") != "scrollbar") {
      tabBarScrollStatus();
      // make sure selected new tabs stay visible
      if (aTab == gBrowser.tabContainer.selectedItem)
        gBrowser.tabContainer.ensureTabIsVisible(aTab._tPos);
    }
    checkBeforeAndAfter();
  },

  onTabClose: function TMP_EL_onTabClose(aEvent) {
    // aTab is the tab we are closing now
    var aTab = aEvent.target;
    var tabBar = gBrowser.tabContainer;

    // if we close the 2nd tab and browser.tabs.autoHide is true reset all scroll and multi-row parameter
    // strip already collapsed at this point
    var tabsCount = tabBar.childNodes.length - (gIsFirefox35 ? gBrowser._removingTabs.length : 0);
    if (tabsCount == 2 && gTabmixPrefs.getBoolPref("browser.tabs.autoHide")) {
      tabBar.collapsedTabs = 0;
      setTabBarHeight(1);
      tabBar.removeAttribute("multibar");
    }

    this.onTabClose_updateTabBar(aTab);
  },

  // TGM extention use it
  onTabClose_updateTabBar: function TMP_EL_onTabClose_updateTabBar(aTab) {
    var tabBar = gBrowser.tabContainer;
    if ( tabscroll != 2 ) {
      var _canScrollTabsLeft = tabBar.canScrollTabsLeft;
      var _canScrollTabsRight = tabBar.canScrollTabsRight;
      tabBar.collapsedTabs--;
      if (!_canScrollTabsLeft)
        tabBar.canScrollTabsLeft = false;
      if (!_canScrollTabsRight)
        tabBar.canScrollTabsRight = false;

      window.setTimeout( function() {
                           tabBar.adjustScrollTabsLeft();
                           tabBar.adjustScrollTabsRight();
                           tabBar.adjustNewtabButtonvisibility();
                         }, 25 );
    }
    else if (tabBar.hasAttribute("multibar")) {
      // don't update tabBar.collapsedTabs after timeout
      // we must do it live......
      if (aTab._tPos < tabBar.collapsedTabs) {
        // don't use the setter here
        tabBar._collapsedTabs--;
      }
      if (!tabBar._onCloseTimeout) {
        tabBar._onCloseTimeout = window.setTimeout( function TMP_onCloseTimeout() {
          if (tabBar._onCloseTimeout) {
            clearTimeout(tabBar._onCloseTimeout);
            tabBar._onCloseTimeout = null;
          }
          if (tabBar.getAttribute("multibar") == "scrollbar" && tabBar.collapsedTabs > 0) {
            if (tabBar.lastTabRowNumber == tabBar.maxRow && !inSameRow(tabBar.lastChild, tabBar.lastChild.previousSibling))
              tabBar.rowScroll(-1);
          }
          tabBarScrollStatus();
          checkBeforeAndAfter();
        }, 25);
      }
    }
    else
      tabBar.disAllowNewtabbutton = false;

    //XXX underline the label bleed over the end when tab is to small and we have close button on the tab !!!!????
    if (tabBar.hasAttribute("hideunderline"))
      window.setTimeout( function() {toggleUnderlineTabsLabel();}, 50);

  },

  onTabSelect: function TMP_EL_TabSelect(aEvent) {
    var tab = aEvent.target;
    var tabBar = gBrowser.tabContainer;
    // update this functions after new tab select
    tabBar.nextTab = 1;
    tab.setAttribute("flst_id", new Date().getTime());
    if (!tab.hasAttribute("visited"))
      tab.setAttribute("visited", true);
    TMP_LastTab.OnSelect();
    SessionManager.tabSelected(true);

    if (tabBar.hasAttribute("multibar")) {
      var top = tabBar.topTabY;
      var tabRow = tabBar.getTabRowNumber(tab, top);
      var prev = tab.previousSibling, next = tab.nextSibling;
      if ( prev && tabRow != tabBar.getTabRowNumber(prev, top) )
        prev.removeAttribute("beforeselected");
      if ( next && tabRow != tabBar.getTabRowNumber(next, top) )
        next.removeAttribute("afterselected");
    }

    var tabsBottom = document.getAnonymousElementByAttribute(tabBar, "class", "tabs-bottom");
    if (tabsBottom)
      TMP_setItem(tabBar, "tabonbottom", tab.baseY >= tabsBottom.boxObject.y || null);
  },

  onTabBarScroll: function TMP_EL_onTabBarScroll(aEvent) {
    var tabBar = gBrowser.tabContainer;

    let tabs = tabBar.getElementsByAttribute("showbutton" , "*");
    for (var i = 0; i < tabs.length; i++)
      tabs[i].removeAttribute("showbutton");

    var ScrollDirection = aEvent.detail > 0 ? 1 : -1;
      if (gTabmixPrefs.getBoolPref("extensions.tabmix.reversedScroll"))
        ScrollDirection = -1 * ScrollDirection;

    var shouldMoveFocus = gTabmixPrefs.getBoolPref("extensions.tabmix.enableScrollSwitch");
    if (shouldMoveFocus) {
      tabBar.advanceSelectedTab(ScrollDirection, true);
    }
    else if ("TreeStyleTabBrowser" in window) {
       return;
    }
    else if ( tabscroll != 2 )
      tabBar.collapsedTabs += ScrollDirection;
    else if ( tabscroll == 2 )
      tabBar.rowScroll(ScrollDirection);

    aEvent.stopPropagation();
    aEvent.preventDefault();
  },

  onWindowClose: function TMP_EL_onWindowClose() {
    window.removeEventListener("unload", this, false);

    if (!gIsFirefox35) {
      gBrowser.mTabDropIndicatorBar.removeEventListener('dragover', TMP_TabDragOver, true);
      gBrowser.mTabDropIndicatorBar.removeEventListener('dragdrop', TMP_TabDragDrop, true);
    }

    document.getElementById("goPopup").removeEventListener("popupshowing", TMP_Places.historyMenuItemsTitle, false);

    var isLastWindow = numberOfWindows() == 0;
    // we close tabmix dialog windows on exit
    if (isLastWindow) {
      Array.forEach(["tabmixopt-filetype", "tabmixopt-appearance", "tabmixopt"], function(aID) {
        var win = gWindowManager.getMostRecentWindow("mozilla:" + aID);
        if (win) {
          if (aID != "tabmixopt")
            win.close();
          else
            win.setTimeout(function(){win.close();},0);
        }
      });
    }

    // check if we need to sanitize on exit without prompt to user
    try {
      // if tryToSanitize is false and privacy.sanitize.promptOnSanitize is true
      // we call TMP_Sanitizer.sanitize from Firefox Sanitizer
      var tabmixSanitized = isLastWindow && gTabmixPrefs.getBoolPref("privacy.sanitize.sanitizeOnShutdown") && TMP_Sanitizer.tryToSanitize(true);
    }
    catch (ex) {
      tabmixSanitized = false;
    }
    if (!tabmixSanitized) {
      SessionManager.deinit(isLastWindow, false);
      SessionManager.windowIsClosing(true, isLastWindow, true, false);
    }
    if (gIsFirefox35) {
      var observerService = Cc["@mozilla.org/observer-service;1"].getService(Ci.nsIObserverService);
      observerService.notifyObservers(null, "browser-window-change-state", "closed");
      observerService.removeObserver(SessionManager, "browser-window-change-state");
      observerService.removeObserver(SessionManager, "private-browsing");
      observerService.removeObserver(SessionManager, "quit-application-requested");
      observerService.removeObserver(SessionManager, "browser-lastwindow-close-requested");
      if (SessionManager.afterExitPrivateBrowsing) {
        clearTimeout(SessionManager.afterExitPrivateBrowsing);
        SessionManager.afterExitPrivateBrowsing = null;
      }
    }

    document.getElementById("contentAreaContextMenu").removeEventListener("popupshowing", TM_checkContentMenu, false);
    gBrowser.tabContextMenu.removeEventListener("popupshowing", Tm_checkTabClick, false);
    gBrowser.tabContextMenu.removeEventListener("popupshown", TMP_tabContextMenuShown, false);

    TMP_Places.deinit();
    TMP_LastTab.deinit();

    window.removeEventListener("fullscreen", this, true);
    var fullScrToggler = document.getElementById("fullscr-bottom-toggler");
    if (fullScrToggler) {
      fullScrToggler.removeEventListener("mouseover", FullScreen._expandCallback, false);
      fullScrToggler.removeEventListener("dragenter", FullScreen._expandCallback, false);
    }

    gBrowser.tabContainer.removeEventListener("SSTabRestoring", this, true);
    gBrowser.tabContainer.removeEventListener("SSTabClosing", this, true);
    gBrowser.tabContainer.removeEventListener("TabOpen", this, true);
    gBrowser.tabContainer.removeEventListener("TabClose", this, true);
    gBrowser.tabContainer.removeEventListener("TabSelect", this, true);
    gBrowser.tabContainer.removeEventListener("DOMMouseScroll", this, false);
    if (/^Linux/.test(navigator.platform)) {
       if (gIsFirefox37)
          document.getElementById("TabsToolbar").removeEventListener("DOMMouseScroll", this, false);
       else
          document.getElementById("navigator-toolbox").removeEventListener("DOMMouseScroll", this, false);
    }

    // TreeStyleTab extension add this to be compatible with old tabmix version
    // we call removeEventListener again here in case user close the window without opening new tabs
    if ("TreeStyleTabBrowser" in window)
      gBrowser.tabContainer.removeEventListener('DOMNodeInserted', tabxTabAdded, true);

    gTMPprefObserver.removeObservers();
  },

  // some theme not use Tabmix tab binding
  // we check here that all of our attribute is here
  setTabAttribute: function TMP_EL_setTabAttribute(aTab) {
    var skin = gTabmixPrefs.getCharPref("general.skins.selectedSkin");
    if (skin=="classic/1.0")
      return;

    let button  = document.getAnonymousElementByAttribute(aTab, "button_side", "left");
    if (button)
      return;

    let leftButton;
    let rightButton;
    let tabMiddle;
    let classString = /tab-middle|box-inherit|tab-image-middle|tab-body/;

    function getCloseButtons(aNodes) {
      Array.slice(aNodes).forEach(function(aNode) {
      if (classString.test(aNode.getAttribute("class")))
        tabMiddle = aNode;

      if (aNode.localName == "toolbarbutton" && aNode.getAttribute("anonid") == "tmp-close-button") {
        if (leftButton) {
          rightButton = aNode;
          aNode.setAttribute("button_side", "right");
        }
        else {
          leftButton = aNode;
          aNode.setAttribute("button_side", "left");
        }
        if (leftButton && rightButton)
          return;
        }
      });
    }

    // 1st search in tab
    getCloseButtons(document.getAnonymousNodes(aTab));
    // 2nd search in tab-middle
    if (!rightButton && !leftButton && tabMiddle)
      getCloseButtons(tabMiddle.childNodes);
    // only one button !
    if (!rightButton && leftButton)
      leftButton.setAttribute("button_side", "right");
  }

}

/* for treeStyleTab extension look in treeStyleTab hacks.js
   we remove tabxTabAdded function and use TMP_eventListener.onTabOpen from 0.3.7pre.080815
*/
function tabxTabAdded() {
  // remove eventListener added by treeStyleTab on first call to tabxTabAdded
  gBrowser.tabContainer.removeEventListener('DOMNodeInserted', tabxTabAdded, true);
  return;
}
