// code by onemen
const prefStringTMHistory = "extensions.tabmix.opentabfor.history";
const prefStringTMUseMiddleClick = "extensions.tabmix.middlecurrent";
const prefStringTMBookmark = "extensions.tabmix.opentabfor.bookmarks";

var TMP_Places = {
   addEvent: function TMP_PC_addEvent() {
      window.addEventListener("load", this, false);
      window.addEventListener("unload", this, false);
   },

   handleEvent: function TMP_PC_handleEvent(aEvent) {
      switch (aEvent.type) {
         case "load":
           window.removeEventListener("load", this, false);
           this.init();
           break;
         case "unload":
           window.removeEventListener("unload", this, false);
           this.deinit();
           break;
      }
   },

   init : function TMP_PC_init() {
      if (!("tmLog" in window))
        window.tmLog = function(a,b) { window.setTimeout(function (a1,b1) { getTopWin().tmLog(a1,b1);}, 100, a, b);}

      this.initPlacesUIUtils();
      PlacesController.prototype.beforeTabMixPLusBuildContextMenu = PlacesController.prototype.buildContextMenu;
      PlacesController.prototype.buildContextMenu = function(aPopup) {
         var anyVisible = this.beforeTabMixPLusBuildContextMenu(aPopup);
         if (anyVisible)
            TMP_Places.buildContextMenu();

         return(anyVisible);
      }

      // use tab label for bookmark name when user renamed the tab
      // PlacesCommandHook exist on browser window
      if ("PlacesCommandHook" in window) {
         eval("PlacesCommandHook.bookmarkPage ="+PlacesCommandHook.bookmarkPage.toString().replace(
            'title = webNav.document.title || url.spec;',
            'title = TMP_Places.getTabFixedTitle(aBrowser, url) || webNav.document.title || url.spec;'
         ));

         eval("PlacesCommandHook._getUniqueTabInfo ="+PlacesCommandHook._getUniqueTabInfo.toString().replace(
            'tabList.push(uri);',
            'tabList.push({uri: uri, title: TMP_Places.getTabFixedTitle(browsers[i], uri)});'
         ).replace(
            'seenURIs.uri.spec = true;',
            'seenURIs[uri.spec] = true;'
         ));
      }

      if (this.isVersion37) {
        if ("PlacesViewBase.prototype" in window) {
           eval("PlacesViewBase.prototype._mayAddCommandsItems ="+PlacesViewBase.prototype._mayAddCommandsItems.toString().replace(
              "openUILink(this.getAttribute('targetURI'), event);",
              "TMP_Places.openLivemarkSite(this.getAttribute('targetURI'), event);"
           ));
        }
      }
      else {
        if ("BookmarksEventHandler" in window) {
           eval("BookmarksEventHandler.onPopupShowing ="+BookmarksEventHandler.onPopupShowing.toString().replace(
              "openUILink(this.getAttribute('siteURI'), event);",
              "TMP_Places.openLivemarkSite(this.getAttribute('siteURI'), event);"
           ));
        }

        eval("TMP_Places.historyMenuItemsTitle ="+TMP_Places.historyMenuItemsTitle.toString().replace(
          'item._placesNode.uri',
          'item.node.uri'
        ));

        eval("TMP_Places.historyMenu ="+TMP_Places.historyMenu.toString().replace(
          'aEvent.target._placesNode',
          'aEvent.target.node'
        ));
      }

      // fix small bug when the event is not mouse event
      // inverse focus of middle/ctrl/meta clicked bookmarks/history
      // when we are in single window mode set the function to retuen "tab"
      eval("whereToOpenLink ="+whereToOpenLink.toString().replace(
        'var middle = !ignoreButton && e.button == 1;',
        'var middle = e instanceof MouseEvent && !ignoreButton && e.button == 1;'
      ).replace(
        'if (shift)',
        'var inversefocus = getBoolPref("extensions.tabmix.inversefocusOther", true);\
         if (inversefocus || (!inversefocus && shift))'
      ).replace( // Firefox 3.7
        'return shift ? "tabshifted" : "tab";',
        'let inversefocus = getBoolPref("extensions.tabmix.inversefocusOther", true);\
         return inversefocus || shift ? "tabshifted" : "tab";'
      ).replace(
        'return "window";',
        'return getSingleWindowMode() ? "tab" : "window";'
      ));

      eval("openUILinkIn ="+openUILinkIn.toString().replace(
        '{',
        '{ var bookMarkId, backgroundPref, tabmixArg = arguments.length > 5 ? arguments[5] : null; \
         if (tabmixArg) { \
           bookMarkId = "bookMarkId" in tabmixArg && tabmixArg.bookMarkId > -1 ? tabmixArg.bookMarkId : null; \
           backgroundPref = "backgroundPref" in tabmixArg ? tabmixArg.backgroundPref : null; \
         }'
      ).replace(
        'var w = getTopWin();',
        '$& \
         if (where == "window" && getSingleWindowMode()) where = "tab";'
      ).replace(
        'ww.openWindow(w || window, getBrowserURL(), null, "chrome,dialog=no,all", sa);',
        'var newWin = ww.openWindow(w || window, getBrowserURL(), null, "chrome,dialog=no,all", sa); \
         if (bookMarkId) newWin.bookMarkIds = bookMarkId;'
      ).replace(
        '"browser.tabs.loadBookmarksInBackground"',
        'backgroundPref || $&'
      ).replace(
        'w.loadURI(url, referrerUrl, postData, allowThirdPartyFixup);',
        '$& if (bookMarkId) w.gBrowser.mCurrentTab.setAttribute("tabmix_bookmarkId", bookMarkId);'
      ).replace( // Firefox 3.0 - 3.6
        'browser.loadOneTab(url, referrerUrl, null, postData, loadInBackground, allowThirdPartyFixup || false);',
        '$& if (bookMarkId) browser.getTabForLastPanel().setAttribute("tabmix_bookmarkId", bookMarkId);'
      ).replace( // firefox 3.7+
        'browser.loadOneTab(url, {referrerURI: referrerUrl, postData: postData, inBackground: loadInBackground, allowThirdPartyFixup: allowThirdPartyFixup});',
        '$& if (bookMarkId) browser.getTabForLastPanel().setAttribute("tabmix_bookmarkId", bookMarkId);'
      ));
   },

   functions: ["_openTabset", "openURINodesInTabs", "openContainerNodeInTabs", "openNodeWithEvent", "openNodeIn"],
   initPlacesUIUtils: function TMP_PC_initPlacesUIUtils() {
      var appInfo = Cc["@mozilla.org/xre/app-info;1"].getService(Ci.nsIXULAppInfo);
      var versionChecker = Cc["@mozilla.org/xpcom/version-comparator;1"]
                        .getService(Ci.nsIVersionComparator);
      this.isVersion37 = versionChecker.compare(appInfo.version, "3.7a5pre") >= 0;
      if (PlacesUIUtils.tabmix_inited) {
         PlacesUIUtils.tabmix_inited++;
         return;
      }

      PlacesUIUtils.tabmix_inited = 1;
      if (this.isVersion37) {
         this.functions.forEach(function(aFn) {
            PlacesUIUtils["tabmix_" + aFn] = PlacesUIUtils[aFn];
         });
      }
      var openDialogCode = this.isVersion37 ? 'win.openDialog(win.getBrowserURL(), "_blank", "chrome,all,dialog=no", urls.join("|"));' :
                                              'window.openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no", urls.join("|"));';

      var treeStyleTab = "TreeStyleTabBookmarksService" in window;
      if (treeStyleTab) {
        // To TreeStyleTab extension developre contact me at onemen.one@gmail.com
        function delayEval() {
          eval("PlacesUIUtils._openTabset ="+PlacesUIUtils._openTabset.toString().replace(
            'urls = []',
            'behavior, $&'
          ).replace(
            openDialogCode,
            'let newWin = $& \
             newWin.bookMarkIds = ids.join("|");'
          ).replace(
            'let openGroupBookmarkBehavior =',
            '$& behavior ='
          ).replace(
            /browserWindow\.(gBrowser|getBrowser\(\))\.loadTabs\(urls, loadInBackground, replaceCurrentTab\);/,
            'var changeWhere = where == "tabshifted" && aEvent.target.localName != "menuitem"; \
             if (changeWhere) where = "current"; \
             browserWindow.TMP_Places.openGroup(urls, ids, where, behavior);'
          ));
        }
        window.setTimeout(delayEval, 0);
      }
      else { // TreeStyleTab not installed
        eval("PlacesUIUtils._openTabset ="+PlacesUIUtils._openTabset.toString().replace(
          'var urls = [];',
          '$& var ids = [];'
        ).replace(
          'urls.push(item.uri);',
          '$& ids.push(item.id);'
        ).replace(
         openDialogCode,
         'let newWin = $& \
          newWin.bookMarkIds = ids.join("|");'
        ).replace(
          /browserWindow\.(gBrowser|getBrowser\(\))\.loadTabs\(urls, loadInBackground, replaceCurrentTab\);/,
          'var changeWhere = where == "tabshifted" && aEvent.target.localName != "menuitem"; \
           if (changeWhere) where = "current"; \
           browserWindow.TMP_Places.openGroup(urls, ids, where);'
        ));

        eval("PlacesUIUtils.openURINodesInTabs ="+PlacesUIUtils.openURINodesInTabs.toString().replace(
          'push({uri: aNodes[i].uri,',
          'push({id: aNodes[i].itemId, uri: aNodes[i].uri,'
        ));

        // we enter getURLsForContainerNode into TMP_Places to prevent leakes from PlacesUtils
        if (!this.getURLsForContainerNode) {
          eval("TMP_Places.getURLsForContainerNode ="+PlacesUtils.getURLsForContainerNode.toString().replace(
            /{uri: child.uri,/g,
            '{id: child.itemId, uri: child.uri,'
          ).replace(
            /this./g,  'PlacesUtils.'
          ));
        }

        eval("PlacesUIUtils.openContainerNodeInTabs ="+PlacesUIUtils.openContainerNodeInTabs.toString().replace(
          'PlacesUtils.getURLsForContainerNode(aNode)',
          'TMP_Places.getURLsForContainerNode(aNode)'
        ));
      }

      eval("PlacesUIUtils.openNodeWithEvent ="+PlacesUIUtils.openNodeWithEvent.toString().replace(
         'whereToOpenLink(aEvent));',
         'whereToOpenLink(aEvent), aEvent);'
      ));

      // Don't change "current" when user click context menu open (callee is PC_doCommand and aWhere is current)
      // we disable the open menu when the tab is lock
      var oldCode = this.isVersion37 ? "this._getCurrentActiveWin().openUILinkIn(aNode.uri, aWhere);" :
                                                                  "openUILinkIn(aNode.uri, aWhere);";
      var newCode = this.isVersion37 ? "this._getCurrentActiveWin()." : "";
      eval("PlacesUIUtils.openNodeIn ="+PlacesUIUtils.openNodeIn.toString().replace(
         oldCode,
         'if (arguments.length == 3) \
             aWhere = TMP_Places.isBookmarklet(aNode.uri) ? "current" : TMP_Places.fixWhereToOpen(arguments[2], aWhere); \
          else if (aWhere == "current" && arguments.callee.caller.name != "PC_doCommand" && !TMP_Places.isBookmarklet(aNode.uri)) \
             aWhere = TMP_Places.fixWhereToOpen(null, aWhere);'  +
          newCode + 'openUILinkIn(aNode.uri, aWhere, null, null, null, {bookMarkId: aNode.itemId});'
      ));
   },

   deinit: function TMP_PC_deinit() {
      PlacesUIUtils.tabmix_inited--;

      if (this.isVersion37 && PlacesUIUtils.tabmix_inited == 0) {
        this.functions.forEach(function(aFn) {
           PlacesUIUtils[aFn] = PlacesUIUtils["tabmix_" + aFn];
           delete PlacesUIUtils["tabmix_" + aFn];
        });
        delete PlacesUIUtils.tabmix_inited;
      }

      PlacesController.prototype.buildContextMenu = PlacesController.prototype.beforeTabMixPLusBuildContextMenu;
      PlacesController.prototype.beforeTabMixPLusBuildContextMenu = null;
   },

   getURLsForContainerNode: null,

   buildContextMenu : function TMP_PC_buildContextMenu() {
      var _open = document.getElementById("placesContext_open");
      var _openInWindow = document.getElementById("placesContext_open:newwindow");
      var _openInTab = document.getElementById("placesContext_open:newtab");
      TMP_updateContextMenu(_open, _openInWindow, _openInTab, this.getPrefByDocumentURI(window));
   },

   historyMenuItemsTitle : function TMP_PC_historyMenuItemsTitle(aEvent) {
      var aMenuPopup = aEvent.target;
      if (aMenuPopup.id != "goPopup" || !gTabmixPrefs.getBoolPref("extensions.tabmix.titlefrombookmark"))
         return;

      for (var i = 0; i < aMenuPopup.childNodes.length ; i++) {
         if (aMenuPopup.childNodes[i].id == "startHistorySeparator")
            break;
      }
      for (i++; i < aMenuPopup.childNodes.length ; i++) {
         var item = aMenuPopup.childNodes[i];
         if (item.id == "endHistorySeparator")
            break;
         var bookMarkName = getTitleFromBookmark(item._placesNode.uri);
         if (bookMarkName)
            item.setAttribute("label", bookMarkName);
      }
   },

   // replace openlivemarksite-menuitem with tabmix function
   openLivemarkSite : function TMP_PC_openLivemarkSite(aUrl, aEvent) {
     var where = this.fixWhereToOpen(aEvent, whereToOpenLink(aEvent), prefStringTMBookmark);
     openUILinkIn(aUrl, where);
   },

   historyMenu : function TMP_PC_historyMenu(aEvent) {
      var node = aEvent.target._placesNode;
      if (node) {
         PlacesUIUtils.markPageAsTyped(node.uri);
         var where = this.isBookmarklet(node.uri) ? "current" :
                      this.fixWhereToOpen(aEvent, whereToOpenLink(aEvent, false, true), prefStringTMHistory);
         openUILinkIn(node.uri, where);
      }
   },

   isBookmarklet : function (url) {
      var jsURL = /^ *javascript:/;
      return jsURL.test(url) ? true : false;
   },

   fixWhereToOpen: function (aEvent, aWhere, aPref) {
      var w = getTopWin();
      if (!w)
         return aWhere;

      var tabBrowser = w.gBrowser;
      var aTab = tabBrowser.mCurrentTab;

      if (typeof(aPref) == "undefined")
         aPref = this.getPrefByDocumentURI(window);

      var _pref = w.gTabmixPrefs;
      if ((_pref.getBoolPref(aPref) || aTab.hasAttribute("locked")))
         if (aEvent && _pref.getBoolPref(prefStringTMUseMiddleClick) &&
               (aEvent.button == 1 || aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey)))
            aWhere = "current";
         else if (aWhere == "current" && !tabBrowser.isBlankNotBusyTab(aTab))
            aWhere = "tab";

      return aWhere;
   },

   getPrefByDocumentURI: function (aWindow) {
     switch (aWindow.document.documentURI) {
       case "chrome://browser/content/places/places.xul":
         if (PlacesOrganizer._places.selectedNode.itemId != PlacesUIUtils.leftPaneQueries["History"])
           break;
       case "chrome://browser/content/history/history-panel.xul":
         return prefStringTMHistory;
       case "chrome://browser/content/browser.xul":
       case "chrome://browser/content/bookmarks/bookmarksPanel.xul":
       default:
         break;
     }
     return prefStringTMBookmark;
   },

  // fixed: reuse all blank tab not just in the end
  // fixed: if "browser.tabs.loadFolderAndReplace" is true don't reuse locked and protected tabs open bookmark after those tabs
  // fixed: focus the first tab if "extensions.tabmix.openTabNext" is true
  // fixed: remove "selected" and "flst_id" from reuse tab
  openGroup: function TMP_PC_openGroup(bmGroup, bmIds, aWhere) {
    var tabBar = gBrowser.tabContainer;
    var tabs = tabBar.childNodes;

    var doReplace = (/^tab/).test(aWhere) ? false :
                             gTabmixPrefs.getBoolPref("browser.tabs.loadFolderAndReplace");
    var loadInBackground = bmGroup.length > 1 ? gTabmixPrefs.getBoolPref("extensions.tabmix.loadBookmarksGroupInBackground") :
                                                 gTabmixPrefs.getBoolPref("browser.tabs.loadBookmarksInBackground");
    var openTabNext = getOpenTabNextPref();

    // catch tab for reuse
    var aTab, reuseTabs = [], removeTabs = [], i;
    var tabIsBlank, canReplace;
    for (i = 0; i < tabs.length ; i++) {
       aTab = tabs[i];
       tabIsBlank = gBrowser.isBlankNotBusyTab(aTab);
       // don't reuse collapsed tab if width fitTitle is set
       canReplace = (doReplace && !aTab.hasAttribute("locked")) || tabIsBlank;
       if (reuseTabs.length < bmGroup.length && canReplace)
          reuseTabs.push(aTab);
       else if ((doReplace && !aTab.hasAttribute("locked") && !aTab.hasAttribute("protected")) || tabIsBlank) {
          aTab.collapsed = true;
          removeTabs.push(aTab);
       }
    }

    var tabToSelect = null;
    var prevTab = (!doReplace && openTabNext && gBrowser.mCurrentTab._tPos < tabs.length - 1) ? gBrowser.mCurrentTab : tabBar.lastChild;
    var tabPos, index;
    for (i = 0; i < bmGroup.length ; i++) {
       try { // bug 300911
          if (i < reuseTabs.length) {
             aTab = reuseTabs[i];
             let browser = gBrowser.getBrowserForTab(aTab);
             browser.userTypedValue = bmGroup[i];
             browser.loadURI(bmGroup[i]);
             // setTabTitle will call tabBarScrollStatus for us
             aTab.collapsed = false;
             // reset visited & flst_id attribute
             if (aTab != gBrowser.mCurrentTab) {
                aTab.removeAttribute("visited");
                aTab.removeAttribute("flst_id");
             } else
                aTab.setAttribute("reloadcurrent", true);
          }
          else
             aTab = gBrowser.addTab(bmGroup[i]);
          if (bmIds[i] && bmIds[i] > -1)
             aTab.setAttribute("tabmix_bookmarkId", bmIds[i]);
       } catch (er) {
       }

       if (!tabToSelect)
          tabToSelect = aTab;
       // move tab to place
       index = prevTab._tPos + 1;
       tabPos = aTab._tPos < index ? index - 1 : index;
       gBrowser.TMmoveTabTo(aTab, tabPos);
       prevTab = aTab;
    }
    tabBar.nextTab = 1;

    // focus the first tab if prefs say to
    if (!loadInBackground || doReplace &&
                             (gBrowser.selectedTab.hasAttribute("reloadcurrent") ||
                              gBrowser.selectedTab in removeTabs)) {
      var old = gBrowser.selectedTab;
      gBrowser.selectedTab = tabToSelect;
      if (old != tabToSelect)
        tabToSelect.owner = old;
      var reloadCurrent = old.hasAttribute("reloadcurrent");
      if (reloadCurrent)
        old.removeAttribute("reloadcurrent");
      if (reloadCurrent && old != tabToSelect) {
        old.removeAttribute("visited");
        old.removeAttribute("flst_id");
      }
    }

    // and focus the content
    content.focus();

    // Close any remaining open tabs or blank tabs that are left over.
    while (removeTabs.length > 0) {
       gBrowser.removeTab(removeTabs.pop());
    }

  },

   getBookmarkTitle: function TMP_PC_getBookmarkTitle(aUrl, aItemId) {
      try {
         if (aItemId && aItemId > -1) {
           var _URI = PlacesUtils.bookmarks.getBookmarkURI(aItemId);
           if (_URI && _URI.spec == aUrl)
             return PlacesUtils.bookmarks.getItemTitle(aItemId);
         }
         aItemId = PlacesUtils.getMostRecentBookmarkForURI(gIOService.newURI(aUrl, null, null));
         return aItemId > -1 ? PlacesUtils.bookmarks.getItemTitle(aItemId): null;
      } catch (ex) {
        TMP_ASSERT(ex);
      }
      return null;
   },

   // start showAddBookmarkUI with user defined title if exist
   getTabFixedTitle: function TMP_PC_getTabFixedTitle(aBrowser, aURI) {
      if (gBrowser == aBrowser)
         aBrowser = gBrowser.selectedBrowser;

      var aTab = gBrowser.getTabForBrowser(aBrowser);
      var fixedLabelUri = aTab.getAttribute("label-uri");
      if (fixedLabelUri && (fixedLabelUri == aURI.spec || fixedLabelUri == "*"))
         return aTab.getAttribute("fixed-label");

      return null;
   }

}

function getTitleFromBookmark(aUrl, aTitle, aItemId) {
   if (!gTabmixPrefs.getBoolPref("extensions.tabmix.titlefrombookmark") || !aUrl)
      return aTitle;
   var title = TMP_Places.getBookmarkTitle(aUrl, aItemId);
   var ieTab = "gIeTab" in window;
   if (title || !ieTab)
      return title || aTitle;

   // IE Tab is installed try to find url with or without the prefix
   var ietab = "chrome://ietab/content/reloaded.html?url="
   if (aUrl == ietab)
      return aTitle;
   if (aUrl.indexOf(ietab) == 0)
      title = TMP_Places.getBookmarkTitle(aUrl.replace(ietab, ""), aItemId);
   else
      title = TMP_Places.getBookmarkTitle(ietab + aUrl, aItemId);

   return title || aTitle;
}

// if we don't have any browser window open return false so we can open new window
function getSingleWindowMode() {
  var w = getTopWin();
  if (!w)
    return false;
  return w.gTabmixPrefs.getBoolPref("extensions.tabmix.singleWindow", false);
}

// update context menu for bookmarks manager and sidebar
// for bookmarks/places, history, sage and more.....
function TMP_updateContextMenu(open, openInWindow, openInTab, pref) {
  // if all 3 was hidden ... probably "Open all in Tabs" is visible
  if (open.hidden && openInWindow.hidden && openInTab.hidden)
    return;

  var w = getTopWin();
  if (w) {
    var where = w.TMP_whereToOpen(pref);

    if (!openInWindow.hidden && w.gSingleWindowMode)
      openInWindow.hidden = true;
    else if (openInWindow.hasAttribute("default"))
      openInWindow.removeAttribute("default");

    TMP_setItem(openInTab, "default", where.inNew ? "true" : null);

    if (open.hidden != where.lock)
      open.hidden = where.lock;
    if (!open.hidden)
      TMP_setItem(open, "default", !where.inNew ? "true" : null);
  }
  else {
    open.hidden = true;
    openInTab.hidden = true;
    openInWindow.hidden = false;
    openInWindow.setAttribute("default", true);
  }
}


// Show/hide one item (specified via name or the item element itself).
function TMP_showItem (aItemOrId, aShow) {
  var item = typeof(aItemOrId) == "string" ? document.getElementById(aItemOrId) : aItemOrId;
  if (item)
    item.hidden = !aShow;
}

function TMP_setItem(aItemOrId, aAttr, aVal) {
  var elem = typeof(aItemOrId) == "string" ? document.getElementById(aItemOrId) : aItemOrId;
  if (elem) {
    if (aVal == null) {
      elem.removeAttribute(aAttr);
      return;
    }
    if (typeof(aVal) == "boolean")
      aVal = aVal ? "true" : "false";

    if (elem.getAttribute(aAttr) != aVal)
      elem.setAttribute(aAttr, aVal);
  }
}

/* DEPRECATED */
const TMP_D_MSG = "This function was DEPRECATED in TabMix since version 0.3.8.2pre.090822";
var TMP_Bookmark = {
  // TreeStyleTab eval TMP_Bookmark.openGroup function so we keep it here
  openGroup: function TMP_BM_openGroup(bmGroup, bmIds, aWhere) { },
  buildContextMenu: function () { tmLog(TMP_D_MSG, true); },
  TMP_openGroupBookmark: function () { tmLog(TMP_D_MSG, true); },
  _getBookmarkTitle: function () { tmLog(TMP_D_MSG, true); }
}
function isBookmarkletTM() { tmLog(TMP_D_MSG, true); }
function openInWebPanelTM() { tmLog(TMP_D_MSG, true); }
function whereToOpenLinkTabmix() { tmLog(TMP_D_MSG, true); }
function TMP_update_whereToOpen() { tmLog(TMP_D_MSG, true); }
