/***************************************************************************
 *
 * Copyright (c) 1999 Balzs Scheidler
 * Copyright (c) 1999-2001 BalaBit IT Ltd.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: afinter.c,v 1.12 2001/08/26 15:06:25 bazsi Exp $
 *
 * Log source for internal messages of syslog-ng
 *
 ***************************************************************************/

#include "afinter.h"
#include "werror.h"
#include "syslog-names.h"
#include "cfgfile.h"
#include "log.h"

static struct syslog_config *assigned_configuration = NULL;

static int write_internal_message(int level, UINT32 length, UINT8 *data)
{
	struct log_info *msg;
	int pri;

	if (assigned_configuration && assigned_configuration->internal) {
		switch (level) {
		case MSG_ERROR:
			pri = LOG_SYSLOG | LOG_ERR;
			break;
		case MSG_FATAL:
			pri = LOG_SYSLOG | LOG_CRIT;
			break;
		case MSG_DEBUG:
			pri = LOG_SYSLOG | LOG_DEBUG;
			break;
		case MSG_VERBOSE:
		case MSG_NOTICE:
		default:
			pri = LOG_SYSLOG | LOG_NOTICE;
		}
		while (data[length - 1] == '\n') 
			length--;
		msg = make_internal_message(pri, length, data);
		msg->flags |= LF_LOCAL;
		HANDLE_LOG(assigned_configuration->internal, msg);
		return 0;
	}
	return 0;
}

void set_error_internal(void)
{
	error_write = write_internal_message;
}

static int do_init_afinter(struct log_handler *c, 
			   struct syslog_config *cfg,
			   struct persistent_config *persistent)
{
	CAST(log_source_driver, self, c);
	if (assigned_configuration == NULL) {
		cfg->internal = self->super.next;
		assigned_configuration = cfg;
		return ST_OK | ST_GOON;
	}
	else {
		werror("Internal sources can only be referenced once!\n");
		return ST_FAIL | ST_QUIT;
	}
}

static void 
do_destroy_afinter(struct log_handler *c, 
		   struct syslog_config *cfg, 
		   struct persistent_config *persistent)
{
	if (cfg == assigned_configuration) {
		assigned_configuration = NULL;
	}
}

struct log_source_driver *make_afinter_source(void)
{
	NEW(log_source_driver, self);

	self->super.super.init = do_init_afinter;
	self->super.super.destroy = do_destroy_afinter;
	return self;
}
