# $Id: FramesIndex.py,v 1.8 2002/11/02 06:37:37 chalky Exp $
#
# This file is a part of Synopsis.
# Copyright (C) 2000, 2001 Stephen Davies
# Copyright (C) 2000, 2001 Stefan Seefeld
#
# Synopsis is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Log: FramesIndex.py,v $
# Revision 1.8  2002/11/02 06:37:37  chalky
# Allow non-frames output, some refactoring of page layout, new modules.
#
# Revision 1.7  2002/11/01 03:39:21  chalky
# Cleaning up HTML after using 'htmltidy'
#
# Revision 1.6  2002/10/29 12:43:56  chalky
# Added flexible TOC support to link to things other than ScopePages
#
# Revision 1.5  2001/07/05 05:39:58  stefan
# advanced a lot in the refactoring of the HTML module.
# Page now is a truely polymorphic (abstract) class. Some derived classes
# implement the 'filename()' method as a constant, some return a variable
# dependent on what the current scope is...
#
# Revision 1.4  2001/06/28 07:22:18  stefan
# more refactoring/cleanup in the HTML formatter
#
# Revision 1.3  2001/06/26 04:32:16  stefan
# A whole slew of changes mostly to fix the HTML formatter's output generation,
# i.e. to make the output more robust towards changes in the layout of files.
#
# the rpm script now works, i.e. it generates source and binary packages.
#
# Revision 1.2  2001/02/01 15:23:24  chalky
# Copywritten brown paper bag edition.
#
#

import os
import Page
from core import config
from Tags import *

class FramesIndex (Page.Page):
    """A class that creates an index with frames"""
    # TODO figure out how to set the default frame contents
    def __init__(self, manager):
	Page.Page.__init__(self, manager)

    def filename(self): return config.files.nameOfIndex()
    def title(self): return 'Synopsis - Generated Documentation'

    def register(self):
        config.set_main_page(self.filename())

    def process(self, start):
	"""Creates a frames index file"""
	me = config.files.nameOfIndex()
	# TODO use project name..
	self.start_file(body='')
	fcontents = rel(me, config.page_contents)
	findex = rel(me, config.page_index)
	# Find something to link to
	fglobal = findex
	decls = [start]
	while decls:
	    decl = decls.pop(0)
	    entry = config.toc[decl.name()]
	    if entry:
		fglobal = rel(me, entry.link)
		break
	    if hasattr(decl, 'declarations'):
		# Depth-first search
		decls = decl.declarations() + decls
	frame1 = solotag('frame', name='contents', src=fcontents)
	frame2 = solotag('frame', name='index', src=findex)
	frame3 = solotag('frame', name='main', src=fglobal)
	frameset1 = entity('frameset', frame1+frame2, rows="30%,*")
	frameset2 = entity('frameset', frameset1+frame3, cols="200,*")
	self.write(frameset2)
	noframes = 'This document was configured to use frames.'
	noframes = noframes + '<ul>'
	noframes = noframes + entity('li', href(fcontents, 'The default Contents frame'))
	noframes = noframes + entity('li', href(findex, 'The default Index frame'))
	noframes = noframes + entity('li', href(fglobal, 'The default Main frame'))
	noframes = noframes + '</ul>'
	noframes = noframes + 'Generated by Synopsis.'
	self.write(entity('noframes', noframes))
	self.end_file(body='')


htmlPageClass = FramesIndex
