
#include "config.h"
#include "i18n.h"

#include "rwsourceswindow.h"

#include <WINGs/wtableview.h>

#include "up.xpm"
#include "down.xpm"


static int numberOfRows(WMTableViewDelegate *self, WMTableView *table)
{
    return 0;
}


static void *valueForCell(WMTableViewDelegate *self, WMTableColumn *column, int row)
{

    return (void*)"A";
}




static WMButton *makeButton(WMWidget *parent, char **image)
{
    WMButton *button;
    WMPixmap *pix;
    
    button = WMCreateCommandButton(parent);

    pix = WMCreatePixmapFromXPMData(WMWidgetScreen(parent), image);
    WMSetButtonImagePosition(button, WIPImageOnly);
    WMSetButtonImage(button, pix);
    WMReleasePixmap(pix);

    return button;
}


RWSourcesWindow::RWSourcesWindow(RWWindow *parent)
    : RWWindow(parent, "sources")
{
    WMBox *hbox;
    WMButton *btn;
    WMTableView *table;
    WMScreen *scr = WMWidgetScreen(_win);
    static WMTableViewDelegate delegate = {
	NULL,
	    numberOfRows,
	    valueForCell,
	    NULL
    };
    
    WMResizeWidget(_win, 600, 200);

    WMSetBoxHorizontal(_topBox, False);
     
    
    table = WMCreateTableView(_topBox);
    WMSetTableViewDataSource(table, this);
    WMSetTableViewBackgroundColor(table, WMWhiteColor(scr));
    WMSetTableViewGridColor(table, WMGrayColor(scr));
    WMSetTableViewHeaderHeight(table, 18);
    WMSetTableViewDelegate(table, &delegate);
    WMAddBoxSubview(_topBox, WMWidgetView(table), True, True, 200, 0, 5);

    {
	WMTableColumn *col;
	
    	col = WMCreateTableColumn("");
	WMAddTableViewColumn(table, col);
	WMSetTableColumnWidth(col, 20);
//	WMSetTableColumnDelegate(col, colDeleg);
	WMSetTableColumnId(col, (void*)0);
	
	col = WMCreateTableColumn(_("Type"));
	WMSetTableColumnWidth(col, 50);
	WMAddTableViewColumn(table, col);
//	WMSetTableColumnDelegate(col, colDeleg);
	WMSetTableColumnId(col, (void*)1);	
	
	col = WMCreateTableColumn(_("Vendor"));
	WMSetTableColumnWidth(col, 54);	
	WMAddTableViewColumn(table, col);
//	WMSetTableColumnDelegate(col, colDeleg);
	WMSetTableColumnId(col, (void*)2);
	
	col = WMCreateTableColumn(_("URI"));
	WMSetTableColumnWidth(col, 250);
	WMAddTableViewColumn(table, col);
//	WMSetTableColumnDelegate(col, colDeleg);
	WMSetTableColumnId(col, (void*)4);
	
	col = WMCreateTableColumn(_("Distribution"));
	WMSetTableColumnWidth(col, 80);
	WMAddTableViewColumn(table, col);
//	WMSetTableColumnDelegate(col, colDeleg);
	WMSetTableColumnId(col, (void*)3);
	
	col = WMCreateTableColumn(_("Components"));
	WMSetTableColumnWidth(col, 100);
	WMAddTableViewColumn(table, col);
//	WMSetTableColumnDelegate(col, colDeleg);
	WMSetTableColumnId(col, (void*)4);	
    }

   
    hbox = WMCreateBox(_topBox);
    WMSetBoxHorizontal(hbox, True);
    WMAddBoxSubview(_topBox, WMWidgetView(hbox), False, True, 24, 0, 0);

    btn = makeButton(hbox, up_xpm);
    WMAddBoxSubview(hbox, WMWidgetView(btn), False, True, 24, 0, 3);

    btn = makeButton(hbox, down_xpm);
    WMAddBoxSubview(hbox, WMWidgetView(btn), False, True, 24, 0, 10);

    

    btn = WMCreateCommandButton(hbox);
    WMSetButtonText(btn, _("Add Repository"));
    WMAddBoxSubview(hbox, WMWidgetView(btn), False, True, 120, 0, 5);

    btn = WMCreateCommandButton(hbox);
    WMSetButtonText(btn, _("Add CD-ROM"));
    WMAddBoxSubview(hbox, WMWidgetView(btn), False, True, 120, 0, 5);
    
    btn = WMCreateCommandButton(hbox);
    WMSetButtonText(btn, _("Remove"));
    WMAddBoxSubview(hbox, WMWidgetView(btn), False, True, 100, 0, 5);

    btn = WMCreateCommandButton(hbox);
    WMSetButtonText(btn, _("Close"));
    WMAddBoxSubviewAtEnd(hbox, WMWidgetView(btn), False, True, 100, 0, 0);
    
    WMMapSubwidgets(_topBox);
    WMMapSubwidgets(_win);
    
    setTitle("Setup Package Repositories (nao ta funcionando ainda!)");
    
    WMRealizeWidget(_win);
}

