/* rpackagecache.h - package cache wrapper
 * 
 * Copyright (c) 2000, 2001 Conectiva S/A 
 * 
 * Author: Alfredo K. Kojima <kojima@conectiva.com.br>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef _RPACKAGECACHE_H_
#define _RPACKAGECACHE_H_



#include <apt-pkg/depcache.h>
#ifdef HAVE_RPM
# include <apt-pkg/rpminit.h>
#endif


class OpProgress;

#ifndef HAVE_RPM
class pkgCache;
class pkgPolicy;
#endif

class RPackageCache {
    MMap *_map;

#ifndef HAVE_RPM
    pkgCache *_cache;
    pkgPolicy *_policy;
#endif

    pkgDepCache *_dcache;    
    
    bool _locked;
   
#ifdef HAVE_RPM
    pkgRpmLock *_lock;
#endif
    
 public:
    inline pkgDepCache *deps() { return _dcache; };
    
    bool open(OpProgress &progress);
    bool reset(OpProgress &progress);
    
    bool lock();
    void releaseLock();
    
#ifdef HAVE_RPM
    RPackageCache() : _map(0), _dcache(0), _lock(0) {};
#else
    RPackageCache() : _map(0), _cache(0), _policy(0), _dcache(0) {};
#endif
};


#endif
