package sylseg_sk::Trans_sylseg;
require 5.000;
require Exporter;
*import = \&Exporter::import;

@ISA = qw(Exporter);
@EXPORT = qw(gen_pos_sylabels calc_probs set_debug_level mess);

use Term::ANSIColor qw(:constants);

warn "Loading module - Trans_syl_seg ...\n";

my $statistics="/usr/share/sylseg_sk/sylseg-sk.stats";
my (%g1_tp, %g1_bp, %g1_mp);
my @syl;
my $prior=1;
my $colour=0;

mess("Reading statistics ...",1);
read_statistics();

sub calc_probs
{
 my @oprb;
 foreach $att (@_)
 {
  my @seq=split("-",$att);
  my $n=@seq;
  mess("Computing prob. for $att  -> $n ...",2);
  my $P=1;
  for($i=0;$i<$n;$i++)
  {
   my $w3=$seq[$i];
   my $w2=$seq[$i-1]; 
   my $w1=$seq[$i-2];
   $P*=b_prob("","",$w3) if($i==0);
   $P*=b_prob("","$w3-$w2",$w3) if($i==1);
   $P*=b_prob("$w3-$w2-$w1","$w3-$w2",$w3) if($i>1);
  }
  mess("Prob.: $P ...",2);
  $oprb[@oprb]="${P}::$att";
 }
 return sort byval @oprb;
 #return @oprb;
}

sub byval
{
 ret_p($b) <=> ret_p($a);
}

sub ret_p
{
 ($p,$r)=split("::",$_[0]);
 return $p; 
}

sub b_prob
{
 my $tg=$_[0];
 my $bg=$_[1];
 my $mg=$_[2];
 my $l1=0.15;
 my $l2=0.35;
 my $l3=0.5;
 my ($P3,$P2,$P1);
 if(defined($g1_tp{"$tg"})) {$P3=$g1_tp{"$tg"};}
  else {$P3=0;}
 if(defined($g1_bp{"$bg"})) {$P2=$g1_bp{"$bg"};}
  else {$P2=0;}
 if(defined($g1_mp{"$mg"})) {$P1=$g1_mp{"$mg"};}
  else {$P1=0;}
 mess("TG($tg): $P3\tBG($bg): $P2\tMG($mg): $P1",3);
 my $P=$l3*$P3+$l2*$P2+$l1*$P1;
 mess("b_prob $tg, $bg, $mg --> $P",3);
 return $P;
}

sub gen_pos_sylabels
{
 my (@psyl1,@psyl2);
 $psyl2[0]=$_[0];
 while(join("",@psyl1) ne join("",@psyl2))
 {
  @psyl1=@psyl2;
  @psyl2=();
  foreach $w (@psyl1)
  {
   $snum=0;
   @lager=split("-",$w);
   $_="-".pop(@lager);
   $lager=join("-",@lager);
   foreach $s (sort @syl)
   {
    if(/-$s/)
    {
     $tt=$_;
     s/-$s/-$s-/;
     $str="$lager".$_;
     push @psyl2,$str if(!member(@psyl2,$str));
     $_=$tt;
     $snum++;
     mess("Applied:   $s",4);
    }
   }
   push @psyl2,"$lager".$_ if($snum==0);
  }
  $a=join(":",@psyl1); mess("$a",4);
  $a=join(":",@psyl2); mess("$a",4);
 } 
 foreach $_ (@psyl2) { s/^-//; s/-$//;}
 return @psyl2;
}

sub member
{
 my $s=pop(@_);
 foreach $h (@_)
  { return 1 if($s eq $h);}
 return 0;
}

sub print_h
{
 my $h=$_[0];
 my $p=$_[1];
 foreach $k (sort keys %$h)
 {
  print "${k}::$$h{$k}::$$p{$k}\n";
 }
}

sub read_statistics
{
 open (STAT,"< $statistics") or
    die ("Nie je mozne otvorit vstupny subor $statistics!!!\n");
 my $st="nic";
 while(<STAT>)
 {
  chomp;
  if(/ MONO G1 /) {$st="mono"; next;}
  if(/ BI G1 /) {$st="bi"; next;}
  if(/ TRI G1 /) {$st="tri"; next;}
  if(/\*\*\*/) {$st="nic"; next;}
  next if($st eq "nic");
  ($gr,$cn,$pr)=split("::",$_);
  $g1_tp{$gr}=$pr if($st eq "tri");
  $g1_bp{$gr}=$pr if($st eq "bi");
  $g1_mp{$gr}=$pr if($st eq "mono");
 }
 close STAT;
 $mon=keys %g1_mp;
 $bi=keys %g1_bp;
 $tri=keys %g1_tp;
 mess("Stats M: $mon B: $bi T: $tri",1);
 @syl=keys %g1_mp;
}

sub set_debug_level
{
   my $tmp=shift;
   my $tmpC=shift;
   return "Error - debug level out of range" if($tmp<0 or $tmp>5);
   $prior=$tmp;
   $colour=$tmpC if($tmpC==0 or $tmpC==1);
   return "true";
}

sub mess
  {
    my($msg,$pr)=@_;
    if($pr <= $prior)
      {
        $nt=$pr-1; $ss="";
	for($x=0;$x<$nt;$x++){$ss.="\t";}
	print "$ss$msg \n" if($colour==0);
        #1-YELLOW,BOLD,2-YELLOW,3-GREEN,         5-default
        print YELLOW,BOLD,"$msg \n",RESET if($pr==1 and $colour==1);
        print YELLOW,"$ss$msg \n",RESET if($pr==2 and $colour==1);
        print GREEN,"$ss$msg \n",RESET if($pr==3 and $colour==1);
        print BLUE,"$ss$msg \n",RESET if($pr==4 and $colour==1);
        print RESET,"$ss$msg \n" if($pr==5 and $colour==1);
      }
  }


END {
    close STDOUT            || die "$0: can't close stdout: $!\n";
    $? = 1 if $? == 255;    # from die
} 

# abcddzdefghchijklmnopqrstuvxyz
# ABCDDzDEFGHChIJKLťMNOPQRSTUVXYZ

