// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef DIFF_TOOLS_IS_INCLUDED
#define DIFF_TOOLS_IS_INCLUDED

#include <ginac/ginac.h>

namespace SyFi
{

	// the divergence
	// GiNaC::ex div(GiNaC::exvector& v);
	GiNaC::ex div(GiNaC::lst& v);
	GiNaC::ex div(GiNaC::lst& v,GiNaC::ex G);
	GiNaC::ex div(GiNaC::ex v);
	GiNaC::ex div(GiNaC::ex v, GiNaC::ex G);

	// the gradient
	GiNaC::ex grad(GiNaC::ex f);
	GiNaC::ex grad(GiNaC::ex f, GiNaC::ex G);

}
#endif
