#include <SyFi.h> 
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    symbol x0("x0"), x1("x1"), y0("y0"), y1("y1"), z0("z0"); 

    ex p0 = lst(x0,y0,z0);
    ex p1 = lst(x1,y0,z0);
    ex p2 = lst(x0,y1,z0);

    Triangle triangle(p0,p1,p2);

    ex repr = triangle.repr();
    cout <<"t.repr "<<repr<<endl; 

    ex f = x*y*z;
    ex intf = triangle.integrate(f); 
    cout <<"intf "<<intf<<endl; 


    // regression test
    /*

    archive ar; 
    ar.archive_ex(repr, "repr"); 
    ar.archive_ex(intf, "intf"); 

    ofstream vfile("triangle_ex2.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("triangle_ex2.gar.v", "triangle_ex2.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }
    */

    return 0; 
}

