#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    ReferenceTriangle domain; 

    VectorCrouzeixRaviart v_fe;
    v_fe.set_size(2); 
    v_fe.set_polygon(domain);
    v_fe.compute_basis_functions();

    P0 p_fe;
    p_fe.set_polygon(domain);
    p_fe.compute_basis_functions();

    usage(v_fe, p_fe); 


    Dof dof; 
    std::map<std::pair<unsigned int,unsigned int>, ex> A; 
    compute_Stokes_element_matrix(v_fe, p_fe, dof, A);  
    print(A); 


    // regression test 

    archive ar; 
    for (unsigned int i=0; i<v_fe.nbf(); i++) {
	    ar.archive_ex(v_fe.N(i), istr("vN",i).c_str()); 
    }
    for (unsigned int i=0; i<p_fe.nbf(); i++) {
	    ar.archive_ex(p_fe.N(i), istr("pN",i).c_str()); 
    }

    std::map<std::pair<unsigned int,unsigned int>, ex>::iterator iter; 
    for (iter = A.begin(); iter != A.end() ; iter++) {
	    ar.archive_ex((*iter).second, istr("A", (*iter).first.first, (*iter).first.second).c_str());
    }

    ofstream vfile("crouzeixraviart_ex2.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("crouzeixraviart_ex2.gar.v", "crouzeixraviart_ex2.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}

