#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    ex f = x*y*z;
    
    // integration over the reference box
    ReferenceBox box; 

    ex repr = box.repr();
    cout <<"b.repr "<<repr<<endl; 

    ex intf = box.integrate(f); 
    cout <<"intf "<<intf<<endl; 

    // integration over the another box
    ex p0 = lst(-1.0,-1.0,-1.0);
    ex p1 = lst( 1.0, 1.0, 1.0);

    Box box2(p0,p1);

    ex repr2 = box2.repr();
    cout <<"b2.repr "<<repr<<endl; 



    ex intf2 = box2.integrate(f); 
    cout <<"intf2 "<<intf2<<endl; 


    // regression test

    archive ar; 
    ar.archive_ex(repr, "repr"); 
    ar.archive_ex(intf, "intf"); 
    ar.archive_ex(repr2, "repr2"); 
    ar.archive_ex(intf2, "intf2"); 


    ofstream vfile("box_ex1.gar.v"); 
    vfile << ar; vfile.close(); 

    if(!compare_archives("box_ex1.gar.v", "box_ex1.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}

