// Copyright (C) 2009-2009 Martin Sandve Alnæs
// Licensed under the GNU LGPL Version 3.0.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes a projection of a function
// between two vector finite element spaces.

#include <dolfin.h>
#include "generated_code/ProjectionVector.h"

using namespace dolfin;
using namespace ProjectionVector;

class Weight: public Function
{
public:
  Weight(const FunctionSpace & V):
    Function(V) {}

  void eval(double* values, const double* x) const
  {
    values[0] = 1.0;
  }
};

class Source: public Function
{
public:
  Source(const FunctionSpace & V):
    Function(V) {}

  void eval(double* values, const double* x) const
  {
    double dx = x[0] - 0.5;
    double dy = x[1] - 0.5;
    //values[0] = cos(2*DOLFIN_PI*dx*dx);
    //values[1] = cos(2*DOLFIN_PI*dy*dy);
    values[0] = x[0] + x[1];
    values[1] = x[0] + x[1];
  }
};

int main(int argc, char ** argv)
{
  UnitSquare mesh(10, 10);

  BilinearForm::TrialSpace V(mesh);
  CoefficientSpace_c C(mesh);
  CoefficientSpace_f F(mesh);

  Weight c(C);
  Source f(F);
  Function u(V);

  BilinearForm a(V, V);
  LinearForm L(V);

  a.c = c;
  L.f = f;

  Matrix A;
  Vector b;
  Assembler::assemble(A, a);
  Assembler::assemble(b, L);

  LUSolver solver(symmetric);
  solver.solve(A, u.vector(), b);
  
  // Interpolate f onto the discrete space V
  Source f2(V);
  Function fi(V);
  f2.interpolate(fi.vector(), V);
  
  File u_file("u.pvd");
  u_file << u;
  File f_file("f.pvd");
  f_file << fi;
  
  //plot(u);
  
  return 0;
}

