//
// C++ Implementation: swsystemtray
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "swsystemtray.h"
#include "mainwindow.h"

SWSystemTray::SWSystemTray(QString ifc, QWidget *parent, const char *name) : KSystemTray(parent, name)
{
	qDebug("Creating SWSystemTray...");

	iface = ifc;
	table = (AccessPointListView*) parentWidget()->child("tblScan");

	KAction * startAction = ((KMainWindow*)parent)->actionCollection()->action("actions_start");	
	startAction->plug(contextMenu());

	KAction * stopAction = ((KMainWindow*)parent)->actionCollection()->action("actions_stop");	
	stopAction->plug(contextMenu());

	KAction * clearAction = ((KMainWindow*)parent)->actionCollection()->action("actions_clear");	
	clearAction->plug(contextMenu());
	
	aplist = new KPopupMenu(this, "accesspointlist");
	connect (aplist, SIGNAL( highlighted(int) ), this, SLOT( itemHighlighted(int) ));
	
	contextMenu()->insertItem(UserIcon("signal_good"), i18n("AccessPoints"), aplist);	
}

SWSystemTray::~SWSystemTray()
{
	qDebug("Deleting SWSystemTray...");
}

int SWSystemTray::getMenuId(KPopupMenu * popup,  QString  name)
{
	int id = 0, i = 0;
	
	while ( (id = popup->idAt(i++)) != -1) {
		if (popup->text(id) == name) {
			return id;
		}
	}
	return -1;
}

void SWSystemTray::contextMenuAboutToShow(KPopupMenu * popup)
{
	
	KActionPtrList list = actionCollection()->actions();
	QString essid, mac;
	QListViewItem * myChild = table->firstChild();
	configPopupMenu * tempMenu = 0;
	bool wep = false;
	bool visible = false;
	popup = popup;
	
	aplist->clear();
        while( myChild ) {
		mac = myChild->text(table->getCol(i18n("MAC")));
		essid = myChild->text(table->getCol(i18n("ESSID")));
		wep = ((myChild->text(table->getCol(i18n("WEP")))==i18n("YES")));
		
		if (parentWidget()->queryList("KPopupMenu", mac)->count() > 0) 
		{ // Use an existent one if exists...
			tempMenu = (configPopupMenu *)parentWidget()->queryList("KPopupMenu", mac)->at(0);
			tempMenu->update();
		}
		else
		{ //Otherwise create...
			tempMenu = new configPopupMenu(parentWidget(), mac, essid, mac, wep, iface);
		}
		// ... and insert it
 		aplist->insertItem( SmallIcon(wep ? "redled" : "greenled"), essid + " (" + mac + ")",  tempMenu );
		
		visible = myChild->isVisible();
		aplist->setItemVisible(getMenuId(aplist, essid + " (" + mac + ")"), visible);

		myChild = myChild->nextSibling();
        }
}

void SWSystemTray::itemHighlighted(int id)
{
	// Extract the mac from the highlighted menuitem text in format "essid (mac)"
	QStringList temp = QStringList::split("(", aplist->text(id));
	QString mac = temp[1].remove(')');
	
	// Set the ap's list table current item the highlighted menuitem in order to use the
	//associate(), removeconfig(), etc slots which use the tables's currentitem() data.	
	table->setCurrentItem(table->findItem(mac, table->getCol(i18n("MAC"))));

}
