/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: AbstractBorder.java,v $
   Revision 1.6  2004/05/03 20:53:45  dannaab
   small tweak to layoutmanager instance objects to make easier to read

   Revision 1.5  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.4  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.border;

import swingwt.awt.*;

public abstract class AbstractBorder implements Border {

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {}
    public Insets getBorderInsets(Component c) {  Insets insets = new Insets(); return getBorderInsets(c, insets); }
    public Insets getBorderInsets(Component c, Insets insets) { return insets; }
    public boolean isBorderOpaque() { return false; }
    public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
	    return getInteriorRectangle(c, this, x, y, width, height);
    }
    public static Rectangle getInteriorRectangle(Component c, Border b, int x, int y, int width, int height) {
        Insets insets;
	    if(b != null)
	        insets = b.getBorderInsets(c);
	    else
	        insets = new Insets(0,0,0,0);
            return new Rectangle( x+insets.left, y+insets.top, width-insets.right-insets.left,
	                              height-insets.top-insets.bottom);
    }
    static boolean isLeftToRight( Component c ) { return c.getComponentOrientation().isLeftToRight(); }
}
