/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: ColorModel.java,v $
   Revision 1.3  2004/04/29 12:49:26  bobintetley
   Additional JOptionePane constants, missing JTree methods and improved awt.Image support

   Revision 1.2  2004/04/21 10:44:31  bobintetley
   Code cleanup and native build script fix


*/
package swingwt.awt.image;

import swingwt.awt.Transparency;

/**
 * @author Robin Rawson-Tetley
 */
public class ColorModel implements Transparency {
    
    public ColorModel() {}
    public ColorModel(int bits) {}
    
    public static ColorModel getRGBdefault() {
	return new ColorModel();
    }
    public boolean hasAlpha() {
        return false;
    }
    public boolean isAlphaPremultiplied() {
        return false;
    }
    public int getTransferType() {
        return 0;
    }
    public int getPixelSize() {
	return 4;
    }
    public int getComponentSize(int componentIdx) {
        return 0;
    }
    public int[] getComponentSize() {
        return null;
    }
    public int getTransparency() {
        return OPAQUE;
    }
    public int getNumComponents() {
        return 0;
    }
    public int getNumColorComponents() {
        return 0;
    }
    public int getRed(int pixel) {
        return 0;
    }
    public int getGreen(int pixel) {
        return 0;
    }
    public int getBlue(int pixel) {
        return 0; 
    }
    public int getAlpha(int pixel) {
        return 0;
    }
    public int getRGB(int pixel) {
	return (getAlpha(pixel) << 24) | (getRed(pixel) << 16) | (getGreen(pixel) << 8) | (getBlue(pixel) << 0);
    }
    public int getRed(Object inData) {
        return 0;
    }
    public int getGreen(Object inData) {
        return 0;
    }
    public int getBlue(Object inData) {
        return 0;
    }
    public int getAlpha(Object inData) {
        return 0;
    }
    public int getRGB(Object inData) {
        return (getAlpha(inData) << 24) | (getRed(inData) << 16) | (getGreen(inData) << 8) | (getBlue(inData) << 0);
    }
    public Object getDataElements(int rgb, Object pixel) {
        throw new UnsupportedOperationException("");
    }
    public int[] getComponents(int pixel, int[] components, int offset) {
        throw new UnsupportedOperationException("");
    }
    public int[] getComponents(Object pixel, int[] components, int offset) {
        throw new UnsupportedOperationException("");
    }
    public int[] getUnnormalizedComponents(float[] normComponents, int normOffset, int[] components, int offset) {
        return null;
    }
    public float[] getNormalizedComponents(int[] components, int offset, float[] normComponents, int normOffset) {
        return null;
    }
    public int getDataElement(int[] components, int offset) {
        throw new UnsupportedOperationException("");
    }
    public Object getDataElements(int[] components, int offset, Object obj) {
        throw new UnsupportedOperationException("");
    }
    public int getDataElement(float[] normComponents, int normOffset) {
        return 0;
    }
    public Object getDataElements(float[] normComponents, int normOffset, Object obj) {
        return null;
    }
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
         return null;
    }
    public ColorModel coerceData (WritableRaster raster, boolean isAlphaPremultiplied) { 
        throw new UnsupportedOperationException("");
    }
    public boolean isCompatibleRaster(Raster raster) {
        throw new UnsupportedOperationException("");
    }
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        throw new UnsupportedOperationException("");
    }
    public WritableRaster getAlphaRaster(WritableRaster raster) {
        return null;
    }
}