/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Graphics2D.java,v $
   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work


*/

package swingwt.awt;

import swingwt.awt.geom.*;
import swingwt.awt.font.*;

import java.util.*;

public abstract class Graphics2D extends Graphics {

    public abstract void draw(Shape s); 
    public abstract void drawGlyphVector(GlyphVector g, float x, float y);
    public abstract void fill(Shape s);
    public abstract boolean hit(Rectangle rect,
				Shape s,
				boolean onStroke);
    public abstract GraphicsConfiguration getDeviceConfiguration();
    public abstract void setComposite(Composite comp);
    public abstract void setPaint( Paint paint );
    public abstract void setStroke(Stroke s);
    public abstract void setRenderingHint(Object hintKey, Object hintValue);
    public abstract Object getRenderingHint(Object hintKey);
    public abstract void setRenderingHints(Map hints);
    public abstract void addRenderingHints(Map hints);
    public abstract RenderingHints getRenderingHints();
    public abstract void translate(int x, int y);
    public abstract void translate(double tx, double ty);
    public abstract void rotate(double theta);
    public abstract void rotate(double theta, double x, double y);
    public abstract void scale(double sx, double sy);
    public abstract void shear(double shx, double shy);
    public abstract void transform(AffineTransform Tx);
    public abstract void setTransform(AffineTransform Tx);
    public abstract AffineTransform getTransform();
    public abstract Paint getPaint();
    public abstract Composite getComposite();
    public abstract void setBackground(Color color);
    public abstract Color getBackground();
    public abstract Stroke getStroke();
    public abstract void clip(Shape s);
    public abstract FontRenderContext getFontRenderContext();
    
}
