/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: EventQueue.java,v $
   Revision 1.1  2004/04/15 14:13:34  bobintetley
   EventQueue implementation


*/


package swingwt.awt;

import swingwtx.swing.*;

/**
 * Dumb wrapper around other functions we have. Implements
 * a bunch of statics that some code may rely on.
 *
 * The real "meat" of what this class is supposed to do
 * is taken care of inside SwingWTUtils (and mapped over
 * SWT dispatch mechanisms)
 *
 * @author  Robin Rawson-Tetley
 */
public class EventQueue {
    
    public EventQueue() {
    }
    
    public static boolean isDispatchThread(Thread t) {
        return t.equals(SwingWTUtils.getDisplay().getThread());
    }
    
    public static AWTEvent getCurrentEvent() {
        return null;    
    }
    
    public static long getMostRecentEventTime() {
        return System.currentTimeMillis();    
    }
    
    public static void invokeAndWait(Runnable run) throws InterruptedException {
        SwingUtilities.invokeAndWait(run);
    }
    
    public static void invokeLater(Runnable run) {
        SwingUtilities.invokeLater(run);    
    }
    
}
