/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.PropertyPageNode;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RegistryPageContributor
implements IPropertyPageContributor {
    private String pluginId;
    private String pageName;
    private String iconName;
    private String pageId;
    private boolean isResourceContributor = false;
    private IConfigurationElement pageElement;
    private HashMap filterProperties;
    private static String[] resourceClassNames = new String[]{"org.eclipse.core.resources.IResource", "org.eclipse.core.resources.IContainer", "org.eclipse.core.resources.IFolder", "org.eclipse.core.resources.IProject", "org.eclipse.core.resources.IFile"};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RegistryPageContributor(String pluginId, String pageId, String pageName, String iconName, HashMap filterProperties, String objectClassName, boolean adaptable, IConfigurationElement pageElement) {
        this.pluginId = pluginId;
        this.pageId = pageId;
        this.pageName = pageName;
        this.iconName = iconName;
        this.filterProperties = filterProperties;
        this.pageElement = pageElement;
        if (adaptable) {
            this.checkIsResourcePage(objectClassName);
        }
    }

    public boolean contributePropertyPages(PropertyPageManager mng, IAdaptable element) {
        PropertyPageNode node = new PropertyPageNode(this, element);
        mng.addToRoot((IPreferenceNode)node);
        return true;
    }

    public IWorkbenchPropertyPage createPage(IAdaptable element) throws CoreException {
        IWorkbenchPropertyPage ppage = null;
        ppage = (IWorkbenchPropertyPage)WorkbenchPlugin.createExtension(this.pageElement, "class");
        ppage.setTitle(this.pageName);
        if (this.isResourceContributor) {
            Object resourceAdapter;
            IAdaptable resource;
            Class resourceClass = LegacyResourceSupport.getResourceClass();
            IAdaptable iAdaptable = resource = resourceClass != null ? (IAdaptable)element.getAdapter(resourceClass) : null;
            if (resource == null && (resourceClass = LegacyResourceSupport.getIContributorResourceAdapterClass()) != null && (resourceAdapter = element.getAdapter(resourceClass)) != null) {
                try {
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.runtime.IAdaptable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Method m = resourceClass.getMethod("getAdaptedResource", classArray);
                    resource = (IAdaptable)m.invoke(resourceAdapter, element);
                }
                catch (Exception exception) {}
            }
            if (resource != null) {
                ppage.setElement(resource);
            }
        }
        if (ppage.getElement() == null) {
            ppage.setElement(element);
        }
        return ppage;
    }

    public ImageDescriptor getPageIcon() {
        if (this.iconName == null) {
            return null;
        }
        IExtension extension = this.pageElement.getDeclaringExtension();
        return AbstractUIPlugin.imageDescriptorFromPlugin(extension.getNamespace(), this.iconName);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean isApplicableTo(Object object) {
        Object result;
        String nameFilter = this.pageElement.getAttribute("nameFilter");
        if (nameFilter != null) {
            String objectName = object.toString();
            if (object instanceof IAdaptable) {
                String elementName;
                IWorkbenchAdapter adapter;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (elementName = adapter.getLabel(object)) != null) {
                    objectName = elementName;
                }
            }
            if (!SelectionEnabler.verifyNameMatch(objectName, nameFilter)) {
                return false;
            }
        }
        if (this.filterProperties == null) {
            return true;
        }
        IActionFilter filter = null;
        Object testObject = object;
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (this.isResourceContributor && resourceClass != null && !resourceClass.isInstance(object) && object instanceof IAdaptable && (result = ((IAdaptable)object).getAdapter(resourceClass)) != null) {
            testObject = result;
        }
        if (testObject instanceof IActionFilter) {
            filter = (IActionFilter)testObject;
        } else if (testObject instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)testObject;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.IActionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            filter = (IActionFilter)iAdaptable.getAdapter((Class)clazz);
        }
        if (filter != null) {
            return this.testCustom(testObject, filter);
        }
        return true;
    }

    private boolean testCustom(Object object, IActionFilter filter) {
        if (this.filterProperties == null) {
            return false;
        }
        Iterator iter = this.filterProperties.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (filter.testAttribute(object, key, value = (String)this.filterProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    private void checkIsResourcePage(String objectClassName) {
        int i = 0;
        while (i < resourceClassNames.length) {
            if (resourceClassNames[i].equals(objectClassName)) {
                this.isResourceContributor = true;
                return;
            }
            ++i;
        }
    }

    public boolean canAdapt() {
        return this.isResourceContributor;
    }
}

