/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProductInfo {
    private IProduct product;
    private String appName;
    private ImageDescriptor[] windowImages;
    private ImageDescriptor aboutImage;
    private ImageDescriptor featureImage;
    private String aboutText;

    public ProductInfo(IProduct product) {
        this.product = product;
    }

    public String getProductName() {
        return this.product != null ? this.product.getName() : null;
    }

    public String getAppName() {
        if (this.appName == null) {
            this.appName = this.getProperty("appName");
        }
        return this.appName;
    }

    public ImageDescriptor getAboutImage() {
        if (this.aboutImage == null) {
            String prop = this.getProperty("aboutImage");
            this.aboutImage = this.getImage(prop);
        }
        return this.aboutImage;
    }

    public ImageDescriptor getFeatureImage() {
        return this.featureImage;
    }

    public ImageDescriptor[] getWindowImages() {
        if (this.windowImages == null) {
            this.windowImages = this.getImages("windowImages");
            if (this.windowImages == null) {
                this.windowImages = this.getImages("windowImage");
            }
        }
        return this.windowImages;
    }

    public String getAboutText() {
        if (this.aboutText == null) {
            this.aboutText = this.getProperty("aboutText");
        }
        return this.aboutText;
    }

    private String getProperty(String key) {
        return this.product != null ? this.product.getProperty(key) : null;
    }

    private URL getURL(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL[] getURLs(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        ArrayList<URL> array = new ArrayList<URL>(10);
        while (tokens.hasMoreTokens()) {
            String str = tokens.nextToken().trim();
            try {
                URL url = new URL(str);
                array.add(url);
            }
            catch (IOException iOException) {}
        }
        URL[] urls = new URL[array.size()];
        array.toArray(urls);
        return urls;
    }

    private ImageDescriptor getImage(String key) {
        URL url = this.getURL(key);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    private ImageDescriptor[] getImages(String key) {
        URL[] urls = this.getURLs(key);
        if (urls == null || urls.length <= 0) {
            return null;
        }
        ImageDescriptor[] images = new ImageDescriptor[urls.length];
        int i = 0;
        while (i < images.length) {
            images[i] = ImageDescriptor.createFromURL((URL)urls[i]);
            ++i;
        }
        return images;
    }
}

