/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;

public class CloseAllAction
extends PageEventAction {
    public CloseAllAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("CloseAllAction.text"), window);
        this.setToolTipText(WorkbenchMessages.getString("CloseAllAction.toolTip"));
        this.setEnabled(false);
        this.setId("closeAll");
        this.updateState();
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.close_all_action_context");
        this.setActionDefinitionId("org.eclipse.ui.file.closeAll");
    }

    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.updateState();
    }

    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        this.updateState();
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            page.closeAllEditors(true);
        }
    }

    private void updateState() {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            this.setEnabled(page.getEditorReferences().length >= 1);
        } else {
            this.setEnabled(false);
        }
    }
}

