/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.NoSuchAttributeException;

public class ActionHandler
extends AbstractHandler {
    private static final String ATTRIBUTE_CHECKED = "checked";
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_STYLE = "style";
    private IAction action;
    private Set definedAttributeNames;

    public ActionHandler(IAction action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.action = action;
        this.definedAttributeNames = new HashSet();
        this.definedAttributeNames.add(ATTRIBUTE_CHECKED);
        this.definedAttributeNames.add(ATTRIBUTE_ENABLED);
        this.definedAttributeNames.add(ATTRIBUTE_ID);
        this.definedAttributeNames.add(ATTRIBUTE_STYLE);
        this.definedAttributeNames = Collections.unmodifiableSet(this.definedAttributeNames);
    }

    public void execute(Object parameter) throws ExecutionException {
        if (this.action.getStyle() == 2 || this.action.getStyle() == 8) {
            this.action.setChecked(!this.action.isChecked());
        }
        try {
            if (parameter instanceof Event) {
                this.action.runWithEvent((Event)parameter);
            } else {
                this.action.run();
            }
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public IAction getAction() {
        return this.action;
    }

    public Object getAttributeValue(String attributeName) throws NoSuchAttributeException {
        if (!this.definedAttributeNames.contains(attributeName)) {
            throw new NoSuchAttributeException();
        }
        if (ATTRIBUTE_CHECKED.equals(attributeName)) {
            return this.action.isChecked() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (ATTRIBUTE_ENABLED.equals(attributeName)) {
            return this.action.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (ATTRIBUTE_ID.equals(attributeName)) {
            return this.action.getId();
        }
        if (ATTRIBUTE_STYLE.equals(attributeName)) {
            return new Integer(this.action.getStyle());
        }
        throw new NoSuchAttributeException();
    }

    public Set getDefinedAttributeNames() {
        return this.definedAttributeNames;
    }
}

