/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = Transfer.registerType("text/uri-list");
    private static final byte[] separator = new byte[]{13, 10};

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (object == null || !(object instanceof String[])) {
            return;
        }
        if (!this.isSupportedType(transferData)) {
            return;
        }
        String[] files = (String[])object;
        byte[] buffer = new byte[]{};
        int i = 0;
        while (i < files.length) {
            int length;
            String string = files[i];
            if (string != null && (length = string.length()) != 0) {
                char[] chars = new char[length];
                string.getChars(0, length, chars, 0);
                int[] error = new int[1];
                int utf8Ptr = OS.g_utf16_to_utf8((char[])chars, (int)chars.length, null, null, (int[])error);
                if (error[0] == 0 && utf8Ptr != 0) {
                    int localePtr = OS.g_locale_from_utf8((int)utf8Ptr, (int)-1, null, null, (int[])error);
                    OS.g_free((int)utf8Ptr);
                    if (error[0] == 0 && localePtr != 0) {
                        int uriPtr = OS.g_filename_to_uri((int)localePtr, (int)0, (int[])error);
                        OS.g_free((int)localePtr);
                        if (error[0] == 0 && uriPtr != 0) {
                            length = OS.strlen((int)uriPtr);
                            byte[] temp = new byte[length];
                            OS.memmove((byte[])temp, (int)uriPtr, (int)length);
                            OS.g_free((int)uriPtr);
                            int newLength = i > 0 ? buffer.length + separator.length + temp.length : temp.length;
                            byte[] newBuffer = new byte[newLength];
                            int offset = 0;
                            if (i > 0) {
                                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                                System.arraycopy(separator, 0, newBuffer, offset += buffer.length, separator.length);
                                offset += separator.length;
                            }
                            System.arraycopy(temp, 0, newBuffer, offset, temp.length);
                            buffer = newBuffer;
                        }
                    }
                }
            }
            ++i;
        }
        if (buffer.length == 0) {
            return;
        }
        int ptr = OS.g_malloc((int)(buffer.length + 1));
        OS.memset((int)ptr, (char)'\u0000', (int)(buffer.length + 1));
        OS.memmove((int)ptr, (byte[])buffer, (int)buffer.length);
        transferData.pValue = ptr;
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0 || transferData.length <= 0) {
            return null;
        }
        int length = transferData.length;
        byte[] temp = new byte[length];
        OS.memmove((byte[])temp, (int)transferData.pValue, (int)length);
        int[] files = new int[]{};
        int offset = 0;
        int i = 0;
        while (i < temp.length - 1) {
            if (temp[i] == 13 && temp[i + 1] == 10) {
                int size = i - offset;
                int file = OS.g_malloc((int)(size + 1));
                byte[] fileBuffer = new byte[size + 1];
                System.arraycopy(temp, offset, fileBuffer, 0, size);
                OS.memmove((int)file, (byte[])fileBuffer, (int)(size + 1));
                int[] newFiles = new int[files.length + 1];
                System.arraycopy(files, 0, newFiles, 0, files.length);
                newFiles[files.length] = file;
                files = newFiles;
                offset = i + 2;
            }
            ++i;
        }
        if (offset < temp.length - 2) {
            int size = temp.length - offset;
            int file = OS.g_malloc((int)(size + 1));
            byte[] fileBuffer = new byte[size + 1];
            System.arraycopy(temp, offset, fileBuffer, 0, size);
            OS.memmove((int)file, (byte[])fileBuffer, (int)(size + 1));
            int[] newFiles = new int[files.length + 1];
            System.arraycopy(files, 0, newFiles, 0, files.length);
            newFiles[files.length] = file;
            files = newFiles;
        }
        String[] fileNames = new String[]{};
        int i2 = 0;
        while (i2 < files.length) {
            int[] error = new int[1];
            int localePtr = OS.g_filename_from_uri((int)files[i2], null, (int[])error);
            OS.g_free((int)files[i2]);
            if (error[0] == 0 && localePtr != 0) {
                int utf8Ptr = OS.g_locale_to_utf8((int)localePtr, (int)-1, null, null, (int[])error);
                OS.g_free((int)localePtr);
                if (error[0] == 0 && utf8Ptr != 0) {
                    int[] items_written = new int[1];
                    int utf16Ptr = OS.g_utf8_to_utf16((int)utf8Ptr, (int)-1, null, (int[])items_written, null);
                    OS.g_free((int)utf8Ptr);
                    length = items_written[0];
                    char[] buffer = new char[length];
                    OS.memmove((char[])buffer, (int)utf16Ptr, (int)(length * 2));
                    OS.g_free((int)utf16Ptr);
                    String name = new String(buffer);
                    String[] newFileNames = new String[fileNames.length + 1];
                    System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
                    newFileNames[fileNames.length] = name;
                    fileNames = newFileNames;
                }
            }
            ++i2;
        }
        if (fileNames.length == 0) {
            return null;
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST};
    }
}

