/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class ConfigurationElement
extends RegistryModelObject
implements IConfigurationElement {
    private String value = null;
    private ConfigurationProperty[] properties = null;
    private IConfigurationElement[] children = null;
    private Object oldStyleConfigurationElement = null;

    /*
     * Unable to fully structure code
     */
    public Object createExecutableExtension(String attributeName) throws CoreException {
        prop = null;
        pluginName = null;
        className = null;
        initData = null;
        if (attributeName != null) {
            prop = this.getAttribute(attributeName);
        } else {
            prop = this.getValue();
            if (prop != null && (prop = prop.trim()).equals("")) {
                prop = null;
            }
        }
        if (prop != null) ** GOTO lbl35
        exec = this.getChildren(attributeName);
        if (exec.length != 0) {
            element = exec[0];
            pluginName = element.getAttribute("plugin");
            className = element.getAttribute("class");
            parms = element.getChildren("parameter");
            if (parms != null) {
                initParms = new Hashtable<String, String>(parms.length + 1);
                i = 0;
                while (i < parms.length) {
                    pname = parms[i].getAttribute("name");
                    if (pname != null) {
                        initParms.put(pname, parms[i].getAttribute("value"));
                    }
                    ++i;
                }
                if (!initParms.isEmpty()) {
                    initData = initParms;
                }
            }
        } else {
            message = Policy.bind("plugin.extDefNotFound", attributeName);
            status = new Status(4, "org.eclipse.core.runtime", 1, message, null);
            InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
            throw new CoreException(status);
lbl35:
            // 1 sources

            i = prop.indexOf(58);
            if (i != -1) {
                executable = prop.substring(0, i).trim();
                initData = prop.substring(i + 1).trim();
            } else {
                executable = prop;
            }
            i = executable.indexOf(47);
            if (i != -1) {
                pluginName = executable.substring(0, i).trim();
                className = executable.substring(i + 1).trim();
            } else {
                className = executable;
            }
        }
        if (className == null || className.equals("")) {
            message = Policy.bind("plugin.extDefNoClass", attributeName);
            status = new Status(4, "org.eclipse.core.runtime", 1, message, null);
            InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
            throw new CoreException(status);
        }
        return this.createExecutableExtension(InternalPlatform.getDefault().getBundle(this.getDeclaringExtension().getNamespace()), pluginName, className, initData, this, attributeName);
    }

    Object createExecutableExtension(Bundle bundle, String pluginName, String className, Object initData, IConfigurationElement cfig, String propertyName) throws CoreException {
        String id = bundle.getSymbolicName();
        if (pluginName != null && !pluginName.equals("") && !pluginName.equals(id)) {
            Bundle otherBundle = null;
            otherBundle = InternalPlatform.getDefault().getBundle(pluginName);
            return this.createExecutableExtension(otherBundle, className, initData, cfig, propertyName);
        }
        return this.createExecutableExtension(bundle, className, initData, cfig, propertyName);
    }

    public Object createExecutableExtension(Bundle bundle, String className, Object initData, IConfigurationElement cfig, String propertyName) throws CoreException {
        Class classInstance = null;
        try {
            classInstance = bundle.loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(Policy.bind("plugin.loadClassError", bundle.getSymbolicName(), className), e1);
        }
        Object result = null;
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            this.throwException(Policy.bind("plugin.instantiateClassError", bundle.getSymbolicName(), className), e);
        }
        if (result instanceof IExecutableExtension) {
            try {
                ((IExecutableExtension)result).setInitializationData(cfig, propertyName, initData);
            }
            catch (CoreException ce) {
                InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(ce.getStatus());
                throw new CoreException(ce.getStatus());
            }
            catch (Exception te) {
                this.throwException(Policy.bind("policy.initObjectError", bundle.getSymbolicName(), className), te);
            }
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.core.runtime", 1, message, exception);
        InternalPlatform.getDefault().getLog(InternalPlatform.getDefault().getBundleContext().getBundle()).log(status);
        throw new CoreException(status);
    }

    public Extension getParentExtension() {
        Object p = this.getParent();
        while (p != null && p instanceof ConfigurationElement) {
            p = ((ConfigurationElement)p).getParent();
        }
        return (Extension)p;
    }

    public IExtension getDeclaringExtension() {
        return this.getParentExtension();
    }

    public ConfigurationProperty[] getProperties() {
        return this.properties;
    }

    public String getValue() {
        String s = this.getValueAsIs();
        if (s == null) {
            return null;
        }
        BundleModel bundleModel = (BundleModel)((Extension)this.getDeclaringExtension()).getParent();
        String localized = bundleModel.getResourceString(s);
        if (localized != s) {
            this.setLocalizedValue(localized);
        }
        return localized;
    }

    public String getValueAsIs() {
        return this.value;
    }

    public IConfigurationElement[] getChildren() {
        return this.children == null ? new IConfigurationElement[]{} : this.children;
    }

    public IConfigurationElement[] getChildren(String name) {
        IConfigurationElement[] list = this.getChildren();
        if (list == null) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> children = new ArrayList<IConfigurationElement>();
        int i = 0;
        while (i < list.length) {
            IConfigurationElement element = list[i];
            if (name.equals(element.getName())) {
                children.add(list[i]);
            }
            ++i;
        }
        return children.toArray(new IConfigurationElement[children.size()]);
    }

    public String getAttribute(String name) {
        String s;
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return null;
        }
        ConfigurationProperty found = null;
        int i = 0;
        while (i < list.length) {
            if (name.equals(list[i].getName())) {
                found = list[i];
                break;
            }
            ++i;
        }
        if (found == null || (s = found.getValue()) == null) {
            return null;
        }
        BundleModel bundleModel = (BundleModel)((Extension)this.getDeclaringExtension()).getParent();
        String localized = bundleModel.getResourceString(s);
        if (localized != s) {
            found.setLocalizedValue(localized);
        }
        return localized;
    }

    public String getAttributeAsIs(String name) {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (name.equals(list[i].getName())) {
                return list[i].getValue();
            }
            ++i;
        }
        return null;
    }

    public String[] getAttributeNames() {
        ConfigurationProperty[] list = this.getProperties();
        if (list == null) {
            return new String[0];
        }
        String[] result = new String[list.length];
        int i = 0;
        while (i < list.length) {
            result[i] = list[i].getName();
            ++i;
        }
        return result;
    }

    public void markReadOnly() {
        int i;
        super.markReadOnly();
        if (this.children != null) {
            i = 0;
            while (i < this.children.length) {
                ((ConfigurationElement)this.children[i]).markReadOnly();
                ++i;
            }
        }
        if (this.properties != null) {
            i = 0;
            while (i < this.properties.length) {
                this.properties[i].markReadOnly();
                ++i;
            }
        }
    }

    public void setProperties(ConfigurationProperty[] value) {
        this.assertIsWriteable();
        this.properties = value;
    }

    public void setChildren(IConfigurationElement[] value) {
        this.assertIsWriteable();
        this.children = value;
    }

    public void setValue(String value) {
        this.assertIsWriteable();
        this.value = value;
    }

    public void setLocalizedValue(String value) {
        this.value = value;
        ((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).setDirty(true);
    }
}

