/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

class FlowUtilities
extends FigureUtilities {
    private static Dimension ELLIPSIS_SIZE = new Dimension();

    FlowUtilities() {
    }

    public static int getTextForSpace(TextFragmentBox frag, String string, Font font, int availableWidth, float avg, int wrapping) {
        frag.truncated = false;
        if (string.length() == 0) {
            frag.length = 0;
            FlowUtilities.setupFragment(frag, font, string);
            return 0;
        }
        FontMetrics metrics = FigureUtilities.getFontMetrics(font);
        BreakIterator breakItr = BreakIterator.getLineInstance();
        breakItr.setText(string);
        if ((double)avg == 0.0) {
            avg = metrics.getAverageCharWidth();
        }
        int firstBreak = breakItr.next();
        int winNL = string.indexOf("\r\n");
        int macNL = string.indexOf(13);
        int unixNL = string.indexOf(10);
        int min = wrapping == 0 ? firstBreak : 1;
        int MIN = min;
        if (macNL == winNL) {
            macNL = -1;
        }
        int max = string.length() + 1;
        if (winNL != -1) {
            max = Math.min(max, winNL);
            min = Math.min(min, winNL);
        }
        if (unixNL != -1) {
            max = Math.min(max, unixNL);
            min = Math.min(min, unixNL);
        }
        if (macNL != -1) {
            max = Math.min(max, macNL);
            min = Math.min(min, macNL);
        }
        int origMax = max;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getStringExtents((String)string.substring((int)0, (int)guess), (Font)font).width) <= availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        int result = string.length();
        switch (wrapping) {
            case 0: {
                result = min == string.length() || min == winNL || min == unixNL || min == macNL ? min : (max == origMax && FigureUtilities.getStringExtents((String)string.substring((int)0, (int)max), (Font)font).width <= availableWidth ? max : Math.max(MIN, breakItr.preceding(Math.min(max + 1, string.length() - 1))));
                frag.length = result;
                break;
            }
            case 1: {
                result = min == string.length() || min == winNL || min == unixNL || min == macNL ? min : (max == origMax && FigureUtilities.getStringExtents((String)string.substring((int)0, (int)max), (Font)font).width <= availableWidth ? max : (breakItr.isBoundary(min) ? min : (breakItr.isBoundary(Math.min(max, string.length() - 1)) ? max : breakItr.preceding(Math.min(max + 1, string.length() - 1)))));
                if (result <= 0) {
                    result = min;
                }
                frag.length = result;
                break;
            }
            case 2: {
                if (min == string.length() || min == winNL || min == unixNL || min == macNL) {
                    result = frag.length = min--;
                    FlowUtilities.setupFragment(frag, font, string);
                    if (frag.getWidth() <= availableWidth) {
                        return result;
                    }
                } else if (max == origMax && FigureUtilities.getStringExtents((String)string.substring((int)0, (int)max), (Font)font).width <= availableWidth) {
                    result = frag.length = max;
                    FlowUtilities.setupFragment(frag, font, string);
                    return result;
                }
                result = breakItr.preceding(Math.min(max + 1, string.length() - 1));
                if (result <= 0) {
                    ELLIPSIS_SIZE = FigureUtilities.getStringExtents("...", font);
                    FlowUtilities.getTextForSpace(frag, string, font, availableWidth - FlowUtilities.ELLIPSIS_SIZE.width, avg, 1);
                    frag.truncated = true;
                    result = breakItr.following(min);
                    if (result != -1) break;
                    result = string.length();
                    break;
                }
                frag.length = result;
            }
        }
        FlowUtilities.setupFragment(frag, font, string);
        return result;
    }

    static void setupFragment(TextFragmentBox frag, Font f, String s) {
        while (frag.length > 0 && Character.isWhitespace(s.charAt(frag.length - 1))) {
            --frag.length;
        }
        Dimension d = FigureUtilities.getStringExtents(s.substring(0, frag.length), f);
        FontMetrics fm = FigureUtilities.getFontMetrics(f);
        frag.setHeight(fm.getHeight());
        frag.setAscent(fm.getAscent());
        if (frag.truncated) {
            d.width += FlowUtilities.ELLIPSIS_SIZE.width;
        }
        frag.setWidth(d.width);
    }
}

