/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.text;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import swingwtx.swing.event.DocumentEvent;
import swingwtx.swing.event.DocumentListener;
import swingwtx.swing.event.UndoableEditListener;
import swingwtx.swing.text.AttributeSet;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.DocumentFilter;
import swingwtx.swing.text.Element;
import swingwtx.swing.text.MutableAttributeSet;
import swingwtx.swing.text.Position;
import swingwtx.swing.text.Segment;
import swingwtx.swing.tree.TreeNode;
import swingwtx.swing.undo.AbstractUndoableEdit;
import swingwtx.swing.undo.CannotRedoException;
import swingwtx.swing.undo.CannotUndoException;
import swingwtx.swing.undo.CompoundEdit;
import swingwtx.swing.undo.UndoableEdit;

public abstract class AbstractDocument
implements Document,
Serializable {
    protected Content content = null;
    protected Vector documentListeners = new Vector();
    protected Vector undoListeners = new Vector();
    protected Hashtable props = new Hashtable(2);
    private DocumentFilter documentFilter = null;
    private DocumentFilter.FilterBypass filterBypass = null;

    public abstract Element getParagraphElement(int var1);

    public int getLength() {
        return this.content.length();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.documentListeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.documentListeners.remove(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoListeners.add(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoListeners.remove(listener);
    }

    public Object getProperty(Object key) {
        return this.props.get(key);
    }

    public void putProperty(Object key, Object value) {
        this.props.put(key, value);
    }

    public void remove(int offs, int len) throws BadLocationException {
        DocumentFilter docFilter = this.getDocumentFilter();
        if (docFilter != null) {
            docFilter.remove(this.getFilterBypass(), offs, len);
        } else {
            this.doRemove(offs, len, true);
        }
    }

    private void doRemove(int offs, int len, boolean fireEvent) throws BadLocationException {
        this.content.remove(offs, len);
        if (fireEvent) {
            this.fireDocumentEvent(new DefaultDocumentEvent(offs, len, DocumentEvent.EventType.REMOVE));
        }
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        DocumentFilter docFilter = this.getDocumentFilter();
        if (docFilter != null) {
            docFilter.insertString(this.getFilterBypass(), offset, str, a);
        } else {
            this.doInsertString(offset, str, a, true);
        }
    }

    private void doInsertString(int offset, String str, AttributeSet a, boolean fireEvent) throws BadLocationException {
        this.content.insertString(offset, str);
        if (fireEvent) {
            this.fireDocumentEvent(new DefaultDocumentEvent(offset, str.length(), DocumentEvent.EventType.INSERT));
        }
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.content.getString(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.content.getChars(offset, length, txt);
    }

    public Position getStartPosition() {
        try {
            return this.content.createPosition(0);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public Position getEndPosition() {
        try {
            return this.content.createPosition(this.content.length() - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this.content.createPosition(offs);
    }

    public Element[] getRootElements() {
        return null;
    }

    public void render(Runnable r) {
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        this.documentFilter = documentFilter;
    }

    public DocumentFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    protected void fireDocumentEvent(DocumentEvent e) {
        for (int i = 0; i < this.documentListeners.size(); ++i) {
            if (e.getType().equals(DocumentEvent.EventType.INSERT)) {
                ((DocumentListener)this.documentListeners.get(i)).insertUpdate(e);
            }
            if (e.getType().equals(DocumentEvent.EventType.CHANGE)) {
                ((DocumentListener)this.documentListeners.get(i)).changedUpdate(e);
            }
            if (!e.getType().equals(DocumentEvent.EventType.REMOVE)) continue;
            ((DocumentListener)this.documentListeners.get(i)).removeUpdate(e);
        }
    }

    private class DefaultFilterBypass
    extends DocumentFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public void remove(int offset, int length) throws BadLocationException {
            AbstractDocument.this.doRemove(offset, length, false);
        }

        public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
            AbstractDocument.this.doInsertString(offset, string, attr, false);
        }

        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            AbstractDocument.this.doRemove(offset, length, false);
            AbstractDocument.this.doInsertString(offset, text, attrs, false);
        }
    }

    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public class BranchElement
    extends AbstractElement {
        public BranchElement(Element parent, AttributeSet attributeSet) {
            super(parent, attributeSet);
        }

        public Element positionToElement(int pos) {
            return null;
        }

        public void replace(int offset, int length, Element[] elems) {
        }

        public String getName() {
            return "";
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public Element getElement(int index) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int offset) {
            return 0;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Enumeration children() {
            return null;
        }
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        protected DocumentEvent.EventType type = null;
        protected int offset = 0;
        protected int len = 0;

        public DefaultDocumentEvent(int offs, int len, DocumentEvent.EventType type) {
            this.type = type;
            this.offset = offs;
            this.len = len;
        }

        public String toString() {
            return this.edits.toString();
        }

        public boolean addEdit(UndoableEdit anEdit) {
            return false;
        }

        public void redo() throws CannotRedoException {
        }

        public void undo() throws CannotUndoException {
        }

        public boolean isSignificant() {
            return true;
        }

        public String getPresentationName() {
            return "";
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.len;
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            return null;
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        public ElementEdit(Element e, int index, Element[] removed, Element[] added) {
        }

        public Element getElement() {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public Element[] getChildrenRemoved() {
            return null;
        }

        public Element[] getChildrenAdded() {
            return null;
        }

        public void redo() throws CannotRedoException {
        }

        public void undo() throws CannotUndoException {
        }
    }

    public class LeafElement
    extends AbstractElement {
        public LeafElement(Element parent, AttributeSet a, int offs0, int offs1) {
            super(parent, a);
        }

        public String toString() {
            return "";
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public String getName() {
            return "";
        }

        public int getElementIndex(int pos) {
            return 0;
        }

        public Element getElement(int index) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Enumeration children() {
            return null;
        }
    }

    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    Serializable,
    TreeNode {
        public AbstractElement(Element parent, AttributeSet a) {
        }

        public void dump(PrintStream psOut, int indentAmount) {
        }

        public int getAttributeCount() {
            return 0;
        }

        public boolean isDefined(Object attrName) {
            return false;
        }

        public boolean isEqual(AttributeSet attr) {
            return false;
        }

        public AttributeSet copyAttributes() {
            return null;
        }

        public Object getAttribute(Object attrName) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public boolean containsAttribute(Object name, Object value) {
            return false;
        }

        public boolean containsAttributes(AttributeSet attrs) {
            return false;
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public void addAttribute(Object name, Object value) {
        }

        public void addAttributes(AttributeSet attr) {
        }

        public void removeAttribute(Object name) {
        }

        public void removeAttributes(Enumeration names) {
        }

        public void removeAttributes(AttributeSet attrs) {
        }

        public void setResolveParent(AttributeSet parent) {
        }

        public Document getDocument() {
            return null;
        }

        public Element getParentElement() {
            return null;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public String getName() {
            return "";
        }

        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getParent() {
            return null;
        }

        public int getIndex(TreeNode node) {
            return 0;
        }

        public abstract int getStartOffset();

        public abstract int getEndOffset();

        public abstract Element getElement(int var1);

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract boolean isLeaf();

        public abstract boolean getAllowsChildren();

        public abstract Enumeration children();
    }
}

