/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.table;

import java.util.Enumeration;
import java.util.Vector;
import swingwtx.swing.DefaultListSelectionModel;
import swingwtx.swing.ListSelectionModel;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ListSelectionEvent;
import swingwtx.swing.event.TableColumnModelEvent;
import swingwtx.swing.event.TableColumnModelListener;
import swingwtx.swing.table.TableColumn;
import swingwtx.swing.table.TableColumnModel;

public class DefaultTableColumnModel
implements TableColumnModel {
    private Vector columns = new Vector();
    private Vector listenerList = new Vector();
    private int columnMargin = 0;
    public int lastColClicked = -1;

    public void addColumn(TableColumn t) {
        this.columns.add(t);
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.columns.indexOf(t)));
    }

    public void removeColumn(TableColumn t) {
        this.columns.remove(t);
        this.fireColumnRemoved(new TableColumnModelEvent(this, 0, this.columns.indexOf(t)));
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public TableColumn getColumn(int columnIndex) {
        if (columnIndex == -1) {
            return null;
        }
        return (TableColumn)this.columns.elementAt(columnIndex);
    }

    public int getColumnIndexAtX(int xPosition) {
        return this.lastColClicked;
    }

    public int getColumnIndex(Object columnIdentifier) {
        for (int i = 0; i < this.columns.size(); ++i) {
            TableColumn tc = (TableColumn)this.columns.get(i);
            if (!tc.getIdentifier().equals(columnIdentifier)) continue;
            return i;
        }
        throw new IllegalArgumentException("Column not found!");
    }

    public int getColumnMargin() {
        return 0;
    }

    public boolean getColumnSelectionAllowed() {
        return false;
    }

    public Enumeration getColumns() {
        return this.columns.elements();
    }

    public int getSelectedColumnCount() {
        return 0;
    }

    public int[] getSelectedColumns() {
        return null;
    }

    public ListSelectionModel getSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public int getTotalColumnWidth() {
        return 0;
    }

    public void moveColumn(int columnIndex, int newIndex) {
    }

    public void setColumnSelectionAllowed(boolean flag) {
    }

    public void setSelectionModel(ListSelectionModel newModel) {
    }

    public void setColumnMargin(int newMargin) {
        this.columnMargin = newMargin;
        this.fireColumnMarginChanged();
    }

    public void addColumnModelListener(TableColumnModelListener x) {
        this.listenerList.add(x);
    }

    public void removeColumnModelListener(TableColumnModelListener x) {
        this.listenerList.remove(x);
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            ((TableColumnModelListener)this.listenerList.get(i)).columnAdded(e);
        }
    }

    protected void fireColumnMarginChanged() {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            ((TableColumnModelListener)this.listenerList.get(i)).columnMarginChanged(new ChangeEvent(this));
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            ((TableColumnModelListener)this.listenerList.get(i)).columnMoved(e);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            ((TableColumnModelListener)this.listenerList.get(i)).columnRemoved(e);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent e) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            ((TableColumnModelListener)this.listenerList.get(i)).columnSelectionChanged(e);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }
}

