/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwtx.swing.AbstractSpinnerModel;

public class SpinnerNumberModel
extends AbstractSpinnerModel {
    protected Comparable minimum;
    protected Comparable maximum;
    protected Number stepSize;
    protected Number value;

    public SpinnerNumberModel() {
        this(new Integer(0), null, null, new Integer(1));
    }

    public SpinnerNumberModel(int value, int minimum, int maximum, int stepSize) {
        this(new Integer(value), new Integer(minimum), new Integer(maximum), new Integer(stepSize));
    }

    public SpinnerNumberModel(double value, double minimum, double maximum, double stepSize) {
        this(new Double(value), new Double(minimum), new Double(maximum), new Double(stepSize));
    }

    public SpinnerNumberModel(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.stepSize = stepSize;
    }

    public void setMinimum(Comparable minimum) {
        this.minimum = minimum;
        this.fireStateChanged();
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Comparable maximum) {
        this.maximum = maximum;
        this.fireStateChanged();
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void setStepSize(Number stepSize) {
        this.stepSize = stepSize;
        this.fireStateChanged();
    }

    public Number getStepSize() {
        return this.stepSize;
    }

    public Object getNextValue() {
        return this.nextValue(1);
    }

    public Object getPreviousValue() {
        return this.nextValue(-1);
    }

    public Number getNumber() {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = (Number)value;
        this.fireStateChanged();
    }

    protected Number nextValue(int direction) {
        Number newValue;
        if (this.value instanceof Float || this.value instanceof Double) {
            double v = this.value.doubleValue() + this.stepSize.doubleValue() * (double)direction;
            newValue = this.value instanceof Double ? (Number)new Double(v) : (Number)new Float(v);
        } else {
            long v = this.value.longValue() + this.stepSize.longValue() * (long)direction;
            newValue = this.value instanceof Long ? (Number)new Long(v) : (Number)(this.value instanceof Integer ? (Number)new Integer((int)v) : (Number)(this.value instanceof Short ? (Number)new Short((short)v) : (Number)new Byte((byte)v)));
        }
        if (this.maximum != null && this.maximum.compareTo(newValue) < 0) {
            return this.getNumber();
        }
        if (this.minimum != null && this.minimum.compareTo(newValue) > 0) {
            return this.getNumber();
        }
        return newValue;
    }
}

