/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt.geom;

public abstract class Point2D {
    public abstract void setLocation(double var1, double var3);

    public abstract double getX();

    public abstract double getY();

    public double distanceSq(double x, double y) {
        return Point2D.distanceSq(this.getX(), this.getY(), x, y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Point2D.distanceSq(x1, y1, x2, y2));
    }

    public static double distanceSq(double x1, double y1, double x2, double y2) {
        double x = x1 - x2;
        double y = y1 - y2;
        return x * x + y * y;
    }

    public double distance(double x, double y) {
        return Point2D.distance(this.getX(), this.getY(), x, y);
    }

    public double distance(Point2D point) {
        return this.distance(point.getX(), point.getY());
    }

    public double distanceSq(Point2D point) {
        return this.distanceSq(point.getX(), point.getY());
    }

    public void setLocation(Point2D point) {
        this.setLocation(point.getX(), point.getY());
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double x, double y) {
            this.x = (float)x;
            this.y = (float)y;
        }

        public void setLocation(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

