/*
 * Decompiled with CFR 0.152.
 */
package demo.swingset;

import demo.swingset.CodeViewer;
import demo.swingset.SwingSet2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.LayoutManager;
import swingwtx.swing.BoxLayout;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JFrame;
import swingwtx.swing.JPanel;
import swingwtx.swing.border.Border;
import swingwtx.swing.border.CompoundBorder;
import swingwtx.swing.border.EmptyBorder;
import swingwtx.swing.border.SoftBevelBorder;

public class DemoModule
extends JFrame {
    private int PREFERRED_WIDTH = 680;
    private int PREFERRED_HEIGHT = 600;
    Border loweredBorder = new CompoundBorder((Border)new SoftBevelBorder(1), (Border)new EmptyBorder(5, 5, 5, 5));
    public static Dimension HGAP2 = new Dimension(2, 1);
    public static Dimension VGAP2 = new Dimension(1, 2);
    public static Dimension HGAP5 = new Dimension(5, 1);
    public static Dimension VGAP5 = new Dimension(1, 5);
    public static Dimension HGAP10 = new Dimension(10, 1);
    public static Dimension VGAP10 = new Dimension(1, 10);
    public static Dimension HGAP15 = new Dimension(15, 1);
    public static Dimension VGAP15 = new Dimension(1, 15);
    public static Dimension HGAP20 = new Dimension(20, 1);
    public static Dimension VGAP20 = new Dimension(1, 20);
    public static Dimension HGAP25 = new Dimension(25, 1);
    public static Dimension VGAP25 = new Dimension(1, 25);
    public static Dimension HGAP30 = new Dimension(30, 1);
    public static Dimension VGAP30 = new Dimension(1, 30);
    private SwingSet2 swingset = null;
    private JPanel panel = new JPanel();
    private String resourceName = null;
    private String iconPath = null;
    private String sourceCode = null;
    private ResourceBundle bundle = null;

    public DemoModule(SwingSet2 swingSet2) {
        this(swingSet2, null, null);
    }

    public DemoModule(SwingSet2 swingSet2, String string, String string2) {
        this.panel.setLayout((LayoutManager)new BorderLayout());
        this.resourceName = string;
        this.iconPath = string2;
        this.swingset = swingSet2;
        this.loadSourceCode();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public JPanel getDemoPanel() {
        return this.panel;
    }

    public SwingSet2 getSwingSet2() {
        return this.swingset;
    }

    public String getString(String string) {
        String string2 = "nada";
        if (this.bundle == null) {
            this.bundle = this.getSwingSet2() != null ? this.getSwingSet2().getResourceBundle() : ResourceBundle.getBundle("resources.swingset");
        }
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("java.util.MissingResourceException: Couldn't find value for: " + string);
        }
        return string2;
    }

    public char getMnemonic(String string) {
        return this.getString(string).charAt(0);
    }

    public ImageIcon createImageIcon(String string, String string2) {
        if (this.getSwingSet2() != null) {
            return this.getSwingSet2().createImageIcon(string, string2);
        }
        String string3 = "/resources/images/" + string;
        return new ImageIcon(((Object)((Object)this)).getClass().getResource(string3), string2);
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void loadSourceCode() {
        if (this.getResourceName() != null) {
            String string = "../demo/swingset/" + this.getResourceName() + ".java";
            this.sourceCode = new String("<html><body bgcolor=\"#ffffff\"><pre>");
            char[] cArray = new char[50000];
            CodeViewer codeViewer = new CodeViewer();
            try {
                File file = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    this.sourceCode = this.sourceCode + codeViewer.syntaxHighlight(string2) + " \n ";
                    string2 = bufferedReader.readLine();
                }
                this.sourceCode = this.sourceCode + new String("</pre></body></html>");
            }
            catch (Exception exception) {
                this.sourceCode = "Could not load file: " + string;
                exception.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.getString(this.getResourceName() + ".name");
    }

    public Icon getIcon() {
        return this.createImageIcon(this.iconPath, this.getResourceName() + ".name");
    }

    public String getToolTip() {
        return this.getString(this.getResourceName() + ".tooltip");
    }

    public void mainImpl() {
        JFrame jFrame = new JFrame(this.getName());
        jFrame.getContentPane().setLayout((LayoutManager)new BorderLayout());
        jFrame.getContentPane().add((Component)this.getDemoPanel(), (Object)"Center");
        this.getDemoPanel().setPreferredSize(new Dimension(this.PREFERRED_WIDTH, this.PREFERRED_HEIGHT));
        jFrame.pack();
        jFrame.show();
    }

    public JPanel createHorizontalPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        if (bl) {
            jPanel.setBorder(this.loweredBorder);
        }
        return jPanel;
    }

    public JPanel createVerticalPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        if (bl) {
            jPanel.setBorder(this.loweredBorder);
        }
        return jPanel;
    }

    public static void main(String[] stringArray) {
        DemoModule demoModule = new DemoModule(null);
        demoModule.mainImpl();
    }

    public void init() {
        this.getContentPane().setLayout((LayoutManager)new BorderLayout());
        this.getContentPane().add((Component)this.getDemoPanel(), (Object)"Center");
    }
}

