/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.NoDragUnderEffect;
import org.eclipse.swt.dnd.TableDragUnderEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragUnderEffect;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private DragUnderEffect effect;
    private TransferData selectedDataType;
    private int selectedOperation;
    private int keyOperation = -1;
    private long dragOverStart;
    private Runnable dragOverHeartbeat;
    private DNDEvent dragOverEvent;
    private static DropTarget CurrentDropTarget = null;
    private static final String DROPTARGETID = "DropTarget";
    private static final int DRAGOVER_HYSTERESIS = 50;
    private static Callback DragTrackingHandler;
    private static Callback DragReceiveHandler;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DragTrackingHandler = new Callback(clazz, "DragTrackingHandler", 4);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DragReceiveHandler = new Callback(clazz2, "DragReceiveHandler", 3);
        OS.InstallTrackingHandler((int)DragTrackingHandler.getAddress(), (int)0, null);
        OS.InstallReceiveHandler((int)DragReceiveHandler.getAddress(), (int)0, null);
    }

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (DragTrackingHandler == null || DragTrackingHandler == null) {
            DND.error(2001);
        }
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        this.effect = control instanceof Tree ? new TreeDragUnderEffect((Tree)control) : (control instanceof Table ? new TableDragUnderEffect((Table)control) : new NoDragUnderEffect(control));
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                if (DropTarget.this.control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long time = System.currentTimeMillis();
                int delay = 50;
                if (time < DropTarget.this.dragOverStart) {
                    delay = (int)(DropTarget.this.dragOverStart - time);
                } else {
                    int allowedOperations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                    TransferData[] allowedTypes = ((DropTarget)DropTarget.this).dragOverEvent.dataTypes;
                    TransferData[] dataTypes = new TransferData[allowedTypes.length];
                    System.arraycopy(allowedTypes, 0, dataTypes, 0, dataTypes.length);
                    DNDEvent event = new DNDEvent();
                    event.widget = ((DropTarget)DropTarget.this).dragOverEvent.widget;
                    event.x = ((DropTarget)DropTarget.this).dragOverEvent.x;
                    event.y = ((DropTarget)DropTarget.this).dragOverEvent.y;
                    event.time = (int)time;
                    event.feedback = 1;
                    event.dataTypes = dataTypes;
                    event.dataType = DropTarget.this.selectedDataType;
                    event.operations = ((DropTarget)DropTarget.this).dragOverEvent.operations;
                    event.detail = DropTarget.this.selectedOperation;
                    try {
                        DropTarget.this.notifyListeners(2004, event);
                    }
                    catch (Throwable throwable) {
                        event.dataType = null;
                        event.detail = 0;
                    }
                    DropTarget.this.effect.show(event.feedback, event.x, event.y);
                    DropTarget.this.selectedDataType = null;
                    if (event.dataType != null) {
                        int i = 0;
                        while (i < allowedTypes.length) {
                            if (allowedTypes[i].type == event.dataType.type) {
                                DropTarget.this.selectedDataType = event.dataType;
                                break;
                            }
                            ++i;
                        }
                    }
                    DropTarget.this.selectedOperation = 0;
                    if (DropTarget.this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
                        DropTarget.this.selectedOperation = event.detail;
                    }
                }
                DropTarget.this.control.getDisplay().timerExec(delay, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    private static int DragReceiveHandler(int theWindow, int handlerRefCon, int theDrag) {
        DropTarget target = DropTarget.FindDropTarget(theWindow, theDrag);
        if (target == null) {
            return 0;
        }
        return target.dragReceiveHandler(theWindow, handlerRefCon, theDrag);
    }

    private static int DragTrackingHandler(int message, int theWindow, int handlerRefCon, int theDrag) {
        if (message == 5 || message == 1) {
            CurrentDropTarget = null;
            return 0;
        }
        DropTarget target = DropTarget.FindDropTarget(theWindow, theDrag);
        if (CurrentDropTarget != null) {
            if (target == null || DropTarget.CurrentDropTarget.control.handle != target.control.handle) {
                CurrentDropTarget.dragTrackingHandler(4, theWindow, handlerRefCon, theDrag);
                CurrentDropTarget = target;
                message = 2;
            }
        } else {
            CurrentDropTarget = target;
            message = 2;
        }
        if (target == null) {
            return 0;
        }
        return target.dragTrackingHandler(message, theWindow, handlerRefCon, theDrag);
    }

    private static DropTarget FindDropTarget(int theWindow, int theDrag) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Point mouse = new Point();
        OS.GetDragMouse((int)theDrag, (Point)mouse, null);
        int[] theRoot = new int[1];
        OS.GetRootControl((int)theWindow, (int[])theRoot);
        int[] theControl = new int[1];
        Rect rect = new Rect();
        OS.GetWindowBounds((int)theWindow, (short)33, (Rect)rect);
        CGPoint inPoint = new CGPoint();
        inPoint.x = mouse.h - rect.left;
        inPoint.y = mouse.v - rect.top;
        OS.HIViewGetSubviewHit((int)theRoot[0], (CGPoint)inPoint, (boolean)true, (int[])theControl);
        if (!OS.IsControlEnabled((int)theControl[0])) {
            return null;
        }
        Widget widget = display.findWidget(theControl[0]);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData(DROPTARGETID);
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    private int dragReceiveHandler(int theWindow, int handlerRefCon, int theDrag) {
        this.updateDragOverHover(0L, null);
        this.effect.show(0, 0, 0);
        if (this.keyOperation == -1) {
            return -1857;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.detail = 0;
        try {
            this.notifyListeners(2003, event);
        }
        catch (Throwable throwable) {}
        event = new DNDEvent();
        if (!this.setEventData(theDrag, event)) {
            return -1857;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, event.dataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        try {
            this.notifyListeners(2007, event);
        }
        catch (Throwable throwable) {
            event.detail = 0;
            event.dataType = null;
        }
        this.selectedDataType = null;
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            return -1857;
        }
        byte[][] data = new byte[][]{};
        short[] numItems = new short[1];
        OS.CountDragItems((int)theDrag, (short[])numItems);
        short i = 0;
        while (i < numItems[0]) {
            int[] theItemRef = new int[1];
            OS.GetDragItemReferenceNumber((int)theDrag, (short)((short)(i + 1)), (int[])theItemRef);
            int[] size = new int[1];
            OS.GetFlavorDataSize((int)theDrag, (int)theItemRef[0], (int)this.selectedDataType.type, (int[])size);
            if (size[0] > 0) {
                byte[] buffer = new byte[size[0]];
                OS.GetFlavorData((int)theDrag, (int)theItemRef[0], (int)this.selectedDataType.type, (byte[])buffer, (int[])size, (int)0);
                byte[][] newData = new byte[data.length + 1][];
                System.arraycopy(data, 0, newData, 0, data.length);
                newData[data.length] = buffer;
                data = newData;
            }
            i = (short)(i + 1);
        }
        Object object = null;
        int i2 = 0;
        while (i2 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i2];
            if (transfer.isSupportedType(this.selectedDataType)) {
                this.selectedDataType.data = data;
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++i2;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        event.data = object;
        try {
            this.notifyListeners(2006, event);
            this.selectedOperation = 0;
            if ((allowedOperations & event.detail) == event.detail) {
                this.selectedOperation = event.detail;
            }
        }
        catch (Throwable throwable) {
            this.selectedOperation = 0;
        }
        int action = this.opToOsOp(this.selectedOperation);
        OS.SetDragDropAction((int)theDrag, (int)action);
        return this.selectedOperation == 0 ? -1857 : 0;
    }

    private int dragTrackingHandler(int message, int theWindow, int handlerRefCon, int theDrag) {
        DNDEvent event;
        if (message == 4) {
            this.updateDragOverHover(0L, null);
            this.effect.show(0, 0, 0);
            OS.SetThemeCursor((int)0);
            if (this.keyOperation == -1) {
                return -1857;
            }
            this.keyOperation = -1;
            DNDEvent event2 = new DNDEvent();
            event2.widget = this;
            event2.time = (int)System.currentTimeMillis();
            event2.detail = 0;
            try {
                this.notifyListeners(2003, event2);
            }
            catch (Throwable throwable) {}
            return 0;
        }
        int oldKeyOperation = this.keyOperation;
        if (message == 2) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(theDrag, event = new DNDEvent())) {
            this.keyOperation = -1;
            OS.SetThemeCursor((int)18);
            return -1857;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        switch (message) {
            case 2: {
                event.type = 2002;
                break;
            }
            case 3: {
                if (this.keyOperation == oldKeyOperation) {
                    event.type = 2004;
                    event.dataType = this.selectedDataType;
                    event.detail = this.selectedOperation;
                    break;
                }
                event.type = 2005;
                event.dataType = this.selectedDataType;
            }
        }
        this.updateDragOverHover(50L, event);
        try {
            this.notifyListeners(event.type, event);
        }
        catch (Throwable throwable) {
            OS.SetThemeCursor((int)18);
            return -1857;
        }
        if (event.detail == 16) {
            event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        OS.SetDragDropAction((int)theDrag, (int)this.opToOsOp(this.selectedOperation));
        this.effect.show(event.feedback, event.x, event.y);
        switch (this.selectedOperation) {
            case 1: {
                OS.SetThemeCursor((int)1);
                break;
            }
            case 4: {
                OS.SetThemeCursor((int)2);
                break;
            }
            case 2: {
                OS.SetThemeCursor((int)0);
                break;
            }
            default: {
                OS.SetThemeCursor((int)18);
            }
        }
        if (message == 2) {
            this.dragOverHeartbeat.run();
        }
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    private int getOperationFromKeyState(int theDrag) {
        boolean command;
        short[] modifiers = new short[1];
        OS.GetDragModifiers((int)theDrag, (short[])modifiers, null, null);
        boolean option = (modifiers[0] & 0x800) == 2048;
        boolean bl = command = (modifiers[0] & 0x100) == 256;
        if (option && command) {
            return 4;
        }
        if (option) {
            return 1;
        }
        if (command) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    public void notifyListeners(int eventType, Event event) {
        org.eclipse.swt.graphics.Point coordinates = new org.eclipse.swt.graphics.Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        if (this.control instanceof Tree) {
            event.item = ((Tree)this.control).getItem(coordinates);
        }
        if (this.control instanceof Table) {
            event.item = ((Table)this.control).getItem(coordinates);
        }
        super.notifyListeners(eventType, event);
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DROPTARGETID, null);
        this.transferAgents = null;
        this.control = null;
    }

    private int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        return osOperation;
    }

    private int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 2) != 0) {
            operation |= 4;
        }
        if ((osOperation & 0x10) != 0) {
            operation |= 2;
        }
        if (osOperation == -1) {
            operation = 7;
        }
        return operation;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    private boolean setEventData(int theDrag, DNDEvent event) {
        int operation;
        if (theDrag == 0) {
            return false;
        }
        int style = this.getStyle();
        int[] outActions = new int[1];
        OS.GetDragAllowableActions((int)theDrag, (int[])outActions);
        int operations = this.osOpToOp(outActions[0]) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState(theDrag);
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        short[] numItems = new short[1];
        OS.CountDragItems((int)theDrag, (short[])numItems);
        int[] flavors = new int[10];
        int index = -1;
        short i = 0;
        while (i < numItems[0]) {
            int[] theItemRef = new int[1];
            OS.GetDragItemReferenceNumber((int)theDrag, (short)((short)(i + 1)), (int[])theItemRef);
            short[] numFlavors = new short[1];
            OS.CountDragItemFlavors((int)theDrag, (int)theItemRef[0], (short[])numFlavors);
            int[] theType = new int[1];
            int j = 0;
            while (j < numFlavors.length) {
                theType[0] = 0;
                if (OS.GetFlavorType((int)theDrag, (int)theItemRef[0], (short)((short)(j + 1)), (int[])theType) == 0) {
                    boolean unique = true;
                    int k = 0;
                    while (k < flavors.length) {
                        if (flavors[k] == theType[0]) {
                            unique = false;
                            break;
                        }
                        ++k;
                    }
                    if (unique) {
                        if (index == flavors.length - 1) {
                            int[] temp = new int[flavors.length + 10];
                            System.arraycopy(flavors, 0, temp, 0, flavors.length);
                            flavors = temp;
                        }
                        flavors[++index] = theType[0];
                    }
                }
                ++j;
            }
            i = (short)(i + 1);
        }
        if (index == -1) {
            return false;
        }
        TransferData[] dataTypes = new TransferData[index + 1];
        index = -1;
        int i2 = 0;
        while (i2 < dataTypes.length) {
            if (flavors[i2] != 0) {
                TransferData data = new TransferData();
                data.type = flavors[i2];
                int j = 0;
                while (j < this.transferAgents.length) {
                    if (this.transferAgents[j].isSupportedType(data)) {
                        dataTypes[++index] = data;
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (index == -1) {
            return false;
        }
        if (index < dataTypes.length - 1) {
            TransferData[] temp = new TransferData[index + 1];
            System.arraycopy(dataTypes, 0, temp, 0, index + 1);
            dataTypes = temp;
        }
        Point mouse = new Point();
        OS.GetDragMouse((int)theDrag, (Point)mouse, null);
        event.widget = this;
        event.x = mouse.h;
        event.y = mouse.v;
        event.time = (int)System.currentTimeMillis();
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        return true;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
    }

    private void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        this.dragOverEvent.dataTypes = event.dataTypes;
        this.dragOverEvent.operations = event.operations;
        this.dragOverEvent.dataType = event.dataType;
        this.dragOverEvent.detail = event.detail;
    }
}

