/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import classes.Project;
import classes.TypeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simulation.JobType;
import trafficdefinition.TrafficArea;
import ui.dialogs.DlgSelectTypes;

public class PnlTrafficAreaProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnChangeColor = null;
    private TrafficArea currentArea = null;
    private JLabel lblColorTitle = null;
    private JLabel lblNameTitle = null;
    private JLabel lblPopulation = null;
    private JLabel lblWorkPositions = null;
    private JSpinner spnPopulation = null;
    private JSpinner spnWorkPositions = null;
    private JTextField txtName = null;
    private JButton btnResidentJobs = null;
    private JButton btnWorkerJobs = null;
    private JLabel lblAverageAdultsPerHouse = null;
    private JLabel lblAverageChildrenPerHouse = null;
    private JLabel lblPossibilityAdultIsDriver = null;
    private JLabel lblPossibilityAdultHasJob = null;
    private JSpinner spnAverageAdultsPerHouse = null;
    private JSpinner spnAverageChildrenPerHouse = null;
    private JSpinner spnPossibilityAdultIsDriver = null;
    private JSpinner spnPossibilityAdultHasJob = null;
    private JLabel lblPossibilityDriverHasCar = null;
    private JSpinner spnPossibilityDriverHasCar = null;
    private JCheckBox chkEnabled = null;

    public PnlTrafficAreaProperties() {
        this.initialize();
    }

    public void setArea(TrafficArea area) {
        this.currentArea = area;
        this.txtName.setText(this.currentArea.getName());
        this.btnChangeColor.setBackground(this.currentArea.getColor());
        this.spnPopulation.setValue(this.currentArea.getPopulation());
        this.spnWorkPositions.setValue(this.currentArea.getWorkPositions());
        this.spnAverageAdultsPerHouse.setValue(Float.valueOf(this.currentArea.getAverageAdultsPerHouse()));
        this.spnAverageChildrenPerHouse.setValue(Float.valueOf(this.currentArea.getAverageChildrenPerHouse()));
        this.spnPossibilityAdultHasJob.setValue(Float.valueOf(this.currentArea.getPossibilityAdultHasJob()));
        this.spnPossibilityAdultIsDriver.setValue(Float.valueOf(this.currentArea.getPossibilityAdultIsDriver()));
        this.spnPossibilityDriverHasCar.setValue(Float.valueOf(this.currentArea.getPossibilityDriverHasCar()));
        if (this.currentArea.getPopulation() == 0) {
            this.btnResidentJobs.setEnabled(false);
        } else {
            this.btnResidentJobs.setEnabled(true);
        }
        if (this.currentArea.getWorkPositions() == 0) {
            this.btnWorkerJobs.setEnabled(false);
        } else {
            this.btnWorkerJobs.setEnabled(true);
        }
        this.chkEnabled.setSelected(this.currentArea.isEnabled());
    }

    private JButton getBtnChangeColor() {
        if (this.btnChangeColor == null) {
            this.btnChangeColor = new JButton();
            this.btnChangeColor.setPreferredSize(new Dimension(86, 20));
            this.btnChangeColor.setText("");
            this.btnChangeColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlTrafficAreaProperties.this.ChangeColor();
                }
            });
        }
        return this.btnChangeColor;
    }

    private JSpinner getSpnPopulation() {
        if (this.spnPopulation == null) {
            this.spnPopulation = new JSpinner();
            this.spnPopulation.setPreferredSize(new Dimension(70, 20));
            this.spnPopulation.setModel(new SpinnerNumberModel(0, 0, 1000000, 1));
            this.spnPopulation.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setPopulation((Integer)PnlTrafficAreaProperties.this.spnPopulation.getValue());
                    if ((Integer)PnlTrafficAreaProperties.this.spnPopulation.getValue() == 0) {
                        PnlTrafficAreaProperties.this.btnResidentJobs.setEnabled(false);
                    } else {
                        PnlTrafficAreaProperties.this.btnResidentJobs.setEnabled(true);
                    }
                }
            });
        }
        return this.spnPopulation;
    }

    private JSpinner getSpnWorkPositions() {
        if (this.spnWorkPositions == null) {
            this.spnWorkPositions = new JSpinner();
            this.spnWorkPositions.setPreferredSize(new Dimension(70, 20));
            this.spnWorkPositions.setModel(new SpinnerNumberModel(0, 0, 1000000, 1));
            this.spnWorkPositions.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setWorkPositions((Integer)PnlTrafficAreaProperties.this.spnWorkPositions.getValue());
                    if ((Integer)PnlTrafficAreaProperties.this.spnWorkPositions.getValue() == 0) {
                        PnlTrafficAreaProperties.this.btnWorkerJobs.setEnabled(false);
                    } else {
                        PnlTrafficAreaProperties.this.btnWorkerJobs.setEnabled(true);
                    }
                }
            });
        }
        return this.spnWorkPositions;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setName(PnlTrafficAreaProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints81 = new GridBagConstraints();
        gridBagConstraints81.gridx = 1;
        gridBagConstraints81.weighty = 1.0;
        gridBagConstraints81.anchor = 17;
        gridBagConstraints81.gridy = 11;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.gridy = 9;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.gridy = 9;
        this.lblPossibilityDriverHasCar = new JLabel();
        this.lblPossibilityDriverHasCar.setText("Possibility driver has car:");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.gridy = 10;
        GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
        gridBagConstraints71.gridx = 1;
        gridBagConstraints71.anchor = 17;
        gridBagConstraints71.gridy = 8;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.gridy = 7;
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
        gridBagConstraints51.gridx = 1;
        gridBagConstraints51.anchor = 17;
        gridBagConstraints51.gridy = 6;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 10;
        this.lblPossibilityAdultHasJob = new JLabel();
        this.lblPossibilityAdultHasJob.setText("Possibility adult has job:");
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.gridx = 0;
        gridBagConstraints32.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints32.anchor = 17;
        gridBagConstraints32.gridy = 8;
        this.lblPossibilityAdultIsDriver = new JLabel();
        this.lblPossibilityAdultIsDriver.setText("Possibility adult is driver:");
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.gridy = 7;
        this.lblAverageChildrenPerHouse = new JLabel();
        this.lblAverageChildrenPerHouse.setText("Average children per house:");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints13.gridy = 6;
        this.lblAverageAdultsPerHouse = new JLabel();
        this.lblAverageAdultsPerHouse.setText("Average adults per house:");
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.insets = new Insets(5, 0, 5, 10);
        gridBagConstraints31.anchor = 11;
        gridBagConstraints31.fill = 0;
        gridBagConstraints31.gridwidth = 2;
        gridBagConstraints31.gridy = 4;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 10);
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 3;
        GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
        gridBagConstraints41.gridx = 1;
        gridBagConstraints41.anchor = 17;
        gridBagConstraints41.gridy = 1;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 1;
        gridBagConstraints12.anchor = 11;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints12.gridy = 5;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridy = 3;
        this.lblWorkPositions = new JLabel();
        this.lblWorkPositions.setText("Work positions:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints11.gridy = 1;
        this.lblPopulation = new JLabel();
        this.lblPopulation.setText("Population:");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.weighty = 0.0;
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints7.gridy = 5;
        this.lblColorTitle = new JLabel();
        this.lblColorTitle.setText("Color:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(351, 280);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints);
        this.add((Component)this.getTxtName(), gridBagConstraints1);
        this.add((Component)this.lblColorTitle, gridBagConstraints7);
        this.add((Component)this.lblPopulation, gridBagConstraints11);
        this.add((Component)this.lblWorkPositions, gridBagConstraints3);
        this.add((Component)this.getBtnChangeColor(), gridBagConstraints12);
        this.add((Component)this.getSpnPopulation(), gridBagConstraints41);
        this.add((Component)this.getSpnWorkPositions(), gridBagConstraints5);
        this.add((Component)this.getBtnResidentJobs(), gridBagConstraints2);
        this.add((Component)this.getBtnWorkerJobs(), gridBagConstraints31);
        this.add((Component)this.lblAverageAdultsPerHouse, gridBagConstraints13);
        this.add((Component)this.lblAverageChildrenPerHouse, gridBagConstraints21);
        this.add((Component)this.lblPossibilityAdultIsDriver, gridBagConstraints32);
        this.add((Component)this.lblPossibilityAdultHasJob, gridBagConstraints4);
        this.add((Component)this.getSpnAverageAdultsPerHouse(), gridBagConstraints51);
        this.add((Component)this.getSpnAverageChildrenPerHouse(), gridBagConstraints6);
        this.add((Component)this.getSpnPossibilityAdultIsDriver(), gridBagConstraints71);
        this.add((Component)this.getSpnPossibilityAdultHasJob(), gridBagConstraints8);
        this.add((Component)this.lblPossibilityDriverHasCar, gridBagConstraints9);
        this.add((Component)this.getSpnPossibilityDriverHasCar(), gridBagConstraints10);
        this.add((Component)this.getChkEnabled(), gridBagConstraints81);
    }

    protected void ChangeColor() {
        Color newColor = JColorChooser.showDialog(this, "Select flow color", this.currentArea.getColor());
        if (newColor != null) {
            this.currentArea.setColor(newColor);
            this.btnChangeColor.setBackground(newColor);
        }
    }

    private JButton getBtnResidentJobs() {
        if (this.btnResidentJobs == null) {
            this.btnResidentJobs = new JButton();
            this.btnResidentJobs.setText("Select resident job types...");
            this.btnResidentJobs.setPreferredSize(new Dimension(190, 20));
            this.btnResidentJobs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlTrafficAreaProperties.this.SelectResidentJobTypes();
                }
            });
        }
        return this.btnResidentJobs;
    }

    private JButton getBtnWorkerJobs() {
        if (this.btnWorkerJobs == null) {
            this.btnWorkerJobs = new JButton();
            this.btnWorkerJobs.setPreferredSize(new Dimension(190, 20));
            this.btnWorkerJobs.setText("Select worker job types...");
            this.btnWorkerJobs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlTrafficAreaProperties.this.SelectWorkerJobTypes();
                }
            });
        }
        return this.btnWorkerJobs;
    }

    protected void SelectResidentJobTypes() {
        TypeSelection<JobType> projectJobTypes = new TypeSelection<JobType>(Project.getCurrentlyLoadedProject().getJobTypes());
        TypeSelection<JobType> residentJobTypes = new TypeSelection<JobType>(this.currentArea.getResidentsJobSelection());
        residentJobTypes.addTypesNotInSelection(projectJobTypes);
        DlgSelectTypes<JobType> dlg = new DlgSelectTypes<JobType>(residentJobTypes);
        dlg.setVisible(true);
        if (dlg.getAnswer() == 0) {
            residentJobTypes.removeTypesWithZeroPercentage();
            this.currentArea.setResidentsJobSelection(residentJobTypes);
        }
    }

    protected void SelectWorkerJobTypes() {
        TypeSelection<JobType> projectJobTypes = new TypeSelection<JobType>(Project.getCurrentlyLoadedProject().getJobTypes());
        TypeSelection<JobType> workerJobTypes = new TypeSelection<JobType>(this.currentArea.getWorkersJobSelection());
        workerJobTypes.addTypesNotInSelection(projectJobTypes);
        DlgSelectTypes<JobType> dlg = new DlgSelectTypes<JobType>(workerJobTypes);
        dlg.setVisible(true);
        if (dlg.getAnswer() == 0) {
            workerJobTypes.removeTypesWithZeroPercentage();
            this.currentArea.setWorkersJobSelection(workerJobTypes);
        }
    }

    private JSpinner getSpnAverageAdultsPerHouse() {
        if (this.spnAverageAdultsPerHouse == null) {
            this.spnAverageAdultsPerHouse = new JSpinner();
            this.spnAverageAdultsPerHouse.setPreferredSize(new Dimension(70, 20));
            this.spnAverageAdultsPerHouse.setModel(new SpinnerNumberModel(new Float(2.0f), new Float(1.0f), new Float(10.0f), new Float(0.1)));
            this.spnAverageAdultsPerHouse.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setAverageAdultsPerHouse(((Float)PnlTrafficAreaProperties.this.spnAverageAdultsPerHouse.getValue()).floatValue());
                }
            });
        }
        return this.spnAverageAdultsPerHouse;
    }

    private JSpinner getSpnAverageChildrenPerHouse() {
        if (this.spnAverageChildrenPerHouse == null) {
            this.spnAverageChildrenPerHouse = new JSpinner();
            this.spnAverageChildrenPerHouse.setPreferredSize(new Dimension(70, 20));
            this.spnAverageChildrenPerHouse.setModel(new SpinnerNumberModel(new Float(1.0f), new Float(0.0f), new Float(10.0f), new Float(0.1)));
            this.spnAverageChildrenPerHouse.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setAverageChildrenPerHouse(((Float)PnlTrafficAreaProperties.this.spnAverageChildrenPerHouse.getValue()).floatValue());
                }
            });
        }
        return this.spnAverageChildrenPerHouse;
    }

    private JSpinner getSpnPossibilityAdultIsDriver() {
        if (this.spnPossibilityAdultIsDriver == null) {
            this.spnPossibilityAdultIsDriver = new JSpinner();
            this.spnPossibilityAdultIsDriver.setPreferredSize(new Dimension(70, 20));
            this.spnPossibilityAdultIsDriver.setModel(new SpinnerNumberModel(new Float(0.5), new Float(0.0f), new Float(1.0f), new Float(0.01)));
            this.spnPossibilityAdultIsDriver.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setPossibilityAdultIsDriver(((Float)PnlTrafficAreaProperties.this.spnPossibilityAdultIsDriver.getValue()).floatValue());
                }
            });
        }
        return this.spnPossibilityAdultIsDriver;
    }

    private JSpinner getSpnPossibilityAdultHasJob() {
        if (this.spnPossibilityAdultHasJob == null) {
            this.spnPossibilityAdultHasJob = new JSpinner();
            this.spnPossibilityAdultHasJob.setPreferredSize(new Dimension(70, 20));
            this.spnPossibilityAdultHasJob.setModel(new SpinnerNumberModel(new Float(0.95), new Float(0.0f), new Float(1.0f), new Float(0.01)));
            this.spnPossibilityAdultHasJob.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setPossibilityAdultHasJob(((Float)PnlTrafficAreaProperties.this.spnPossibilityAdultHasJob.getValue()).floatValue());
                }
            });
        }
        return this.spnPossibilityAdultHasJob;
    }

    private JSpinner getSpnPossibilityDriverHasCar() {
        if (this.spnPossibilityDriverHasCar == null) {
            this.spnPossibilityDriverHasCar = new JSpinner();
            this.spnPossibilityDriverHasCar.setPreferredSize(new Dimension(70, 20));
            this.spnPossibilityDriverHasCar.setModel(new SpinnerNumberModel(new Float(0.95), new Float(0.0f), new Float(1.0f), new Float(0.01)));
            this.spnPossibilityDriverHasCar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setPossibilityDriverHasCar(((Float)PnlTrafficAreaProperties.this.spnPossibilityDriverHasCar.getValue()).floatValue());
                }
            });
        }
        return this.spnPossibilityDriverHasCar;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlTrafficAreaProperties.this.currentArea.setEnabled(PnlTrafficAreaProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }
}

