/*
 * Decompiled with CFR 0.152.
 */
package ui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimTimeEdit
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private JSpinner spnRealTime = null;
    private JSpinner spnSimTime = null;
    private int value = 0;
    private JLabel lblRealTime = null;
    private JLabel lblSimTime = null;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public void addChangeListener(ChangeListener c) {
        if (!this.changeListeners.contains(c)) {
            this.changeListeners.add(c);
        }
    }

    public void removeChangeListener(ChangeListener c) {
        if (this.changeListeners.contains(c)) {
            this.changeListeners.remove(c);
        }
    }

    private void NotifyValueChanged() {
        for (ChangeListener c : this.changeListeners) {
            c.stateChanged(new ChangeEvent(this));
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        Date d = new Date();
        d.setHours(value / 3600);
        d.setMinutes(value % 3600 / 60);
        d.setSeconds(value % 3600 % 60);
        this.spnRealTime.setValue(d);
        this.spnSimTime.setValue(value);
        this.spnSimTime.addChangeListener(this);
        this.spnRealTime.addChangeListener(this);
    }

    public SimTimeEdit() {
        this.initialize();
        this.setValue(0);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints2.gridy = 1;
        this.lblSimTime = new JLabel();
        this.lblSimTime.setText("Simulation time:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.gridy = 0;
        this.lblRealTime = new JLabel();
        this.lblRealTime.setText("Real time:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 0;
        this.setSize(163, 49);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSpnRealTime(), gridBagConstraints);
        this.add((Component)this.getSpnSimTime(), gridBagConstraints1);
        this.add((Component)this.lblRealTime, gridBagConstraints11);
        this.add((Component)this.lblSimTime, gridBagConstraints2);
    }

    private JSpinner getSpnRealTime() {
        if (this.spnRealTime == null) {
            this.spnRealTime = new JSpinner();
            this.spnRealTime.setModel(new SpinnerDateModel(new Date(), null, null, 12));
            JSpinner.DateEditor de = new JSpinner.DateEditor(this.spnRealTime, "HH:mm");
            this.spnRealTime.setEditor(de);
            this.spnRealTime.setPreferredSize(new Dimension(60, 20));
        }
        return this.spnRealTime;
    }

    private JSpinner getSpnSimTime() {
        if (this.spnSimTime == null) {
            this.spnSimTime = new JSpinner();
            this.spnSimTime.setModel(new SpinnerNumberModel(0, 0, 86400, 60));
            this.spnSimTime.setPreferredSize(new Dimension(60, 20));
        }
        return this.spnSimTime;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.spnSimTime.removeChangeListener(this);
        this.spnRealTime.removeChangeListener(this);
        if (e.getSource().equals(this.spnRealTime)) {
            Date d = (Date)this.spnRealTime.getValue();
            this.value = d.getHours() * 3600 + d.getMinutes() * 60 + d.getSeconds();
            this.spnSimTime.setValue(this.value);
        } else if (e.getSource().equals(this.spnSimTime)) {
            this.value = (Integer)this.spnSimTime.getValue();
            Date d = new Date();
            d.setHours(this.value / 3600);
            d.setMinutes(this.value % 3600 / 60);
            d.setSeconds(this.value % 3600 % 60);
            this.spnRealTime.setValue(d);
        }
        this.spnSimTime.addChangeListener(this);
        this.spnRealTime.addChangeListener(this);
        this.NotifyValueChanged();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.spnRealTime.setEnabled(b);
        this.spnSimTime.setEnabled(b);
        this.lblSimTime.setEnabled(b);
        this.lblRealTime.setEnabled(b);
    }
}

