/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.demand.ODRelation;
import cadyts.utilities.math.Matrix;
import cadyts.utilities.misc.DynamicData;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class SumoODWriter {
    SumoODWriter() {
    }

    private List<String> extractZones(DynamicData<ODRelation<String>> od) {
        TreeSet<String> zones = new TreeSet<String>();
        for (ODRelation<String> key : od.keySet()) {
            zones.add(key.getFromTAZ());
            zones.add(key.getToTAZ());
        }
        return new ArrayList<String>(zones);
    }

    private Matrix tripMatrix(DynamicData<ODRelation<String>> od, int bin, List<String> zones) {
        Matrix result = new Matrix(zones.size(), zones.size());
        int i = 0;
        while (i < zones.size()) {
            int j = 0;
            while (j < zones.size()) {
                ODRelation<String> key = new ODRelation<String>(zones.get(i), zones.get(j));
                result.getRow(i).set(j, od.getBinValue(key, bin));
                ++j;
            }
            ++i;
        }
        return result;
    }

    void write(DynamicData<ODRelation<String>> od, String filePrefix) throws FileNotFoundException {
        List<String> zones = this.extractZones(od);
        int bin = 0;
        while (bin < od.getBinCnt()) {
            Matrix tripMatrix = this.tripMatrix(od, bin, zones);
            if (tripMatrix.frobeniusNorm() > 0.0) {
                int h_start = od.binStart_s(bin) / 3600;
                int m_start = (od.binStart_s(bin) - h_start * 3600) / 60;
                int h_end = od.binStart_s(bin + 1) / 3600;
                int m_end = (od.binStart_s(bin + 1) - h_end * 3600) / 60;
                PrintWriter writer = new PrintWriter(String.valueOf(filePrefix) + "_" + h_start + "h" + m_start + "m-" + h_end + "h" + m_end + "m.fma");
                writer.println("$VMR");
                writer.println("* vehicle type");
                writer.println("0");
                writer.println("* from-time to-time");
                writer.println(String.valueOf(h_start) + "." + m_start + " " + h_end + "." + m_end);
                writer.println("* factor");
                writer.println("1.0");
                writer.println("* district number");
                writer.println(zones.size());
                writer.println("* names");
                for (String zone : zones) {
                    writer.print("\t" + zone);
                }
                writer.println();
                writer.println("*");
                int i = 0;
                while (i < zones.size()) {
                    writer.println("* district " + zones.get(i) + " sum = " + tripMatrix.getRow(i).sum());
                    int j = 0;
                    while (j < zones.size()) {
                        writer.print("\t" + tripMatrix.getRow(i).get(j));
                        ++j;
                    }
                    writer.println();
                    ++i;
                }
                writer.flush();
                writer.close();
            }
            ++bin;
        }
    }
}

