#ifndef _DialogPreferences_h
#define _DialogPreferences_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <libglademm/xml.h>
#include <gtkmm.h>


/*
 *
 */
class TreeViewEncodings : public Gtk::TreeView
{
public:

	/*
	 *
	 */
	class Column : public Gtk::TreeModel::ColumnRecord
	{
	public:
		Column()
		{
			add(use);
			add(name);
			add(charset);
		}

		Gtk::TreeModelColumn<bool>					use;
		Gtk::TreeModelColumn<Glib::ustring>	name;
		Gtk::TreeModelColumn<Glib::ustring>	charset;
	};

public:
  TreeViewEncodings(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void save_cfg();

	void on_add_charset();
	void on_remove_charset();
	void on_up_charset();
	void on_down_charset();

	void on_selection_changed();

	void on_used_auto_detected_toggled();
public:
	Glib::RefPtr<Gtk::ListStore>	m_model;

	Gtk::Button*	m_buttonAddCharset;
	Gtk::Button*	m_buttonRemoveCharset;
	Gtk::Button*	m_buttonUpCharset;
	Gtk::Button*	m_buttonDownCharset;
	Gtk::CheckButton*	m_checkUsedAutoDetected;
};


/*
 *
 */
class TreeViewVideoPlayer : public Gtk::TreeView
{
protected:
	/*
	 *
	 */
	class Column : public Gtk::TreeModel::ColumnRecord
	{
	public:
		Column()
		{
			add(active);
			add(name);
			add(cmd);
		}

		Gtk::TreeModelColumn<bool> active;
		Gtk::TreeModelColumn<Glib::ustring>	name;
		Gtk::TreeModelColumn<Glib::ustring>	cmd;
	};
public:
  TreeViewVideoPlayer(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void on_add_video_player();
	void on_remove_video_player();
protected:
	void save_cfg();

	void on_signal_toggled(const Glib::ustring &path);
	void on_signal_name_edited(const Glib::ustring &path, const Glib::ustring &text);
	void on_signal_cmd_edited(const Glib::ustring &path, const Glib::ustring &text);


protected:
	Glib::RefPtr<Gtk::ListStore> m_model;
};



/*
 *
 */
class DialogPreferences : public Gtk::Dialog
{
public:
	DialogPreferences(BaseObjectType *cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

protected:
	//
	void on_general_maximize_window_changed();

	void save_general();
	void save_video_player();
	void save_encodings();
protected:
	// general
	Gtk::CheckButton*		m_checkMaximizeWindow;

	// video preview
	TreeViewVideoPlayer*	m_treeViewVideoPlayer;
	Gtk::Button*					m_buttonAddVideoPlayer;
	Gtk::Button*					m_buttonRemoveVideoPlayer;

	// encodings
	TreeViewEncodings*	m_encodingsTreeView;

	Gtk::CheckButton*		m_checkUsedAutoDetected;
};

#endif//_DialogPreferences_h

