﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TestEnumeration
{
  public class DaysOfTheWeek : System.Collections.IEnumerable
  {
    string[] days = { "Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat" };
    public List<string> stack = new List<string>();

    public System.Collections.IEnumerator GetEnumerator()
    {
      stack.Clear();
      for (int i = 0; i < days.Length; i++)
      {
        stack.Add(days[i]);
        yield return days[i];
      }
    }
  }

  class Program
  {
    static void Main()
    {
      // Create an instance of the collection class
      DaysOfTheWeek week = new DaysOfTheWeek();

      // Iterate with foreach
      foreach (string day in week)
      {
        System.Console.Write(week.stack.Count + " ");
        System.Console.Write(day + " ");
      }
    }
  }
}
