/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales, CN=Sales CA */
  9, X'304b310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e310e300c060355040b130553616c65733111300f0603550403130853616c6573204341'
);

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Sales, CN=Sales CA' */
  11, X'5f9b1346f92072c800d588b5a74c2e97ea0b9328'
);

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, OU=Sales, CN=Sales CA' */
  11, X'c9ca6b980be96d5f210d7fed1529eb6c567ec26c'
);

INSERT INTO identities (
  type, data
) VALUES ( /* dave@strongswan.org */
  3, X'64617665407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Sales, CN=dave@strongswan.org' */
  11, X'671081ec8703e10c31abdf12d53275046eba1522'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales CN=Sales CA */
  1, 1, X'308203bb308202a3a003020102020121300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3130303430363039353433335a170d3139303430343039353433335a304b310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e310e300c060355040b130553616c65733111300f0603550403130853616c657320434130820122300d06092a864886f70d01010105000382010f003082010a0282010100c24e4d26998c37b9511fa125ba1d704e34581c569beaf41620fe14b736734847fd07169b55dfaa773da9a3cf1a8c4ed817f05e01441df39d4331c6bad861b2f74c3e49963f5677b83af0b1caab98bcaae0923cedec527a7d608260951226f9e53e1f371ad320625aa1ee899fdbfd6701b607e52bde7140ff075c91276a27173a5cbf4329c464dd3c59b6ff52b837ed13d1bbf3b3ba3c94b27f2518865773d4465ee4f4ec52801b049d030d7271df9eb6903b5f41dc1ecdab742c0c8eb1569b62aff41bf7c16702cb7abe2a185dbedc2b2f3fb8cd5e785161e4afdbee22da602381b0512350378aaa14dcdab5bcf02aceb7a4388fd157d1eb7bd2f5afc5f574810203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145f9b1346f92072c800d588b5a74c2e97ea0b9328306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010024654ea5cc8c7cbbafbad69eaff4f721674dde9dfb2e8a9078fd92f612039abbc587663f7238f983f6aa93e762349ec9f302978648c8c5e77d46f3e4ebee5e9e12092d2021427a98aebee5fd5add449d07809ed0e7789a45084262f32850914aa7615a8573349ae5f814f56b977df9a2d600be52da9a94a103e01bae0c3e0872dd2c946f8a817a9964dc9751ffa3a00392d078db4b888ed8fdd6cc33646f9f6f38448231a764ea3761eea7a04d2c7bfa7cb8b1749a4cfa71bb6631987feedd9ee63a64386f22dd7ccebff69f510b0503e13394a3621190219566373343aca19500ab5ae4b1bc0700468b4b9773d7c15d645c7df237375fc8663fe86f9b775828'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales, CN=dave@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 7 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 8 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, OU=Sales, CN=dave@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 7 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 8 
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_DAVE', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id
) VALUES (
  'home', 1, 7, 9 
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', 'ipsec _updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

