/* Object identifiers (OIDs) used by strongSwan
 * Copyright (C) 2003-2008 Andreas Steffen, Hochschule fuer Technik Rapperswil
 * 
 * This file has been automatically generated by the script oid.pl
 * Do not edit manually!
 */

#include <utils/utils.h>

#ifndef OID_H_
#define OID_H_

typedef struct {
    u_char octet;
    u_int  next;
    u_int  down;
    u_int  level;
    const u_char *name;
} oid_t;

extern const oid_t oid_names[];

#define OID_UNKNOWN							-1
#define OID_NAME_DISTINGUISHER				6
#define OID_PILOT_USERID					16
#define OID_PILOT_DOMAIN_COMPONENT			17
#define OID_COMMON_NAME						20
#define OID_SURNAME							21
#define OID_SERIAL_NUMBER					22
#define OID_COUNTRY							23
#define OID_LOCALITY						24
#define OID_STATE_OR_PROVINCE				25
#define OID_ORGANIZATION					26
#define OID_ORGANIZATION_UNIT				27
#define OID_TITLE							28
#define OID_DESCRIPTION						29
#define OID_USER_CERTIFICATE				30
#define OID_NAME							31
#define OID_GIVEN_NAME						32
#define OID_INITIALS						33
#define OID_UNIQUE_IDENTIFIER				34
#define OID_DN_QUALIFIER					35
#define OID_ROLE							36
#define OID_SUBJECT_KEY_ID					39
#define OID_KEY_USAGE						40
#define OID_SUBJECT_ALT_NAME				42
#define OID_BASIC_CONSTRAINTS				44
#define OID_CRL_NUMBER						45
#define OID_CRL_REASON_CODE					46
#define OID_DELTA_CRL_INDICATOR				49
#define OID_ISSUING_DIST_POINT				50
#define OID_NAME_CONSTRAINTS				52
#define OID_CRL_DISTRIBUTION_POINTS			53
#define OID_CERTIFICATE_POLICIES			54
#define OID_ANY_POLICY						55
#define OID_POLICY_MAPPINGS					56
#define OID_AUTHORITY_KEY_ID				57
#define OID_POLICY_CONSTRAINTS				58
#define OID_EXTENDED_KEY_USAGE				59
#define OID_FRESHEST_CRL					61
#define OID_INHIBIT_ANY_POLICY				62
#define OID_TARGET_INFORMATION				63
#define OID_NO_REV_AVAIL					64
#define OID_CAMELLIA128_CBC					75
#define OID_CAMELLIA192_CBC					76
#define OID_CAMELLIA256_CBC					77
#define OID_RSA_ENCRYPTION					90
#define OID_MD2_WITH_RSA					91
#define OID_MD5_WITH_RSA					92
#define OID_SHA1_WITH_RSA					93
#define OID_RSAES_OAEP						94
#define OID_SHA256_WITH_RSA					97
#define OID_SHA384_WITH_RSA					98
#define OID_SHA512_WITH_RSA					99
#define OID_SHA224_WITH_RSA					100
#define OID_PBE_MD5_DES_CBC					102
#define OID_PBE_SHA1_DES_CBC				103
#define OID_PBKDF2							104
#define OID_PBES2							105
#define OID_PKCS7_DATA						107
#define OID_PKCS7_SIGNED_DATA				108
#define OID_PKCS7_ENVELOPED_DATA			109
#define OID_PKCS7_SIGNED_ENVELOPED_DATA		110
#define OID_PKCS7_DIGESTED_DATA				111
#define OID_PKCS7_ENCRYPTED_DATA			112
#define OID_EMAIL_ADDRESS					114
#define OID_UNSTRUCTURED_NAME				115
#define OID_PKCS9_CONTENT_TYPE				116
#define OID_PKCS9_MESSAGE_DIGEST			117
#define OID_PKCS9_SIGNING_TIME				118
#define OID_CHALLENGE_PASSWORD				120
#define OID_UNSTRUCTURED_ADDRESS			121
#define OID_EXTENSION_REQUEST				122
#define OID_X509_CERTIFICATE				125
#define OID_PBE_SHA1_RC4_128				129
#define OID_PBE_SHA1_RC4_40					130
#define OID_PBE_SHA1_3DES_CBC				131
#define OID_PBE_SHA1_3DES_2KEY_CBC			132
#define OID_PBE_SHA1_RC2_CBC_128			133
#define OID_PBE_SHA1_RC2_CBC_40				134
#define OID_P12_KEY_BAG						137
#define OID_P12_PKCS8_KEY_BAG				138
#define OID_P12_CERT_BAG					139
#define OID_P12_CRL_BAG						140
#define OID_MD2								144
#define OID_MD5								145
#define OID_3DES_EDE_CBC					147
#define OID_EC_PUBLICKEY					151
#define OID_C2PNB163V1						154
#define OID_C2PNB163V2						155
#define OID_C2PNB163V3						156
#define OID_C2PNB176W1						157
#define OID_C2PNB191V1						158
#define OID_C2PNB191V2						159
#define OID_C2PNB191V3						160
#define OID_C2PNB191V4						161
#define OID_C2PNB191V5						162
#define OID_C2PNB208W1						163
#define OID_C2PNB239V1						164
#define OID_C2PNB239V2						165
#define OID_C2PNB239V3						166
#define OID_C2PNB239V4						167
#define OID_C2PNB239V5						168
#define OID_C2PNB272W1						169
#define OID_C2PNB304W1						170
#define OID_C2PNB359V1						171
#define OID_C2PNB368W1						172
#define OID_C2PNB431R1						173
#define OID_PRIME192V1						175
#define OID_PRIME192V2						176
#define OID_PRIME192V3						177
#define OID_PRIME239V1						178
#define OID_PRIME239V2						179
#define OID_PRIME239V3						180
#define OID_PRIME256V1						181
#define OID_ECDSA_WITH_SHA1					183
#define OID_ECDSA_WITH_SHA224				185
#define OID_ECDSA_WITH_SHA256				186
#define OID_ECDSA_WITH_SHA384				187
#define OID_ECDSA_WITH_SHA512				188
#define OID_MS_SMARTCARD_LOGON				202
#define OID_USER_PRINCIPAL_NAME				203
#define OID_STRONGSWAN						209
#define OID_TCGID							216
#define OID_AUTHORITY_INFO_ACCESS			260
#define OID_IP_ADDR_BLOCKS					262
#define OID_POLICY_QUALIFIER_CPS			264
#define OID_POLICY_QUALIFIER_UNOTICE		265
#define OID_SERVER_AUTH						267
#define OID_CLIENT_AUTH						268
#define OID_OCSP_SIGNING					275
#define OID_XMPP_ADDR						281
#define OID_AUTHENTICATION_INFO				285
#define OID_ACCESS_IDENTITY					286
#define OID_CHARGING_IDENTITY				287
#define OID_GROUP							288
#define OID_OCSP							291
#define OID_BASIC							292
#define OID_NONCE							293
#define OID_CRL								294
#define OID_RESPONSE						295
#define OID_NO_CHECK						296
#define OID_ARCHIVE_CUTOFF					297
#define OID_SERVICE_LOCATOR					298
#define OID_CA_ISSUERS						299
#define OID_IKE_INTERMEDIATE				304
#define OID_DES_CBC							308
#define OID_SHA1							309
#define OID_SHA1_WITH_RSA_OIW				310
#define OID_ECGDSA_PUBKEY					329
#define OID_ECGDSA_SIG_WITH_RIPEMD160		332
#define OID_ECGDSA_SIG_WITH_SHA1			333
#define OID_ECGDSA_SIG_WITH_SHA224			334
#define OID_ECGDSA_SIG_WITH_SHA256			335
#define OID_ECGDSA_SIG_WITH_SHA384			336
#define OID_ECGDSA_SIG_WITH_SHA512			337
#define OID_SECT163K1						360
#define OID_SECT163R1						361
#define OID_SECT239K1						362
#define OID_SECT113R1						363
#define OID_SECT113R2						364
#define OID_SECT112R1						365
#define OID_SECT112R2						366
#define OID_SECT160R1						367
#define OID_SECT160K1						368
#define OID_SECT256K1						369
#define OID_SECT163R2						370
#define OID_SECT283K1						371
#define OID_SECT283R1						372
#define OID_SECT131R1						373
#define OID_SECT131R2						374
#define OID_SECT193R1						375
#define OID_SECT193R2						376
#define OID_SECT233K1						377
#define OID_SECT233R1						378
#define OID_SECT128R1						379
#define OID_SECT128R2						380
#define OID_SECT160R2						381
#define OID_SECT192K1						382
#define OID_SECT224K1						383
#define OID_SECT224R1						384
#define OID_SECT384R1						385
#define OID_SECT521R1						386
#define OID_SECT409K1						387
#define OID_SECT409R1						388
#define OID_SECT571K1						389
#define OID_SECT571R1						390
#define OID_AES128_CBC						399
#define OID_AES128_GCM						400
#define OID_AES128_CCM						401
#define OID_AES192_CBC						402
#define OID_AES192_GCM						403
#define OID_AES192_CCM						404
#define OID_AES256_CBC						405
#define OID_AES256_GCM						406
#define OID_AES256_CCM						407
#define OID_SHA256							409
#define OID_SHA384							410
#define OID_SHA512							411
#define OID_SHA224							412
#define OID_NS_REVOCATION_URL				426
#define OID_NS_CA_REVOCATION_URL			427
#define OID_NS_CA_POLICY_URL				428
#define OID_NS_COMMENT						429
#define OID_EMPLOYEE_NUMBER					432
#define OID_PKI_MESSAGE_TYPE				438
#define OID_PKI_STATUS						439
#define OID_PKI_FAIL_INFO					440
#define OID_PKI_SENDER_NONCE				441
#define OID_PKI_RECIPIENT_NONCE				442
#define OID_PKI_TRANS_ID					443
#define OID_TPM_MANUFACTURER				449
#define OID_TPM_MODEL						450
#define OID_TPM_VERSION						451
#define OID_TPM_ID_LABEL					452

#define OID_MAX								453

#endif /* OID_H_ */
