/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004,2005 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

char *nstrcat(int n, ...) {
	static char *buf = 0;
	const char *arg;
	char *tmp = 0;
	va_list ap;
	int i;

	free(buf);
	buf = strdup("");
	va_start(ap, n);
	for (i = 0; i < n; i++) {
		arg = va_arg(ap, const char *);
		if (!arg || !strlen(arg)) continue;
		tmp = buf;
		buf = (char *)malloc(sizeof(char) * (strlen(tmp) + strlen(arg) + 1));
		strcpy(buf, tmp);
		strcat(buf, arg);
		free(tmp);
	}
	return buf;
}

char *nstrcat_r(int n, ...) {
	char *buf = 0, *tmp = 0;
	const char *arg;
	va_list ap;
	int i;

	buf = strdup("");
	va_start(ap, n);
	for (i = 0; i < n; i++) {
		arg = va_arg(ap, const char *);
		if (!arg || !strlen(arg)) continue;
		tmp = buf;
		buf = (char *)malloc(sizeof(char) * (strlen(tmp) + strlen(arg) + 1));
		strcpy(buf, tmp);
		strcat(buf, arg);
		free(tmp);
	}
	return buf;
}

void ReplaceSpace(char **src) {
	int num = 0, i, j;
	char *dst;
	for(i = 0; i < strlen(*src); i++) {
		if ((*src)[i] == ' ') num++;
	}
	if (!num) return;
	dst = (char *)malloc(sizeof(char) * (strlen(*src) + (num * 2) + 1));
	dst[0] = '\0';
	for (i = 0, j = 0; i <= strlen(*src); i++, j++) {
		if ((*src)[i] == ' ') {
			dst[j] = '%';
			dst[++j] = '2';
			dst[++j] = '0';
		} else {
			dst[j] = (*src)[i];
		}
	}
	free(*src);
	*src = dst;
}
