/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _URL_H
#define _URL_H 1

#include <FL/Fl_Preferences.H>
#include "interface.h"

#define PROGNAME "Strip Club"
#define PROGVERSION "0.7.5"
#define SCVERSION PROGNAME" v"PROGVERSION
#define USERAGENT PROGNAME"/"PROGVERSION

#ifdef WIN32
#	define NOGZIP 1
#	define README "readme.txt"
#	ifndef DEFAULT_BROWSER
#		define DEFAULT_BROWSER "start"
#	endif
#else
#	ifdef NOGZIP
#		define README PREFIX"/share/doc/stripclub/readme.txt"
#	else
#		define README "readme.txt"
#		define ZREADME PREFIX"/share/doc/stripclub/readme.txt.gz"
#	endif
#	ifndef DEFAULT_BROWSER
#		define DEFAULT_BROWSER "mozilla-firefox"
#	endif
#endif

#define TEMPHTML "temp.html"
#define TEMPTXT "temp.txt"

enum eOffType {
	OFFTYPE_OFFLINE = 0,
	OFFTYPE_MISSING,
	OFFTYPE_CHECK
};

typedef struct _URL {
	char *Full;
	char *Protocol;
	char *Host;
	char *Port;	
	char *Path;
	char *FullPath;
	char *File;
	char *Extension;
} sURL;

extern char *CurComic;
extern Fl_Preferences *Prefs, *CurComicG;
extern cInterface Interface;
extern eOffType Offline;
extern sURL *Proxy;

// It seems Windows does not have this function... how odd
#ifndef strndup
inline char *strndup(const char *src, int size) {
	char *dst = (char *)malloc(size + 1);
	strncpy(dst, src, size);
	dst[size] = 0;
	return dst;
}
#endif

inline void clonestr(const char *src, char **dst, int size = 0) {
	if (size) {
		*dst = strndup(src, size);
	} else {
		*dst = strdup(src);
	}
}

inline int strcatlim(char *dst, const char *src, int size) {
	unsigned int left = size - strlen(dst) - 1;	// How much of src we can copy
	if (left < strlen(src)) {
		strncat(dst, src, left);
		return strlen(src) - left;	// Return the amount that didn't get copied
	} else {
		strcat(dst, src);
		return 0;					// Return 0 because we were able to copy it all
	}
}

// Some system headers define these already (notably windef.h)

#ifndef max
inline int max(int a, int b) {
	return (a > b) ? a : b;
}
#endif

#ifndef min
inline int min(int a, int b) {
	return (a < b) ? a : b;
}
#endif

sURL *URLCreate(const char *URL);
char *MakeNewURL(const char *New, sURL *Old);
char *URLUnbreak(sURL *Break);
void URLDelete(sURL *URL);

void SwitchComic(Fl_Widget *w, void *New);

#endif
