/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include <PDFDoc.h>
#include <TextOutputDev.h>
#include <GlobalParams.h>
#include <string>

void
toConsole(void *, char *text, int len) {
    std::string s(text, len);
    printf("%s", s.c_str());
}

int
main(int argc, char** argv) {
    globalParams = new GlobalParams("");

    // open file
    if (argc != 2) {
        delete globalParams;
        return -1;
    }
    FILE* f = fopen(argv[1], "r");
    if (f == 0) {
        delete globalParams;
        return -1;
    }

    // create document object
    Object obj;
    obj.initNull();
    FileStream* fs = new FileStream(f, 0, gFalse, 0, &obj);
    PDFDoc doc(fs);
    if (!doc.isOk()) {
        printf("No pdf file\n");
        fclose(f);
        delete globalParams;
        return -1;
    }

    // get page range
    int firstPage, lastPage;
    firstPage = 1;
    lastPage = doc.getNumPages();

    // get document info
    Object info;
    doc.getDocInfo(&info);
    if (info.isDict()) {
        // figure out how to get metadata
    }
    info.free();

    //TextOutputDev* textOut = new TextOutputDev("out", gFalse, gFalse, gFalse);
    int dummy;
    TextOutputDev* textOut = new TextOutputDev(toConsole, &dummy, gTrue, gTrue);
    if (textOut->isOk()) {
        doc.displayPages(textOut, firstPage, lastPage, 72, 72, 0,
		      gFalse, gTrue, gFalse);
    }
    delete textOut;
    //fclose(f);
    delete globalParams;
    return 0;
}
