# - Try to find the  binding of the libextractor library
# Once done this will define
#
#  LIBEXTRACTOR_FOUND - system has libextractor
#  LIBEXTRACTOR_INCLUDE_DIR - the libextractor include directory
#  LIBEXTRACTOR_LIBRARIES - Link these to use libextractor 
#  LIBEXTRACTOR_DEFINITIONS - Compiler switches required for using libextractor
#

FIND_PATH(LIBEXTRACTOR_INCLUDE_DIR extractor.h
  /usr/include
  /usr/local/include
) 
 
FIND_LIBRARY(LIBEXTRACTOR_LIBRARIES extractor
  /usr/lib
  /usr/local/lib
)
  
if (LIBEXTRACTOR_INCLUDE_DIR AND LIBEXTRACTOR_LIBRARIES)
  set(LIBEXTRACTOR_FOUND TRUE)
else (LIBEXTRACTOR_INCLUDE_DIR AND LIBEXTRACTOR_LIBRARIES)
  set(LIBEXTRACTOR_FOUND FALSE)
endif (LIBEXTRACTOR_INCLUDE_DIR AND LIBEXTRACTOR_LIBRARIES)
  
if (LIBEXTRACTOR_FOUND)
  if (NOT LIBEXTRACTOR_FIND_QUIETLY)
    message(STATUS "Found libextractor: library: ${LIBEXTRACTOR_LIBRARIES}, include path: ${LIBEXTRACTOR_INCLUDE_DIR}")
  endif (NOT LIBEXTRACTOR_FIND_QUIETLY)
else (LIBEXTRACTOR_FOUND)
  if (LIBEXTRACTOR_FIND_REQUIRED)
    message(FATAL_ERROR "Could NOT find libextractor")
  endif (LIBEXTRACTOR_FIND_REQUIRED)
endif (LIBEXTRACTOR_FOUND)
  
MARK_AS_ADVANCED(LIBEXTRACTOR_INCLUDE_DIR LIBEXTRACTOR_LIBRARIES)
