#import <Cocoa/Cocoa.h>

@interface WarController : NSObject
{
    IBOutlet id indicator;
    IBOutlet id window;
	IBOutlet id panel;
	IBOutlet id input;
	IBOutlet id expansionCheck;
	IBOutlet id macCheck;
	int value;
	BOOL running;
}

// Called to setup tool 
- (void)awakeFromNib;

// Called to prepare for tool operation
- (void)applicationDidBecomeActive:(NSNotification *)aNotification;

// Called to run the tool
- (void)expandFrom:(NSString *)dataPath expansion:(BOOL)expansion mac:(BOOL)mac;

// Causes the utility to quit after the user elects to fail in the location panel
- (IBAction)failLocation:(id)sender;

// Causes the utility to search for a path specified by the location panel (and run if path is fine)
- (IBAction)tryLocation:(id)sender;

// Called to inform of the maximum number of calls to progress
- (void)setMaxProgress:(int)max;

// Called to signal progress of tool
- (void)progress;

@end
