/*
Copyright (C) 2000 Liam Girdwood
Copyright (C) 2003 Fabien Chreau

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

Some functions in this file use the VSOP87 solution by
Messrs. Bretagnon and Francou.

*/

#include <math.h>
#include "vsop87.h"
#include "misc_stellplanet.h"

#define LONG_L0 1441
#define LONG_L1 655
#define LONG_L2 259
#define LONG_L3 69
#define LONG_L4 8
#define LAT_B0 311
#define LAT_B1 130
#define LAT_B2 39
#define LAT_B3 15
#define RADIUS_R0 1387
#define RADIUS_R1 625
#define RADIUS_R2 249
#define RADIUS_R3 69
#define RADIUS_R4 12


static const struct vsop uranus_longitude_l0[LONG_L0] = {
    {     5.48129294297,  0.00000000000,        0.00000000000}, 
    {     0.09260408234,  0.89106421507,       74.78159856730}, 
    {     0.01504247898,  3.62719260920,        1.48447270830}, 
    {     0.00365981674,  1.89962179044,       73.29712585900}, 
    {     0.00272328168,  3.35823706307,      149.56319713460}, 
    {     0.00070328461,  5.39254450063,       63.73589830340}, 
    {     0.00068892678,  6.09292483287,       76.26607127560}, 
    {     0.00061998615,  2.26952066061,        2.96894541660}, 
    {     0.00061950719,  2.85098872691,       11.04570026390}, 
    {     0.00026468770,  3.14152083966,       71.81265315070}, 
    {     0.00025710476,  6.11379840493,      454.90936652730}, 
    {     0.00021078850,  4.36059339067,      148.07872442630}, 
    {     0.00017818647,  1.74436930289,       36.64856292950}, 
    {     0.00014613507,  4.73732166022,        3.93215326310}, 
    {     0.00011162509,  5.82681796350,      224.34479570190}, 
    {     0.00010997910,  0.48865004018,      138.51749687070}, 
    {     0.00009527478,  2.95516862826,       35.16409022120}, 
    {     0.00007545601,  5.23626582400,      109.94568878850}, 
    {     0.00004220241,  3.23328220918,       70.84944530420}, 
    {     0.00004051900,  2.27755017300,      151.04766984290}, 
    {     0.00003354596,  1.06549007380,        4.45341812490}, 
    {     0.00002926718,  4.62903718891,        9.56122755560}, 
    {     0.00003490340,  5.48306144511,      146.59425171800}, 
    {     0.00003144069,  4.75199570434,       77.75054398390}, 
    {     0.00002922333,  5.35235361027,       85.82729883120}, 
    {     0.00002272788,  4.36600400036,       70.32818044240}, 
    {     0.00002051219,  1.51773566586,        0.11187458460}, 
    {     0.00002148602,  0.60745949945,       38.13303563780}, 
    {     0.00001991643,  4.92437588682,      277.03499374140}, 
    {     0.00001376226,  2.04283539351,       65.22037101170}, 
    {     0.00001666902,  3.62744066769,      380.12776796000}, 
    {     0.00001284107,  3.11347961505,      202.25339517410}, 
    {     0.00001150429,  0.93343589092,        3.18139373770}, 
    {     0.00001533221,  2.58594681212,       52.69019803950}, 
    {     0.00001281604,  0.54271272721,      222.86032299360}, 
    {     0.00001372139,  4.19641530878,      111.43016149680}, 
    {     0.00001221029,  0.19900650030,      108.46121608020}, 
    {     0.00000946181,  1.19253165736,      127.47179660680}, 
    {     0.00001150989,  4.17898916639,       33.67961751290}, 
    {     0.00001244347,  0.91614441731,        2.44768055480}, 
    {     0.00001072013,  0.23566016888,       62.25142559510}, 
    {     0.00001090463,  1.77501500531,       12.53017297220}, 
    {     0.00000707935,  5.18291670033,      213.29909543800}, 
    {     0.00000653376,  0.96587864431,       78.71375183040}, 
    {     0.00000627570,  0.18209040157,      984.60033162190}, 
    {     0.00000524485,  2.01275350435,      299.12639426920}, 
    {     0.00000559396,  3.35768635981,        0.52126486180}, 
    {     0.00000606847,  5.43209889250,      529.69096509460}, 
    {     0.00000404897,  5.98690517582,        8.07675484730}, 
    {     0.00000467183,  0.41482520325,      145.10977900970}, 
    {     0.00000471311,  1.40661608158,      184.72728735580}, 
    {     0.00000483226,  2.10553218341,        0.96320784650}, 
    {     0.00000395569,  5.87037914022,      351.81659230870}, 
    {     0.00000433527,  5.52141037763,      183.24281464750}, 
    {     0.00000309843,  5.83301863492,      145.63104387150}, 
    {     0.00000378642,  2.34989391811,       56.62235130260}, 
    {     0.00000399033,  0.33796522578,      415.55249061210}, 
    {     0.00000300392,  5.64355207373,       22.09140052780}, 
    {     0.00000249230,  4.74621772167,      225.82926841020}, 
    {     0.00000239311,  2.35072447972,      137.03302416240}, 
    {     0.00000294103,  5.83919833199,       39.61750834610}, 
    {     0.00000216450,  4.77807782477,      340.77089204480}, 
    {     0.00000251784,  1.63692846797,      221.37585028530}, 
    {     0.00000219624,  1.92233630317,       67.66805156650}, 
    {     0.00000202019,  1.29693040688,        0.04818410980}, 
    {     0.00000224105,  0.51589500446,       84.34282612290}, 
    {     0.00000216563,  6.14217553245,        5.93789083320}, 
    {     0.00000222605,  2.84314245655,        0.26063243090}, 
    {     0.00000207907,  5.58012637880,       68.84370773410}, 
    {     0.00000187520,  1.31927606520,        0.16005869440}, 
    {     0.00000199306,  0.95648612651,      152.53214255120}, 
    {     0.00000158075,  0.73795262538,       54.17467074780}, 
    {     0.00000168606,  5.87865394974,       18.15924726470}, 
    {     0.00000170326,  3.67712574811,        5.41662597140}, 
    {     0.00000193647,  1.88800957346,      456.39383923560}, 
    {     0.00000193051,  0.91616617785,      453.42489381900}, 
    {     0.00000181991,  3.53625031273,       79.23501669220}, 
    {     0.00000173102,  1.53869634445,      160.60889739850}, 
    {     0.00000164483,  1.42390725018,      106.97674337190}, 
    {     0.00000171940,  5.67948631369,      219.89137757700}, 
    {     0.00000162805,  3.05027759814,      112.91463420510}, 
    {     0.00000146659,  1.26296726443,       59.80374504030}, 
    {     0.00000139276,  5.38697273752,       32.19514480460}, 
    {     0.00000138636,  4.25998533357,      909.81873305460}, 
    {     0.00000143058,  1.29980453870,       35.42472265210}, 
    {     0.00000123986,  1.37489956563,        7.11354700080}, 
    {     0.00000104582,  5.02793726187,        0.75075952540}, 
    {     0.00000103295,  0.68145096277,       14.97785352700}, 
    {     0.00000094957,  0.90678215577,       74.66972398270}, 
    {     0.00000082948,  2.92800368384,      265.98929347750}, 
    {     0.00000110403,  2.02666475709,      554.06998748280}, 
    {     0.00000094433,  3.94271122207,       74.89347315190}, 
    {     0.00000080072,  1.01583506701,        6.59228213900}, 
    {     0.00000109576,  5.70572405893,       77.96299230500}, 
    {     0.00000085946,  1.70581556772,       82.85835341460}, 
    {     0.00000103799,  1.45794315266,       24.37902238820}, 
    {     0.00000074661,  4.63178804642,       69.36497259590}, 
    {     0.00000079813,  3.00965058125,      297.64192156090}, 
    {     0.00000084490,  0.36886722094,      186.21176006410}, 
    {     0.00000088657,  0.52498114072,      181.75834193920}, 
    {     0.00000070368,  1.18984702891,       66.70484372000}, 
    {     0.00000069971,  0.87463619381,      305.34616939270}, 
    {     0.00000070082,  3.75845990682,      131.40394986990}, 
    {     0.00000084350,  5.88592009032,      256.53994050650}, 
    {     0.00000074493,  6.24238684280,      447.79581952650}, 
    {     0.00000062454,  0.16868402018,      479.28838891550}, 
    {     0.00000072904,  2.84891153624,      462.02291352810}, 
    {     0.00000069205,  4.43939850837,       39.35687591520}, 
    {     0.00000076729,  4.58716659215,        6.21977512350}, 
    {     0.00000073423,  4.27591432865,       87.31177153950}, 
    {     0.00000055577,  1.49804110443,       71.60020482960}, 
    {     0.00000057315,  1.63007488533,      143.62530630140}, 
    {     0.00000061674,  3.18616775231,       77.22927912210}, 
    {     0.00000057668,  3.67128264895,       51.20572533120}, 
    {     0.00000050352,  1.12355398826,       20.60692781950}, 
    {     0.00000053720,  5.51853172042,      128.95626931510}, 
    {     0.00000057895,  2.66869216910,      381.61224066830}, 
    {     0.00000058089,  1.58635213310,       60.76695288680}, 
    {     0.00000045390,  0.48027056949,       14.01464568050}, 
    {     0.00000037513,  6.06768205316,      211.81462272970}, 
    {     0.00000038565,  3.43547372715,      153.49535039770}, 
    {     0.00000046085,  4.36220351003,       75.74480641380}, 
    {     0.00000040220,  4.57551863155,       46.20979048510}, 
    {     0.00000034314,  2.93858938870,      140.00196957900}, 
    {     0.00000038754,  5.59046474201,       99.16062095550}, 
    {     0.00000034864,  1.02877681340,      203.73786788240}, 
    {     0.00000040016,  0.69893479575,      218.40690486870}, 
    {     0.00000032562,  4.21895389367,      200.76892246580}, 
    {     0.00000031889,  5.50965372046,       72.33391801250}, 
    {     0.00000041668,  3.82449219367,       81.00137369080}, 
    {     0.00000034668,  0.39221757952,        1.37259812370}, 
    {     0.00000039741,  6.05490168728,      293.18850343600}, 
    {     0.00000027545,  2.18754130148,      125.98732389850}, 
    {     0.00000036328,  1.66621808766,      258.02441321480}, 
    {     0.00000035508,  1.96672429313,      835.03713448730}, 
    {     0.00000035373,  3.72274050162,      692.58748435350}, 
    {     0.00000027364,  2.10315692995,      209.36694217490}, 
    {     0.00000026442,  4.48298644364,      373.90799283650}, 
    {     0.00000034517,  1.08687838842,      191.20769491020}, 
    {     0.00000026317,  3.63357788040,      490.33408917940}, 
    {     0.00000029888,  3.87365011384,      259.50888592310}, 
    {     0.00000025926,  0.54378574725,       41.64449777560}, 
    {     0.00000027110,  0.00478270361,       28.57180808220}, 
    {     0.00000026313,  5.81236674192,       75.30286342910}, 
    {     0.00000034277,  6.05545630018,      275.55052103310}, 
    {     0.00000024315,  3.18651202042,       81.37388070630}, 
    {     0.00000029936,  1.88789030410,      269.92144674060}, 
    {     0.00000026242,  6.20368166778,      134.58534360760}, 
    {     0.00000022842,  0.92857008471,      288.08069400530}, 
    {     0.00000025216,  5.43032747843,      116.42609634290}, 
    {     0.00000027063,  4.75299776159,       41.10198105440}, 
    {     0.00000022706,  0.53057453120,     1514.29129671650}, 
    {     0.00000026480,  4.77161377188,      284.14854074220}, 
    {     0.00000021950,  4.59091247537,      404.50679034820}, 
    {     0.00000022022,  1.84418065243,      617.80588578620}, 
    {     0.00000024811,  4.70901440561,      378.64329525170}, 
    {     0.00000029040,  0.17160028536,      528.20649238630}, 
    {     0.00000020487,  0.10247779138,      195.13984817330}, 
    {     0.00000020726,  5.62240737217,       55.65914345610}, 
    {     0.00000025919,  0.74700144605,      278.51946644970}, 
    {     0.00000022824,  3.58334799786,        1.59634729290}, 
    {     0.00000021855,  0.05691568897,      173.94221952280}, 
    {     0.00000019045,  2.30354999303,        5.10780943070}, 
    {     0.00000020831,  2.64115582292,      105.49227066360}, 
    {     0.00000021849,  5.87274563981,       45.57665103870}, 
    {     0.00000021075,  1.98176191313,      114.39910691340}, 
    {     0.00000019306,  2.84240229356,      159.12442469020}, 
    {     0.00000019062,  0.50604571692,       67.35923502580}, 
    {     0.00000020431,  3.77538635518,      135.54855145410}, 
    {     0.00000017322,  4.47827838578,      120.35824960600}, 
    {     0.00000020581,  0.88703968592,      255.05546779820}, 
    {     0.00000019339,  1.48569403160,        0.89377187730}, 
    {     0.00000021333,  2.74458777210,       28.31117565130}, 
    {     0.00000017629,  4.09292272552,      296.15744885260}, 
    {     0.00000015918,  3.94524461273,       17.52610781830}, 
    {     0.00000015556,  0.92841352827,      300.61086697750}, 
    {     0.00000016443,  0.30879187235,       30.71067209630}, 
    {     0.00000015248,  4.93045860155,        7.42236354150}, 
    {     0.00000019300,  6.21959323869,      329.83706636550}, 
    {     0.00000013876,  0.56084534056,      144.14657116320}, 
    {     0.00000016198,  2.30318612128,      344.70304530790}, 
    {     0.00000016033,  0.19604773155,      103.09277421860}, 
    {     0.00000014368,  2.57751058848,      230.56457082540}, 
    {     0.00000016807,  4.93620648940,      565.11568774670}, 
    {     0.00000017121,  1.82016259921,      294.67297614430}, 
    {     0.00000016827,  0.27566510604,       73.81839072080}, 
    {     0.00000015455,  1.91556741732,       96.87299909510}, 
    {     0.00000015814,  3.86318315976,       98.89998852460}, 
    {     0.00000011923,  6.17587234615,       44.72531777680}, 
    {     0.00000012446,  6.22466345410,       80.19822453870}, 
    {     0.00000013001,  1.99483872260,       27.08733537390}, 
    {     0.00000013180,  3.43753711704,      227.31374111850}, 
    {     0.00000011678,  4.31505860166,      426.59819087600}, 
    {     0.00000014374,  5.78359439943,     1059.38193018920}, 
    {     0.00000015879,  0.98454960135,     6208.29425142410}, 
    {     0.00000011511,  2.55846980442,       19.12245511120}, 
    {     0.00000011193,  1.74548073119,      220.41264243880}, 
    {     0.00000011981,  5.84355465210,       13.33332212430}, 
    {     0.00000013333,  5.39450805857,      391.17346822390}, 
    {     0.00000012322,  4.57477369077,       23.57587323610}, 
    {     0.00000012847,  1.77354298387,      180.27386923090}, 
    {     0.00000011629,  4.29071404978,      142.44965013380}, 
    {     0.00000012214,  2.44698830848,      100.38446123290}, 
    {     0.00000012439,  2.32661007670,       80.71948940050}, 
    {     0.00000009770,  0.39792836846,        7.86430652620}, 
    {     0.00000013165,  2.74113201454,      177.87437278590}, 
    {     0.00000012265,  5.42816045200,      831.10498122420}, 
    {     0.00000010264,  5.90199222998,       74.52096613640}, 
    {     0.00000009317,  3.75869700707,       74.82978267710}, 
    {     0.00000012284,  5.52145313445,       74.26033370550}, 
    {     0.00000010682,  4.00694729802,      235.39049596580}, 
    {     0.00000009243,  5.38488037675,       20.44686912510}, 
    {     0.00000009458,  2.60118467048,       92.30770638560}, 
    {     0.00000009317,  1.16483658243,       74.73341445750}, 
    {     0.00000010786,  1.88993609169,      241.61027108930}, 
    {     0.00000010597,  5.50467173303,      187.69623277240}, 
    {     0.00000012035,  6.02036249862,      154.01661525950}, 
    {     0.00000009129,  1.15458738606,        0.63313944640}, 
    {     0.00000011708,  6.25765865911,      155.78297225810}, 
    {     0.00000012186,  5.79479693025,     1364.72809958190}, 
    {     0.00000010992,  5.76674596450,      628.85158605010}, 
    {     0.00000008531,  5.17918037530,        1.64453140270}, 
    {     0.00000008662,  3.78046237096,       74.94165726170}, 
    {     0.00000011225,  1.30868548209,      604.47256366190}, 
    {     0.00000010540,  1.05897224519,      291.70403072770}, 
    {     0.00000008443,  3.52060391248,      756.32338265690}, 
    {     0.00000010290,  5.30499384790,       75.04223099820}, 
    {     0.00000009591,  1.64200163871,       24.11838995730}, 
    {     0.00000008020,  6.24545313293,      543.02428721890}, 
    {     0.00000007796,  5.23505740309,       58.10682401090}, 
    {     0.00000008649,  1.14271989382,       74.62153987290}, 
    {     0.00000007793,  4.00212500951,       31.49256938900}, 
    {     0.00000008915,  3.63129999542,      408.43894361130}, 
    {     0.00000007195,  4.24369275612,      110.20632121940}, 
    {     0.00000009545,  2.00926809412,      331.32153907380}, 
    {     0.00000008786,  2.25836637388,      451.94042111070}, 
    {     0.00000009768,  0.10232823685,      366.48562929500}, 
    {     0.00000009075,  1.63090160034,      443.86366626340}, 
    {     0.00000007255,  4.35305855248,       88.11492069160}, 
    {     0.00000009482,  1.43114303369,      414.06801790380}, 
    {     0.00000007645,  0.62076955028,       50.40257617910}, 
    {     0.00000006836,  5.12192858785,        0.80314915210}, 
    {     0.00000006899,  5.86240754958,      339.28641933650}, 
    {     0.00000008125,  0.45159535895,       25.60286266560}, 
    {     0.00000006488,  6.03171366016,        1.22384027740}, 
    {     0.00000009108,  2.41055572869,    10138.50394764370}, 
    {     0.00000008139,  0.21930359866,      422.66603761290}, 
    {     0.00000007164,  4.00283046264,      157.63995198190}, 
    {     0.00000006393,  4.47880072523,       79.88940799800}, 
    {     0.00000008039,  2.10161085530,       92.94084583200}, 
    {     0.00000006773,  1.38798529262,       16.67477455640}, 
    {     0.00000006816,  2.84724339946,      142.14083359310}, 
    {     0.00000007788,  5.86998158412,      760.25553592000}, 
    {     0.00000008380,  2.33770107198,      417.03696332040}, 
    {     0.00000007928,  3.41948324447,        7.70424783180}, 
    {     0.00000007235,  0.50521045386,      457.87831194390}, 
    {     0.00000007143,  5.57879993926,        4.73530241520}, 
    {     0.00000007379,  0.47767694338,       68.18931642830}, 
    {     0.00000006403,  3.88657131997,       74.03083904190}, 
    {     0.00000006101,  1.65240727244,      350.33211960040}, 
    {     0.00000006820,  6.15375544111,       67.88049988760}, 
    {     0.00000005994,  2.36087653120,        2.00573757010}, 
    {     0.00000006008,  5.46469064027,       48.75804477640}, 
    {     0.00000007020,  0.13804863634,      306.83064210100}, 
    {     0.00000005720,  1.49555002206,      206.18554843720}, 
    {     0.00000006862,  1.08055101709,      465.95506679120}, 
    {     0.00000006413,  5.07420793721,        4.66586644600}, 
    {     0.00000007804,  3.98873608283,        3.62333672240}, 
    {     0.00000005530,  5.57878118094,        2.92076130680}, 
    {     0.00000005519,  3.38213279322,      149.45132255000}, 
    {     0.00000006111,  1.95407755561,      216.92243216040}, 
    {     0.00000006580,  2.70993826910,      329.72519178090}, 
    {     0.00000005835,  3.99897551776,      347.88443904560}, 
    {     0.00000005112,  2.42454049536,      342.25536475310}, 
    {     0.00000005533,  2.83342316665,      260.99335863140}, 
    {     0.00000005727,  0.49154098031,        0.37250701550}, 
    {     0.00000005395,  2.78483514026,       13.49338081870}, 
    {     0.00000006024,  4.78785737004,      558.00214074590}, 
    {     0.00000004903,  1.76924594442,      333.65734504400}, 
    {     0.00000005381,  5.71120333625,        1.69692102940}, 
    {     0.00000005389,  2.94075276200,        9.40116886120}, 
    {     0.00000005042,  5.47678294897,      372.42352012820}, 
    {     0.00000005093,  3.43101132912,      518.64526483070}, 
    {     0.00000004766,  5.34829276989,       61.28821774860}, 
    {     0.00000005655,  3.30309284254,        0.65439130580}, 
    {     0.00000005566,  0.44947190504,      162.09337010680}, 
    {     0.00000005834,  3.46697149482,       55.13787859430}, 
    {     0.00000005656,  1.23594821626,      328.35259365720}, 
    {     0.00000005071,  5.42033083225,      977.48678462110}, 
    {     0.00000005719,  0.66730329426,       92.04707395470}, 
    {     0.00000005283,  2.42272151430,       58.31927233200}, 
    {     0.00000005613,  2.36101054919,        6.90109867970}, 
    {     0.00000004853,  1.27093959120,      983.11585891360}, 
    {     0.00000005512,  0.13294006611,      149.67507171920}, 
    {     0.00000004693,  1.85511154338,      119.50691634410}, 
    {     0.00000004307,  4.18173079985,       90.82323367730}, 
    {     0.00000005957,  1.73124132593,      152.74459087230}, 
    {     0.00000005675,  5.53546214308,     1087.69310584050}, 
    {     0.00000004562,  3.26460078185,       89.75945209430}, 
    {     0.00000005594,  5.75194360195,      358.93013930950}, 
    {     0.00000004689,  5.01733767973,       43.12897048390}, 
    {     0.00000004424,  0.97724627015,        4.19278569400}, 
    {     0.00000004012,  1.08246444514,       75.53235809270}, 
    {     0.00000005623,  1.10387378290,       66.91729204110}, 
    {     0.00000004048,  1.94074496693,       17.26547538740}, 
    {     0.00000004768,  2.24189462905,      986.08480433020}, 
    {     0.00000005213,  1.36495122038,      767.36908292080}, 
    {     0.00000004922,  0.13742479140,        0.85133326190}, 
    {     0.00000004342,  5.33545538316,      152.01087768940}, 
    {     0.00000003918,  3.85162186106,        2.28762186040}, 
    {     0.00000003931,  1.70191687660,        5.62907429250}, 
    {     0.00000004658,  0.93863607366,      267.47376618580}, 
    {     0.00000003895,  5.87672991487,       16.46232623530}, 
    {     0.00000005176,  3.40869435646,     1289.94650101460}, 
    {     0.00000004628,  5.42648205428,       16.04163511000}, 
    {     0.00000005039,  2.16699952281,      367.97010200330}, 
    {     0.00000003775,  0.59927848906,      210.33015002140}, 
    {     0.00000005015,  0.26807931893,      403.13419222450}, 
    {     0.00000004535,  2.90035619661,       59.28248017850}, 
    {     0.00000004571,  0.85791209853,      969.62247809490}, 
    {     0.00000004201,  5.12033927784,       19.01058052660}, 
    {     0.00000004700,  4.17550908523,      130.44074202340}, 
    {     0.00000003694,  0.75965712567,      114.13847448250}, 
    {     0.00000003794,  4.59731406975,       25.86349509650}, 
    {     0.00000004019,  4.98465691172,       30.05628079050}, 
    {     0.00000004735,  3.76713441227,      373.01422095920}, 
    {     0.00000003635,  3.20392753847,      991.71387862270}, 
    {     0.00000004021,  0.47038124299,      387.24131496080}, 
    {     0.00000003443,  5.20975249527,      894.84087952760}, 
    {     0.00000003304,  2.01134489744,      286.59622129700}, 
    {     0.00000003315,  3.98568908785,      264.50482076920}, 
    {     0.00000003280,  5.46909245799,      192.69216761850}, 
    {     0.00000004481,  6.15510814040,      173.68158709190}, 
    {     0.00000003302,  1.63115447974,      681.54178408960}, 
    {     0.00000003193,  3.96514676020,      146.38180339690}, 
    {     0.00000004000,  1.40741532794,      383.09671337660}, 
    {     0.00000003523,  5.19259518595,       97.41551581630}, 
    {     0.00000003844,  3.60271287642,        0.59070083100}, 
    {     0.00000003183,  4.15987875012,       76.47851959670}, 
    {     0.00000003122,  4.50195163590,     1439.50969814920}, 
    {     0.00000003238,  1.64548946107,      214.78356814630}, 
    {     0.00000003543,  4.15778489389,       68.56182344380}, 
    {     0.00000002950,  2.95792688293,      120.99138905240}, 
    {     0.00000002904,  3.69931078718,      874.39401040250}, 
    {     0.00000003292,  2.14601654518,      253.57099508990}, 
    {     0.00000003225,  2.56298661136,       60.55450456570}, 
    {     0.00000003071,  3.57595003388,      117.91056905120}, 
    {     0.00000003237,  4.80214981899,       19.64371997300}, 
    {     0.00000002780,  0.65215559196,       42.53826965290}, 
    {     0.00000003240,  5.31726675118,      546.95644048200}, 
    {     0.00000003657,  5.89905956226,       16.15350969460}, 
    {     0.00000003547,  2.76324444984,       82.48584639910}, 
    {     0.00000003556,  4.68368769233,      593.42686339800}, 
    {     0.00000003342,  1.56467995408,      312.45971639350}, 
    {     0.00000003437,  4.95814102027,       49.72125262290}, 
    {     0.00000003593,  2.52079368833,       22.89454967990}, 
    {     0.00000002672,  2.41694469728,       29.20494752860}, 
    {     0.00000002899,  3.48228574147,       95.38852638680}, 
    {     0.00000003102,  1.42591645035,       17.63798240290}, 
    {     0.00000003341,  2.64162643824,      771.30123618390}, 
    {     0.00000002547,  6.10642153796,      455.87257437380}, 
    {     0.00000002680,  1.16873928613,      477.80391620720}, 
    {     0.00000003335,  3.01819753318,       88.79624424780}, 
    {     0.00000003356,  3.09879595032,      552.58551477450}, 
    {     0.00000002947,  0.32015414114,      150.52640498110}, 
    {     0.00000002678,  1.42841144096,        1.11196569280}, 
    {     0.00000002540,  1.94053883528,        6.48040755440}, 
    {     0.00000002953,  4.59498573141,      167.08930495290}, 
    {     0.00000002746,  1.93558791594,       73.18525127440}, 
    {     0.00000002491,  2.97226347553,      453.94615868080}, 
    {     0.00000003051,  1.91972740209,      561.18353448360}, 
    {     0.00000002999,  1.37948475539,      365.00115658670}, 
    {     0.00000002491,  5.45961727666,       66.18357885820}, 
    {     0.00000002845,  1.23683883276,       32.24332891440}, 
    {     0.00000002318,  1.14709996164,       43.24084506850}, 
    {     0.00000002591,  1.46851525197,       33.13710079170}, 
    {     0.00000003188,  4.01290993082,      555.55446019110}, 
    {     0.00000002341,  5.87022529526,      228.27694896500}, 
    {     0.00000002507,  3.85921708605,      104.00779795530}, 
    {     0.00000002825,  1.55599717119,      353.30106501700}, 
    {     0.00000002823,  3.60128149001,       42.58645376270}, 
    {     0.00000002911,  5.22123493517,       73.40900044360}, 
    {     0.00000002269,  3.31411348054,        4.14460158420}, 
    {     0.00000002243,  2.66541975581,       70.11573212130}, 
    {     0.00000002253,  4.08061547423,      123.53964334370}, 
    {     0.00000002576,  2.38332773848,      100.64509366380}, 
    {     0.00000002868,  6.16611201949,      101.86893394120}, 
    {     0.00000002760,  5.71757499554,       43.28902917830}, 
    {     0.00000002847,  0.54976679257,       20.49505323490}, 
    {     0.00000002944,  2.79704642392,      418.26080359780}, 
    {     0.00000002155,  4.04509548705,       47.06112374700}, 
    {     0.00000002825,  1.90768435934,      273.10284047830}, 
    {     0.00000002529,  4.12564642359,      332.80601178210}, 
    {     0.00000002797,  2.32758928903,      404.61866493280}, 
    {     0.00000002040,  2.01870191041,      316.39186965660}, 
    {     0.00000002525,  3.11718333411,      905.88657979150}, 
    {     0.00000002021,  5.48821446741,       47.69426319340}, 
    {     0.00000002170,  4.46196560050,        2.70831298570}, 
    {     0.00000002399,  3.78849518280,       75.58474771940}, 
    {     0.00000002746,  4.82558024832,        6.85291456990}, 
    {     0.00000002471,  3.46241291144,        8.59801970910}, 
    {     0.00000001980,  3.45572736554,      472.17484191470}, 
    {     0.00000001968,  5.79683846128,       11.15757484850}, 
    {     0.00000001976,  5.43505814122,      199.28444975750}, 
    {     0.00000002285,  2.79572464474,       22.63391724900}, 
    {     0.00000001913,  0.27742491783,       69.15252427480}, 
    {     0.00000002663,  5.43112910549,     3265.83082813250}, 
    {     0.00000002604,  0.43662049730,      439.78275515400}, 
    {     0.00000002058,  1.69376068077,       65.87476231750}, 
    {     0.00000002121,  2.00288263601,      106.01353552540}, 
    {     0.00000002217,  0.97212356159,       39.09624348430}, 
    {     0.00000002003,  1.49825259375,       29.22619938800}, 
    {     0.00000002225,  4.36334040085,      468.24268865160}, 
    {     0.00000002057,  0.06201487399,      205.22234059070}, 
    {     0.00000002086,  0.44287700052,       10.29494073850}, 
    {     0.00000001924,  0.83899941456,      254.94359321360}, 
    {     0.00000001770,  4.32048805830,        0.45757438700}, 
    {     0.00000001973,  6.05836685033,       78.40493528970}, 
    {     0.00000001852,  6.19975101768,      258.87574647670}, 
    {     0.00000002095,  5.80179588658,      486.40193591630}, 
    {     0.00000002207,  5.18886333203,      134.06407874580}, 
    {     0.00000002085,  5.35829244404,      908.33426034630}, 
    {     0.00000001887,  6.20764466965,      198.32124191100}, 
    {     0.00000002147,  1.40526642648,      526.72201967800}, 
    {     0.00000002085,  2.55047290838,       49.50880430180}, 
    {     0.00000001634,  3.36868035546,      118.02244363580}, 
    {     0.00000001729,  1.99202140996,       77.06922042770}, 
    {     0.00000001772,  0.04590477856,      334.29048449040}, 
    {     0.00000001844,  2.97451465787,      178.78939652260}, 
    {     0.00000001730,  2.01735784062,      142.66209845490}, 
    {     0.00000001597,  1.60733571281,       40.16002506730}, 
    {     0.00000001602,  5.65898626013,      175.16605980020}, 
    {     0.00000001668,  1.53361997245,        0.83008140250}, 
    {     0.00000001768,  4.72713891115,       32.71640966640}, 
    {     0.00000001731,  5.53331362694,       15.49911838880}, 
    {     0.00000001756,  5.57550298818,      522.57741809380}, 
    {     0.00000001762,  2.61456701609,      166.82867252200}, 
    {     0.00000001558,  3.43776574559,      124.50285119020}, 
    {     0.00000001785,  2.31713014156,      290.21955801940}, 
    {     0.00000001878,  1.08799780926,      274.06604832480}, 
    {     0.00000001530,  3.28602877385,      820.05928096030}, 
    {     0.00000001540,  6.11183693327,      165.60483224460}, 
    {     0.00000001503,  1.88793984015,      303.86169668440}, 
    {     0.00000001637,  0.10818716175,       72.77586099720}, 
    {     0.00000001497,  2.01776960009,      150.08446199640}, 
    {     0.00000001575,  5.25534001318,      233.90602325750}, 
    {     0.00000001469,  0.61918308468,     1033.35837639830}, 
    {     0.00000001904,  6.25182084377,      162.89651925890}, 
    {     0.00000001398,  3.41567259878,        4.99593484610}, 
    {     0.00000001696,  2.11496406243,      189.72322220190}, 
    {     0.00000001641,  0.88245154254,      115.88357962170}, 
    {     0.00000001924,  0.91450801831,     1819.63746610920}, 
    {     0.00000001707,  2.55772668001,     1108.13997496560}, 
    {     0.00000001338,  3.17269412566,      362.86229257260}, 
    {     0.00000001430,  3.73352970530,        8.90683624980}, 
    {     0.00000001342,  2.84242222704,       55.77101804070}, 
    {     0.00000001366,  4.00103358750,      103.35340664950}, 
    {     0.00000001606,  6.02754119794,       31.23193695810}, 
    {     0.00000001693,  1.52609075769,      401.64971951620}, 
    {     0.00000001451,  5.63277890051,      129.91947716160}, 
    {     0.00000001390,  0.22627586528,      370.93904741990}, 
    {     0.00000001300,  0.19222551672,       81.89514556810}, 
    {     0.00000001280,  0.62174224381,      448.68959140380}, 
    {     0.00000001290,  2.77107833656,       63.62402371880}, 
    {     0.00000001712,  2.16788442139,      536.80451209540}, 
    {     0.00000001694,  2.49962791661,      441.26722786230}, 
    {     0.00000001644,  2.41311982961,       10.08249241740}, 
    {     0.00000001668,  5.00711095329,       79.51690098250}, 
    {     0.00000001629,  5.55917656506,      344.96367773880}, 
    {     0.00000001345,  4.42619970902,      189.18070548070}, 
    {     0.00000001252,  5.92300780390,       57.14361616440}, 
    {     0.00000001176,  1.63172838154,       84.18276742850}, 
    {     0.00000001322,  0.24854997323,      114.94162363460}, 
    {     0.00000001647,  0.00195946885,      491.55792945680}, 
    {     0.00000001383,  5.72955320309,       89.33876096900}, 
    {     0.00000001421,  4.26035410510,      369.45457471160}, 
    {     0.00000001287,  0.99537181009,       14.66903698630}, 
    {     0.00000001412,  5.18998440411,      113.87784205160}, 
    {     0.00000001113,  5.54145519770,      403.02231763990}, 
    {     0.00000001484,  1.03508883775,     1215.16490244730}, 
    {     0.00000001391,  1.49396068486,       14.22709400160}, 
    {     0.00000001202,  3.60264192173,      480.77286162380}, 
    {     0.00000001113,  4.80418427391,        9.44935297100}, 
    {     0.00000001428,  1.57155860246,      419.74527630610}, 
    {     0.00000001311,  2.99755331991,      458.84151979040}, 
    {     0.00000001438,  6.10376597618,       64.69910614990}, 
    {     0.00000001074,  3.16426816293,       54.33472944220}, 
    {     0.00000001387,  2.78485990518,       26.02355379090}, 
    {     0.00000001203,  0.20627563214,        0.56944897160}, 
    {     0.00000001347,  5.57876007696,       95.22846769240}, 
    {     0.00000001388,  1.66409814967,      240.38643081190}, 
    {     0.00000001269,  2.37681963075,       37.87240320690}, 
    {     0.00000001011,  2.76310774823,       80.41067285980}, 
    {     0.00000001003,  2.79269932952,      218.92816973050}, 
    {     0.00000001004,  1.15611283525,      384.05992122310}, 
    {     0.00000001009,  2.43209796832,      154.97982310600}, 
    {     0.00000001326,  0.99157908827,      483.22054217860}, 
    {     0.00000001339,  0.58791307654,      476.43131808350}, 
    {     0.00000000989,  3.31666847329,       18.91000679010}, 
    {     0.00000001070,  2.82291623041,      616.32141307790}, 
    {     0.00000001257,  1.51721661185,      280.96714700450}, 
    {     0.00000001219,  3.62982970433,      106.27416795630}, 
    {     0.00000001276,  4.73464701935,      691.10301164520}, 
    {     0.00000001146,  4.85249483698,     1044.40407666220}, 
    {     0.00000001124,  2.46295455688,      326.86812094890}, 
    {     0.00000000980,  6.04026702553,        5.46901559810}, 
    {     0.00000001230,  0.61713965835,      237.67811782620}, 
    {     0.00000000922,  0.36432013348,       10.93382567930}, 
    {     0.00000001227,  5.83120102521,       63.84777288800}, 
    {     0.00000000918,  3.41111361461,      375.39246554480}, 
    {     0.00000001262,  5.69321383311,      694.07195706180}, 
    {     0.00000001037,  5.92126063748,        4.82592514040}, 
    {     0.00000001148,  5.35062584493,      369.08206769610}, 
    {     0.00000001020,  2.45414816467,      147.11551657980}, 
    {     0.00000001217,  3.63858890321,      699.70103135430}, 
    {     0.00000000960,  4.78383473840,       93.90405367850}, 
    {     0.00000000993,  3.39918521663,       10.78506783300}, 
    {     0.00000000879,  3.42965236315,        3.08082000120}, 
    {     0.00000001109,  4.80576232812,     6133.51265285680}, 
    {     0.00000001004,  3.13174510948,      215.43795945210}, 
    {     0.00000000868,  2.87444546307,       15.19030184810}, 
    {     0.00000001167,  6.01716139063,      377.15882254340}, 
    {     0.00000000967,  2.51117953936,      121.84272231430}, 
    {     0.00000000857,  5.69539341636,      141.69889060840}, 
    {     0.00000001180,  2.37522177893,       33.94024994380}, 
    {     0.00000000961,  0.22181374419,        0.91502373670}, 
    {     0.00000000901,  4.21763792004,      488.84961647110}, 
    {     0.00000000999,  2.76968761861,      148.59998928810}, 
    {     0.00000001007,  3.44301576832,       36.90919536040}, 
    {     0.00000000838,  1.63355479706,        2.33580597020}, 
    {     0.00000001055,  5.32670142035,      308.31511480930}, 
    {     0.00000001043,  1.72678741786,      438.29828244570}, 
    {     0.00000000809,  0.77488827280,     2043.98226181110}, 
    {     0.00000000966,  5.97805325335,      606.76018552230}, 
    {     0.00000000826,  2.97722608735,       62.77269045690}, 
    {     0.00000000989,  4.44879184782,      406.10313764110}, 
    {     0.00000000842,  4.09747897628,      140.65636088480}, 
    {     0.00000001020,  5.13250756040,      157.26744496640}, 
    {     0.00000000797,  3.10995123049,       93.79217909390}, 
    {     0.00000001075,  2.48259317920,      405.99126305650}, 
    {     0.00000000944,  1.16305712399,       82.20396210880}, 
    {     0.00000000917,  4.89097024007,       12.00890811040}, 
    {     0.00000000883,  2.36224385140,        3.77209456870}, 
    {     0.00000001020,  3.90895442648,      194.28851491140}, 
    {     0.00000000772,  3.14155617772,      248.46318565920}, 
    {     0.00000001067,  4.11262597752,      141.48644228730}, 
    {     0.00000000982,  1.66627917034,       40.58071619260}, 
    {     0.00000000818,  5.48402326753,      252.65597135320}, 
    {     0.00000000843,  0.97496001006,       73.88782669000}, 
    {     0.00000000846,  3.36344025893,       40.84134862350}, 
    {     0.00000001017,  2.65138157720,      477.91579079180}, 
    {     0.00000000727,  2.75669289381,      703.63318461740}, 
    {     0.00000000772,  4.96057719406,      661.09491496450}, 
    {     0.00000001013,  4.06561496066,       76.15419669100}, 
    {     0.00000000770,  0.58191520313,       97.67614824720}, 
    {     0.00000000782,  4.43864011717,      295.19424100610}, 
    {     0.00000000933,  1.26735157121,      624.91943278700}, 
    {     0.00000000742,  2.20772577601,     1171.87587326900}, 
    {     0.00000000785,  0.09340179162,      440.68227252570}, 
    {     0.00000000790,  0.78895659697,       11.84884941600}, 
    {     0.00000000801,  5.48034970397,       21.97952594320}, 
    {     0.00000000717,  4.97342005598,      425.11371816770}, 
    {     0.00000000948,  3.14533047586,      833.55266177900}, 
    {     0.00000000963,  4.82532331563,     1744.85586754190}, 
    {     0.00000000811,  6.14174773500,      184.98791978670}, 
    {     0.00000000683,  3.19990811010,       31.65262808340}, 
    {     0.00000000887,  4.21473602061,      778.41478318470}, 
    {     0.00000000683,  2.71571995972,      685.47393735270}, 
    {     0.00000000878,  4.69541024930,       81.68269724700}, 
    {     0.00000000897,  3.94746491465,       75.67537044460}, 
    {     0.00000000744,  4.00270623421,      902.70518605380}, 
    {     0.00000000825,  4.24768237924,     1246.65747183630}, 
    {     0.00000000673,  2.56327330773,      109.31254934210}, 
    {     0.00000000670,  5.39020598872,      610.69233878540}, 
    {     0.00000000835,  3.65058253628,       14.81779483260}, 
    {     0.00000000703,  3.32025655236,       25.06034594440}, 
    {     0.00000000653,  5.83345039162,       86.63044798330}, 
    {     0.00000000657,  1.73039905547,      216.48048917570}, 
    {     0.00000000737,  2.66162027091,      363.51668387840}, 
    {     0.00000000652,  3.21433113908,      207.88246946660}, 
    {     0.00000000632,  5.31163153800,      180.16199464630}, 
    {     0.00000000751,  1.05682418871,      916.93228005540}, 
    {     0.00000000858,  0.07715076892,      156.15547927360}, 
    {     0.00000000633,  4.98330418733,      958.57677783100}, 
    {     0.00000000651,  6.22872888278,       69.67378913660}, 
    {     0.00000000617,  1.32204773700,      193.65537546500}, 
    {     0.00000000789,  5.67161089073,      280.00393915800}, 
    {     0.00000000815,  3.68454632935,      411.62033734900}, 
    {     0.00000000668,  1.92099734116,       37.61177077600}, 
    {     0.00000000643,  0.26372916234,      217.23124870110}, 
    {     0.00000000648,  5.91545920656,      302.09533968580}, 
    {     0.00000000786,  1.22164212539,      490.07345674850}, 
    {     0.00000000730,  0.75877218619,       44.09217833040}, 
    {     0.00000000662,  2.70374442339,      469.13646052890}, 
    {     0.00000000616,  5.68826448465,       25.27279426550}, 
    {     0.00000000708,  0.65048856186,       14.55716240170}, 
    {     0.00000000680,  0.50483861507,     1057.89745748090}, 
    {     0.00000000741,  4.39625712898,      184.09414790940}, 
    {     0.00000000616,  4.62035066985,       12.26954054130}, 
    {     0.00000000578,  1.51577770689,      668.20846196530}, 
    {     0.00000000574,  3.07628710998,      285.11174858870}, 
    {     0.00000000658,  3.16493349809,      268.43697403230}, 
    {     0.00000000599,  2.08313007917,      149.30256470370}, 
    {     0.00000000778,  4.44580465697,      171.65459766240}, 
    {     0.00000000702,  2.56984201593,      621.73803904930}, 
    {     0.00000000593,  1.51837555428,      397.39324334740}, 
    {     0.00000000651,  2.27936792883,       49.17873590170}, 
    {     0.00000000558,  0.37741292307,      107.49800823370}, 
    {     0.00000000559,  0.82035344351,      541.53981451060}, 
    {     0.00000000579,  2.66384618570,      823.99143422340}, 
    {     0.00000000738,  3.04661280921,      131.92521473170}, 
    {     0.00000000661,  3.46706982545,      105.38039607900}, 
    {     0.00000000550,  3.56043970960,      497.44763618020}, 
    {     0.00000000552,  2.93525507111,       34.20088237470}, 
    {     0.00000000570,  5.61286873129,      118.87377689770}, 
    {     0.00000000611,  3.52382599505,      149.40313844020}, 
    {     0.00000000538,  0.46786259161,      133.10087089930}, 
    {     0.00000000581,  3.06975609659,      137.55428902420}, 
    {     0.00000000699,  2.57905086244,      602.98809095360}, 
    {     0.00000000529,  5.41517154207,      450.97721326420}, 
    {     0.00000000572,  0.49705877254,      331.20966448920}, 
    {     0.00000000567,  4.82584789901,      842.15068148810}, 
    {     0.00000000600,  5.83868295988,      181.05576652360}, 
    {     0.00000000545,  2.85574498347,       61.44827644300}, 
    {     0.00000000591,  5.51829236048,      140.96517742550}, 
    {     0.00000000624,  0.70843752821,      836.52160719560}, 
    {     0.00000000638,  3.99812366414,      136.06981631590}, 
    {     0.00000000623,  5.84341335790,       52.80207262410}, 
    {     0.00000000576,  0.33426283342,      139.48070471720}, 
    {     0.00000000588,  0.05694902672,       95.93104310800}, 
    {     0.00000000516,  2.19916574088,      458.09076026500}, 
    {     0.00000000640,  6.23103740957,    10063.72234907640}, 
    {     0.00000000583,  2.01801609392,      449.28029223480}, 
    {     0.00000000541,  3.38817907552,      252.08652238160}, 
    {     0.00000000674,  1.68032765593,      149.04193227280}, 
    {     0.00000000537,  2.96196069752,       73.13706716460}, 
    {     0.00000000508,  2.53212989919,       41.75637236020}, 
    {     0.00000000524,  6.13250235908,     1589.07289528380}, 
    {     0.00000000630,  0.72006810767,      513.07988101300}, 
    {     0.00000000536,  5.79291762554,      282.66406803390}, 
    {     0.00000000582,  0.49661830540,      283.62727588040}, 
    {     0.00000000589,  6.24054791700,       29.79564835960}, 
    {     0.00000000465,  0.25511403173,       57.25549074900}, 
    {     0.00000000581,  4.76285550074,      479.40026350010}, 
    {     0.00000000534,  2.40031010789,      393.46109008430}, 
    {     0.00000000499,  1.70080029975,      262.47783133970}, 
    {     0.00000000574,  2.86244729074,      170.76082578510}, 
    {     0.00000000564,  1.20364214586,      832.58945393250}, 
    {     0.00000000556,  4.40198802843,      196.62432088160}, 
    {     0.00000000566,  0.34311426390,      343.47920503050}, 
    {     0.00000000530,  3.45607265169,      450.45594840240}, 
    {     0.00000000443,  3.98624215251,      135.33610313300}, 
    {     0.00000000558,  6.06570955170,       76.37794586020}, 
    {     0.00000000565,  4.90824100099,      463.50738623640}, 
    {     0.00000000519,  3.93421845882,      460.53844081980}, 
    {     0.00000000462,  4.19010570010,      271.40591944890}, 
    {     0.00000000474,  4.61013000511,      291.26208774300}, 
    {     0.00000000515,  2.23857274690,      228.79821382680}, 
    {     0.00000000436,  6.22400798387,      149.61138124440}, 
    {     0.00000000499,  3.72703652941,      853.19638175200}, 
    {     0.00000000436,  5.07972033661,       79.44746501330}, 
    {     0.00000000426,  2.17011428925,      119.39504175950}, 
    {     0.00000000540,  1.04610917716,      446.31134681820}, 
    {     0.00000000423,  1.23352648155,      357.44566660120}, 
    {     0.00000000484,  2.83311091436,      400.16524680790}, 
    {     0.00000000547,  0.55236729498,      241.87090352020}, 
    {     0.00000000436,  3.63014811867,      149.51501302480}, 
    {     0.00000000435,  1.21235386124,      911.30320576290}, 
    {     0.00000000506,  1.59810782706,       54.28654533240}, 
    {     0.00000000468,  0.00162187872,      232.42155054920}, 
    {     0.00000000450,  6.04091895999,     1894.41906467650}, 
    {     0.00000000426,  4.89607718517,      116.53797092750}, 
    {     0.00000000405,  6.24550564728,      149.72325582900}, 
    {     0.00000000552,  0.23040562733,      829.62050851590}, 
    {     0.00000000517,  2.70015186737,      412.58354519550}, 
    {     0.00000000406,  2.04699110555,      232.04904353370}, 
    {     0.00000000409,  4.02096236368,      735.87651353180}, 
    {     0.00000000464,  3.82915340503,     1094.54602041040}, 
    {     0.00000000554,  3.92724998283,      416.77633088950}, 
    {     0.00000000478,  0.23337342897,     1182.92157353290}, 
    {     0.00000000455,  4.41056074117,      754.83890994860}, 
    {     0.00000000425,  0.19362570317,      310.17209453310}, 
    {     0.00000000405,  0.08637530483,       18.96239641680}, 
    {     0.00000000505,  4.18178166641,      449.49274055590}, 
    {     0.00000000391,  0.09596077147,     1097.09427470170}, 
    {     0.00000000486,  4.60822193064,      442.75170057060}, 
    {     0.00000000447,  0.56825354381,      758.77106321170}, 
    {     0.00000000406,  3.80066885794,       34.53095077480}, 
    {     0.00000000543,  2.80897788326,      514.56435372130}, 
    {     0.00000000394,  0.82400691137,      337.80194662820}, 
    {     0.00000000498,  1.11991750513,      154.29849954980}, 
    {     0.00000000526,  5.35729655960,      838.21852822500}, 
    {     0.00000000396,  6.00531185948,      246.97871295090}, 
    {     0.00000000436,  3.61896813250,      229.08009811710}, 
    {     0.00000000419,  0.90546729320,      451.72797278960}, 
    {     0.00000000394,  4.86493280924,     1404.08497549710}, 
    {     0.00000000505,  4.80928477681,      155.50108796780}, 
    {     0.00000000437,  1.36909044697,      745.27768239300}, 
    {     0.00000000472,  3.61944685312,      679.25416222920}, 
    {     0.00000000465,  5.53770634513,      494.26624244250}, 
    {     0.00000000415,  3.01980670649,      348.84764689210}, 
    {     0.00000000422,  3.51871257208,      706.81457835510}, 
    {     0.00000000354,  4.06294331463,      124.29040286910}, 
    {     0.00000000350,  0.69344344427,      742.99006053260}, 
    {     0.00000000400,  0.28819545975,      407.58761034940}, 
    {     0.00000000436,  3.13753022197,      168.57377766120}, 
    {     0.00000000461,  4.10342065247,       27.72047482030}, 
    {     0.00000000353,  2.94674365806,      806.72595883600}, 
    {     0.00000000364,  3.07518732480,      442.63982598600}, 
    {     0.00000000482,  1.48698198058,      149.82382956550}, 
    {     0.00000000397,  2.65695336615,      464.47059408290}, 
    {     0.00000000348,  5.78081905496,     1265.56747862640}, 
    {     0.00000000422,  1.93225903819,      474.94684537520}, 
    {     0.00000000352,  4.04751614480,      180.79513409270}, 
    {     0.00000000458,  4.95302010209,      619.29035849450}, 
    {     0.00000000358,  0.16212320594,     1190.78588005910}, 
    {     0.00000000356,  3.19289330603,       21.19762865050}, 
    {     0.00000000406,  3.72223708907,     3116.26763099790}, 
    {     0.00000000341,  3.05116722794,       15.78100267910}, 
    {     0.00000000352,  2.38001884804,      511.59540830470}, 
    {     0.00000000376,  3.67717394221,      328.24071907260}, 
    {     0.00000000370,  0.17259001853,     6531.66165626500}, 
    {     0.00000000378,  4.72535454314,       30.59879751170}, 
    {     0.00000000456,  0.83406682485,      674.80074410430}, 
    {     0.00000000376,  5.91068811321,     1617.38407093510}, 
    {     0.00000000392,  1.90856045571,    25863.55834587229}, 
    {     0.00000000332,  0.85733579829,      749.20983565610}, 
    {     0.00000000321,  2.59404134515,     1300.99220127850}, 
    {     0.00000000444,  0.92962461992,       98.35747180340}, 
    {     0.00000000338,  4.15717957485,       21.14944454070}, 
    {     0.00000000317,  3.90481203904,       38.60611638980}, 
    {     0.00000000346,  1.30799145303,      321.76031151820}, 
    {     0.00000000387,  3.06870543578,     1012.91150727320}, 
    {     0.00000000324,  6.11165016338,      696.51963761660}, 
    {     0.00000000335,  1.33853903231,      172.45774681450}, 
    {     0.00000000314,  4.56810921721,     1681.11996923850}, 
    {     0.00000000310,  5.02963877803,     1811.77315958300}, 
    {     0.00000000382,  5.26829613655,       67.07735073550}, 
    {     0.00000000394,  4.26717713334,      304.23420369990}, 
    {     0.00000000406,  3.58469900333,    26013.12154300690}, 
    {     0.00000000309,  2.68348239684,      248.72381809010}, 
    {     0.00000000372,  1.99921282497,      192.80404220310}, 
    {     0.00000000370,  4.11260458857,      239.16259053450}, 
    {     0.00000000299,  3.96468960950,    20277.00789528740}, 
    {     0.00000000305,  6.24476771738,      501.37978944330}, 
    {     0.00000000298,  2.73915352450,      143.93412284210}, 
    {     0.00000000362,  5.98792551264,      920.86443331850}, 
    {     0.00000000298,  3.52867456736,       21.45826108140}, 
    {     0.00000000375,  5.43269388058,      625.99451521810}, 
    {     0.00000000331,  2.33574542436,      229.45260513260}, 
    {     0.00000000370,  3.51055181581,       91.45637312370}, 
    {     0.00000000308,  5.60489714954,      445.34813897170}, 
    {     0.00000000317,  4.34771147014,      217.44369702220}, 
    {     0.00000000294,  6.15987510624,       19.97378837310}, 
    {     0.00000000414,  4.81163687199,      589.49471013490}, 
    {     0.00000000302,  5.26079338050,       27.56041612590}, 
    {     0.00000000372,  2.20287549079,       44.07092647100}, 
    {     0.00000000390,  1.77880995993,      419.48464387520}, 
    {     0.00000000371,  0.30454914535,     6283.07584999140}, 
    {     0.00000000292,  0.17009533973,      455.66012605270}, 
    {     0.00000000370,  2.48289171331,      376.19561469690}, 
    {     0.00000000315,  2.97527331738,      236.87496867410}, 
    {     0.00000000319,  4.13089051068,       81.26200612170}, 
    {     0.00000000290,  2.63347600042,      454.15860700190}, 
    {     0.00000000300,  1.28922027378,      799.61241183520}, 
    {     0.00000000350,  4.25460254325,      227.52618943960}, 
    {     0.00000000289,  6.12627198170,      132.88842257820}, 
    {     0.00000000360,  3.48063709609,       44.61344319220}, 
    {     0.00000000393,  5.12508976370,     3192.53370227350}, 
    {     0.00000000365,  0.55471648096,      285.63301345050}, 
    {     0.00000000311,  3.56801685990,      288.73508531110}, 
    {     0.00000000333,  4.95319798125,      881.50755740330}, 
    {     0.00000000385,  4.98242164368,      572.22923474750}, 
    {     0.00000000339,  5.65360136491,      195.77298761970}, 
    {     0.00000000363,  0.98999016221,      839.70300093330}, 
    {     0.00000000386,  3.32408807296,    25939.82441714789}, 
    {     0.00000000289,  3.00353602984,      204.70107572890}, 
    {     0.00000000374,  0.90849814157,      549.72844394250}, 
    {     0.00000000321,  1.65412170860,       90.28071695610}, 
    {     0.00000000383,  3.00200467817,      551.21291665080}, 
    {     0.00000000279,  4.06882632435,      904.18965876210}, 
    {     0.00000000366,  6.15032242763,      491.81856188770}, 
    {     0.00000000341,  3.73123892015,      452.46168597250}, 
    {     0.00000000360,  3.29825671883,      104.52906281710}, 
    {     0.00000000319,  5.57991791116,      459.36278465220}, 
    {     0.00000000386,  4.71096019501,      901.95442652840}, 
    {     0.00000000296,  2.33233720412,       89.59939339990}, 
    {     0.00000000348,  0.93025072898,       29.74746424980}, 
    {     0.00000000308,  1.48912863494,     1530.80601257850}, 
    {     0.00000000272,  2.84186859971,     2045.46673451940}, 
    {     0.00000000327,  2.25624475244,      272.58157561650}, 
    {     0.00000000333,  3.58076165959,      428.08266358430}, 
    {     0.00000000349,  2.34615857088,     6069.77675455340}, 
    {     0.00000000278,  5.33956009504,      335.77495719870}, 
    {     0.00000000270,  5.72961044984,      450.17406411210}, 
    {     0.00000000282,  2.51807549695,      156.04360468900}, 
    {     0.00000000334,  3.79230663769,      697.80716836880}, 
    {     0.00000000270,  0.49362216969,      320.32402291970}, 
    {     0.00000000321,  0.71639963302,      320.27583880990}, 
    {     0.00000000296,  2.51339170311,      266.10116806210}, 
    {     0.00000000270,  4.99754135777,      309.27832265580}, 
    {     0.00000000265,  3.33672155263,      639.89728631400}, 
    {     0.00000000324,  5.54296698387,     1507.17774971570}, 
    {     0.00000000282,  0.62853626574,      263.96230404800}, 
    {     0.00000000366,  5.89950070572,      268.95823889410}, 
    {     0.00000000285,  4.23006264357,      177.30492381430}, 
    {     0.00000000347,  4.70852082400,      282.14280317210}, 
    {     0.00000000332,  0.76535923530,       50.66320861000}, 
    {     0.00000000284,  2.87061321749,      883.79517926370}, 
    {     0.00000000333,  6.24087751277,      563.63121503840}, 
    {     0.00000000363,  3.29320353192,      378.90392768260}, 
    {     0.00000000336,  3.79029047358,     9999.98645077300}, 
    {     0.00000000259,  4.37287015895,     1310.39337013970}, 
    {     0.00000000255,  4.84760640021,      229.76142167330}, 
    {     0.00000000286,  3.72531001807,      230.93707784090}, 
    {     0.00000000332,  2.36777399155,     2274.54683263650}, 
    {     0.00000000325,  5.91384585098,     9990.42522321740}, 
    {     0.00000000260,  5.92834225229,      455.06942522170}, 
    {     0.00000000274,  0.53976988872,      380.23964254460}, 
    {     0.00000000319,  4.92433309582,     1140.38330388000}, 
    {     0.00000000259,  3.15728798274,      454.74930783290}, 
    {     0.00000000293,  3.80820074659,      194.17664032680}, 
    {     0.00000000264,  0.34153729395,     1193.96727379680}, 
    {     0.00000000296,  2.31655276454,      422.71422172270}, 
    {     0.00000000303,  0.17738702664,      384.58118608490}, 
    {     0.00000000285,  1.29732672572,       25.12978191360}, 
    {     0.00000000251,  1.67282111226,      447.20511869550}, 
    {     0.00000000251,  3.03412113376,      117.31986822020}, 
    {     0.00000000326,  1.68159391466,      161.72086309130}, 
    {     0.00000000248,  5.85392046839,      229.34073054800}, 
    {     0.00000000258,  5.02749399426,      406.95447090300}, 
    {     0.00000000264,  6.15508431133,     1385.17496870700}, 
    {     0.00000000276,  1.57831452320,      336.83873878170}, 
    {     0.00000000264,  2.90833578247,       75.15410558280}, 
    {     0.00000000284,  5.70644286377,       92.41958097020}, 
    {     0.00000000273,  3.78780023228,      380.01589337540}, 
    {     0.00000000252,  2.00771359511,       85.93917341580}, 
    {     0.00000000255,  5.06133623645,      102.52332524700}, 
    {     0.00000000257,  1.34131613295,      304.12232911530}, 
    {     0.00000000244,  2.73811369909,      445.72064598720}, 
    {     0.00000000265,  3.02540121790,      454.79749194270}, 
    {     0.00000000274,  1.36882612211,      188.65944061890}, 
    {     0.00000000239,  5.33018322578,      293.70976829780}, 
    {     0.00000000235,  5.60412059654,      437.64389113990}, 
    {     0.00000000276,  5.62363398057,      187.17496791060}, 
    {     0.00000000278,  3.81695614226,       31.54075349880}, 
    {     0.00000000292,  4.64128185538,      151.85081899500}, 
    {     0.00000000314,  3.86400459047,      734.45573129830}, 
    {     0.00000000234,  1.80885124531,     1503.24559645260}, 
    {     0.00000000322,  2.35445171313,      122.47586176070}, 
    {     0.00000000258,  6.05880184188,      455.02124111190}, 
    {     0.00000000238,  2.56020773425,      170.01006625970}, 
    {     0.00000000232,  4.77316690974,       73.34530996880}, 
    {     0.00000000232,  5.10057210704,      263.02034806090}, 
    {     0.00000000240,  2.99777840790,     1147.49685088080}, 
    {     0.00000000281,  4.15776226983,      279.48267429620}, 
    {     0.00000000257,  3.04913300739,      436.81380973740}, 
    {     0.00000000235,  3.02410451628,      361.37781986430}, 
    {     0.00000000255,  0.88643610795,      418.52143602870}, 
    {     0.00000000264,  1.89462495453,       74.40909155180}, 
    {     0.00000000268,  0.38577446389,      444.23617327890}, 
    {     0.00000000222,  4.53746462038,      230.82520325630}, 
    {     0.00000000241,  2.49671371454,      548.24397123420}, 
    {     0.00000000239,  4.41496531562,      213.95348674380}, 
    {     0.00000000237,  3.26466054351,      535.91074021810}, 
    {     0.00000000220,  0.41236373275,      448.31708438830}, 
    {     0.00000000226,  3.93834877953,      754.03576079650}, 
    {     0.00000000237,  2.40162775612,      827.92358748650}, 
    {     0.00000000240,  1.77900522919,      380.38840039090}, 
    {     0.00000000224,  0.05082919493,       76.21788716580}, 
    {     0.00000000258,  4.48552116447,      551.10104206620}, 
    {     0.00000000278,  4.63839965274,      341.99473232220}, 
    {     0.00000000300,  1.76109411385,      371.52974825090}, 
    {     0.00000000287,  3.90151164865,      531.97858695500}, 
    {     0.00000000274,  1.99452951365,      968.13800538660}, 
    {     0.00000000262,  6.12295568294,      311.28406022590}, 
    {     0.00000000264,  5.76806626227,      635.96513305090}, 
    {     0.00000000214,  1.90097549431,      208.84567731310}, 
    {     0.00000000221,  5.73564108330,     1136.45115061690}, 
    {     0.00000000279,  2.40796258509,     1670.07426897460}, 
    {     0.00000000247,  4.10467533143,      962.50893109410}, 
    {     0.00000000251,  0.65896974227,      423.62924545940}, 
    {     0.00000000273,  4.48420386716,     6060.21552699780}, 
    {     0.00000000284,  1.98517323011,      402.21916848780}, 
    {     0.00000000213,  0.40391978805,      197.79997704920}, 
    {     0.00000000271,  3.29944247062,      749.58234267160}, 
    {     0.00000000214,  1.77108713711,      358.40887444770}, 
    {     0.00000000212,  1.30757526648,       74.14845912090}, 
    {     0.00000000285,  3.45237643998,      299.71709510020}, 
    {     0.00000000215,  0.11685291153,      893.35640681930}, 
    {     0.00000000226,  4.36569336172,      450.71658083330}, 
    {     0.00000000285,  0.89336265206,       81.63451313720}, 
    {     0.00000000276,  2.67678282261,      310.97524368520}, 
    {     0.00000000237,  4.64910992307,      385.75684225250}, 
    {     0.00000000233,  5.39644711520,      245.54242435240}, 
    {     0.00000000266,  0.21523688619,      148.81243760920}, 
    {     0.00000000222,  1.64662422921,       76.42612997000}, 
    {     0.00000000271,  2.94530770298,      763.43692965770}, 
    {     0.00000000209,  5.56347456206,       78.92620015150}, 
    {     0.00000000250,  1.28952902548,      421.18156490460}, 
    {     0.00000000254,  2.61839399513,      525.23754696970}, 
    {     0.00000000221,  2.85700154975,      104.57724692690}, 
    {     0.00000000235,  0.29404113312,     6057.24658158120}, 
    {     0.00000000213,  1.81939118803,      104.83787935780}, 
    {     0.00000000219,  4.81031857297,      377.68008740520}, 
    {     0.00000000239,  4.14502038477,      260.36021918500}, 
    {     0.00000000259,  6.22064928944,      305.60680182360}, 
    {     0.00000000241,  4.25260400494,     1478.86657406440}, 
    {     0.00000000260,  6.06592450487,      586.31331639720}, 
    {     0.00000000215,  2.19677481542,     1321.43907040360}, 
    {     0.00000000240,  6.18410669894,      689.61853893690}, 
    {     0.00000000204,  0.09387343234,      945.24345570670}, 
    {     0.00000000219,  0.49807555465,      507.59956456680}, 
    {     0.00000000203,  1.80599017081,     1072.71525231350}, 
    {     0.00000000212,  5.16316390795,      256.42806592190}, 
    {     0.00000000262,  2.82472906853,      971.10695080320}, 
    {     0.00000000280,  3.80946061981,       67.92868399740}, 
    {     0.00000000212,  3.61675003861,       75.41473801370}, 
    {     0.00000000205,  0.30735417946,      461.12914165080}, 
    {     0.00000000222,  3.52840777605,      511.53171782990}, 
    {     0.00000000198,  4.47397050345,      289.56516671360}, 
    {     0.00000000271,  3.44737698948,      564.85505531580}, 
    {     0.00000000234,  0.17593976046,      251.17149864490}, 
    {     0.00000000199,  4.86362206373,       76.78733613740}, 
    {     0.00000000211,  1.05544090440,      257.39127376840}, 
    {     0.00000000214,  3.97499500159,      370.56654040440}, 
    {     0.00000000211,  4.12360308875,      695.55642977010}, 
    {     0.00000000196,  3.96250134928,      412.37109687440}, 
    {     0.00000000229,  5.00491031721,      103.98654609590}, 
    {     0.00000000242,  5.74082244878,      340.51025961390}, 
    {     0.00000000230,  2.56838559117,      147.55745956450}, 
    {     0.00000000208,  3.79662225345,      325.38364824060}, 
    {     0.00000000258,  0.01795959348,     2199.76523406920}, 
    {     0.00000000213,  5.89130495905,      170.17012495410}, 
    {     0.00000000267,  0.78536095157,      976.73602509570}, 
    {     0.00000000218,  1.97075089989,      569.04784100980}, 
    {     0.00000000257,  1.38354609083,      360.41461201780}, 
    {     0.00000000195,  3.26824797258,      984.71220620650}, 
    {     0.00000000251,  4.87361192641,      516.04882642960}, 
    {     0.00000000202,  4.03331754714,      187.27554164710}, 
    {     0.00000000223,  0.97997805412,      627.36711334180}, 
    {     0.00000000205,  5.28074143210,      223.38158785540}, 
    {     0.00000000224,  5.24077049451,      206.70681329900}, 
    {     0.00000000260,  5.90070113141,      520.12973753900}, 
    {     0.00000000188,  1.49833733081,       26.82670294300}, 
    {     0.00000000205,  5.05597552852,      772.78570889220}, 
    {     0.00000000228,  3.64861995308,      367.59759498780}, 
    {     0.00000000237,  2.97607548462,      271.61836777000}, 
    {     0.00000000224,  1.25201508170,      161.41204655060}, 
    {     0.00000000185,  4.50042780818,      224.86606056370}, 
    {     0.00000000236,  5.41408651212,      550.13783421970}, 
    {     0.00000000192,  2.35024531733,      236.19364511790}, 
    {     0.00000000237,  3.66086044285,     1106.65550225730}, 
    {     0.00000000225,  1.66222054133,     1366.21257229020}, 
    {     0.00000000193,  3.01431831660,      164.38099196720}, 
    {     0.00000000218,  5.46588301502,     1500.06420271490}, 
    {     0.00000000207,  5.55969556391,      332.69413719750}, 
    {     0.00000000208,  4.68503146595,      448.97147569410}, 
    {     0.00000000211,  0.34453145739,      980.66817835880}, 
    {     0.00000000217,  3.70105940449,      655.93892142400}, 
    {     0.00000000190,  1.69474626512,     1031.87390369000}, 
    {     0.00000000254,  2.52997093206,       58.17051448570}, 
    {     0.00000000242,  4.63165125809,      167.72244439930}, 
    {     0.00000000182,  0.38822952347,      249.94765836750}, 
    {     0.00000000229,  2.97276294509,      676.28521681260}, 
    {     0.00000000184,  0.87882802865,      947.69113626150}, 
    {     0.00000000203,  3.17061034955,      846.08283475120}, 
    {     0.00000000181,  4.57548083160,      343.21857259960}, 
    {     0.00000000250,  3.61454066264,      452.20105354160}, 
    {     0.00000000181,  0.80505262570,      168.31314523030}, 
    {     0.00000000187,  0.91771297573,      556.51766803760}, 
    {     0.00000000199,  1.94637571303,      253.45912050530}, 
    {     0.00000000191,  0.61001202802,      394.94556279260}, 
    {     0.00000000180,  3.74457885445,     1447.42639430210}, 
    {     0.00000000179,  5.35660015345,      122.05517063540}, 
    {     0.00000000231,  6.22502194357,     1610.27052393430}, 
    {     0.00000000240,  6.03703834530,      898.77303279070}, 
    {     0.00000000218,  2.33495824686,      623.43496007870}, 
    {     0.00000000181,  1.91828280417,      337.58949830710}, 
    {     0.00000000221,  2.89138126660,      238.90195810360}, 
    {     0.00000000209,  1.03618779316,     6212.22640468720}, 
    {     0.00000000213,  1.02918228734,      657.16276170140}, 
    {     0.00000000183,  2.72582542773,      332.17287233570}, 
    {     0.00000000204,  4.67512756150,      377.41945497430}, 
    {     0.00000000205,  5.62140485721,      388.46515523820}, 
    {     0.00000000219,  2.76359711762,      561.88610989920}, 
    {     0.00000000212,  3.46768338211,      181.64646735460}, 
    {     0.00000000211,  4.59763685784,     1109.62444767390}, 
    {     0.00000000212,  2.99004198457,      559.69906177530}, 
    {     0.00000000174,  2.21353674595,      887.72733252680}, 
    {     0.00000000173,  1.74529912106,      365.14991443300}, 
    {     0.00000000174,  2.45391768476,     1332.48477066750}, 
    {     0.00000000240,  4.85443977637,      761.74000862830}, 
    {     0.00000000178,  0.05006039446,      941.31130244360}, 
    {     0.00000000195,  2.37804209176,      444.82687410990}, 
    {     0.00000000242,  4.29915867363,     6244.94281435360}, 
    {     0.00000000172,  3.87569337913,      389.68899551560}, 
    {     0.00000000188,  2.26967965211,       90.93510826190}, 
    {     0.00000000217,  1.72840709072,    10213.28554621100}, 
    {     0.00000000221,  3.92472409608,      562.66800719190}, 
    {     0.00000000173,  4.18722182816,      247.83004621280}, 
    {     0.00000000174,  2.94442479945,      454.86118241750}, 
    {     0.00000000239,  3.42577256015,      188.23874949360}, 
    {     0.00000000174,  6.14174672485,      454.95755063710}, 
    {     0.00000000191,  0.05959544276,      429.77958461370}, 
    {     0.00000000199,  4.06645118654,     6204.36209816100}, 
    {     0.00000000232,  0.73635761605,      525.75881183150}, 
    {     0.00000000190,  3.21864199482,      473.46237266690}, 
    {     0.00000000184,  2.09184439155,      262.80789973980}, 
    {     0.00000000204,  2.53426014155,      128.43500445330}, 
    {     0.00000000199,  5.18040948653,      517.42142455330}, 
    {     0.00000000169,  3.32081675151,      442.37919355510}, 
    {     0.00000000194,  1.70394842618,      454.64873409640}, 
    {     0.00000000174,  0.92072543792,      298.23262239190}, 
    {     0.00000000197,  2.45889996723,    10142.43610090680}, 
    {     0.00000000169,  2.85071771667,      182.27960680100}, 
    {     0.00000000176,  3.06802568810,      594.91133610630}, 
    {     0.00000000170,  1.61438641294,     1512.80682400820}, 
    {     0.00000000181,  5.54852777620,      388.20452280730}, 
    {     0.00000000205,  2.42849105018,      179.31066138440}, 
    {     0.00000000168,  0.36331522083,      597.35901666110}, 
    {     0.00000000233,  4.13122108092,      544.50875992720}, 
    {     0.00000000212,  1.16230626511,      268.69760646320}, 
    {     0.00000000164,  4.16304107762,      433.71173787680}, 
    {     0.00000000184,  4.13171323402,    78114.14622758799}, 
    {     0.00000000216,  4.13270907264,      375.67434983510}, 
    {     0.00000000164,  3.48735100134,     1521.40484371730}, 
    {     0.00000000166,  3.69271105852,      381.09097580650}, 
    {     0.00000000215,  3.01465140857,     3191.04922956520}, 
    {     0.00000000210,  0.51797558404,      987.78172535960}, 
    {     0.00000000196,  1.96055142388,      255.83736509090}, 
    {     0.00000000188,  1.75260412819,     9987.45627780080}, 
    {     0.00000000183,  1.55394479952,      545.27502581760}, 
    {     0.00000000162,  3.53658533673,      477.00076705510}, 
    {     0.00000000197,  1.23651696009,      873.17017012510}, 
    {     0.00000000228,  5.72185284514,    10175.15251057320}, 
    {     0.00000000221,  1.65277750718,      630.33605875840}, 
    {     0.00000000166,  4.86610094513,     1440.99417085750}, 
    {     0.00000000177,  3.02796963506,     5983.94945572220}, 
    {     0.00000000170,  2.58560048709,     1515.77576942480}, 
    {     0.00000000177,  2.88506192589,      240.12579838100}, 
    {     0.00000000208,  2.04949512692,      302.37722397610}, 
    {     0.00000000189,  5.82946378780,       36.17548217750}, 
    {     0.00000000216,  0.68196473963,     1363.24362687360}, 
    {     0.00000000175,  2.61001153558,      885.43971066640}, 
    {     0.00000000210,  2.65555515930,      224.45667028650}, 
    {     0.00000000160,  3.50517836979,      150.31395666000}, 
    {     0.00000000174,  0.49467967031,      369.97583957340}, 
    {     0.00000000188,  5.48911204749,    10134.57179438060}, 
    {     0.00000000191,  5.68393131484,      662.64307814760}, 
    {     0.00000000205,  0.92509219538,      548.44091319030}, 
    {     0.00000000206,  6.10268880505,     1054.92851206430}, 
    {     0.00000000185,  0.91857524328,      440.89472084680}, 
    {     0.00000000189,  2.67822187732,     2250.16781024830}, 
    {     0.00000000184,  5.67663245346,      409.92341631960}, 
    {     0.00000000207,  3.01561723041,       95.27665180220}, 
    {     0.00000000192,  3.38477678765,      141.17762574660}, 
    {     0.00000000175,  3.98637627601,      354.99798604640}, 
    {     0.00000000179,  1.06144138645,      455.16999895820}, 
    {     0.00000000185,  1.48084539492,      226.79247625670}, 
    {     0.00000000172,  2.45526838627,      398.28701522470}, 
    {     0.00000000203,  4.82705125287,     6737.98521651870}, 
    {     0.00000000159,  3.62343847192,       73.97844941520}, 
    {     0.00000000215,  3.25584948597,      125.18417474640}, 
    {     0.00000000205,  0.77710214764,      769.81676347560}, 
    {     0.00000000164,  4.68848272913,     6607.92772754060}, 
    {     0.00000000215,  1.66517240781,      118.07062774560}, 
    {     0.00000000164,  0.87369484245,      774.48262992160}, 
    {     0.00000000160,  3.32460761773,      138.56568098050}, 
    {     0.00000000161,  2.52319991589,      409.07208305770}, 
    {     0.00000000173,  3.15899401917,       70.04629615210}, 
    {     0.00000000158,  0.06255653314,      138.46931276090}, 
    {     0.00000000154,  5.92679370788,      224.23292111730}, 
    {     0.00000000166,  4.16626167677,       72.07328558160}, 
    {     0.00000000183,  2.68426170572,      838.00607990390}, 
    {     0.00000000193,  1.38193725138,      154.67100656530}, 
    {     0.00000000188,  3.61481992714,      517.16079212240}, 
    {     0.00000000189,  0.66749483500,      484.91746320800}, 
    {     0.00000000203,  2.66775880985,      327.43756992050}, 
    {     0.00000000193,  4.43470193645,      832.06818907070}, 
    {     0.00000000159,  0.56494121338,      379.16456011350}, 
    {     0.00000000166,  4.45048519194,     9914.15915194180}, 
    {     0.00000000168,  3.52621114631,      464.99185894470}, 
    {     0.00000000196,  6.24770073617,    10668.19491273830}, 
    {     0.00000000151,  5.72816916526,       59.59129671920}, 
    {     0.00000000181,  0.32013093352,      421.22974901440}, 
    {     0.00000000205,  6.02871481422,      772.58876693610}, 
    {     0.00000000176,  4.99216368664,      123.01837848190}, 
    {     0.00000000160,  1.37750465628,      308.68762182480}, 
    {     0.00000000202,  1.13801628591,      508.62646288810}, 
    {     0.00000000177,  3.63679025498,     1291.43097372290}, 
    {     0.00000000151,  1.15330259215,     1116.00428149180}, 
    {     0.00000000178,  4.93531001103,      349.36891175390}, 
    {     0.00000000205,  2.81769329338,      225.30800354840}, 
    {     0.00000000182,  0.91474840270,     3189.56475685690}, 
    {     0.00000000156,  2.37674956845,      151.26011816400}, 
    {     0.00000000154,  2.76526452323,    78263.70942472259}, 
    {     0.00000000162,  5.62540185969,     1123.11782849260}, 
    {     0.00000000182,  0.63986108075,      274.58731318660}, 
    {     0.00000000156,  4.83915698384,      753.14198891920}, 
    {     0.00000000167,  6.27621577207,      757.80785536520}, 
    {     0.00000000151,  1.69627858213,      325.95309721220}, 
    {     0.00000000149,  2.40009261288,      210.85141488320}, 
    {     0.00000000149,  5.09330665926,      509.08403727510}, 
    {     0.00000000179,  0.93833237775,      196.83676920270}, 
    {     0.00000000195,  0.23272769710,      984.48845703730}, 
    {     0.00000000147,  2.15520667674,       73.24894174920}, 
    {     0.00000000166,  4.95085074433,      276.92311915680}, 
    {     0.00000000194,  5.71948163347,     6136.48159827340}, 
    {     0.00000000148,  1.50337825489,     1525.33699698040}, 
    {     0.00000000205,  0.81050821834,     6171.64568849460}, 
    {     0.00000000195,  5.02600286169,      415.29185818120}, 
    {     0.00000000147,  4.88804405947,      683.02625679790}, 
    {     0.00000000168,  4.68232587155,      519.60847267720}, 
    {     0.00000000161,  1.71491481543,      277.14686832600}, 
    {     0.00000000185,  5.86240343650,     1743.37139483360}, 
    {     0.00000000177,  5.39738308693,    25936.85547173129}, 
    {     0.00000000159,  3.71583639802,     6604.95878212400}, 
    {     0.00000000152,  3.76465336789,      768.85355562910}, 
    {     0.00000000191,  4.45675615557,      340.88276662940}, 
    {     0.00000000147,  6.01587695039,      369.34270012700}, 
    {     0.00000000148,  1.70522713789,     1523.69246557770}, 
    {     0.00000000144,  1.19516771137,       95.97922721780}, 
    {     0.00000000181,  4.75684140426,       71.15826184490}, 
    {     0.00000000145,  3.15169720832,      523.47118997110}, 
    {     0.00000000146,  4.40646311724,     2014.02655475710}, 
    {     0.00000000162,  4.76511090288,      245.49424024260}, 
    {     0.00000000195,  1.45876037172,      281.48841186630}, 
    {     0.00000000155,  2.45354382334,      557.03893289940}, 
    {     0.00000000149,  2.09335099835,      273.85360000370}, 
    {     0.00000000187,  1.77504712447,      995.64603188580}, 
    {     0.00000000151,  3.12279980744,      746.76215510130}, 
    {     0.00000000147,  5.09554340545,      466.75821594330}, 
    {     0.00000000172,  1.42535111080,      276.07178589490}, 
    {     0.00000000190,  0.86480008000,    10066.69129449300}, 
    {     0.00000000154,  2.07677643107,       91.24392480260}, 
    {     0.00000000142,  2.70241566553,     1367.69704499850}, 
    {     0.00000000185,  0.07257813358,      548.65336151140}, 
    {     0.00000000140,  2.61987335792,       76.31425538540}, 
    {     0.00000000154,  3.03571181321,      714.67888488130}, 
    {     0.00000000169,  5.57948514798,      163.57784281510}, 
    {     0.00000000186,  4.76535517241,      197.25746032800}, 
    {     0.00000000153,  3.32414222326,      138.40562228610}, 
    {     0.00000000167,  5.32278498942,      457.35704708210}, 
    {     0.00000000142,  4.15791797624,      156.67674413540}, 
    {     0.00000000151,  4.34031737599,      147.96684984170}, 
    {     0.00000000183,  6.17032359307,      132.57960603750}, 
    {     0.00000000138,  2.13811958190,      540.05534180230}, 
    {     0.00000000138,  5.01289623723,      144.89733068860}, 
    {     0.00000000167,  2.14405503902,      343.73983746140}, 
    {     0.00000000152,  3.11015659760,     1381.24281544390}, 
    {     0.00000000177,  1.05125544318,      586.37700687200}, 
    {     0.00000000149,  4.87184568681,      130.55261660800}, 
    {     0.00000000155,  5.70008442904,      115.62294719080}, 
    {     0.00000000149,  4.33130158420,      223.82353084010}, 
    {     0.00000000181,  4.13770517410,      267.58564077040}, 
    {     0.00000000154,  2.83750308914,      108.98248094200}, 
    {     0.00000000163,  2.53865234151,      743.79320968470}, 
    {     0.00000000165,  3.41287686341,      247.23934538180}, 
    {     0.00000000151,  2.20235595263,      476.31944349890}, 
    {     0.00000000144,  0.01781384847,      164.54105066160}, 
    {     0.00000000130,  2.21675074014,     1596.98959143670}, 
    {     0.00000000139,  1.43423426981,       73.55775828990}, 
    {     0.00000000130,  2.59858785273,      317.87634236490}, 
    {     0.00000000151,  0.90758816089,      156.46429581430}, 
    {     0.00000000132,  5.78977405289,      262.05714021440}, 
    {     0.00000000150,  3.82803929273,      523.75307426140}, 
    {     0.00000000128,  1.75773422282,       77.70235987410}, 
    {     0.00000000129,  2.46767229126,      680.05731138130}, 
    {     0.00000000133,  2.63453025078,      973.55463135800}, 
    {     0.00000000141,  3.21657574370,      710.74673161820}, 
    {     0.00000000135,  4.39682615321,      153.18653385700}, 
    {     0.00000000164,  0.99473913469,       94.42531854030}, 
    {     0.00000000145,  5.12015953658,      677.76968952090}, 
    {     0.00000000126,  1.32965975637,      400.57463708510}, 
    {     0.00000000141,  1.24113752853,      460.84725736050}, 
    {     0.00000000133,  4.61730809440,      250.60204967330}, 
    {     0.00000000129,  5.27547517603,       88.27497938600}, 
    {     0.00000000127,  0.42170103072,      913.75088631770}, 
    {     0.00000000163,  4.54645286709,      346.44815044710}, 
    {     0.00000000125,  3.65991404025,      191.31956949480}, 
    {     0.00000000145,  2.22528076208,      673.31627139600}, 
    {     0.00000000126,  4.73776902368,     1063.31408345230}, 
    {     0.00000000134,  1.14931407095,      725.09144569880}, 
    {     0.00000000129,  3.47362853744,     1257.70317210020}, 
    {     0.00000000124,  5.93939315836,      354.78553772530}, 
    {     0.00000000136,  2.59497163361,     1119.18567522950}, 
    {     0.00000000154,  0.69730597728,      365.90067395840}, 
    {     0.00000000140,  0.65543247220,       73.03649342810}, 
    {     0.00000000146,  2.80047542494,      188.92007304980}, 
    {     0.00000000154,  1.87714738928,      164.12035953630}, 
    {     0.00000000125,  2.18116740243,      764.18768918310}, 
    {     0.00000000155,  1.28214942977,      148.19059901090}, 
    {     0.00000000132,  0.29965207574,      255.57673266000}, 
    {     0.00000000125,  1.04485712681,      415.66436519670}, 
    {     0.00000000137,  2.18373893649,      765.88461021250}, 
    {     0.00000000127,  2.93669188864,      147.86627610520}, 
    {     0.00000000140,  0.76860031410,      273.15102458810}, 
    {     0.00000000142,  4.10293143898,      309.79958751760}, 
    {     0.00000000118,  5.29215987279,      346.18751801620}, 
    {     0.00000000118,  5.64065029465,      430.53034413910}, 
    {     0.00000000117,  4.70740499014,      346.39996633730}, 
    {     0.00000000159,  3.17545315975,      587.86147958030}, 
    {     0.00000000130,  4.93752382941,      112.39336934330}, 
    {     0.00000000123,  2.01301867655,      376.87693825310}, 
    {     0.00000000131,  5.76525549509,       75.43598987310}, 
    {     0.00000000152,  4.20648305698,       76.52670370650}, 
    {     0.00000000133,  0.27916246107,      221.16340196420}, 
    {     0.00000000115,  6.26954994750,      226.63241756230}, 
    {     0.00000000159,  6.17088331412,      269.07011347870}, 
    {     0.00000000114,  3.58569184745,     1048.33622992530}, 
    {     0.00000000152,  2.72945581345,      639.63665388310}, 
    {     0.00000000121,  4.67661834370,     1222.27844944810}, 
    {     0.00000000119,  4.81856456066,       73.45718455340}, 
    {     0.00000000125,  0.74436796006,      280.21638747910}, 
    {     0.00000000117,  4.00334187137,      107.91869935900}, 
    {     0.00000000113,  2.15393931454,      303.05854753230}, 
    {     0.00000000128,  0.04409162068,       76.10601258120}, 
    {     0.00000000142,  0.57614004948,      246.43619622970}, 
    {     0.00000000138,  5.48635616668,      392.65794093220}, 
    {     0.00000000156,  4.96860085576,      552.69738935910}, 
    {     0.00000000112,  4.31357868330,       74.32402418030}, 
    {     0.00000000116,  3.19955309317,       71.86083726050}, 
    {     0.00000000112,  0.38818418554,       75.23917295430}, 
    {     0.00000000110,  1.35277364690,      376.94637422230}, 
    {     0.00000000152,  0.76257718923,      956.28915597060}, 
    {     0.00000000116,  4.73215012461,     1052.26838318840}, 
    {     0.00000000137,  2.40893045020,      488.58898404020}, 
    {     0.00000000121,  4.23091725782,      115.36231475990}, 
    {     0.00000000131,  0.45681197732,     1261.63532536330}, 
    {     0.00000000142,  1.87324332430,      175.42669223110}, 
    {     0.00000000128,  2.98656300188,      694.83822295220}, 
    {     0.00000000107,  5.62518758086,      582.38116313410}, 
    {     0.00000000134,  4.02062578806,       57.79800747020}, 
    {     0.00000000112,  1.06960066812,      481.73606947030}, 
    {     0.00000000106,  1.01847069745,      625.88264063350}, 
    {     0.00000000125,  1.14766684530,      688.44288276930}, 
    {     0.00000000110,  1.50687781826,     1083.76095257740}, 
    {     0.00000000122,  3.47813324957,      763.22448133660}, 
    {     0.00000000109,  0.47991556990,      143.34342201110}, 
    {     0.00000000109,  2.37913722341,      313.68355667090}, 
    {     0.00000000112,  4.82305132773,      323.50541665740}, 
    {     0.00000000133,  3.91778366061,     9988.94075050910}, 
    {     0.00000000117,  5.79438398039,      383.30916169770}, 
    {     0.00000000143,  2.38142377439,      355.74874557180}, 
    {     0.00000000104,  6.22747103073,      166.23797169100}, 
    {     0.00000000125,  0.93541375535,      532.87235883230}, 
    {     0.00000000136,  3.34772962822,      624.51004250980}, 
    {     0.00000000111,  2.80052858233,      185.57862061770}, 
    {     0.00000000122,  0.66856217536,      499.89531673500}, 
    {     0.00000000129,  5.71746410559,      388.72578766910}, 
    {     0.00000000124,  0.47197488986,      480.88473620840}, 
    {     0.00000000099,  2.73963726422,      469.72716135990}, 
    {     0.00000000135,  0.43811617647,     1286.01434775150}, 
    {     0.00000000118,  5.62193572572,      386.98068252990}, 
    {     0.00000000098,  6.12967230866,     1830.68316637310}, 
    {     0.00000000109,  2.38141278301,       73.93026530540}, 
    {     0.00000000131,  5.44225511718,       74.12720726150}, 
    {     0.00000000100,  3.99996377183,      313.94418910180}, 
    {     0.00000000097,  0.80340713292,      840.66620877980}, 
    {     0.00000000113,  4.35141023213,      904.40210708320}, 
    {     0.00000000108,  1.53330326885,      215.74677599280}, 
    {     0.00000000113,  0.54441962592,     1250.58962509940}, 
    {     0.00000000098,  1.38351669708,     1218.13384786390}, 
    {     0.00000000102,  5.79129370115,       65.38042970610}, 
    {     0.00000000106,  3.94341216754,      678.36039035190}, 
    {     0.00000000124,  1.28838964889,      664.12755085590}, 
    {     0.00000000099,  0.02552769353,      117.36805233000}, 
    {     0.00000000131,  2.67824794719,      981.63138620530}, 
    {     0.00000000119,  3.92954881851,     6134.99712556510}, 
    {     0.00000000128,  4.11821528752,      632.78373931320}, 
    {     0.00000000110,  3.43940323812,       78.97438426130}, 
    {     0.00000000124,  4.84054644412,     1162.47470440780}, 
    {     0.00000000098,  4.25775813209,      199.80571461930}, 
    {     0.00000000125,  2.27613295738,      424.15051032120}, 
    {     0.00000000126,  3.91634098527,    26086.41866886590}, 
    {     0.00000000101,  5.13619689570,      915.44780734710}, 
    {     0.00000000113,  4.93378111345,      108.72184851110}, 
    {     0.00000000105,  3.71144437242,      107.02492748170}, 
    {     0.00000000125,  5.71482360911,     3339.12795399150}, 
    {     0.00000000097,  5.84826276361,      739.05790726950}, 
    {     0.00000000106,  2.53486223474,       76.00543884470}, 
    {     0.00000000111,  1.67593033062,     1002.75957888660}, 
    {     0.00000000105,  3.08951960134,      598.53467282870}, 
    {     0.00000000109,  5.84626924359,       51.88704888740}, 
    {     0.00000000115,  4.28360700908,      172.19711438360}, 
    {     0.00000000097,  3.02476841325,      669.01161111740}, 
    {     0.00000000104,  3.79048221012,      661.15860543930}, 
    {     0.00000000128,  4.12077041398,      537.39521292640}, 
    {     0.00000000119,  5.28769603458,      151.15954442750}, 
    {     0.00000000123,  0.76717587470,      566.60016045500}, 
    {     0.00000000125,  2.46093494660,      686.95841006100}, 
    {     0.00000000110,  0.48706972538,      367.85822741870}, 
    {     0.00000000091,  1.20582179592,     1134.16352875650}, 
    {     0.00000000127,  5.92519293974,      322.61164478010}, 
    {     0.00000000095,  1.48492429003,       70.58881287330}, 
    {     0.00000000105,  1.25919493117,      524.06189080210}, 
    {     0.00000000109,  2.16321134153,      506.37572428940}, 
    {     0.00000000096,  5.79387198359,      335.14181775230}, 
    {     0.00000000100,  0.16435626060,     1895.90353738480}, 
    {     0.00000000104,  6.19360690877,      150.36634628670}, 
    {     0.00000000127,  2.12085008036,     6206.80977871580}, 
    {     0.00000000116,  1.93143384597,      636.66770846650}, 
    {     0.00000000094,  3.60705393791,     1226.21060271120}, 
    {     0.00000000101,  0.24474158501,      170.71264167530}, 
    {     0.00000000091,  2.18722199515,      294.30046912880}, 
    {     0.00000000092,  5.62416527287,      798.12793912690}, 
    {     0.00000000115,  0.61012607379,      583.86563584240}, 
    {     0.00000000102,  4.71122439335,      924.04582705620}, 
    {     0.00000000089,  5.21344736627,      207.67002114550}, 
    {     0.00000000094,  3.70231426761,       63.21463344160}, 
    {     0.00000000091,  3.75312295357,      923.15205517890}, 
    {     0.00000000110,  3.96973294508,      154.55913198070}, 
    {     0.00000000109,  1.01882208456,      748.09786996330}, 
    {     0.00000000118,  0.99881794452,      134.37289528650}, 
    {     0.00000000090,  0.41169241547,      318.67949151700}, 
    {     0.00000000107,  3.76840018527,      882.99203011160}, 
    {     0.00000000088,  5.47502707027,       70.63699698310}, 
    {     0.00000000088,  0.90750547659,      612.17681149370}, 
    {     0.00000000118,  3.14225356391,       37.16982779130}, 
    {     0.00000000106,  5.71907464992,     1101.02642796480}, 
    {     0.00000000092,  1.60540815321,      213.41097002260}, 
    {     0.00000000108,  2.73050081078,       73.08467753790}, 
    {     0.00000000091,  0.73982044423,      320.16396422530}, 
    {     0.00000000095,  3.37355805725,      190.66517818900}, 
    {     0.00000000090,  2.58787034269,       75.51531175020}, 
    {     0.00000000102,  2.92980359364,      533.46305966330}, 
    {     0.00000000092,  4.94283886398,     1055.44977692610}, 
    {     0.00000000113,  2.35541984980,      176.65053250850}, 
    {     0.00000000098,  6.04221644753,     1357.61455258110}, 
    {     0.00000000086,  2.90604124166,      234.49672408850}, 
    {     0.00000000085,  0.83669286935,      301.41401612960}, 
    {     0.00000000098,  0.85154630120,     1131.19458333990}, 
    {     0.00000000112,  0.92696951989,      590.83042499690}, 
    {     0.00000000112,  5.45918572076,      705.11765732570}, 
    {     0.00000000101,  4.26515214526,      195.40048060420}, 
    {     0.00000000102,  5.81318586612,     1396.22066897090}, 
    {     0.00000000084,  3.86583598631,      913.00012679230}, 
    {     0.00000000101,  0.14878503401,      702.14871190910}, 
    {     0.00000000098,  0.30973273548,       12.15766595670}, 
    {     0.00000000094,  5.53729042047,      178.13500521680}, 
    {     0.00000000090,  1.42741371964,      592.20302312060}, 
    {     0.00000000103,  3.56392656212,      487.10451133190}, 
    {     0.00000000114,  1.71224480179,      216.26804085460}, 
    {     0.00000000098,  6.12303086368,      575.26761613330}, 
    {     0.00000000082,  3.07432558693,      315.16802937920}, 
    {     0.00000000099,  0.95472771381,      176.38990007760}, 
    {     0.00000000114,  2.59949812888,       75.63293182920}, 
    {     0.00000000091,  5.72899997508,      196.88495331250}, 
    {     0.00000000098,  1.78363341484,      259.76951835400}, 
    {     0.00000000113,  1.70438642876,      150.93579525830}, 
    {     0.00000000081,  6.19017012933,      154.22906358060}, 
    {     0.00000000087,  2.67929938770,      539.09213395580}, 
    {     0.00000000080,  2.38043346629,     1053.75285589670}, 
    {     0.00000000084,  3.41034232685,     1349.75024605490}, 
    {     0.00000000088,  0.14553753672,     1062.35087560580}, 
    {     0.00000000092,  0.39976274896,      576.16138801060}, 
    {     0.00000000080,  6.14901515198,      515.46387109300}, 
    {     0.00000000084,  4.08795854193,      323.24478422650}, 
    {     0.00000000079,  3.44985050546,       71.70077856610}, 
    {     0.00000000103,  0.24719113679,      395.10562148700}, 
    {     0.00000000081,  2.61930932018,      623.22251175760}, 
    {     0.00000000079,  0.90143680512,      718.61103814440}, 
    {     0.00000000079,  2.22415153671,       74.04788538440}, 
    {     0.00000000092,  2.57503576494,      302.16477565500}, 
    {     0.00000000094,  4.13472590590,       64.25716316520}, 
    {     0.00000000090,  3.55225063298,      495.96316347190}, 
    {     0.00000000097,  5.23472340611,     1112.07212822870}, 
    {     0.00000000088,  5.01537308962,     1297.86319716750}, 
    {     0.00000000090,  1.32491876418,      724.83081326790}, 
    {     0.00000000106,  5.11210367902,       74.19089773630}, 
    {     0.00000000084,  2.69256231569,       27.74172667970}, 
    {     0.00000000083,  3.61925786724,      514.71311156760}, 
    {     0.00000000080,  4.91927269399,      347.36317418380}, 
    {     0.00000000077,  5.57198158633,       74.99404688840}, 
    {     0.00000000082,  2.22882573860,      469.88722005430}, 
    {     0.00000000089,  6.06487552896,       75.37229939830}, 
    {     0.00000000078,  3.25878759023,      394.35486196160}, 
    {     0.00000000104,  3.00022428298,      532.65991051120}, 
    {     0.00000000079,  4.37011833943,      396.54191008550}, 
    {     0.00000000103,  3.64560367439,      540.73666535850}, 
    {     0.00000000082,  4.43941220587,      432.81796599950}, 
    {     0.00000000101,  5.81737971094,      658.18966002270}, 
    {     0.00000000097,  2.59101775215,      690.13980379870}, 
    {     0.00000000082,  5.40861394405,      529.57909051000}, 
    {     0.00000000081,  2.52312280794,      384.95369310040}, 
    {     0.00000000076,  4.43418522057,      818.57480825200}, 
    {     0.00000000081,  0.95220782125,       73.66963287450}, 
    {     0.00000000087,  5.57227856660,     6284.56032269970}, 
    {     0.00000000094,  6.23547840274,      305.71867640820}, 
    {     0.00000000075,  4.35228806434,      112.49394307980}, 
    {     0.00000000096,  1.12909514630,      123.96033446900}, 
    {     0.00000000095,  2.73244270397,      934.19775544280}, 
    {     0.00000000097,  4.75415372291,       90.56260124640}, 
    {     0.00000000088,  5.23693832326,      434.67494572330}, 
    {     0.00000000076,  4.86126967725,       72.49397670690}, 
    {     0.00000000104,  5.37590823539,      543.91805909620}, 
    {     0.00000000091,  1.04794288604,      938.12990870590}, 
    {     0.00000000099,  2.19698635547,     1129.71011063160}, 
    {     0.00000000074,  3.27934639338,       89.00869256890}, 
    {     0.00000000100,  4.59916398079,      461.76228109720}, 
    {     0.00000000074,  5.63493926040,      233.53351624200}, 
    {     0.00000000074,  3.03606610688,     1531.55677210390}, 
    {     0.00000000099,  0.64774167845,      554.18186206740}, 
    {     0.00000000084,  3.14436294064,      370.04527554260}, 
    {     0.00000000077,  1.33778374453,     1022.31267613440}, 
    {     0.00000000081,  3.36096602483,      292.01284726840}, 
    {     0.00000000081,  4.15588604506,      432.22726516850}, 
    {     0.00000000074,  2.91359929208,      302.74973099160}, 
    {     0.00000000092,  5.11372489097,      912.78767847120}, 
    {     0.00000000073,  5.42920211703,      539.25219265020}, 
    {     0.00000000081,  5.25618688362,      311.65656724140}, 
    {     0.00000000082,  0.77806577612,      591.94239068970}, 
    {     0.00000000074,  0.16737907492,     1374.12926844310}, 
    {     0.00000000077,  3.20203134483,      527.24328453980}, 
    {     0.00000000081,  3.80903070318,       75.89356426010}, 
    {     0.00000000097,  4.67281118685,       16.98359109710}, 
    {     0.00000000077,  2.10541189728,      139.17188817650}, 
    {     0.00000000091,  4.67274741065,       84.86409098470}, 
    {     0.00000000098,  2.37249774428,      566.33952802410}, 
    {     0.00000000082,  2.16070758110,      529.80283967920}, 
    {     0.00000000072,  3.47566702228,     1086.04857443780}, 
    {     0.00000000092,  0.21608932947,     1297.06004801540}, 
    {     0.00000000093,  4.30059085579,      224.93549653290}, 
    {     0.00000000086,  3.02917299294,      126.50858876030}, 
    {     0.00000000079,  1.29816054687,      683.98946464440}, 
    {     0.00000000095,  2.46862196214,     9917.12809735840}, 
    {     0.00000000076,  2.48420575089,       37.71234451250}, 
    {     0.00000000097,  0.68274913158,      207.36120460480}, 
    {     0.00000000096,  4.16112194001,     1042.91960395390}, 
    {     0.00000000071,  6.04130834510,      223.45102382460}, 
    {     0.00000000076,  3.37676835926,      502.86426215160}, 
    {     0.00000000084,  3.24912782551,      628.96346063470}, 
    {     0.00000000073,  0.73113607430,      390.49214466770}, 
    {     0.00000000071,  4.64209882547,       72.54636633360}, 
    {     0.00000000073,  3.31815515601,      356.27001043360}, 
    {     0.00000000072,  2.60766427215,      602.02488310710}, 
    {     0.00000000074,  5.76600995478,     1424.53184462220}, 
    {     0.00000000074,  4.22820017237,     1274.96864748760}, 
    {     0.00000000074,  2.78217896807,     1522.20799286940}, 
    {     0.00000000074,  4.38596183925,     1372.64479573480}, 
};


static const struct vsop uranus_longitude_l1[LONG_L1] = {
    {    74.78159860910,  0.00000000000,        0.00000000000}, 
    {     0.00154332863,  5.24158770553,       74.78159856730}, 
    {     0.00024456474,  1.71260334156,        1.48447270830}, 
    {     0.00009258442,  0.42829732350,       11.04570026390}, 
    {     0.00008265977,  1.50218091379,       63.73589830340}, 
    {     0.00009150160,  1.41213765216,      149.56319713460}, 
    {     0.00003899108,  0.46483579160,        3.93215326310}, 
    {     0.00002277065,  4.17199181523,       76.26607127560}, 
    {     0.00001927470,  0.52976188479,        2.96894541660}, 
    {     0.00001232725,  1.58632088145,       70.84944530420}, 
    {     0.00000791201,  5.43640595978,        3.18139373770}, 
    {     0.00000766954,  1.99425624214,       73.29712585900}, 
    {     0.00000481813,  2.98574070918,       85.82729883120}, 
    {     0.00000449635,  4.14242946378,      138.51749687070}, 
    {     0.00000565091,  3.87400932383,      224.34479570190}, 
    {     0.00000426600,  4.73158166033,       71.81265315070}, 
    {     0.00000347745,  2.45368882357,        9.56122755560}, 
    {     0.00000332699,  2.55525645638,      148.07872442630}, 
    {     0.00000317054,  5.57858240166,       52.69019803950}, 
    {     0.00000179897,  5.68365861477,       12.53017297220}, 
    {     0.00000171119,  3.00040981195,       78.71375183040}, 
    {     0.00000205579,  2.36242761009,        2.44768055480}, 
    {     0.00000158038,  2.90930836614,        0.96320784650}, 
    {     0.00000189090,  4.20258063269,       56.62235130260}, 
    {     0.00000202696,  0.34360451816,      151.04766984290}, 
    {     0.00000154762,  5.59005854748,        4.45341812490}, 
    {     0.00000143472,  2.59047613814,       62.25142559510}, 
    {     0.00000151459,  2.93993108236,       77.75054398390}, 
    {     0.00000153561,  4.65220425575,       35.16409022120}, 
    {     0.00000121462,  4.14937021194,      127.47179660680}, 
    {     0.00000115538,  3.73245717203,       65.22037101170}, 
    {     0.00000102213,  4.18917777961,      145.63104387150}, 
    {     0.00000101894,  6.03382617339,        0.11187458460}, 
    {     0.00000088409,  3.99004756152,       18.15924726470}, 
    {     0.00000087591,  6.15639888455,      202.25339517410}, 
    {     0.00000080591,  2.64095955809,       22.09140052780}, 
    {     0.00000072047,  6.04586846354,       70.32818044240}, 
    {     0.00000068727,  4.05075598128,       77.96299230500}, 
    {     0.00000059329,  3.70581611259,       67.66805156650}, 
    {     0.00000047388,  3.54091852775,      351.81659230870}, 
    {     0.00000042712,  5.72066604839,        5.41662597140}, 
    {     0.00000044405,  5.91042456876,        7.11354700080}, 
    {     0.00000035784,  3.29585017124,        8.07675484730}, 
    {     0.00000035724,  3.32933903151,       71.60020482960}, 
    {     0.00000036081,  5.89881403933,       33.67961751290}, 
    {     0.00000041676,  4.94718694607,      222.86032299360}, 
    {     0.00000031215,  5.48938304422,      160.60889739850}, 
    {     0.00000031453,  5.62016551866,      984.60033162190}, 
    {     0.00000035171,  5.07842850969,       38.13303563780}, 
    {     0.00000035543,  0.05502439660,      299.12639426920}, 
    {     0.00000030810,  5.49604033608,       59.80374504030}, 
    {     0.00000028883,  4.51759500034,       84.34282612290}, 
    {     0.00000026705,  5.53637447019,      131.40394986990}, 
    {     0.00000029956,  1.66046193211,      447.79581952650}, 
    {     0.00000029206,  1.14722620686,      462.02291352810}, 
    {     0.00000025811,  4.99049651973,      137.03302416240}, 
    {     0.00000025474,  5.73884476629,      380.12776796000}, 
    {     0.00000021683,  2.80603505468,       69.36497259590}, 
    {     0.00000023016,  2.24983506758,      111.43016149680}, 
    {     0.00000019228,  3.55594434001,       54.17467074780}, 
    {     0.00000021696,  0.98872139680,      213.29909543800}, 
    {     0.00000019457,  1.86460184285,      108.46121608020}, 
    {     0.00000016140,  3.10230818045,       14.97785352700}, 
    {     0.00000013138,  1.95065801902,       87.31177153950}, 
    {     0.00000013904,  1.54207093820,      340.77089204480}, 
    {     0.00000013543,  4.38430774439,        5.93789083320}, 
    {     0.00000016493,  2.80104132725,      225.82926841020}, 
    {     0.00000013111,  5.88308816286,        6.21977512350}, 
    {     0.00000011811,  0.32606713574,       35.42472265210}, 
    {     0.00000012471,  0.32808369953,       51.20572533120}, 
    {     0.00000010981,  1.69299666770,       45.57665103870}, 
    {     0.00000010888,  5.97042047900,      265.98929347750}, 
    {     0.00000011433,  3.37877229066,       72.33391801250}, 
    {     0.00000012003,  3.60398124894,      269.92144674060}, 
    {     0.00000012936,  5.38263455371,      152.53214255120}, 
    {     0.00000011674,  1.74413259892,       79.23501669220}, 
    {     0.00000010446,  4.16878885118,       24.37902238820}, 
    {     0.00000010634,  3.06878261442,      284.14854074220}, 
    {     0.00000009674,  5.51339189448,      153.49535039770}, 
    {     0.00000009590,  0.49485192598,      209.36694217490}, 
    {     0.00000009269,  3.54589954480,       41.64449777560}, 
    {     0.00000009568,  5.59970406046,       82.85835341460}, 
    {     0.00000009310,  4.49468477512,       20.60692781950}, 
    {     0.00000009632,  1.00932793597,       68.84370773410}, 
    {     0.00000008745,  3.91021963381,       60.76695288680}, 
    {     0.00000010176,  3.51758777802,      529.69096509460}, 
    {     0.00000010048,  4.64919764888,       77.22927912210}, 
    {     0.00000008679,  1.96792212254,      195.13984817330}, 
    {     0.00000008387,  4.41835912213,      134.58534360760}, 
    {     0.00000007983,  5.35924979986,       75.74480641380}, 
    {     0.00000009263,  3.95182354442,       39.61750834610}, 
    {     0.00000007594,  5.77307721631,       73.81839072080}, 
    {     0.00000007713,  4.44174669087,       14.01464568050}, 
    {     0.00000007490,  2.17900285342,      145.10977900970}, 
    {     0.00000007873,  5.74835382023,      184.72728735580}, 
    {     0.00000007688,  2.41795807218,      146.59425171800}, 
    {     0.00000006438,  0.84540553248,       32.19514480460}, 
    {     0.00000006256,  2.17063033953,       74.89347315190}, 
    {     0.00000007937,  0.17172664970,      120.35824960600}, 
    {     0.00000007020,  4.12096862702,      191.20769491020}, 
    {     0.00000006862,  2.13341287037,      116.42609634290}, 
    {     0.00000005208,  3.11117214481,      106.97674337190}, 
    {     0.00000004811,  2.25140758551,       46.20979048510}, 
    {     0.00000004566,  3.45427623308,        0.75075952540}, 
    {     0.00000004473,  3.94632863732,        6.59228213900}, 
    {     0.00000005202,  1.15450734319,      112.91463420510}, 
    {     0.00000004323,  5.15540388592,      144.14657116320}, 
    {     0.00000004746,  5.18244413774,       81.00137369080}, 
    {     0.00000004232,  0.21921910020,       92.94084583200}, 
    {     0.00000004323,  2.52442111234,       99.16062095550}, 
    {     0.00000003879,  2.78711315762,      565.11568774670}, 
    {     0.00000004332,  5.91118459987,      221.37585028530}, 
    {     0.00000003801,  0.75135339336,       58.10682401090}, 
    {     0.00000003812,  3.23225846555,      479.28838891550}, 
    {     0.00000003656,  5.27986185627,       66.91729204110}, 
    {     0.00000003811,  4.92593102646,      125.98732389850}, 
    {     0.00000004172,  2.28697665136,      109.94568878850}, 
    {     0.00000003472,  2.95403921517,       74.66972398270}, 
    {     0.00000003501,  4.89811329155,       28.31117565130}, 
    {     0.00000004495,  4.15453337890,      344.70304530790}, 
    {     0.00000004258,  2.68419933901,        7.86430652620}, 
    {     0.00000003456,  0.02638325764,      140.00196957900}, 
    {     0.00000004181,  1.90641663083,      277.03499374140}, 
    {     0.00000003644,  5.32238666094,      408.43894361130}, 
    {     0.00000003205,  0.05087987138,      220.41264243880}, 
    {     0.00000003190,  1.48430670387,      128.95626931510}, 
    {     0.00000003901,  6.25926496244,        0.89377187730}, 
    {     0.00000003788,  0.03327505225,      152.74459087230}, 
    {     0.00000003200,  0.52009458683,        2.28762186040}, 
    {     0.00000003011,  1.93475294714,       80.19822453870}, 
    {     0.00000004054,  5.23320423468,       96.87299909510}, 
    {     0.00000003798,  4.97868021019,       36.64856292950}, 
    {     0.00000003895,  1.10480659598,      297.64192156090}, 
    {     0.00000003295,  4.80719384894,      422.66603761290}, 
    {     0.00000003192,  2.81905779664,      453.42489381900}, 
    {     0.00000002804,  6.19069392998,      135.54855145410}, 
    {     0.00000003469,  5.88266049174,       16.67477455640}, 
    {     0.00000002785,  1.35852942533,      404.50679034820}, 
    {     0.00000002892,  0.53676605577,      159.12442469020}, 
    {     0.00000003232,  1.54622440929,       23.57587323610}, 
    {     0.00000002958,  6.25751544465,      456.39383923560}, 
    {     0.00000002542,  1.85372598824,      490.33408917940}, 
    {     0.00000002547,  5.19766530615,      173.94221952280}, 
    {     0.00000003118,  6.10201148242,      142.44965013380}, 
    {     0.00000002762,  3.51066557656,      288.08069400530}, 
    {     0.00000002793,  3.90482859776,      358.93013930950}, 
    {     0.00000002958,  5.31404018803,       55.13787859430}, 
    {     0.00000002387,  1.31646029756,      211.81462272970}, 
    {     0.00000002413,  4.38647851761,       60.55450456570}, 
    {     0.00000002285,  2.31869038469,       31.49256938900}, 
    {     0.00000002366,  2.21968144549,       66.70484372000}, 
    {     0.00000002779,  4.72642945119,      186.21176006410}, 
    {     0.00000002270,  3.49350071105,      206.18554843720}, 
    {     0.00000002224,  0.41045917285,       81.37388070630}, 
    {     0.00000002196,  0.76298510234,       17.52610781830}, 
    {     0.00000002115,  3.58641580944,      333.65734504400}, 
    {     0.00000002575,  0.73175693995,      200.76892246580}, 
    {     0.00000002158,  2.61976125405,       13.33332212430}, 
    {     0.00000002041,  6.27470432139,       98.89998852460}, 
    {     0.00000002212,  2.36295359318,      347.88443904560}, 
    {     0.00000002183,  2.49004676830,       76.47851959670}, 
    {     0.00000002032,  1.67484911580,      235.39049596580}, 
    {     0.00000002226,  5.97327738150,     1514.29129671650}, 
    {     0.00000001858,  2.20139550864,      203.73786788240}, 
    {     0.00000002127,  2.52590780597,      373.90799283650}, 
    {     0.00000001865,  4.98207204280,        5.10780943070}, 
    {     0.00000001822,  2.44474441003,       55.65914345610}, 
    {     0.00000002037,  5.80360322726,      146.38180339690}, 
    {     0.00000001894,  4.32787921047,       49.50880430180}, 
    {     0.00000001841,  3.35082910127,      143.62530630140}, 
    {     0.00000001717,  3.95035994581,       24.11838995730}, 
    {     0.00000001684,  1.28092098597,      103.09277421860}, 
    {     0.00000002042,  5.48498644784,      373.01422095920}, 
    {     0.00000001720,  2.35857527806,        1.64453140270}, 
    {     0.00000001637,  2.99504798037,      391.17346822390}, 
    {     0.00000001605,  0.97423033751,      977.48678462110}, 
    {     0.00000001678,  4.97988460684,      387.24131496080}, 
    {     0.00000001520,  3.15010457259,        7.42236354150}, 
    {     0.00000001505,  2.89631333643,       19.64371997300}, 
    {     0.00000001574,  1.61508712335,      991.71387862270}, 
    {     0.00000001509,  3.32685682695,      909.81873305460}, 
    {     0.00000001674,  4.30506338212,      305.34616939270}, 
    {     0.00000001412,  4.53556726512,       81.89514556810}, 
    {     0.00000001375,  2.49046817916,      426.59819087600}, 
    {     0.00000001373,  5.75337637150,       19.12245511120}, 
    {     0.00000001340,  3.94224997586,       61.28821774860}, 
    {     0.00000001367,  4.39913585014,       27.08733537390}, 
    {     0.00000001385,  2.20171302118,       67.35923502580}, 
    {     0.00000001351,  4.36029315547,       70.11573212130}, 
    {     0.00000001304,  2.79975533399,       25.60286266560}, 
    {     0.00000001313,  3.73575380324,      628.85158605010}, 
    {     0.00000001338,  4.92441744235,      617.80588578620}, 
    {     0.00000001361,  0.72643457214,      546.95644048200}, 
    {     0.00000001273,  3.20493914871,       92.04707395470}, 
    {     0.00000001228,  5.92585113207,      415.55249061210}, 
    {     0.00000001242,  4.09549754457,      443.86366626340}, 
    {     0.00000001552,  5.05296247763,       10.29494073850}, 
    {     0.00000001210,  4.83276785889,      100.38446123290}, 
    {     0.00000001236,  4.30781434404,       67.88049988760}, 
    {     0.00000001173,  5.32389543861,       17.26547538740}, 
    {     0.00000001352,  3.55425818464,      230.56457082540}, 
    {     0.00000001437,  6.18417653960,       14.22709400160}, 
    {     0.00000001248,  0.16711396982,       29.20494752860}, 
    {     0.00000001169,  3.31424750673,       44.72531777680}, 
    {     0.00000001259,  1.88793196065,        0.65439130580}, 
    {     0.00000001311,  5.72020892609,      329.72519178090}, 
    {     0.00000001155,  2.04134400388,       30.71067209630}, 
    {     0.00000001101,  1.52350365110,      157.63995198190}, 
    {     0.00000001070,  2.89562175028,      543.02428721890}, 
    {     0.00000001121,  4.49662162318,      162.09337010680}, 
    {     0.00000001417,  2.04676765553,      181.75834193920}, 
    {     0.00000001258,  0.23621358146,      561.18353448360}, 
    {     0.00000001255,  1.26185998194,      155.78297225810}, 
    {     0.00000001040,  2.92622745204,      241.61027108930}, 
    {     0.00000001057,  3.26987298875,       28.57180808220}, 
    {     0.00000001122,  1.06425470357,       88.11492069160}, 
    {     0.00000001174,  5.28477501625,      300.61086697750}, 
    {     0.00000001229,  3.10355036800,      454.90936652730}, 
    {     0.00000001065,  0.29391740657,       58.31927233200}, 
    {     0.00000000960,  5.20482964431,       42.53826965290}, 
    {     0.00000001015,  4.37032150952,       13.49338081870}, 
    {     0.00000000982,  4.89018485859,      465.95506679120}, 
    {     0.00000000889,  3.09788627376,      110.20632121940}, 
    {     0.00000001102,  1.70896942951,       43.12897048390}, 
    {     0.00000000867,  4.22078052532,       20.44686912510}, 
    {     0.00000000897,  0.17179849041,      604.47256366190}, 
    {     0.00000000937,  0.09295857555,      273.10284047830}, 
    {     0.00000000829,  5.25281847981,      472.17484191470}, 
    {     0.00000000864,  4.75896276795,       33.13710079170}, 
    {     0.00000000877,  4.34963188052,      105.49227066360}, 
    {     0.00000000882,  0.53648210499,       80.71948940050}, 
    {     0.00000000966,  2.82647414963,       41.10198105440}, 
    {     0.00000000805,  3.53324257123,       39.35687591520}, 
    {     0.00000001087,  2.79964970506,       48.75804477640}, 
    {     0.00000000861,  4.69150625691,     1059.38193018920}, 
    {     0.00000000846,  1.65248920316,      554.06998748280}, 
    {     0.00000000891,  2.85006063739,       32.24332891440}, 
    {     0.00000000938,  1.90783329336,      259.50888592310}, 
    {     0.00000000876,  0.83921717739,        4.73530241520}, 
    {     0.00000000964,  1.56609888164,      227.31374111850}, 
    {     0.00000000707,  6.16918394997,        3.62333672240}, 
    {     0.00000000689,  0.64981694232,       88.79624424780}, 
    {     0.00000000830,  0.39292254125,      378.64329525170}, 
    {     0.00000000708,  5.49627918383,      558.00214074590}, 
    {     0.00000000787,  1.95609328363,       16.46232623530}, 
    {     0.00000000901,  1.83265668559,      258.87574647670}, 
    {     0.00000000786,  2.26160622294,       16.04163511000}, 
    {     0.00000000640,  4.15920545966,      141.69889060840}, 
    {     0.00000000672,  1.00050394612,      522.57741809380}, 
    {     0.00000000625,  5.82930714013,       89.75945209430}, 
    {     0.00000000619,  4.31040053451,      455.87257437380}, 
    {     0.00000000619,  4.77556598161,      453.94615868080}, 
    {     0.00000000666,  2.80724719033,       68.56182344380}, 
    {     0.00000000754,  4.22436113545,      486.40193591630}, 
    {     0.00000000665,  0.76096162867,      120.99138905240}, 
    {     0.00000000636,  5.75172788892,      119.50691634410}, 
    {     0.00000000595,  3.92147529886,       25.27279426550}, 
    {     0.00000000629,  1.79018286231,      440.68227252570}, 
    {     0.00000000719,  4.27356498725,       50.40257617910}, 
    {     0.00000000598,  0.22963306541,      117.91056905120}, 
    {     0.00000000706,  0.45734010595,      536.80451209540}, 
    {     0.00000000691,  6.14152846301,      258.02441321480}, 
    {     0.00000000588,  5.49070240544,      767.36908292080}, 
    {     0.00000000580,  0.63199844828,       95.38852638680}, 
    {     0.00000000739,  1.12968525578,      129.91947716160}, 
    {     0.00000000625,  0.60601623675,      152.01087768940}, 
    {     0.00000000684,  3.48227286692,      835.03713448730}, 
    {     0.00000000657,  0.08702780614,      114.39910691340}, 
    {     0.00000000611,  4.15939229748,      154.01661525950}, 
    {     0.00000000592,  1.93836345843,      106.27416795630}, 
    {     0.00000000528,  5.94363613171,      518.64526483070}, 
    {     0.00000000508,  1.43931861260,      218.92816973050}, 
    {     0.00000000505,  4.39807654944,      121.84272231430}, 
    {     0.00000000526,  0.30539221936,      756.32338265690}, 
    {     0.00000000492,  0.02248323091,      106.01353552540}, 
    {     0.00000000483,  0.69881109315,      264.50482076920}, 
    {     0.00000000483,  3.75988497269,      342.25536475310}, 
    {     0.00000000631,  2.23161489343,      218.40690486870}, 
    {     0.00000000587,  0.18557468628,      458.09076026500}, 
    {     0.00000000582,  6.01383333156,       47.06112374700}, 
    {     0.00000000566,  1.94388664070,      699.70103135430}, 
    {     0.00000000469,  2.00109396664,      275.55052103310}, 
    {     0.00000000469,  0.07681059856,      216.48048917570}, 
    {     0.00000000465,  4.97885409598,      458.84151979040}, 
    {     0.00000000450,  2.93431036585,      692.58748435350}, 
    {     0.00000000546,  2.42033648569,      339.28641933650}, 
    {     0.00000000543,  2.61197344648,      451.72797278960}, 
    {     0.00000000433,  2.83073694779,       32.71640966640}, 
    {     0.00000000497,  4.22419242251,      166.82867252200}, 
    {     0.00000000436,  2.61151229793,      685.47393735270}, 
    {     0.00000000501,  0.18281416681,      331.32153907380}, 
    {     0.00000000447,  4.51662766639,      142.14083359310}, 
    {     0.00000000419,  1.92148690569,      148.59998928810}, 
    {     0.00000000466,  0.96357284606,      760.25553592000}, 
    {     0.00000000554,  5.40626840965,      278.51946644970}, 
    {     0.00000000410,  4.63543184365,       40.16002506730}, 
    {     0.00000000445,  1.00949029615,      468.24268865160}, 
    {     0.00000000415,  5.68097308082,       92.30770638560}, 
    {     0.00000000397,  3.98144952901,       31.23193695810}, 
    {     0.00000000421,  5.47567810199,      104.00779795530}, 
    {     0.00000000403,  5.19002062014,       22.63391724900}, 
    {     0.00000000428,  3.48886570846,      180.27386923090}, 
    {     0.00000000412,  1.02398688739,      469.13646052890}, 
    {     0.00000000385,  3.79014384290,      450.97721326420}, 
    {     0.00000000424,  2.40007672624,       39.09624348430}, 
    {     0.00000000469,  2.07500437056,      296.15744885260}, 
    {     0.00000000367,  5.39331524988,      874.39401040250}, 
    {     0.00000000439,  5.75684595296,      183.24281464750}, 
    {     0.00000000440,  0.36377653224,      367.97010200330}, 
    {     0.00000000409,  4.21847176009,      181.05576652360}, 
    {     0.00000000367,  0.97754899263,      113.87784205160}, 
    {     0.00000000427,  3.32207591906,      114.94162363460}, 
    {     0.00000000361,  2.87413243525,      384.05992122310}, 
    {     0.00000000388,  5.44131901900,       26.02355379090}, 
    {     0.00000000361,  0.18436557007,      184.09414790940}, 
    {     0.00000000397,  4.78908291565,      268.43697403230}, 
    {     0.00000000375,  5.66345783317,      353.30106501700}, 
    {     0.00000000420,  3.84692082861,      254.94359321360}, 
    {     0.00000000356,  2.46750808920,      210.33015002140}, 
    {     0.00000000352,  0.12498542900,      142.66209845490}, 
    {     0.00000000367,  2.92343694465,      291.26208774300}, 
    {     0.00000000395,  4.76556910944,      109.31254934210}, 
    {     0.00000000349,  0.36426017087,       46.47042291600}, 
    {     0.00000000358,  2.75549207793,      295.19424100610}, 
    {     0.00000000412,  2.43295972201,      483.22054217860}, 
    {     0.00000000352,  1.24968669034,       97.41551581630}, 
    {     0.00000000442,  1.88628680612,      123.53964334370}, 
    {     0.00000000385,  3.26394747049,       79.44746501330}, 
    {     0.00000000406,  2.53016887679,      255.05546779820}, 
    {     0.00000000370,  4.14864372053,      282.66406803390}, 
    {     0.00000000347,  1.94674357151,      173.68158709190}, 
    {     0.00000000340,  1.34666529473,       34.20088237470}, 
    {     0.00000000372,  1.86781055268,      207.88246946660}, 
    {     0.00000000353,  2.64173549643,      162.89651925890}, 
    {     0.00000000370,  1.88031244406,      192.69216761850}, 
    {     0.00000000358,  4.58259834086,      149.67507171920}, 
    {     0.00000000369,  2.15183429984,      555.55446019110}, 
    {     0.00000000329,  0.89991825345,      905.88657979150}, 
    {     0.00000000322,  3.40065562385,      309.27832265580}, 
    {     0.00000000361,  2.19153615911,      562.66800719190}, 
    {     0.00000000335,  5.03174519184,      189.72322220190}, 
    {     0.00000000330,  4.23716253952,       75.30286342910}, 
    {     0.00000000366,  1.74722181798,      545.47196777370}, 
    {     0.00000000309,  4.56448107045,      350.33211960040}, 
    {     0.00000000317,  0.98960192882,      335.14181775230}, 
    {     0.00000000359,  5.76812959678,      916.93228005540}, 
    {     0.00000000295,  1.33754315792,      150.52640498110}, 
    {     0.00000000329,  1.82999432252,      706.81457835510}, 
    {     0.00000000305,  2.85945986335,      267.47376618580}, 
    {     0.00000000384,  4.25602154390,      198.32124191100}, 
    {     0.00000000296,  1.71949913712,      394.35486196160}, 
    {     0.00000000285,  0.69559923528,      312.45971639350}, 
    {     0.00000000311,  1.47691197071,      375.39246554480}, 
    {     0.00000000300,  5.09637659621,      376.19561469690}, 
    {     0.00000000359,  2.54874884785,     9988.94075050910}, 
    {     0.00000000283,  3.06617758884,      193.65537546500}, 
    {     0.00000000300,  5.92918355218,      124.29040286910}, 
    {     0.00000000290,  4.90172200702,      681.54178408960}, 
    {     0.00000000276,  4.65186244616,      332.17287233570}, 
    {     0.00000000285,  4.83606028553,       68.18931642830}, 
    {     0.00000000310,  3.75000484412,      253.57099508990}, 
    {     0.00000000294,  0.92142971378,      610.69233878540}, 
    {     0.00000000304,  5.60868779754,      271.40591944890}, 
    {     0.00000000300,  2.69560181941,      548.44091319030}, 
    {     0.00000000266,  1.57547215891,      369.08206769610}, 
    {     0.00000000270,  2.12904548682,      778.41478318470}, 
    {     0.00000000278,  3.38349188253,      346.39996633730}, 
    {     0.00000000288,  2.78232740152,     1812.52391910840}, 
    {     0.00000000274,  4.87674891727,      831.10498122420}, 
    {     0.00000000306,  5.15892626020,      285.63301345050}, 
    {     0.00000000260,  0.96985733128,       90.82323367730}, 
    {     0.00000000289,  3.99815838405,      451.94042111070}, 
    {     0.00000000341,  3.64288743408,      187.69623277240}, 
    {     0.00000000262,  5.24129067312,       94.42531854030}, 
    {     0.00000000255,  5.62384661312,      691.10301164520}, 
    {     0.00000000278,  2.76955704952,      657.16276170140}, 
    {     0.00000000314,  1.67255558365,       25.86349509650}, 
    {     0.00000000252,  1.20515376123,      134.06407874580}, 
    {     0.00000000270,  5.95275530301,      362.86229257260}, 
    {     0.00000000250,  1.95456834458,      497.44763618020}, 
    {     0.00000000331,  2.03342131435,      445.34813897170}, 
    {     0.00000000255,  1.82867847630,      180.16199464630}, 
    {     0.00000000280,  1.15414227570,      986.08480433020}, 
    {     0.00000000247,  5.99403279584,      147.11551657980}, 
    {     0.00000000291,  2.41284857072,      381.61224066830}, 
    {     0.00000000251,  5.78452299837,      630.33605875840}, 
    {     0.00000000297,  1.57774242730,       49.72125262290}, 
    {     0.00000000244,  4.93404985518,      107.49800823370}, 
    {     0.00000000249,  5.56442927723,      133.10087089930}, 
    {     0.00000000240,  2.84851616507,       44.09217833040}, 
    {     0.00000000248,  1.97763922353,      593.42686339800}, 
    {     0.00000000233,  0.16241159105,      124.50285119020}, 
    {     0.00000000238,  4.32756553343,      823.99143422340}, 
    {     0.00000000249,  2.86247259468,      226.79247625670}, 
    {     0.00000000261,  2.27307279052,       73.08467753790}, 
    {     0.00000000233,  2.20084586652,      894.84087952760}, 
    {     0.00000000229,  6.25761030439,      122.47586176070}, 
    {     0.00000000244,  5.76540363539,      135.33610313300}, 
    {     0.00000000306,  1.55862796103,     3191.04922956520}, 
    {     0.00000000288,  5.81344092057,      902.70518605380}, 
    {     0.00000000302,  5.76656213355,      219.89137757700}, 
    {     0.00000000247,  4.80414025079,      204.70107572890}, 
    {     0.00000000264,  0.01674333019,      294.67297614430}, 
    {     0.00000000245,  5.89659082767,      507.59956456680}, 
    {     0.00000000253,  0.68155783879,       43.28902917830}, 
    {     0.00000000259,  0.32203683101,      105.38039607900}, 
    {     0.00000000240,  1.26452469031,      559.69906177530}, 
    {     0.00000000237,  2.90263404390,      156.15547927360}, 
    {     0.00000000299,  3.55325980025,      397.39324334740}, 
    {     0.00000000244,  1.77778279869,      411.62033734900}, 
    {     0.00000000211,  0.44507165688,      597.35901666110}, 
    {     0.00000000209,  6.27743346360,      470.69036920640}, 
    {     0.00000000226,  2.98952389106,       25.12978191360}, 
    {     0.00000000293,  4.38922897212,      334.29048449040}, 
    {     0.00000000278,  3.98468567421,      477.80391620720}, 
    {     0.00000000206,  1.00879014806,      175.16605980020}, 
    {     0.00000000246,  2.70487794377,      227.52618943960}, 
    {     0.00000000237,  2.74955785783,      446.31134681820}, 
    {     0.00000000242,  1.94330310979,      228.27694896500}, 
    {     0.00000000220,  2.21089026533,      460.53844081980}, 
    {     0.00000000247,  3.57103210654,      372.42352012820}, 
    {     0.00000000279,  1.36587529090,      118.87377689770}, 
    {     0.00000000218,  3.73553622758,      449.28029223480}, 
    {     0.00000000216,  4.40353401308,    10063.72234907640}, 
    {     0.00000000230,  4.66927758266,      535.32003938710}, 
    {     0.00000000197,  2.20805345461,      473.06861379200}, 
    {     0.00000000229,  3.19497593427,      463.50738623640}, 
    {     0.00000000201,  5.34615119244,      480.77286162380}, 
    {     0.00000000193,  6.19624242617,      820.05928096030}, 
    {     0.00000000242,  1.96036147638,      988.53248488500}, 
    {     0.00000000190,  3.13243705705,      136.06981631590}, 
    {     0.00000000193,  4.07671504865,      143.93412284210}, 
    {     0.00000000202,  1.83078684759,       72.49397670690}, 
    {     0.00000000228,  3.34903021483,       95.97922721780}, 
    {     0.00000000208,  4.81133247680,      377.15882254340}, 
    {     0.00000000200,  0.61839132774,      236.87496867410}, 
    {     0.00000000235,  3.67436839260,      838.21852822500}, 
    {     0.00000000193,  2.15481780749,       74.94165726170}, 
    {     0.00000000187,  2.81310936004,      572.22923474750}, 
    {     0.00000000213,  1.61813973088,       42.58645376270}, 
    {     0.00000000207,  6.03862516281,      524.06189080210}, 
    {     0.00000000203,  5.04988207039,      457.87831194390}, 
    {     0.00000000203,  1.04758889180,      409.92341631960}, 
    {     0.00000000188,  2.07982369812,      976.00231191280}, 
    {     0.00000000210,  5.85785362661,      196.62432088160}, 
    {     0.00000000192,  3.61383045656,      993.19835133100}, 
    {     0.00000000209,  3.17349988395,     1587.58842257550}, 
    {     0.00000000184,  1.85051728434,      908.33426034630}, 
    {     0.00000000192,  5.22508686633,      450.45594840240}, 
    {     0.00000000180,  5.28618792228,       21.19762865050}, 
    {     0.00000000213,  5.58315163677,      538.28898480370}, 
    {     0.00000000176,  5.03044627538,      170.76082578510}, 
    {     0.00000000203,  5.80938645616,      624.91943278700}, 
    {     0.00000000180,  2.51990272877,     1044.40407666220}, 
    {     0.00000000179,  6.05515483358,      525.75881183150}, 
    {     0.00000000175,  1.96452622716,      520.12973753900}, 
    {     0.00000000199,  0.52713547564,      457.35704708210}, 
    {     0.00000000185,  2.84806428136,     1293.87865427770}, 
    {     0.00000000175,  1.54398883192,       15.19030184810}, 
    {     0.00000000174,  4.66394244510,     9947.05568153210}, 
    {     0.00000000185,  5.46594207951,      981.63138620530}, 
    {     0.00000000171,  5.67389958400,      114.13847448250}, 
    {     0.00000000182,  1.04937888593,      532.65991051120}, 
    {     0.00000000178,  0.51114232798,      172.19711438360}, 
    {     0.00000000169,  3.11804373794,      978.97125732940}, 
    {     0.00000000176,  3.74915826552,      920.86443331850}, 
    {     0.00000000180,  1.07197408549,      586.31331639720}, 
    {     0.00000000166,  1.93682971120,      449.49274055590}, 
    {     0.00000000169,  0.59306510650,      983.11585891360}, 
    {     0.00000000178,  3.92600130864,      621.73803904930}, 
    {     0.00000000174,  4.32154318588,      280.96714700450}, 
    {     0.00000000191,  0.54024876337,      424.15051032120}, 
    {     0.00000000189,  0.10678158871,      406.95447090300}, 
    {     0.00000000205,  0.52365243803,      653.98136796370}, 
    {     0.00000000168,  3.54301022192,      414.06801790380}, 
    {     0.00000000164,  1.87404692874,      171.65459766240}, 
    {     0.00000000185,  5.12729146826,      521.09294538550}, 
    {     0.00000000172,  0.39423495673,      328.24071907260}, 
    {     0.00000000172,  0.34793158963,     2349.32843120380}, 
    {     0.00000000180,  0.37372289781,      661.09491496450}, 
    {     0.00000000170,  5.79397661496,      421.18156490460}, 
    {     0.00000000159,  2.25636452893,      539.25219265020}, 
    {     0.00000000193,  1.65109454411,       91.45637312370}, 
    {     0.00000000166,  2.23770488518,       80.93193772160}, 
    {     0.00000000183,  3.00393831502,      286.59622129700}, 
    {     0.00000000166,  0.92209664824,      444.82687410990}, 
    {     0.00000000170,  0.39414968415,      417.03696332040}, 
    {     0.00000000162,  3.23150668653,      177.87437278590}, 
    {     0.00000000181,  4.00504030975,      388.72578766910}, 
    {     0.00000000153,  2.20468918814,      749.20983565610}, 
    {     0.00000000163,  3.73110852012,      216.92243216040}, 
    {     0.00000000212,  4.72231132508,      833.55266177900}, 
    {     0.00000000198,  6.18808818431,      346.18751801620}, 
    {     0.00000000177,  2.13790488243,       66.18357885820}, 
    {     0.00000000189,  0.61299968484,        8.59801970910}, 
    {     0.00000000213,  4.78511947496,     1190.03512053370}, 
    {     0.00000000164,  4.63818971012,      178.78939652260}, 
    {     0.00000000180,  1.93178230246,      248.72381809010}, 
    {     0.00000000158,  6.13942077870,      782.34693644780}, 
    {     0.00000000206,  0.89126217502,      260.99335863140}, 
    {     0.00000000176,  3.10085327825,      233.90602325750}, 
    {     0.00000000149,  3.08021590217,      386.34754308350}, 
    {     0.00000000150,  5.07107463854,      293.18850343600}, 
    {     0.00000000180,  6.18875446783,      526.72201967800}, 
    {     0.00000000164,  4.49121433201,      374.49869366750}, 
    {     0.00000000189,  1.11458377928,     6058.73105428950}, 
    {     0.00000000147,  3.01754055024,      670.49608382570}, 
    {     0.00000000168,  3.76331368122,       74.26033370550}, 
    {     0.00000000144,  2.31996539469,      294.30046912880}, 
    {     0.00000000167,  5.42159494206,       22.89454967990}, 
    {     0.00000000144,  5.81822380109,       75.53235809270}, 
    {     0.00000000157,  0.40945769911,       88.27497938600}, 
    {     0.00000000175,  4.53761339010,      184.98791978670}, 
    {     0.00000000153,  0.48543215446,      144.89733068860}, 
    {     0.00000000160,  2.60794839561,     1055.44977692610}, 
    {     0.00000000179,  4.37562818485,      764.18768918310}, 
    {     0.00000000143,  1.99453048271,      354.99798604640}, 
    {     0.00000000146,  5.69235209707,      600.54041039880}, 
    {     0.00000000177,  3.90369220329,     1396.22066897090}, 
    {     0.00000000193,  2.53328556634,      189.18070548070}, 
    {     0.00000000155,  4.70126542016,      306.83064210100}, 
    {     0.00000000154,  4.62870568847,      154.97982310600}, 
    {     0.00000000164,  6.02390945956,      383.09671337660}, 
    {     0.00000000187,  4.84188822839,      432.81796599950}, 
    {     0.00000000185,  3.23152718658,      683.98946464440}, 
    {     0.00000000152,  3.68645778017,     1439.50969814920}, 
    {     0.00000000135,  0.15727475865,      115.36231475990}, 
    {     0.00000000183,  3.27617419135,      331.20966448920}, 
    {     0.00000000143,  5.46480801118,       74.03083904190}, 
    {     0.00000000144,  4.20445488125,      237.67811782620}, 
    {     0.00000000133,  4.32149882064,      515.46387109300}, 
    {     0.00000000167,  4.08839285774,       74.52096613640}, 
    {     0.00000000136,  1.71455645866,       93.90405367850}, 
    {     0.00000000135,  3.91190350483,      232.42155054920}, 
    {     0.00000000162,  1.97790343838,      221.16340196420}, 
    {     0.00000000132,  2.82624616573,      385.75684225250}, 
    {     0.00000000160,  1.35947259957,      514.56435372130}, 
    {     0.00000000126,  3.80235468146,      491.81856188770}, 
    {     0.00000000141,  2.57765836949,      217.23124870110}, 
    {     0.00000000124,  0.99583430014,      541.53981451060}, 
    {     0.00000000167,  3.31937662997,     6133.51265285680}, 
    {     0.00000000141,  2.63411441470,      323.50541665740}, 
    {     0.00000000128,  5.08522615028,      448.68959140380}, 
    {     0.00000000157,  5.87846003299,      149.45132255000}, 
    {     0.00000000163,  6.15363541244,     3340.61242669980}, 
    {     0.00000000145,  0.39378158577,      357.44566660120}, 
    {     0.00000000130,  0.87687909058,      234.49672408850}, 
    {     0.00000000132,  4.39790926475,      686.95841006100}, 
    {     0.00000000118,  2.97103357711,      163.57784281510}, 
    {     0.00000000149,  3.44120121334,      371.52974825090}, 
    {     0.00000000128,  2.90544144809,      537.39521292640}, 
    {     0.00000000118,  4.93654738085,      771.30123618390}, 
    {     0.00000000138,  1.60526889301,      229.08009811710}, 
    {     0.00000000140,  0.19423734509,      103.35340664950}, 
    {     0.00000000138,  0.41128239547,      175.42669223110}, 
    {     0.00000000155,  3.98039100074,      302.09533968580}, 
    {     0.00000000127,  2.98955690598,      328.35259365720}, 
    {     0.00000000114,  2.38099208126,    10213.28554621100}, 
    {     0.00000000127,  2.38558048946,      842.15068148810}, 
    {     0.00000000131,  3.01936629873,      635.96513305090}, 
    {     0.00000000138,  0.44662144244,      838.96928775040}, 
    {     0.00000000129,  4.25513451348,      310.17209453310}, 
    {     0.00000000148,  0.41799256546,      594.91133610630}, 
    {     0.00000000149,  4.10330124264,       98.35747180340}, 
    {     0.00000000109,  2.88811868696,       42.06518890090}, 
    {     0.00000000109,  3.78134972711,       40.58071619260}, 
    {     0.00000000108,  2.55916728156,      199.28444975750}, 
    {     0.00000000125,  0.48048283452,      404.61866493280}, 
    {     0.00000000135,  2.87189439592,      167.72244439930}, 
    {     0.00000000118,  3.07682081692,      327.43756992050}, 
    {     0.00000000119,  5.78903264789,      260.36021918500}, 
    {     0.00000000111,  3.22737687538,       15.49911838880}, 
    {     0.00000000109,  6.27549146354,       73.13706716460}, 
    {     0.00000000109,  4.70945671248,       76.42612997000}, 
    {     0.00000000126,  2.80187501225,      639.89728631400}, 
    {     0.00000000105,  1.48616898015,      405.99126305650}, 
    {     0.00000000116,  4.85863853667,     1515.77576942480}, 
    {     0.00000000114,  2.76818793591,      291.70403072770}, 
    {     0.00000000107,  1.11766952208,      271.61836777000}, 
    {     0.00000000111,  2.87343319463,      410.13586464070}, 
    {     0.00000000111,  0.27810454195,      255.83736509090}, 
    {     0.00000000118,  5.07878372226,      679.25416222920}, 
    {     0.00000000099,  1.51676782588,      194.28851491140}, 
    {     0.00000000099,  1.03758417112,      703.63318461740}, 
    {     0.00000000130,  1.66666180289,      403.02231763990}, 
    {     0.00000000123,  6.11422629384,      365.00115658670}, 
    {     0.00000000104,  5.23997703346,      141.48644228730}, 
    {     0.00000000115,  6.23621039514,      214.78356814630}, 
    {     0.00000000096,  0.43424417561,       35.68535508300}, 
    {     0.00000000103,  1.06002930749,       76.37794586020}, 
    {     0.00000000104,  2.65595803065,      742.99006053260}, 
    {     0.00000000115,  5.22994397833,      511.53171782990}, 
    {     0.00000000094,  2.74704482453,       80.41067285980}, 
    {     0.00000000128,  0.77030466848,      806.72595883600}, 
    {     0.00000000110,  5.29132647687,      274.58731318660}, 
    {     0.00000000114,  2.57034943327,       69.15252427480}, 
    {     0.00000000095,  2.62834936080,      217.44369702220}, 
    {     0.00000000113,  0.31878741567,      228.79821382680}, 
    {     0.00000000094,  1.09024515607,      779.89925589300}, 
    {     0.00000000104,  1.63565182098,     1438.02522544090}, 
    {     0.00000000123,  0.31994708206,      205.22234059070}, 
    {     0.00000000089,  3.89481868438,      273.85360000370}, 
    {     0.00000000111,  5.23314925278,      115.88357962170}, 
    {     0.00000000090,  0.08059052014,      543.91805909620}, 
    {     0.00000000103,  1.50283068334,      316.39186965660}, 
    {     0.00000000114,  4.07327336627,      303.86169668440}, 
    {     0.00000000121,  2.40722327908,       89.00869256890}, 
    {     0.00000000085,  2.88976414563,      481.73606947030}, 
    {     0.00000000102,  3.36728076478,      731.94436026870}, 
    {     0.00000000095,  4.08252009963,      223.45102382460}, 
    {     0.00000000103,  1.17394061445,       30.59879751170}, 
    {     0.00000000082,  2.25221007280,      180.79513409270}, 
    {     0.00000000088,  3.62556128338,       73.18525127440}, 
    {     0.00000000106,  5.05420123147,       82.64590509350}, 
    {     0.00000000080,  6.02853833502,      343.21857259960}, 
    {     0.00000000086,  5.34618023172,      107.02492748170}, 
    {     0.00000000096,  1.56226891458,      768.85355562910}, 
    {     0.00000000090,  5.07169537551,      534.42626750980}, 
    {     0.00000000098,  4.92252492060,      582.38116313410}, 
    {     0.00000000101,  0.84796065157,      602.98809095360}, 
    {     0.00000000083,  1.65460715725,      753.14198891920}, 
    {     0.00000000078,  5.51638181769,       74.73341445750}, 
    {     0.00000000093,  5.84400145456,      774.48262992160}, 
    {     0.00000000089,  0.95563866426,        6.90109867970}, 
    {     0.00000000087,  4.41987284863,      552.58551477450}, 
    {     0.00000000103,  4.60346642754,      370.93904741990}, 
    {     0.00000000077,  4.77404419830,      242.50404296660}, 
    {     0.00000000075,  3.39192079177,      118.02244363580}, 
    {     0.00000000076,  1.05747326519,       79.88940799800}, 
    {     0.00000000079,  3.54181953824,      758.77106321170}, 
    {     0.00000000074,  3.98963783883,      301.41401612960}, 
    {     0.00000000078,  1.82705732908,       74.82978267710}, 
    {     0.00000000074,  1.08013205637,      107.91869935900}, 
    {     0.00000000074,  5.37621944193,      473.65931462300}, 
    {     0.00000000078,  2.52470639403,      103.98654609590}, 
    {     0.00000000073,  1.33099035143,      117.31986822020}, 
    {     0.00000000073,  3.86314726423,       47.69426319340}, 
    {     0.00000000079,  3.79190807969,      243.98851567490}, 
    {     0.00000000079,  1.85527149881,      495.96316347190}, 
    {     0.00000000083,  4.63377403454,      147.86627610520}, 
    {     0.00000000075,  3.25894652055,      195.77298761970}, 
    {     0.00000000083,  2.51263535489,       73.88782669000}, 
    {     0.00000000076,  0.65318077927,     6283.07584999140}, 
    {     0.00000000074,  2.98225723938,       77.06922042770}, 
    {     0.00000000095,  1.54407527959,      210.85141488320}, 
    {     0.00000000072,  5.49406740322,       74.62153987290}, 
    {     0.00000000083,  3.32264980311,     1366.21257229020}, 
    {     0.00000000074,  3.65696853700,       69.67378913660}, 
    {     0.00000000074,  3.23127044816,      208.84567731310}, 
    {     0.00000000080,  4.36056904242,     1662.96072197380}, 
    {     0.00000000073,  5.26531290370,      130.44074202340}, 
    {     0.00000000071,  4.81609825971,      321.12717207180}, 
    {     0.00000000076,  2.51848136880,       84.93352695390}, 
    {     0.00000000097,  2.40670778188,       75.67537044460}, 
    {     0.00000000078,  5.68434801179,      221.89711514710}, 
};


static const struct vsop uranus_longitude_l2[LONG_L2] = {
    {     0.00002349469,  2.26708640433,       74.78159856730}, 
    {     0.00000848806,  3.14159265359,        0.00000000000}, 
    {     0.00000768983,  4.52562378749,       11.04570026390}, 
    {     0.00000551555,  3.25819322040,       63.73589830340}, 
    {     0.00000541559,  2.27572631399,        3.93215326310}, 
    {     0.00000529491,  4.92336172394,        1.48447270830}, 
    {     0.00000257527,  3.69060540044,        3.18139373770}, 
    {     0.00000182036,  6.21866555925,       70.84944530420}, 
    {     0.00000184429,  5.05954505833,      149.56319713460}, 
    {     0.00000049505,  6.03085160423,       56.62235130260}, 
    {     0.00000053456,  1.45801353517,       76.26607127560}, 
    {     0.00000038334,  1.78433163102,       52.69019803950}, 
    {     0.00000044885,  3.90644983662,        2.44768055480}, 
    {     0.00000044623,  0.81232539761,       85.82729883120}, 
    {     0.00000037373,  4.46132739805,        2.96894541660}, 
    {     0.00000033044,  0.86461989031,        9.56122755560}, 
    {     0.00000024305,  2.10670976428,       18.15924726470}, 
    {     0.00000029250,  5.09724793503,       73.29712585900}, 
    {     0.00000022309,  4.81978108793,       78.71375183040}, 
    {     0.00000022283,  5.99230347559,      138.51749687070}, 
    {     0.00000017230,  2.53731197138,      145.63104387150}, 
    {     0.00000021416,  2.39692592406,       77.96299230500}, 
    {     0.00000015114,  1.43013979998,      224.34479570190}, 
    {     0.00000016756,  3.46508324378,       12.53017297220}, 
    {     0.00000012003,  0.01666017885,       22.09140052780}, 
    {     0.00000010497,  4.47250656935,       62.25142559510}, 
    {     0.00000010943,  0.08477481315,      127.47179660680}, 
    {     0.00000008683,  4.25475342937,        7.11354700080}, 
    {     0.00000010478,  5.16510093405,       71.60020482960}, 
    {     0.00000007208,  1.25579094145,        5.41662597140}, 
    {     0.00000008383,  5.49939298653,       67.66805156650}, 
    {     0.00000006079,  5.44023447414,       65.22037101170}, 
    {     0.00000005718,  1.83543074459,      202.25339517410}, 
    {     0.00000006109,  3.36329480272,      447.79581952650}, 
    {     0.00000006002,  5.72509014963,      462.02291352810}, 
    {     0.00000005684,  4.14533132422,      151.04766984290}, 
    {     0.00000005091,  3.52369031374,       59.80374504030}, 
    {     0.00000005147,  1.05915315998,      131.40394986990}, 
    {     0.00000004917,  3.38475371297,        4.45341812490}, 
    {     0.00000004818,  1.20436413021,       71.81265315070}, 
    {     0.00000004697,  6.13059120042,      148.07872442630}, 
    {     0.00000003950,  0.69544777458,       77.75054398390}, 
    {     0.00000003655,  1.75283968054,      351.81659230870}, 
    {     0.00000003144,  3.30914690507,      160.60889739850}, 
    {     0.00000003170,  6.13784634729,       77.22927912210}, 
    {     0.00000003149,  3.83524373649,       45.57665103870}, 
    {     0.00000003616,  4.56973348262,      454.90936652730}, 
    {     0.00000002673,  1.05631111199,       69.36497259590}, 
    {     0.00000002660,  5.35501232753,      269.92144674060}, 
    {     0.00000002315,  2.61423820966,       84.34282612290}, 
    {     0.00000002258,  5.07517615514,       14.97785352700}, 
    {     0.00000002249,  1.37812609668,      284.14854074220}, 
    {     0.00000002072,  4.34966778360,      984.60033162190}, 
    {     0.00000002101,  2.31175293338,      120.35824960600}, 
    {     0.00000001808,  0.52249831108,      137.03302416240}, 
    {     0.00000001849,  5.69618054054,       54.17467074780}, 
    {     0.00000001983,  3.87043200848,      195.13984817330}, 
    {     0.00000001632,  5.07069503204,      209.36694217490}, 
    {     0.00000001578,  2.91229378751,       51.20572533120}, 
    {     0.00000001722,  6.25913624391,       41.64449777560}, 
    {     0.00000001656,  6.26113629911,      277.03499374140}, 
    {     0.00000001822,  1.24304611018,       35.16409022120}, 
    {     0.00000001345,  2.04057300383,       70.32818044240}, 
    {     0.00000001253,  2.65486278486,      134.58534360760}, 
    {     0.00000001239,  4.63255501972,       92.94084583200}, 
    {     0.00000001369,  6.08201469405,       87.31177153950}, 
    {     0.00000001277,  5.87454788183,       60.55450456570}, 
    {     0.00000001281,  2.51504858314,       72.33391801250}, 
    {     0.00000001250,  1.09008933023,      213.29909543800}, 
    {     0.00000001055,  4.00338488062,      299.12639426920}, 
    {     0.00000001133,  4.64929170681,      152.74459087230}, 
    {     0.00000001082,  1.07336611951,      153.49535039770}, 
    {     0.00000001037,  4.82158521698,      116.42609634290}, 
    {     0.00000000863,  3.56774115747,      340.77089204480}, 
    {     0.00000000957,  2.11521253777,       20.60692781950}, 
    {     0.00000000952,  2.47170644510,      380.12776796000}, 
    {     0.00000000836,  6.12347738126,       49.50880430180}, 
    {     0.00000000808,  0.29677438017,      191.20769491020}, 
    {     0.00000000808,  4.08162792952,       14.22709400160}, 
    {     0.00000000792,  6.17091063120,      344.70304530790}, 
    {     0.00000000791,  2.37030711541,       58.10682401090}, 
    {     0.00000000914,  2.11419968166,       14.01464568050}, 
    {     0.00000000788,  0.75228496417,      408.43894361130}, 
    {     0.00000000763,  2.38121244677,      222.86032299360}, 
    {     0.00000000891,  2.04340711828,      265.98929347750}, 
    {     0.00000000730,  3.10064098912,      422.66603761290}, 
    {     0.00000000765,  0.77723827220,       76.47851959670}, 
    {     0.00000000645,  2.77108845143,       96.87299909510}, 
    {     0.00000000745,  2.35633194869,      358.93013930950}, 
    {     0.00000000620,  1.98188971784,       33.67961751290}, 
    {     0.00000000655,  3.85415850280,       16.67477455640}, 
    {     0.00000000608,  0.15790159997,       28.31117565130}, 
    {     0.00000000587,  1.09637968292,       55.13787859430}, 
    {     0.00000000617,  1.70137701054,        8.07675484730}, 
    {     0.00000000645,  5.17890892522,       23.57587323610}, 
    {     0.00000000589,  3.39293635432,      144.14657116320}, 
    {     0.00000000598,  3.77279530334,       80.19822453870}, 
    {     0.00000000562,  4.90624120147,       35.42472265210}, 
    {     0.00000000587,  4.33026772564,       29.20494752860}, 
    {     0.00000000474,  0.88680405794,      565.11568774670}, 
    {     0.00000000477,  3.44956358856,      128.95626931510}, 
    {     0.00000000432,  1.05836005695,       19.64371997300}, 
    {     0.00000000480,  5.27492573341,      206.18554843720}, 
    {     0.00000000454,  6.05565972578,       70.11573212130}, 
    {     0.00000000413,  0.42595505653,      225.82926841020}, 
    {     0.00000000458,  5.47151191138,      333.65734504400}, 
    {     0.00000000528,  2.27025758420,       38.13303563780}, 
    {     0.00000000447,  0.91893151458,      373.01422095920}, 
    {     0.00000000511,  1.59897693264,      142.44965013380}, 
    {     0.00000000420,  5.77293204332,      146.59425171800}, 
    {     0.00000000383,  1.91679738697,        5.62907429250}, 
    {     0.00000000382,  3.04339660220,      152.53214255120}, 
    {     0.00000000418,  1.05236603665,      125.98732389850}, 
    {     0.00000000372,  2.85710020233,      200.76892246580}, 
    {     0.00000000496,  1.92980650193,      415.55249061210}, 
    {     0.00000000370,  3.22212427220,      387.24131496080}, 
    {     0.00000000387,  2.79134085638,       81.89514556810}, 
    {     0.00000000357,  4.64158965749,      220.41264243880}, 
    {     0.00000000345,  2.98021540638,      429.77958461370}, 
    {     0.00000000335,  5.29062985955,       13.33332212430}, 
    {     0.00000000320,  1.62674909598,       99.16062095550}, 
    {     0.00000000320,  0.74685145174,      347.88443904560}, 
    {     0.00000000288,  2.44437048636,      546.95644048200}, 
    {     0.00000000275,  0.62680026669,       31.49256938900}, 
    {     0.00000000281,  6.04447663913,      456.39383923560}, 
    {     0.00000000270,  2.79378345550,      977.48678462110}, 
    {     0.00000000268,  4.64955164739,      230.56457082540}, 
    {     0.00000000271,  0.59225635449,     1894.41906467650}, 
    {     0.00000000263,  3.49309481771,      440.68227252570}, 
    {     0.00000000253,  1.90016027905,      129.91947716160}, 
    {     0.00000000271,  4.82853730065,      561.18353448360}, 
    {     0.00000000259,  0.27190856999,      373.90799283650}, 
    {     0.00000000314,  1.47136601206,       24.37902238820}, 
    {     0.00000000261,  0.09830739366,      991.71387862270}, 
    {     0.00000000235,  5.13968661425,      479.28838891550}, 
    {     0.00000000231,  1.38106363280,      391.17346822390}, 
    {     0.00000000230,  4.81251240097,      159.12442469020}, 
    {     0.00000000305,  4.45518458920,      112.91463420510}, 
    {     0.00000000311,  4.82238770299,      108.46121608020}, 
    {     0.00000000233,  4.25631985431,      365.90067395840}, 
    {     0.00000000261,  1.59315260466,       17.26547538740}, 
    {     0.00000000233,  2.83623217386,      376.19561469690}, 
    {     0.00000000294,  1.66582514618,      124.29040286910}, 
    {     0.00000000213,  1.07884329091,      288.08069400530}, 
    {     0.00000000207,  5.03566431809,      297.64192156090}, 
    {     0.00000000201,  1.68940522081,      135.54855145410}, 
    {     0.00000000231,  2.24878224928,      152.01087768940}, 
    {     0.00000000216,  6.19661665314,      490.33408917940}, 
    {     0.00000000236,  4.93084016804,      458.09076026500}, 
    {     0.00000000225,  0.22664678208,      254.94359321360}, 
    {     0.00000000213,  0.12942394964,      411.62033734900}, 
    {     0.00000000193,  3.70727194044,      353.30106501700}, 
    {     0.00000000214,  2.37863059014,      184.09414790940}, 
    {     0.00000000211,  2.16158427984,      162.09337010680}, 
    {     0.00000000208,  3.81481624262,      258.87574647670}, 
    {     0.00000000188,  0.23642242835,       74.89347315190}, 
    {     0.00000000229,  5.33297149225,      827.17282796110}, 
    {     0.00000000196,  3.41624470471,      173.94221952280}, 
    {     0.00000000186,  1.25407717254,       74.66972398270}, 
    {     0.00000000219,  1.22774377372,      305.34616939270}, 
    {     0.00000000184,  0.07653324668,      969.62247809490}, 
    {     0.00000000181,  5.50268986350,      983.11585891360}, 
    {     0.00000000234,  1.43222813448,      146.38180339690}, 
    {     0.00000000191,  4.02315888568,      774.48262992160}, 
    {     0.00000000176,  0.36587651982,      100.38446123290}, 
    {     0.00000000174,  0.35464783229,      354.99798604640}, 
    {     0.00000000174,  2.81203626850,      140.00196957900}, 
    {     0.00000000201,  1.04955848325,      316.39186965660}, 
    {     0.00000000172,  0.67782414229,      167.72244439930}, 
    {     0.00000000175,  5.90738517293,      235.39049596580}, 
    {     0.00000000171,  1.90443657327,       33.13710079170}, 
    {     0.00000000174,  5.60867787733,      469.13646052890}, 
    {     0.00000000179,  2.38892600195,      486.40193591630}, 
    {     0.00000000171,  1.27067391131,      291.26208774300}, 
    {     0.00000000175,  3.15884013286,       66.91729204110}, 
    {     0.00000000209,  5.78799629527,      111.43016149680}, 
    {     0.00000000171,  5.43315629209,       42.53826965290}, 
    {     0.00000000203,  1.58369655553,      298.23262239190}, 
    {     0.00000000166,  4.78948867256,     1514.29129671650}, 
    {     0.00000000174,  0.56063488876,      521.09294538550}, 
    {     0.00000000205,  3.48282420941,      404.50679034820}, 
    {     0.00000000171,  2.91325849153,      535.32003938710}, 
    {     0.00000000177,  0.86306620537,      472.17484191470}, 
    {     0.00000000184,  2.92293138603,      881.50755740330}, 
    {     0.00000000166,  4.78927133151,      109.94568878850}, 
    {     0.00000000188,  0.57920908215,      369.08206769610}, 
    {     0.00000000155,  1.28199332469,       89.75945209430}, 
    {     0.00000000156,  2.77376676007,      141.69889060840}, 
    {     0.00000000163,  6.18149717003,     1357.61455258110}, 
    {     0.00000000154,  6.13255592810,      218.92816973050}, 
    {     0.00000000151,  2.69773648190,      132.88842257820}, 
    {     0.00000000164,  5.23606804941,     1094.80665284130}, 
    {     0.00000000157,  3.34238375767,      268.43697403230}, 
    {     0.00000000169,  1.82777920099,      398.28701522470}, 
    {     0.00000000178,  3.45386061878,      685.47393735270}, 
    {     0.00000000148,  2.98873276090,      211.81462272970}, 
    {     0.00000000155,  1.72159478356,      679.25416222920}, 
    {     0.00000000148,  0.95649146876,      867.28046340170}, 
    {     0.00000000191,  3.62538073529,      554.06998748280}, 
    {     0.00000000178,  2.10923963877,      661.09491496450}, 
    {     0.00000000135,  6.06368720482,      980.66817835880}, 
    {     0.00000000135,  5.96857483510,       91.45637312370}, 
    {     0.00000000130,  4.36914393286,      273.10284047830}, 
    {     0.00000000153,  3.49640803991,      228.27694896500}, 
    {     0.00000000130,  2.72570287614,      522.57741809380}, 
    {     0.00000000143,  5.02900860888,      536.80451209540}, 
    {     0.00000000126,  1.93883254906,      909.81873305460}, 
    {     0.00000000127,  1.78014700856,      205.43478891180}, 
    {     0.00000000140,  0.83038018169,      535.91074021810}, 
    {     0.00000000127,  5.06009501625,      275.55052103310}, 
    {     0.00000000129,  3.77988686343,      483.22054217860}, 
    {     0.00000000118,  5.83292150811,      703.63318461740}, 
    {     0.00000000130,  4.52188865601,      216.48048917570}, 
    {     0.00000000117,  3.97236048113,      135.33610313300}, 
    {     0.00000000110,  4.10507371008,      433.71173787680}, 
    {     0.00000000113,  1.51901732866,      384.05992122310}, 
    {     0.00000000107,  0.99334138425,      295.19424100610}, 
    {     0.00000000131,  3.98415139373,       73.08467753790}, 
    {     0.00000000108,  4.07981007546,      203.73786788240}, 
    {     0.00000000109,  3.04776608048,      300.61086697750}, 
    {     0.00000000109,  1.22958797958,      525.75881183150}, 
    {     0.00000000131,  2.99178036398,       75.74480641380}, 
    {     0.00000000103,  4.46390192594,      579.34278174830}, 
    {     0.00000000109,  1.99182565930,       60.76695288680}, 
    {     0.00000000121,  0.73822914508,      248.72381809010}, 
    {     0.00000000106,  2.04571727537,     2043.98226181110}, 
    {     0.00000000102,  4.88960169615,      831.10498122420}, 
    {     0.00000000099,  3.81282044986,       73.81839072080}, 
    {     0.00000000094,  5.78362714209,      350.33211960040}, 
    {     0.00000000114,  2.09397520178,      278.51946644970}, 
    {     0.00000000089,  5.90655259674,       79.23501669220}, 
    {     0.00000000097,  2.67425330058,      221.37585028530}, 
    {     0.00000000089,  6.25528198072,      234.49672408850}, 
    {     0.00000000085,  0.13307608646,      639.89728631400}, 
    {     0.00000000090,  5.53000751155,      827.92358748650}, 
    {     0.00000000080,  5.34711145866,      181.05576652360}, 
    {     0.00000000079,  0.95205771963,      426.59819087600}, 
    {     0.00000000084,  3.97140652554,      336.83873878170}, 
    {     0.00000000080,  5.24056087129,      504.56118318100}, 
    {     0.00000000078,  2.26526379571,      450.97721326420}, 
    {     0.00000000081,  1.32480509617,       89.00869256890}, 
    {     0.00000000108,  1.50473495412,       25.27279426550}, 
    {     0.00000000077,  0.31815291828,      447.20511869550}, 
    {     0.00000000081,  4.64364910706,     1208.05135544650}, 
    {     0.00000000077,  5.90631938483,      515.46387109300}, 
    {     0.00000000095,  5.82143764459,      453.42489381900}, 
    {     0.00000000077,  3.56359211434,       82.85835341460}, 
    {     0.00000000093,  0.38301745790,      699.70103135430}, 
    {     0.00000000076,  4.16820366863,       95.38852638680}, 
    {     0.00000000076,  1.49535232496,      849.26422848890}, 
    {     0.00000000099,  2.79074529357,      184.72728735580}, 
    {     0.00000000076,  6.13770068285,      123.53964334370}, 
    {     0.00000000104,  6.25653942640,      443.86366626340}, 
    {     0.00000000073,  3.57936315445,      180.16199464630}, 
    {     0.00000000083,  1.56888177127,      306.83064210100}, 
    {     0.00000000087,  0.74135830037,      227.52618943960}, 
    {     0.00000000079,  1.91762400825,      901.95442652840}, 
    {     0.00000000089,  3.64708770174,      810.65811209910}, 
    {     0.00000000084,  1.50560186863,      419.48464387520}, 
};


static const struct vsop uranus_longitude_l3[LONG_L3] = {
    {     0.00000122192,  0.02112102225,       74.78159856730}, 
    {     0.00000068195,  4.12138633187,        3.93215326310}, 
    {     0.00000052729,  2.38808499397,       11.04570026390}, 
    {     0.00000043714,  2.95937380925,        1.48447270830}, 
    {     0.00000045405,  2.04405402149,        3.18139373770}, 
    {     0.00000024903,  4.88680075600,       63.73589830340}, 
    {     0.00000021004,  4.54879176205,       70.84944530420}, 
    {     0.00000008985,  1.58255257968,       56.62235130260}, 
    {     0.00000009158,  2.57000447334,      149.56319713460}, 
    {     0.00000010361,  0.00000000000,        0.00000000000}, 
    {     0.00000004261,  0.22780215466,       18.15924726470}, 
    {     0.00000003625,  5.38367304590,       76.26607127560}, 
    {     0.00000003244,  5.01058611704,       85.82729883120}, 
    {     0.00000003488,  4.13160885916,       52.69019803950}, 
    {     0.00000003570,  0.94065081296,       77.96299230500}, 
    {     0.00000002738,  0.40346535540,       78.71375183040}, 
    {     0.00000002233,  0.87157987676,      145.63104387150}, 
    {     0.00000001948,  2.67957461817,        7.11354700080}, 
    {     0.00000002120,  5.64073933192,        9.56122755560}, 
    {     0.00000001566,  5.46300116637,       73.29712585900}, 
    {     0.00000001308,  1.25835033636,       12.53017297220}, 
    {     0.00000001616,  0.49324165265,       71.60020482960}, 
    {     0.00000001230,  3.93093451148,       22.09140052780}, 
    {     0.00000000906,  2.17573166732,      127.47179660680}, 
    {     0.00000000811,  5.08300105756,      447.79581952650}, 
    {     0.00000000800,  4.00214562488,      462.02291352810}, 
    {     0.00000000718,  0.34600103024,        5.62907429250}, 
    {     0.00000000718,  1.19635899416,      138.51749687070}, 
    {     0.00000000680,  2.94444506110,      131.40394986990}, 
    {     0.00000000581,  5.14726797687,      224.34479570190}, 
    {     0.00000000406,  4.33376335103,      120.35824960600}, 
    {     0.00000000376,  0.75784834422,      269.92144674060}, 
    {     0.00000000347,  5.94165731686,      284.14854074220}, 
    {     0.00000000345,  3.05968942771,      561.18353448360}, 
    {     0.00000000343,  4.01891371998,      546.95644048200}, 
    {     0.00000000376,  5.95844060660,       45.57665103870}, 
    {     0.00000000334,  1.61761448243,      151.04766984290}, 
    {     0.00000000284,  1.12863896480,      134.58534360760}, 
    {     0.00000000278,  3.43135401420,      202.25339517410}, 
    {     0.00000000374,  3.31569280991,      152.74459087230}, 
    {     0.00000000268,  3.24741531524,      536.80451209540}, 
    {     0.00000000358,  1.10916640253,      333.65734504400}, 
    {     0.00000000355,  2.95198893484,      153.49535039770}, 
    {     0.00000000236,  4.64852235589,      387.24131496080}, 
    {     0.00000000223,  5.11416165165,      347.88443904560}, 
    {     0.00000000245,  5.19436628400,       81.89514556810}, 
    {     0.00000000228,  3.74138931830,       87.31177153950}, 
    {     0.00000000226,  4.29682981394,       77.75054398390}, 
    {     0.00000000234,  5.80540756495,       67.66805156650}, 
    {     0.00000000288,  5.72707827196,      195.13984817330}, 
    {     0.00000000201,  1.74602592032,      213.29909543800}, 
    {     0.00000000204,  5.81145810966,      373.01422095920}, 
    {     0.00000000187,  2.35512484122,      124.29040286910}, 
    {     0.00000000185,  3.12619552579,      148.07872442630}, 
    {     0.00000000170,  1.91718323832,       59.80374504030}, 
    {     0.00000000165,  3.46463258943,      209.36694217490}, 
    {     0.00000000171,  6.12119673115,      351.81659230870}, 
    {     0.00000000191,  5.50650694321,       73.08467753790}, 
    {     0.00000000154,  2.74592153459,       92.94084583200}, 
    {     0.00000000187,  2.88710400041,      146.38180339690}, 
    {     0.00000000142,  3.34786225013,       72.33391801250}, 
    {     0.00000000130,  1.06884333081,       84.34282612290}, 
    {     0.00000000156,  1.27379656026,      160.60889739850}, 
    {     0.00000000112,  2.52374006072,       62.25142559510}, 
    {     0.00000000096,  2.43808447701,      288.08069400530}, 
    {     0.00000000104,  4.80942792304,      144.14657116320}, 
    {     0.00000000090,  4.64083951502,      411.62033734900}, 
    {     0.00000000080,  3.36996054975,      497.44763618020}, 
    {     0.00000000085,  2.90593266919,      483.22054217860}, 
};


static const struct vsop uranus_longitude_l4[LONG_L4] = {
    {     0.00000005536,  4.57721551627,       74.78159856730}, 
    {     0.00000003183,  0.34467460171,       11.04570026390}, 
    {     0.00000001207,  3.40871377105,       56.62235130260}, 
    {     0.00000000634,  4.65445189526,       18.15924726470}, 
    {     0.00000000359,  0.67024156853,      149.56319713460}, 
    {     0.00000000247,  2.07784257495,       63.73589830340}, 
    {     0.00000000109,  2.75514337970,       85.82729883120}, 
    {     0.00000000092,  5.02598538441,      131.40394986990}, 
};


static const struct vsop uranus_latitude_b0[LAT_B0] = {
    {     0.01346277648,  2.61877810547,       74.78159856730}, 
    {     0.00062341400,  5.08111189648,      149.56319713460}, 
    {     0.00061601196,  3.14159265359,        0.00000000000}, 
    {     0.00009963722,  1.61603805646,       76.26607127560}, 
    {     0.00009926160,  0.57630380333,       73.29712585900}, 
    {     0.00003259466,  1.26119342526,      224.34479570190}, 
    {     0.00002972303,  2.24367206357,        1.48447270830}, 
    {     0.00002010275,  6.05550884547,      148.07872442630}, 
    {     0.00001522163,  0.27959645002,       63.73589830340}, 
    {     0.00000924064,  4.03822512696,      151.04766984290}, 
    {     0.00000760640,  6.13999362624,       71.81265315070}, 
    {     0.00000420265,  5.21280055515,       11.04570026390}, 
    {     0.00000430661,  3.55443947716,      213.29909543800}, 
    {     0.00000436847,  3.38081057022,      529.69096509460}, 
    {     0.00000522314,  3.32086440954,      138.51749687070}, 
    {     0.00000434627,  0.34063199763,       77.75054398390}, 
    {     0.00000462630,  0.74256687606,       85.82729883120}, 
    {     0.00000232667,  2.25715668168,      222.86032299360}, 
    {     0.00000215848,  1.59122810633,       38.13303563780}, 
    {     0.00000244698,  0.78795174100,        2.96894541660}, 
    {     0.00000179936,  3.72487768728,      299.12639426920}, 
    {     0.00000174896,  1.23550822483,      146.59425171800}, 
    {     0.00000173648,  1.93654971482,      380.12776796000}, 
    {     0.00000160368,  5.33635511113,      111.43016149680}, 
    {     0.00000144064,  5.96238846558,       35.16409022120}, 
    {     0.00000102049,  2.61876132065,       78.71375183040}, 
    {     0.00000116363,  5.73877137488,       70.84944530420}, 
    {     0.00000106444,  0.94095705978,       70.32818044240}, 
    {     0.00000086160,  0.70251751041,       39.61750834610}, 
    {     0.00000072611,  0.20572158900,      225.82926841020}, 
    {     0.00000071172,  0.83343109173,      109.94568878850}, 
    {     0.00000057495,  2.67048156941,      108.46121608020}, 
    {     0.00000054263,  3.35177461012,      184.72728735580}, 
    {     0.00000044471,  2.74407889623,      152.53214255120}, 
    {     0.00000038592,  5.17390531140,      202.25339517410}, 
    {     0.00000039159,  2.17111197275,      351.81659230870}, 
    {     0.00000041362,  3.22138743484,      160.60889739850}, 
    {     0.00000035132,  4.00123533788,      112.91463420510}, 
    {     0.00000033091,  3.61372505020,      221.37585028530}, 
    {     0.00000031332,  2.71938965609,      145.10977900970}, 
    {     0.00000037340,  4.02083944240,       52.69019803950}, 
    {     0.00000032034,  1.29143160665,      145.63104387150}, 
    {     0.00000027569,  3.70085992486,       36.64856292950}, 
    {     0.00000024272,  2.85050776068,      127.47179660680}, 
    {     0.00000024635,  1.11646359832,        3.93215326310}, 
    {     0.00000024309,  5.48949970007,       79.23501669220}, 
    {     0.00000021418,  0.63723215666,      277.03499374140}, 
    {     0.00000019832,  2.59336449599,       84.34282612290}, 
    {     0.00000022368,  5.73729035268,        4.45341812490}, 
    {     0.00000019125,  1.30093692086,       62.25142559510}, 
    {     0.00000019796,  4.72268731719,      297.64192156090}, 
    {     0.00000020298,  1.06069563441,      454.90936652730}, 
    {     0.00000019769,  5.77906677614,      305.34616939270}, 
    {     0.00000021357,  1.01279253027,       33.67961751290}, 
    {     0.00000015136,  2.91791848257,      426.59819087600}, 
    {     0.00000016010,  1.95529008632,      186.21176006410}, 
    {     0.00000013804,  2.67173362271,       74.66972398270}, 
    {     0.00000011468,  5.73303165530,       41.10198105440}, 
    {     0.00000010741,  3.73406242289,     1059.38193018920}, 
    {     0.00000011468,  3.98150176278,      106.97674337190}, 
    {     0.00000010365,  4.75684964951,      183.24281464750}, 
    {     0.00000010232,  6.18772944512,      373.90799283650}, 
    {     0.00000013803,  5.70721417446,       74.89347315190}, 
    {     0.00000010563,  3.78630189172,      490.33408917940}, 
    {     0.00000011838,  5.96756141943,       87.31177153950}, 
    {     0.00000010033,  1.74884568436,       22.09140052780}, 
    {     0.00000010107,  0.92920871591,       65.22037101170}, 
    {     0.00000009126,  5.11087748378,      153.49535039770}, 
    {     0.00000012093,  2.53736478942,        9.56122755560}, 
    {     0.00000008645,  4.18353789478,       12.53017297220}, 
    {     0.00000009969,  5.83607933801,      604.47256366190}, 
    {     0.00000011363,  2.12628390559,       68.84370773410}, 
    {     0.00000008481,  3.37168822431,       72.33391801250}, 
    {     0.00000007790,  5.11802896670,       77.96299230500}, 
    {     0.00000008306,  5.19333619113,       77.22927912210}, 
    {     0.00000007701,  3.25277033035,       71.60020482960}, 
    {     0.00000007521,  2.98280931167,      114.39910691340}, 
    {     0.00000006948,  3.31879527596,       56.62235130260}, 
    {     0.00000006500,  0.88498775188,      288.08069400530}, 
    {     0.00000006393,  3.51141825287,      220.41264243880}, 
    {     0.00000006208,  0.58088443555,      340.77089204480}, 
    {     0.00000006772,  4.09371704059,      137.03302416240}, 
    {     0.00000005595,  5.68796827406,      259.50888592310}, 
    {     0.00000005301,  2.65424478534,      300.61086697750}, 
    {     0.00000004950,  4.99680523609,      219.89137757700}, 
    {     0.00000006424,  0.44994761517,      140.00196957900}, 
    {     0.00000004972,  4.06861003746,      143.62530630140}, 
    {     0.00000005694,  3.76750788366,       67.66805156650}, 
    {     0.00000004853,  2.03388920337,      415.55249061210}, 
    {     0.00000003803,  1.26170663854,       75.30286342910}, 
    {     0.00000003807,  2.24781903960,      909.81873305460}, 
    {     0.00000003813,  3.10466777490,      181.75834193920}, 
    {     0.00000003780,  5.19959127344,      227.31374111850}, 
    {     0.00000003426,  5.91911283488,      296.15744885260}, 
    {     0.00000003517,  5.44401451357,      628.85158605010}, 
    {     0.00000003943,  4.95109205340,      265.98929347750}, 
    {     0.00000003472,  0.34748263417,      131.40394986990}, 
    {     0.00000003400,  0.53685880010,      206.18554843720}, 
    {     0.00000003039,  4.68312649973,      159.12442469020}, 
    {     0.00000003189,  5.68771037501,      235.39049596580}, 
    {     0.00000003303,  2.09359478408,       73.81839072080}, 
    {     0.00000003062,  4.48989306244,       66.70484372000}, 
    {     0.00000003265,  0.01005829991,       75.74480641380}, 
    {     0.00000002917,  4.21626758697,      258.02441321480}, 
    {     0.00000003747,  0.82998936434,       74.26033370550}, 
    {     0.00000002818,  3.96515762579,       82.85835341460}, 
    {     0.00000002474,  3.81322641071,        7.11354700080}, 
    {     0.00000002394,  2.21473666039,       54.17467074780}, 
    {     0.00000002546,  2.97069404242,      378.64329525170}, 
    {     0.00000002632,  1.55152764206,      154.01661525950}, 
    {     0.00000002639,  2.28085213767,       32.19514480460}, 
    {     0.00000002642,  3.96819246977,      381.61224066830}, 
    {     0.00000002203,  3.06747152218,       59.80374504030}, 
    {     0.00000002635,  0.54046453944,      211.81462272970}, 
    {     0.00000002053,  1.98285180962,       18.15924726470}, 
    {     0.00000002516,  0.63537765744,      187.69623277240}, 
    {     0.00000002485,  3.55942732547,       96.87299909510}, 
    {     0.00000001918,  1.60479578730,       80.19822453870}, 
    {     0.00000002055,  4.49938733826,        5.93789083320}, 
    {     0.00000002018,  2.97794616041,      191.20769491020}, 
    {     0.00000001832,  1.96177252651,       81.89514556810}, 
    {     0.00000001719,  2.22518862087,      479.28838891550}, 
    {     0.00000001857,  1.66299721979,      984.60033162190}, 
    {     0.00000001726,  3.22144940779,      218.40690486870}, 
    {     0.00000001770,  5.24609773415,      105.49227066360}, 
    {     0.00000001520,  0.94716593371,      372.42352012820}, 
    {     0.00000001512,  6.03457842275,       99.16062095550}, 
    {     0.00000001614,  3.39986737271,      230.56457082540}, 
    {     0.00000001711,  3.44232483680,      522.57741809380}, 
    {     0.00000001504,  1.34653259405,       74.52096613640}, 
    {     0.00000001584,  4.37196518404,       80.71948940050}, 
    {     0.00000001360,  5.48691240270,       74.82978267710}, 
    {     0.00000001405,  0.33792710499,      142.44965013380}, 
    {     0.00000001363,  4.56068902351,       42.58645376270}, 
    {     0.00000001709,  3.63180456542,      554.06998748280}, 
    {     0.00000001360,  2.89305157919,       74.73341445750}, 
    {     0.00000001260,  5.50922979275,       74.94165726170}, 
    {     0.00000001384,  4.40028240227,      260.99335863140}, 
    {     0.00000001365,  2.15266243195,      162.09337010680}, 
    {     0.00000001244,  4.97782030325,      149.45132255000}, 
    {     0.00000001278,  0.84565446273,      767.36908292080}, 
    {     0.00000001263,  4.53422211084,      294.67297614430}, 
    {     0.00000001322,  5.10927435201,       51.20572533120}, 
    {     0.00000001180,  0.79757360842,      116.42609634290}, 
    {     0.00000001495,  0.74986873597,       75.04223099820}, 
    {     0.00000001213,  3.66821217363,       20.60692781950}, 
    {     0.00000001248,  3.13317666641,       67.35923502580}, 
    {     0.00000001171,  4.39747177706,      180.27386923090}, 
    {     0.00000001125,  3.86202201629,       39.35687591520}, 
    {     0.00000001263,  2.87116663203,       74.62153987290}, 
    {     0.00000001376,  3.75596842702,       92.94084583200}, 
    {     0.00000001018,  6.20402800983,      835.03713448730}, 
    {     0.00000000962,  3.30346641752,      255.05546779820}, 
    {     0.00000001239,  1.73040337356,      149.67507171920}, 
    {     0.00000000970,  1.71235586924,      115.88357962170}, 
    {     0.00000000943,  3.07319537857,        8.07675484730}, 
    {     0.00000001000,  5.49989514567,      256.53994050650}, 
    {     0.00000000911,  6.23756163651,      200.76892246580}, 
    {     0.00000000908,  0.00832674265,      536.80451209540}, 
    {     0.00000000969,  5.77575675230,      128.95626931510}, 
    {     0.00000000952,  3.00463012001,       14.97785352700}, 
    {     0.00000000983,  0.35101173825,      404.50679034820}, 
    {     0.00000000808,  3.21398175104,       28.31117565130}, 
    {     0.00000000764,  3.45466431894,      214.78356814630}, 
    {     0.00000001021,  1.79907610488,        3.18139373770}, 
    {     0.00000000783,  4.12167749880,      125.98732389850}, 
    {     0.00000000715,  5.80380056776,      157.63995198190}, 
    {     0.00000000689,  1.84739011152,       41.64449777560}, 
    {     0.00000000715,  5.56310287629,      146.38180339690}, 
    {     0.00000000682,  5.16479782395,       74.03083904190}, 
    {     0.00000000673,  2.65544175682,       75.53235809270}, 
    {     0.00000000696,  3.59376281929,      362.86229257260}, 
    {     0.00000000715,  4.76877987059,      331.32153907380}, 
    {     0.00000000729,  2.25493921872,      453.42489381900}, 
    {     0.00000000648,  1.99137116455,      639.89728631400}, 
    {     0.00000000641,  5.77409064831,      110.20632121940}, 
    {     0.00000000666,  5.97888465085,      135.54855145410}, 
    {     0.00000000774,  0.42035537394,      565.11568774670}, 
    {     0.00000000674,  5.32913501430,      142.14083359310}, 
    {     0.00000000776,  5.57009796152,        2.44768055480}, 
    {     0.00000000798,  0.90966507165,      152.01087768940}, 
    {     0.00000000680,  2.94896042701,       60.76695288680}, 
    {     0.00000000603,  2.04208151880,      195.13984817330}, 
    {     0.00000000650,  4.56287025940,      216.92243216040}, 
    {     0.00000000738,  5.07239490532,       89.75945209430}, 
    {     0.00000000597,  1.91415368214,      203.73786788240}, 
    {     0.00000000646,  2.79255070924,       50.40257617910}, 
    {     0.00000000557,  2.91795392350,       68.18931642830}, 
    {     0.00000000565,  2.77660876182,       14.01464568050}, 
    {     0.00000000531,  3.75443696232,      617.80588578620}, 
    {     0.00000000530,  3.51481429918,      291.70403072770}, 
    {     0.00000000506,  4.94596553031,       81.37388070630}, 
    {     0.00000000602,  2.45288547587,       81.00137369080}, 
    {     0.00000000596,  5.42429198496,      692.58748435350}, 
    {     0.00000000648,  5.74877765820,      141.48644228730}, 
    {     0.00000000523,  4.97086637939,      387.24131496080}, 
    {     0.00000000544,  2.99910796114,      152.74459087230}, 
    {     0.00000000485,  2.36315064516,      448.68959140380}, 
    {     0.00000000481,  5.81665495660,      134.58534360760}, 
    {     0.00000000470,  1.30174846020,      228.27694896500}, 
    {     0.00000000475,  0.53495528828,      303.86169668440}, 
    {     0.00000000584,  4.67866565270,       88.79624424780}, 
    {     0.00000000461,  0.55903469027,       23.57587323610}, 
    {     0.00000000478,  6.22340588748,        5.41662597140}, 
    {     0.00000000426,  5.25039648756,       35.42472265210}, 
    {     0.00000000446,  2.50203892379,      905.88657979150}, 
    {     0.00000000441,  4.26182840333,      278.51946644970}, 
    {     0.00000000501,  4.79995214429,      306.83064210100}, 
    {     0.00000000499,  5.86243513978,      293.18850343600}, 
    {     0.00000000474,  3.03117647100,      286.59622129700}, 
    {     0.00000000506,  2.05350887377,      373.01422095920}, 
    {     0.00000000410,  5.30618889138,       95.38852638680}, 
    {     0.00000000395,  5.65591153137,      284.14854074220}, 
    {     0.00000000478,  2.41099809344,      358.93013930950}, 
    {     0.00000000536,  1.82605088834,      114.13847448250}, 
    {     0.00000000383,  5.54529609922,      419.48464387520}, 
    {     0.00000000413,  0.03790517946,      103.09277421860}, 
    {     0.00000000368,  4.08523828488,     1589.07289528380}, 
    {     0.00000000370,  1.82531607739,      334.29048449040}, 
    {     0.00000000387,  0.56619512225,      602.98809095360}, 
    {     0.00000000482,  5.58482619841,       68.56182344380}, 
    {     0.00000000478,  0.17223161797,      120.35824960600}, 
    {     0.00000000419,  5.07107020071,      367.97010200330}, 
    {     0.00000000342,  5.27207825111,       28.57180808220}, 
    {     0.00000000406,  2.00845231847,      679.25416222920}, 
    {     0.00000000381,  4.61323929793,      329.72519178090}, 
    {     0.00000000388,  0.89083225227,      483.22054217860}, 
    {     0.00000000376,  1.28833260468,      155.78297225810}, 
    {     0.00000000326,  6.09139244001,      456.39383923560}, 
    {     0.00000000300,  5.11528183598,      375.39246554480}, 
    {     0.00000000321,  0.11320249807,       69.36497259590}, 
    {     0.00000000299,  6.03912323340,      332.80601178210}, 
    {     0.00000000328,  3.47252263966,       73.40900044360}, 
    {     0.00000000283,  1.81773059325,      647.01083331480}, 
    {     0.00000000308,  3.50107540223,       30.71067209630}, 
    {     0.00000000278,  3.85509473152,      760.25553592000}, 
    {     0.00000000293,  5.44449244354,      477.91579079180}, 
    {     0.00000000319,  1.96492310465,      543.02428721890}, 
    {     0.00000000275,  1.82480767582,       24.37902238820}, 
    {     0.00000000254,  4.23529202563,      391.17346822390}, 
    {     0.00000000248,  2.17740648239,      611.58611066270}, 
    {     0.00000000271,  3.85067228463,      209.36694217490}, 
    {     0.00000000245,  1.04008534095,     1332.48477066750}, 
    {     0.00000000248,  6.19520746836,     1134.16352875650}, 
    {     0.00000000317,  5.60194689908,      501.37978944330}, 
    {     0.00000000242,  1.37720813333,      121.25202148330}, 
    {     0.00000000234,  0.50970508504,      462.02291352810}, 
    {     0.00000000236,  0.71434091094,      233.90602325750}, 
    {     0.00000000319,  4.24234798459,      328.35259365720}, 
    {     0.00000000245,  6.00685270776,      295.19424100610}, 
    {     0.00000000224,  2.04173820334,      370.93904741990}, 
    {     0.00000000226,  4.36158718577,      269.92144674060}, 
    {     0.00000000222,  5.32240209336,      983.11585891360}, 
    {     0.00000000219,  1.37802257893,      302.09533968580}, 
    {     0.00000000301,  5.70756404145,      189.18070548070}, 
    {     0.00000000244,  4.69736688026,      316.39186965660}, 
    {     0.00000000267,  0.15744446717,    10213.28554621100}, 
    {     0.00000000210,  5.84976141374,      147.11551657980}, 
    {     0.00000000224,  3.04838385551,     1439.50969814920}, 
    {     0.00000000267,  2.78030672201,      144.14657116320}, 
    {     0.00000000204,  2.37388505075,      275.55052103310}, 
    {     0.00000000229,  2.33600590519,      150.52640498110}, 
    {     0.00000000194,  5.11344829807,     1215.16490244730}, 
    {     0.00000000215,  0.70130699540,       45.57665103870}, 
    {     0.00000000198,  3.20849122961,        7.42236354150}, 
    {     0.00000000196,  3.83527631644,       46.20979048510}, 
    {     0.00000000195,  6.08813214815,      344.70304530790}, 
    {     0.00000000179,  4.70649738298,      518.64526483070}, 
    {     0.00000000176,  3.72183112618,      150.08446199640}, 
    {     0.00000000222,  6.13768802796,        6.21977512350}, 
    {     0.00000000174,  1.87343899875,      310.17209453310}, 
    {     0.00000000168,  3.34209611420,      173.94221952280}, 
    {     0.00000000192,  0.41644241830,        0.96320784650}, 
    {     0.00000000141,  1.70340116374,      531.17543780290}, 
    {     0.00000000149,  3.99276635695,      228.79821382680}, 
    {     0.00000000137,  6.20556096334,      369.45457471160}, 
    {     0.00000000145,  3.96204016046,      350.33211960040}, 
    {     0.00000000126,  5.28560984253,      329.83706636550}, 
    {     0.00000000132,  4.51993002555,      148.59998928810}, 
    {     0.00000000125,  4.24716365077,      248.72381809010}, 
    {     0.00000000131,  4.06190440824,      526.72201967800}, 
    {     0.00000000120,  4.08620475792,      154.97982310600}, 
    {     0.00000000134,  3.16619358295,      262.47783133970}, 
    {     0.00000000121,  2.31292076167,      232.04904353370}, 
    {     0.00000000125,  4.25542060721,      377.15882254340}, 
    {     0.00000000119,  4.12193841810,      404.61866493280}, 
    {     0.00000000130,  6.09762672394,      171.65459766240}, 
    {     0.00000000127,  3.76800714166,      369.08206769610}, 
    {     0.00000000100,  2.65367785044,      703.63318461740}, 
    {     0.00000000127,  3.33536864400,      149.04193227280}, 
    {     0.00000000116,  4.77834673196,     1289.94650101460}, 
    {     0.00000000096,  2.47155169370,      210.33015002140}, 
    {     0.00000000097,  1.08835035283,      156.15547927360}, 
    {     0.00000000108,  3.07832539912,     6133.51265285680}, 
    {     0.00000000108,  2.03236554349,     6283.07584999140}, 
    {     0.00000000100,  4.75380350867,      218.92816973050}, 
    {     0.00000000093,  1.66567734962,      668.20846196530}, 
    {     0.00000000097,  0.64083375068,      252.65597135320}, 
    {     0.00000000091,  4.11478686503,      166.82867252200}, 
    {     0.00000000089,  4.92738306385,      353.30106501700}, 
    {     0.00000000081,  1.42684401779,      831.10498122420}, 
    {     0.00000000084,  2.75226196759,      217.23124870110}, 
    {     0.00000000083,  4.26421510316,      383.09671337660}, 
    {     0.00000000098,  0.58553892847,      339.28641933650}, 
    {     0.00000000101,  4.62998086587,      756.32338265690}, 
    {     0.00000000079,  5.79692522120,      443.86366626340}, 
    {     0.00000000075,  3.39046285130,      447.20511869550}, 
    {     0.00000000076,  0.11314255037,      406.10313764110}, 
    {     0.00000000074,  0.54434880673,       33.13710079170}, 
    {     0.00000000075,  2.44458975326,      120.99138905240}, 
    {     0.00000000074,  0.63126666381,      335.77495719870}, 
};


static const struct vsop uranus_latitude_b1[LAT_B1] = {
    {     0.00034101978,  0.01321929936,       74.78159856730}, 
    {     0.00002480115,  2.73961370453,      149.56319713460}, 
    {     0.00001719377,  0.00000000000,        0.00000000000}, 
    {     0.00000395276,  5.49322816551,       76.26607127560}, 
    {     0.00000308903,  3.61139770633,       73.29712585900}, 
    {     0.00000181125,  5.32079457105,      224.34479570190}, 
    {     0.00000144520,  4.22110521671,       63.73589830340}, 
    {     0.00000076343,  4.54620999213,       85.82729883120}, 
    {     0.00000072633,  5.97811706013,        1.48447270830}, 
    {     0.00000065492,  2.77607065171,       11.04570026390}, 
    {     0.00000063931,  6.15917217447,      138.51749687070}, 
    {     0.00000050972,  1.79457572126,      151.04766984290}, 
    {     0.00000039930,  3.59559614775,      148.07872442630}, 
    {     0.00000036667,  3.82753352893,       70.84944530420}, 
    {     0.00000026969,  4.71074996908,       78.71375183040}, 
    {     0.00000027205,  4.22769491494,       71.81265315070}, 
    {     0.00000022074,  4.76357435668,      213.29909543800}, 
    {     0.00000022655,  4.40615405121,       77.75054398390}, 
    {     0.00000015720,  1.55930265947,      529.69096509460}, 
    {     0.00000010090,  5.83224201984,      145.63104387150}, 
    {     0.00000012912,  1.56375170441,      299.12639426920}, 
    {     0.00000007956,  5.02287526190,        2.96894541660}, 
    {     0.00000008579,  6.26698868752,      222.86032299360}, 
    {     0.00000007534,  0.80106371071,      160.60889739850}, 
    {     0.00000006679,  2.78528388060,        3.93215326310}, 
    {     0.00000005496,  3.31254191722,       77.96299230500}, 
    {     0.00000005232,  5.06918050814,       71.60020482960}, 
    {     0.00000004398,  4.52763457543,      380.12776796000}, 
    {     0.00000005025,  1.23324638522,       52.69019803950}, 
    {     0.00000005160,  4.31709832477,      225.82926841020}, 
    {     0.00000003310,  3.75868972095,       35.16409022120}, 
    {     0.00000003866,  1.26370982350,       65.22037101170}, 
    {     0.00000003055,  0.62704236969,      152.53214255120}, 
    {     0.00000002433,  5.16881959896,       39.61750834610}, 
    {     0.00000003040,  2.69522691477,      202.25339517410}, 
    {     0.00000002312,  5.05125177167,       22.09140052780}, 
    {     0.00000002685,  0.39348299350,       84.34282612290}, 
    {     0.00000002372,  5.24162482086,       56.62235130260}, 
    {     0.00000002088,  1.79153906168,      220.41264243880}, 
    {     0.00000002085,  3.50728589034,       87.31177153950}, 
    {     0.00000002170,  0.92046078692,      153.49535039770}, 
    {     0.00000001813,  4.58205400420,      146.59425171800}, 
    {     0.00000001712,  3.46795755957,      111.43016149680}, 
    {     0.00000001669,  0.52544187039,      184.72728735580}, 
    {     0.00000001690,  3.51435037186,      351.81659230870}, 
    {     0.00000001623,  1.83332553557,       72.33391801250}, 
    {     0.00000001615,  3.22111940844,       79.23501669220}, 
    {     0.00000001443,  0.38490278682,        9.56122755560}, 
    {     0.00000001379,  2.25314683721,      131.40394986990}, 
    {     0.00000001471,  5.65482351957,       67.66805156650}, 
    {     0.00000001513,  1.70291762548,       12.53017297220}, 
    {     0.00000001219,  1.01279910067,      127.47179660680}, 
    {     0.00000001595,  5.26092020655,       62.25142559510}, 
    {     0.00000001392,  2.19044218730,      206.18554843720}, 
    {     0.00000001569,  3.39043730503,      277.03499374140}, 
    {     0.00000001560,  3.27054489518,       36.64856292950}, 
    {     0.00000001162,  0.53527505489,       77.22927912210}, 
    {     0.00000001085,  1.27498553595,       73.81839072080}, 
    {     0.00000001257,  0.04368108516,       18.15924726470}, 
    {     0.00000001047,  0.81042117668,       75.74480641380}, 
    {     0.00000001038,  3.90628138392,        4.45341812490}, 
    {     0.00000000956,  3.66430920732,       74.89347315190}, 
    {     0.00000001052,  2.41090141006,      297.64192156090}, 
    {     0.00000000976,  5.46581402543,       70.32818044240}, 
    {     0.00000001177,  0.17623728581,      426.59819087600}, 
    {     0.00000000853,  0.81527596999,      137.03302416240}, 
    {     0.00000000862,  1.76954399486,      305.34616939270}, 
    {     0.00000000726,  2.19758076790,      112.91463420510}, 
    {     0.00000000791,  2.49340799866,     1059.38193018920}, 
    {     0.00000000696,  4.12237397933,      109.94568878850}, 
    {     0.00000000694,  1.89100616611,       92.94084583200}, 
    {     0.00000000711,  4.06903566155,      373.90799283650}, 
    {     0.00000000584,  6.17026395543,       81.89514556810}, 
    {     0.00000000660,  4.96483571441,       74.66972398270}, 
    {     0.00000000566,  5.13046568900,      490.33408917940}, 
    {     0.00000000559,  0.90292303032,      221.37585028530}, 
    {     0.00000000692,  0.12427497048,        3.18139373770}, 
    {     0.00000000734,  0.60531957870,       38.13303563780}, 
    {     0.00000000532,  3.98648434092,      604.47256366190}, 
    {     0.00000000584,  5.06689547480,      288.08069400530}, 
    {     0.00000000629,  0.54026926209,       96.87299909510}, 
    {     0.00000000561,  4.73267608947,      454.90936652730}, 
    {     0.00000000470,  3.99280389290,       41.10198105440}, 
    {     0.00000000566,  6.02809954245,      191.20769491020}, 
    {     0.00000000507,  2.22687412142,      265.98929347750}, 
    {     0.00000000506,  1.87736218659,        7.11354700080}, 
    {     0.00000000439,  3.41337176747,       80.19822453870}, 
    {     0.00000000410,  2.50600627363,      142.44965013380}, 
    {     0.00000000422,  3.31613690285,      235.39049596580}, 
    {     0.00000000372,  4.59862949974,      536.80451209540}, 
    {     0.00000000371,  0.79783261377,      108.46121608020}, 
    {     0.00000000373,  4.56996089020,      415.55249061210}, 
    {     0.00000000351,  5.99218780431,      186.21176006410}, 
    {     0.00000000407,  4.34825659263,      340.77089204480}, 
    {     0.00000000328,  0.65738227750,       66.70484372000}, 
    {     0.00000000372,  5.10831450067,      522.57741809380}, 
    {     0.00000000343,  0.53613562161,      300.61086697750}, 
    {     0.00000000270,  1.27650196236,      703.63318461740}, 
    {     0.00000000278,  4.58530381992,      195.13984817330}, 
    {     0.00000000239,  0.43515793516,       33.13710079170}, 
    {     0.00000000237,  3.82041367450,      617.80588578620}, 
    {     0.00000000235,  4.20082783313,      116.42609634290}, 
    {     0.00000000235,  1.41272118988,      835.03713448730}, 
    {     0.00000000245,  4.77313758758,       41.64449777560}, 
    {     0.00000000198,  0.36712400018,        2.44768055480}, 
    {     0.00000000193,  3.18074408969,      387.24131496080}, 
    {     0.00000000204,  3.17054171814,      211.81462272970}, 
    {     0.00000000242,  1.23871652170,      146.38180339690}, 
    {     0.00000000227,  2.35811929824,      159.12442469020}, 
    {     0.00000000186,  5.03606957476,       14.97785352700}, 
    {     0.00000000211,  3.80164653477,      373.01422095920}, 
    {     0.00000000209,  3.12060090889,      227.31374111850}, 
    {     0.00000000166,  3.26464486430,      259.50888592310}, 
    {     0.00000000169,  1.43527176999,      152.74459087230}, 
    {     0.00000000127,  2.56383866135,      140.00196957900}, 
    {     0.00000000124,  6.03937004050,      162.09337010680}, 
    {     0.00000000118,  1.35527417493,      114.39910691340}, 
    {     0.00000000110,  1.36513996746,      183.24281464750}, 
    {     0.00000000109,  2.14362406822,      209.36694217490}, 
    {     0.00000000116,  3.42267498449,      228.27694896500}, 
    {     0.00000000104,  5.33634525923,      378.64329525170}, 
    {     0.00000000128,  5.42597035936,      230.56457082540}, 
    {     0.00000000115,  1.15568409498,      909.81873305460}, 
    {     0.00000000086,  1.55888062727,      344.70304530790}, 
    {     0.00000000098,  5.72850189948,      154.01661525950}, 
    {     0.00000000104,  5.06629922886,      145.10977900970}, 
    {     0.00000000099,  3.88447445684,       33.67961751290}, 
    {     0.00000000085,  6.15025173870,      269.92144674060}, 
    {     0.00000000085,  3.47642579503,      296.15744885260}, 
    {     0.00000000078,  0.83351167637,      144.14657116320}, 
};


static const struct vsop uranus_latitude_b2[LAT_B2] = {
    {     0.00000764663,  1.74870957857,       74.78159856730}, 
    {     0.00000055734,  3.14159265359,        0.00000000000}, 
    {     0.00000025641,  5.67301557131,      149.56319713460}, 
    {     0.00000013335,  5.92348443969,       73.29712585900}, 
    {     0.00000006636,  2.30241577514,       85.82729883120}, 
    {     0.00000004926,  2.21241492976,       76.26607127560}, 
    {     0.00000004368,  0.76649493506,       11.04570026390}, 
    {     0.00000004095,  1.81604424547,       70.84944530420}, 
    {     0.00000003550,  2.72620892642,      224.34479570190}, 
    {     0.00000003556,  0.36898980602,       78.71375183040}, 
    {     0.00000003799,  1.75732801545,      138.51749687070}, 
    {     0.00000001820,  1.54477121376,       77.96299230500}, 
    {     0.00000001651,  1.41591379356,        1.48447270830}, 
    {     0.00000001608,  6.22512841748,      213.29909543800}, 
    {     0.00000001452,  3.90164387464,      145.63104387150}, 
    {     0.00000001245,  3.04960471697,      529.69096509460}, 
    {     0.00000001689,  0.57422602041,       71.60020482960}, 
    {     0.00000001082,  5.44260490226,      151.04766984290}, 
    {     0.00000001033,  5.50906270157,       63.73589830340}, 
    {     0.00000000979,  4.45089803473,        3.93215326310}, 
    {     0.00000000895,  4.45228515086,      148.07872442630}, 
    {     0.00000000610,  0.69755363233,       71.81265315070}, 
    {     0.00000000724,  4.66998863825,      160.60889739850}, 
    {     0.00000000377,  5.83975114717,      127.47179660680}, 
    {     0.00000000395,  2.05229057211,       77.75054398390}, 
    {     0.00000000333,  3.76580834650,      454.90936652730}, 
    {     0.00000000309,  4.06945653305,       18.15924726470}, 
    {     0.00000000286,  0.10714983850,      220.41264243880}, 
    {     0.00000000281,  5.45374336062,      299.12639426920}, 
    {     0.00000000323,  0.04948675860,       72.33391801250}, 
    {     0.00000000365,  2.39747909046,       56.62235130260}, 
    {     0.00000000258,  3.54572684987,       52.69019803950}, 
    {     0.00000000214,  1.99573431344,       22.09140052780}, 
    {     0.00000000220,  5.12637793339,        3.18139373770}, 
    {     0.00000000134,  4.08992196303,      131.40394986990}, 
    {     0.00000000147,  2.92139556480,      153.49535039770}, 
    {     0.00000000096,  1.97465913947,      225.82926841020}, 
    {     0.00000000076,  1.48178075191,      206.18554843720}, 
    {     0.00000000085,  2.49786959141,      380.12776796000}, 
};


static const struct vsop uranus_latitude_b3[LAT_B3] = {
    {     0.00000021201,  3.16540759295,       74.78159856730}, 
    {     0.00000001182,  4.44441014271,      149.56319713460}, 
    {     0.00000001184,  3.14159265359,        0.00000000000}, 
    {     0.00000000433,  1.10371780340,       73.29712585900}, 
    {     0.00000000412,  0.43984657946,       76.26607127560}, 
    {     0.00000000466,  5.92951996029,       70.84944530420}, 
    {     0.00000000464,  1.88752032733,       78.71375183040}, 
    {     0.00000000404,  6.16046303283,       85.82729883120}, 
    {     0.00000000401,  1.68921956710,       63.73589830340}, 
    {     0.00000000295,  5.96253146711,       77.96299230500}, 
    {     0.00000000294,  1.85767623542,       71.60020482960}, 
    {     0.00000000174,  4.79023778832,       11.04570026390}, 
    {     0.00000000099,  0.42283006135,      224.34479570190}, 
    {     0.00000000088,  2.27837607751,      145.63104387150}, 
    {     0.00000000079,  3.66485269931,      138.51749687070}, 
};


static const struct vsop uranus_radius_r0[RADIUS_R0] = {
    {    19.21264847206,  0.00000000000,        0.00000000000}, 
    {     0.88784984413,  5.60377527014,       74.78159856730}, 
    {     0.03440836062,  0.32836099706,       73.29712585900}, 
    {     0.02055653860,  1.78295159330,      149.56319713460}, 
    {     0.00649322410,  4.52247285911,       76.26607127560}, 
    {     0.00602247865,  3.86003823674,       63.73589830340}, 
    {     0.00496404167,  1.40139935333,      454.90936652730}, 
    {     0.00338525369,  1.58002770318,      138.51749687070}, 
    {     0.00243509114,  1.57086606044,       71.81265315070}, 
    {     0.00190522303,  1.99809394714,        1.48447270830}, 
    {     0.00161858838,  2.79137786799,      148.07872442630}, 
    {     0.00143706183,  1.38368544947,       11.04570026390}, 
    {     0.00093192405,  0.17437220467,       36.64856292950}, 
    {     0.00071424548,  4.24509236074,      224.34479570190}, 
    {     0.00089806014,  3.66105364565,      109.94568878850}, 
    {     0.00039009723,  1.66971401684,       70.84944530420}, 
    {     0.00046677296,  1.39976401694,       35.16409022120}, 
    {     0.00039025624,  3.36234773834,      277.03499374140}, 
    {     0.00036755274,  3.88649278513,      146.59425171800}, 
    {     0.00030348723,  0.70100838798,      151.04766984290}, 
    {     0.00029156413,  3.18056336700,       77.75054398390}, 
    {     0.00020471591,  1.55587964879,      202.25339517410}, 
    {     0.00025620756,  5.25656086672,      380.12776796000}, 
    {     0.00025785880,  3.78537709870,       85.82729883120}, 
    {     0.00022637073,  0.72518687029,      529.69096509460}, 
    {     0.00020473534,  2.79640244248,       70.32818044240}, 
    {     0.00017901300,  0.55455066863,        2.96894541660}, 
    {     0.00012328114,  5.96037276805,      127.47179660680}, 
    {     0.00014701666,  4.90434516516,      108.46121608020}, 
    {     0.00011494680,  0.43772043395,       65.22037101170}, 
    {     0.00015502375,  5.35405396163,       38.13303563780}, 
    {     0.00010792498,  1.42106296264,      213.29909543800}, 
    {     0.00011695693,  3.29824190199,        3.93215326310}, 
    {     0.00011959076,  1.75043392140,      984.60033162190}, 
    {     0.00012896452,  2.62154084288,      111.43016149680}, 
    {     0.00011852959,  0.99344161196,       52.69019803950}, 
    {     0.00009111621,  4.99633582839,       62.25142559510}, 
    {     0.00008420792,  5.25351368389,      222.86032299360}, 
    {     0.00007448995,  0.79495503123,      351.81659230870}, 
    {     0.00008402384,  5.03876467031,      415.55249061210}, 
    {     0.00006046221,  5.67958564987,       78.71375183040}, 
    {     0.00005524411,  3.11493320824,        9.56122755560}, 
    {     0.00007329301,  3.97276588872,      183.24281464750}, 
    {     0.00005444570,  5.10574758517,      145.10977900970}, 
    {     0.00005238203,  2.62960535651,       33.67961751290}, 
    {     0.00004079523,  3.22064116734,      340.77089204480}, 
    {     0.00003801645,  6.10982670905,      184.72728735580}, 
    {     0.00003918728,  4.25017709085,       39.61750834610}, 
    {     0.00002940764,  2.14649735789,      137.03302416240}, 
    {     0.00003781197,  3.45840366912,      456.39383923560}, 
    {     0.00002942224,  0.42392830457,      299.12639426920}, 
    {     0.00003686324,  2.48725993956,      453.42489381900}, 
    {     0.00003101496,  4.14028619712,      219.89137757700}, 
    {     0.00002962643,  0.82981906774,       56.62235130260}, 
    {     0.00002937579,  3.67652211319,      140.00196957900}, 
    {     0.00002864793,  0.30998964462,       12.53017297220}, 
    {     0.00002538110,  4.85443168231,      131.40394986990}, 
    {     0.00001962787,  5.24326793681,       84.34282612290}, 
    {     0.00002363719,  0.44244699485,      554.06998748280}, 
    {     0.00001978408,  6.12838999163,      106.97674337190}, 
    {     0.00002182603,  2.94042519396,      305.34616939270}, 
    {     0.00001963255,  0.04114614586,      221.37585028530}, 
    {     0.00001829781,  4.01105197128,       68.84370773410}, 
    {     0.00001642920,  0.35558129224,       67.66805156650}, 
    {     0.00001584876,  3.16265838848,      225.82926841020}, 
    {     0.00001848022,  2.91116293131,      909.81873305460}, 
    {     0.00001632263,  4.23038575372,       22.09140052780}, 
    {     0.00001402196,  1.39106710150,      265.98929347750}, 
    {     0.00001404021,  5.63567908789,        4.45341812490}, 
    {     0.00001656488,  1.96436491067,       79.23501669220}, 
    {     0.00001248478,  5.44008558936,       54.17467074780}, 
    {     0.00001563396,  1.47919498164,      112.91463420510}, 
    {     0.00001248513,  4.88964506527,      479.28838891550}, 
    {     0.00001197649,  2.52152454056,      145.63104387150}, 
    {     0.00001506943,  5.24185420360,      181.75834193920}, 
    {     0.00001481952,  5.66201356223,      152.53214255120}, 
    {     0.00001439115,  1.53047702403,      447.79581952650}, 
    {     0.00001408871,  4.41921152932,      462.02291352810}, 
    {     0.00001477003,  4.32173218344,      256.53994050650}, 
    {     0.00001228234,  5.97697848866,       59.80374504030}, 
    {     0.00001249895,  6.24480493841,      160.60889739850}, 
    {     0.00000906516,  5.62013120164,       74.66972398270}, 
    {     0.00001090686,  4.15394319904,       77.96299230500}, 
    {     0.00000844827,  0.12966056060,       82.85835341460}, 
    {     0.00000900579,  2.37303064621,       74.89347315190}, 
    {     0.00001071649,  1.74298201693,      528.20649238630}, 
    {     0.00000689518,  3.08087933344,       69.36497259590}, 
    {     0.00000594010,  4.50031730404,        8.07675484730}, 
    {     0.00000718644,  4.00028668863,      128.95626931510}, 
    {     0.00000699874,  0.03990034416,      143.62530630140}, 
    {     0.00000575672,  5.89553952415,       66.70484372000}, 
    {     0.00000758678,  2.13693803170,      692.58748435350}, 
    {     0.00000710274,  5.41605211553,      218.40690486870}, 
    {     0.00000548663,  5.62811775865,        3.18139373770}, 
    {     0.00000651756,  4.42317051993,       18.15924726470}, 
    {     0.00000539730,  6.20779847549,       71.60020482960}, 
    {     0.00000544899,  5.69409543986,      203.73786788240}, 
    {     0.00000710254,  4.21967520209,      381.61224066830}, 
    {     0.00000594034,  3.83794153459,       32.19514480460}, 
    {     0.00000709902,  4.48962691884,      293.18850343600}, 
    {     0.00000705697,  0.45518539160,      835.03713448730}, 
    {     0.00000587851,  5.08268227675,      186.21176006410}, 
    {     0.00000598191,  0.35792534475,      269.92144674060}, 
    {     0.00000642152,  2.71090806243,       87.31177153950}, 
    {     0.00000495640,  2.65111742640,      200.76892246580}, 
    {     0.00000630166,  4.46153551027,      275.55052103310}, 
    {     0.00000574950,  5.57877269214,        2.44768055480}, 
    {     0.00000569622,  1.63924602135,       77.22927912210}, 
    {     0.00000556672,  1.07231890667,     1059.38193018920}, 
    {     0.00000449362,  0.27988155703,      617.80588578620}, 
    {     0.00000463703,  1.43450762802,      297.64192156090}, 
    {     0.00000436536,  0.52783902054,      209.36694217490}, 
    {     0.00000463920,  2.35519668239,      211.81462272970}, 
    {     0.00000435944,  2.10077178384,     1514.29129671650}, 
    {     0.00000515533,  3.23274245907,      284.14854074220}, 
    {     0.00000455004,  4.08342038147,       99.16062095550}, 
    {     0.00000477251,  2.89381653210,       39.35687591520}, 
    {     0.00000542691,  5.39457310701,      278.51946644970}, 
    {     0.00000409903,  3.04961893378,      404.50679034820}, 
    {     0.00000368389,  0.71079545635,      125.98732389850}, 
    {     0.00000503183,  5.83915487750,      191.20769491020}, 
    {     0.00000487400,  0.06424307109,       60.76695288680}, 
    {     0.00000455030,  2.59321031027,      490.33408917940}, 
    {     0.00000436349,  2.08129398068,       51.20572533120}, 
    {     0.00000435759,  2.79444435294,       75.74480641380}, 
    {     0.00000323480,  4.82939220481,      195.13984817330}, 
    {     0.00000359344,  0.00870449102,       35.42472265210}, 
    {     0.00000429078,  3.08057776747,       41.10198105440}, 
    {     0.00000319986,  5.48621997496,       14.97785352700}, 
    {     0.00000413961,  0.08822621279,      258.02441321480}, 
    {     0.00000379728,  0.05834508997,      378.64329525170}, 
    {     0.00000420206,  2.25392348451,       81.00137369080}, 
    {     0.00000357527,  4.71408309367,      173.94221952280}, 
    {     0.00000358938,  0.35269536425,      426.59819087600}, 
    {     0.00000405369,  6.12344979469,       24.37902238820}, 
    {     0.00000365088,  5.59471873032,      255.05546779820}, 
    {     0.00000308155,  3.92316644086,      116.42609634290}, 
    {     0.00000325546,  4.71973290837,      134.58534360760}, 
    {     0.00000292775,  3.99521624654,       72.33391801250}, 
    {     0.00000386408,  0.68629232964,      230.56457082540}, 
    {     0.00000305580,  3.76131538046,      344.70304530790}, 
    {     0.00000286849,  1.84987619750,      153.49535039770}, 
    {     0.00000353346,  4.65720677156,      329.83706636550}, 
    {     0.00000301835,  0.13173596285,      565.11568774670}, 
    {     0.00000241282,  1.60400061320,       81.37388070630}, 
    {     0.00000249797,  4.24206827815,       75.30286342910}, 
    {     0.00000245219,  5.94902281852,       20.60692781950}, 
    {     0.00000248331,  1.06282358803,      105.49227066360}, 
    {     0.00000305353,  2.55534744586,     6208.29425142410}, 
    {     0.00000296370,  4.21095612809,     1364.72809958190}, 
    {     0.00000219939,  2.96120542961,      120.35824960600}, 
    {     0.00000233643,  2.97217201792,       46.20979048510}, 
    {     0.00000262427,  3.83657820849,      831.10498122420}, 
    {     0.00000233512,  4.47917715806,      628.85158605010}, 
    {     0.00000187419,  3.03519991355,      135.54855145410}, 
    {     0.00000216800,  3.42879551504,      241.61027108930}, 
    {     0.00000255790,  1.16711533037,      177.87437278590}, 
    {     0.00000220463,  0.19626840245,      180.27386923090}, 
    {     0.00000224582,  0.40674144020,      114.39910691340}, 
    {     0.00000205687,  2.30385491694,      259.50888592310}, 
    {     0.00000211135,  4.93079268569,      103.09277421860}, 
    {     0.00000175625,  5.51167774427,        7.11354700080}, 
    {     0.00000188093,  2.23534719993,        5.41662597140}, 
    {     0.00000171643,  5.21732384809,       41.64449777560}, 
    {     0.00000176103,  1.95966779423,      756.32338265690}, 
    {     0.00000170321,  4.95071878484,      206.18554843720}, 
    {     0.00000169478,  4.04293214414,       55.65914345610}, 
    {     0.00000219016,  0.24791955037,      294.67297614430}, 
    {     0.00000187790,  2.04529505651,      408.43894361130}, 
    {     0.00000182258,  0.70728907628,      391.17346822390}, 
    {     0.00000191808,  5.76676964168,      291.70403072770}, 
    {     0.00000153646,  4.70657045270,      543.02428721890}, 
    {     0.00000169989,  4.50972133596,      288.08069400530}, 
    {     0.00000163761,  5.22511628213,       67.35923502580}, 
    {     0.00000194295,  6.11711108749,      414.06801790380}, 
    {     0.00000168295,  5.25802294337,      518.64526483070}, 
    {     0.00000156891,  0.66346387654,      220.41264243880}, 
    {     0.00000182269,  0.78381581992,      417.03696332040}, 
    {     0.00000167500,  4.92284198283,      422.66603761290}, 
    {     0.00000170706,  2.30954371717,       98.89998852460}, 
    {     0.00000161764,  3.27144223053,      443.86366626340}, 
    {     0.00000133098,  2.88847467964,      373.90799283650}, 
    {     0.00000161139,  3.82341819072,      451.94042111070}, 
    {     0.00000179288,  4.82418428313,      366.48562929500}, 
    {     0.00000178253,  3.98045379191,    10138.50394764370}, 
    {     0.00000142045,  1.26892656490,      159.12442469020}, 
    {     0.00000153749,  4.27847447687,       45.57665103870}, 
    {     0.00000161285,  4.99511779244,       73.81839072080}, 
    {     0.00000146245,  2.65555668221,      465.95506679120}, 
    {     0.00000124849,  4.30472570922,      339.28641933650}, 
    {     0.00000154661,  4.32026115082,      760.25553592000}, 
    {     0.00000142885,  2.07772801387,      457.87831194390}, 
    {     0.00000152257,  4.64725594465,      155.78297225810}, 
    {     0.00000116813,  4.43623541426,        5.93789083320}, 
    {     0.00000113360,  4.65468501147,       80.19822453870}, 
    {     0.00000108272,  3.76939374352,      142.44965013380}, 
    {     0.00000133560,  5.30624966763,       14.01464568050}, 
    {     0.00000116290,  2.51243579606,      296.15744885260}, 
    {     0.00000129281,  0.36073764928,       96.87299909510}, 
    {     0.00000122859,  2.38440865925,      141.48644228730}, 
    {     0.00000101683,  1.05650638045,       92.30770638560}, 
    {     0.00000114628,  6.24869783552,      767.36908292080}, 
    {     0.00000113301,  0.83046410321,      100.38446123290}, 
    {     0.00000107414,  2.39445059446,      347.88443904560}, 
    {     0.00000095213,  0.79902536632,      342.25536475310}, 
    {     0.00000111110,  0.38500786215,      216.92243216040}, 
    {     0.00000127294,  0.42395251520,      331.32153907380}, 
    {     0.00000112636,  0.08107841996,      558.00214074590}, 
    {     0.00000103166,  0.69792291595,      358.93013930950}, 
    {     0.00000111707,  0.75072196369,       80.71948940050}, 
    {     0.00000090912,  5.16491055574,      144.14657116320}, 
    {     0.00000090696,  0.22132377420,      333.65734504400}, 
    {     0.00000098568,  4.33164222339,       74.52096613640}, 
    {     0.00000089282,  2.18851161054,       74.82978267710}, 
    {     0.00000117046,  3.94988763259,       74.26033370550}, 
    {     0.00000089282,  5.87783530506,       74.73341445750}, 
    {     0.00000097479,  0.69714600982,      977.48678462110}, 
    {     0.00000116587,  1.83677031992,     1289.94650101460}, 
    {     0.00000085652,  5.79984896939,        6.59228213900}, 
    {     0.00000086998,  5.61960123914,      300.61086697750}, 
    {     0.00000105424,  5.94521818668,      328.35259365720}, 
    {     0.00000112185,  1.21210217535,      329.72519178090}, 
    {     0.00000082982,  2.20797412496,       74.94165726170}, 
    {     0.00000094527,  4.54115315196,       28.57180808220}, 
    {     0.00000106878,  1.82068770403,      306.83064210100}, 
    {     0.00000103534,  2.99372662370,        6.21977512350}, 
    {     0.00000106186,  0.81603278109,     1087.69310584050}, 
    {     0.00000077777,  2.73309413665,      110.20632121940}, 
    {     0.00000098378,  3.73478755861,       75.04223099820}, 
    {     0.00000085982,  2.83236465462,      983.11585891360}, 
    {     0.00000089038,  4.73790965769,      604.47256366190}, 
    {     0.00000083329,  1.88332319315,      387.24131496080}, 
    {     0.00000085160,  1.25690280514,      142.14083359310}, 
    {     0.00000090074,  3.80297872640,      986.08480433020}, 
    {     0.00000074695,  1.35103014238,      350.33211960040}, 
    {     0.00000090483,  0.36671354002,        0.96320784650}, 
    {     0.00000095775,  5.54841186043,      969.62247809490}, 
    {     0.00000082748,  5.85591719177,       74.62153987290}, 
    {     0.00000075723,  2.78001204936,       88.11492069160}, 
    {     0.00000084009,  1.84380973979,      227.31374111850}, 
    {     0.00000070483,  4.65532969655,       44.72531777680}, 
    {     0.00000071348,  3.65007988636,      894.84087952760}, 
    {     0.00000094503,  4.98848650229,      403.13419222450}, 
    {     0.00000089085,  4.43916822737,      154.01661525950}, 
    {     0.00000079390,  5.66990936464,      267.47376618580}, 
    {     0.00000075695,  5.40808174797,       50.40257617910}, 
    {     0.00000068583,  4.76679841387,      991.71387862270}, 
    {     0.00000065256,  0.69286492023,      152.74459087230}, 
    {     0.00000062931,  2.90223286898,       79.88940799800}, 
    {     0.00000064054,  0.09529052033,      681.54178408960}, 
    {     0.00000080142,  2.97521726739,      526.72201967800}, 
    {     0.00000069651,  3.95227500507,      187.69623277240}, 
    {     0.00000059427,  3.59867941503,       58.10682401090}, 
    {     0.00000059240,  0.51080685499,       28.31117565130}, 
    {     0.00000068652,  2.41879555463,      235.39049596580}, 
    {     0.00000066216,  5.04460437297,       30.71067209630}, 
    {     0.00000070223,  3.73647394236,      546.95644048200}, 
    {     0.00000066829,  0.85504819327,      522.57741809380}, 
    {     0.00000062028,  2.31553517060,       74.03083904190}, 
    {     0.00000062958,  0.29182779746,      119.50691634410}, 
    {     0.00000071477,  3.16924790922,       23.57587323610}, 
    {     0.00000074807,  5.36814054526,      373.01422095920}, 
    {     0.00000063852,  2.36782311698,      157.63995198190}, 
    {     0.00000070614,  0.55855795030,       92.94084583200}, 
    {     0.00000055762,  5.27011035858,      874.39401040250}, 
    {     0.00000075741,  4.66371340256,      101.86893394120}, 
    {     0.00000073741,  6.20569442158,      312.45971639350}, 
    {     0.00000072959,  0.58417048033,      367.97010200330}, 
    {     0.00000053182,  2.24688972584,       17.52610781830}, 
    {     0.00000063238,  4.59765034931,       67.88049988760}, 
    {     0.00000060717,  0.57546407104,      253.57099508990}, 
    {     0.00000052840,  2.45780676537,      264.50482076920}, 
    {     0.00000070508,  1.51929972323,      552.58551477450}, 
    {     0.00000068624,  2.44507754450,      555.55446019110}, 
    {     0.00000062796,  0.33786296182,      561.18353448360}, 
    {     0.00000049353,  1.09630903572,       19.12245511120}, 
    {     0.00000064619,  5.27406291626,       68.18931642830}, 
    {     0.00000062909,  5.35706460122,       92.04707395470}, 
    {     0.00000047640,  3.90841810802,      192.69216761850}, 
    {     0.00000065137,  3.73959418275,      536.80451209540}, 
    {     0.00000065253,  4.24102184816,      771.30123618390}, 
    {     0.00000059404,  6.10556142565,      365.00115658670}, 
    {     0.00000052269,  1.71514378709,      905.88657979150}, 
    {     0.00000045962,  3.87433553200,      210.33015002140}, 
    {     0.00000062160,  2.68143699514,      130.44074202340}, 
    {     0.00000046457,  5.97440565334,      477.80391620720}, 
    {     0.00000046176,  3.89655419144,       48.75804477640}, 
    {     0.00000042915,  3.81993104061,       61.28821774860}, 
    {     0.00000047152,  0.99574606527,      166.82867252200}, 
    {     0.00000053843,  2.86748735900,      353.30106501700}, 
    {     0.00000042114,  2.61910843789,       90.82323367730}, 
    {     0.00000052610,  2.97705829152,      383.09671337660}, 
    {     0.00000043180,  4.15850225489,      173.68158709190}, 
    {     0.00000041297,  1.79923970180,      149.45132255000}, 
    {     0.00000044964,  1.76623473669,        0.52126486180}, 
    {     0.00000042836,  1.56965438447,      120.99138905240}, 
    {     0.00000049794,  4.03361534543,      303.86169668440}, 
    {     0.00000045233,  3.57778625450,       97.41551581630}, 
    {     0.00000038695,  2.39404211170,       31.49256938900}, 
    {     0.00000038067,  5.79467736188,       75.53235809270}, 
    {     0.00000050252,  4.76458300250,      911.30320576290}, 
    {     0.00000050884,  5.15513957128,      439.78275515400}, 
    {     0.00000042820,  5.17313041477,      162.09337010680}, 
    {     0.00000042805,  0.84360648676,       58.31927233200}, 
    {     0.00000050343,  5.81599953406,       66.91729204110}, 
    {     0.00000035657,  1.87511529678,      472.17484191470}, 
    {     0.00000045667,  1.92110814980,       55.13787859430}, 
    {     0.00000039992,  1.74263755793,       89.75945209430}, 
    {     0.00000049427,  1.89225881347,       42.58645376270}, 
    {     0.00000044919,  1.48348147872,      450.97721326420}, 
    {     0.00000034282,  5.20397534102,      316.39186965660}, 
    {     0.00000046407,  0.33922791761,      273.10284047830}, 
    {     0.00000037265,  2.03623179153,      117.91056905120}, 
    {     0.00000046107,  5.62298858989,     1819.63746610920}, 
    {     0.00000039368,  4.19402801195,      486.40193591630}, 
    {     0.00000041044,  4.82988044777,      149.67507171920}, 
    {     0.00000044959,  0.72694662195,     3265.83082813250}, 
    {     0.00000043756,  0.75422118122,      404.61866493280}, 
    {     0.00000031823,  3.84768075664,       20.44686912510}, 
    {     0.00000044288,  4.36757729571,      418.26080359780}, 
    {     0.00000038000,  3.03175184245,      167.08930495290}, 
    {     0.00000043649,  1.57339867295,      491.55792945680}, 
    {     0.00000033721,  1.26383804364,      260.99335863140}, 
    {     0.00000031278,  4.16119477825,       13.33332212430}, 
    {     0.00000036510,  2.58786153975,       68.56182344380}, 
    {     0.00000039768,  2.86365694380,      468.24268865160}, 
    {     0.00000036290,  1.35814658055,       59.28248017850}, 
    {     0.00000032168,  3.12118521629,      103.35340664950}, 
    {     0.00000033633,  0.15841728793,       24.11838995730}, 
    {     0.00000033723,  0.75503571162,      290.21955801940}, 
    {     0.00000029750,  5.33159349844,     1033.35837639830}, 
    {     0.00000031989,  4.67688193416,      205.22234059070}, 
    {     0.00000035268,  1.00718464333,     1108.13997496560}, 
    {     0.00000030858,  4.62657701145,      258.87574647670}, 
    {     0.00000032850,  5.25352681937,      114.13847448250}, 
    {     0.00000033452,  3.40494756837,       43.12897048390}, 
    {     0.00000031092,  2.26716508311,      104.00779795530}, 
    {     0.00000029723,  5.64053362927,      254.94359321360}, 
    {     0.00000031576,  3.78237106230,      152.01087768940}, 
    {     0.00000034573,  5.17385991822,       25.60286266560}, 
    {     0.00000028153,  3.92687523860,      199.28444975750}, 
    {     0.00000028415,  1.76927009458,      820.05928096030}, 
    {     0.00000028971,  2.58260543469,       76.47851959670}, 
    {     0.00000033643,  5.79472403547,      274.06604832480}, 
    {     0.00000031355,  1.39422550951,      178.78939652260}, 
    {     0.00000029433,  5.93671324356,      280.96714700450}, 
    {     0.00000030136,  0.44373325600,       27.08733537390}, 
    {     0.00000033815,  6.26141095251,      401.64971951620}, 
    {     0.00000027513,  2.15290154943,      480.77286162380}, 
    {     0.00000026821,  2.51632690244,      123.53964334370}, 
    {     0.00000026229,  0.22582956326,      286.59622129700}, 
    {     0.00000026562,  3.88341102553,      372.42352012820}, 
    {     0.00000034017,  1.44565808735,       88.79624424780}, 
    {     0.00000027740,  4.64687309709,      198.32124191100}, 
    {     0.00000029859,  0.82891399431,      100.64509366380}, 
    {     0.00000033948,  1.14432761269,       82.48584639910}, 
    {     0.00000026493,  1.98025893553,       95.38852638680}, 
    {     0.00000024352,  2.37812752505,      146.38180339690}, 
    {     0.00000027244,  2.10487988447,     1057.89745748090}, 
    {     0.00000026337,  0.39684584427,      106.01353552540}, 
    {     0.00000024101,  6.21637542402,       16.67477455640}, 
    {     0.00000031013,  5.33985788050,      476.43131808350}, 
    {     0.00000027036,  0.71198582048,      248.72381809010}, 
    {     0.00000023868,  3.42162769068,     1044.40407666220}, 
    {     0.00000029026,  3.98796449555,      908.33426034630}, 
    {     0.00000024251,  0.36629105441,       73.18525127440}, 
    {     0.00000022897,  2.26875155959,      175.16605980020}, 
    {     0.00000028024,  3.46485782344,     1439.50969814920}, 
    {     0.00000022051,  0.05165872393,       33.13710079170}, 
    {     0.00000022208,  5.32236354206,      483.22054217860}, 
    {     0.00000021075,  0.37096066639,      214.78356814630}, 
    {     0.00000020699,  1.79611118091,      118.02244363580}, 
    {     0.00000027443,  5.75986647976,     1215.16490244730}, 
    {     0.00000025481,  5.49691985470,      115.88357962170}, 
    {     0.00000027703,  4.11928306450,      694.07195706180}, 
    {     0.00000024828,  0.65238005620,      132.88842257820}, 
    {     0.00000021295,  3.86501877873,       66.18357885820}, 
    {     0.00000021146,  1.13726745832,       60.55450456570}, 
    {     0.00000023959,  4.56157429146,      458.84151979040}, 
    {     0.00000026221,  2.77532838847,      490.07345674850}, 
    {     0.00000022973,  4.52937663566,       78.40493528970}, 
    {     0.00000025273,  3.64987288394,       73.40900044360}, 
    {     0.00000026408,  3.37240518360,       49.72125262290}, 
    {     0.00000026870,  3.26028443561,      691.10301164520}, 
    {     0.00000021053,  5.54284102969,      129.91947716160}, 
    {     0.00000020861,  3.92598175503,      134.06407874580}, 
    {     0.00000022933,  5.02405062369,      150.52640498110}, 
    {     0.00000022980,  2.56727588550,      332.80601178210}, 
    {     0.00000020836,  0.98988990409,       29.20494752860}, 
    {     0.00000018891,  1.91272305963,      124.50285119020}, 
    {     0.00000018755,  1.07911898423,       70.11573212130}, 
    {     0.00000023454,  0.60524375676,      189.72322220190}, 
    {     0.00000023104,  3.93171225238,       43.28902917830}, 
    {     0.00000019351,  1.33568544736,      616.32141307790}, 
    {     0.00000023769,  0.02170705684,      593.42686339800}, 
    {     0.00000021258,  0.90140026224,      326.86812094890}, 
    {     0.00000019626,  1.40914183189,     1589.07289528380}, 
    {     0.00000018282,  4.55112709109,      165.60483224460}, 
    {     0.00000024502,  0.91753157942,      441.26722786230}, 
    {     0.00000024938,  4.63474678982,      162.89651925890}, 
    {     0.00000018904,  1.23360547168,       13.49338081870}, 
    {     0.00000017364,  5.28602832892,        7.86430652620}, 
    {     0.00000018603,  5.11206439748,       81.89514556810}, 
    {     0.00000017341,  4.06476736790,      403.02231763990}, 
    {     0.00000022513,  3.15059944802,      419.74527630610}, 
    {     0.00000017912,  2.53786076055,       47.06112374700}, 
    {     0.00000021237,  2.14856256664,       75.58474771940}, 
    {     0.00000016995,  2.48647736969,     2043.98226181110}, 
    {     0.00000022639,  2.07623129511,      699.70103135430}, 
    {     0.00000023531,  5.80237015057,      232.04904353370}, 
    {     0.00000019255,  1.56621203980,      425.11371816770}, 
    {     0.00000022735,  0.28274542760,        0.11187458460}, 
    {     0.00000020910,  5.30767454224,      237.67811782620}, 
    {     0.00000016146,  3.45551692754,        0.75075952540}, 
    {     0.00000021076,  0.96002144676,      405.99126305650}, 
    {     0.00000017963,  1.60799681102,      215.43795945210}, 
    {     0.00000016289,  4.88888227946,       69.15252427480}, 
    {     0.00000021756,  3.23184546146,     1744.85586754190}, 
    {     0.00000021708,  0.88801367868,      344.96367773880}, 
    {     0.00000015964,  0.34537232571,       77.06922042770}, 
    {     0.00000017286,  6.02968524571,       32.24332891440}, 
    {     0.00000015915,  2.96605572794,       25.86349509650}, 
    {     0.00000017830,  4.01479681257,      280.00393915800}, 
    {     0.00000014755,  3.74119528291,      610.69233878540}, 
    {     0.00000015023,  4.24763459617,      228.27694896500}, 
    {     0.00000015326,  0.22145354256,       17.26547538740}, 
    {     0.00000015354,  0.25482391126,      661.09491496450}, 
    {     0.00000016424,  3.43626239649,      147.11551657980}, 
    {     0.00000014654,  1.14175759154,      823.99143422340}, 
    {     0.00000015172,  5.07753627325,      114.94162363460}, 
    {     0.00000014674,  1.68177921160,      207.88246946660}, 
    {     0.00000017682,  5.94376629143,      624.91943278700}, 
    {     0.00000018848,  1.38456546450,      377.15882254340}, 
    {     0.00000015425,  1.66489033237,      440.68227252570}, 
    {     0.00000014513,  0.39264401278,      142.66209845490}, 
    {     0.00000014672,  4.41834132435,       16.46232623530}, 
    {     0.00000016992,  0.16042368544,      438.29828244570}, 
    {     0.00000016587,  0.92058534977,      369.08206769610}, 
    {     0.00000017239,  4.51659362028,      606.76018552230}, 
    {     0.00000013222,  3.04340106170,      668.20846196530}, 
    {     0.00000014458,  2.93327046597,      419.48464387520}, 
    {     0.00000013238,  0.13650358961,      216.48048917570}, 
    {     0.00000015722,  4.93688742368,      124.29040286910}, 
    {     0.00000012927,  1.65950183059,       54.33472944220}, 
    {     0.00000014216,  4.41971117975,       47.69426319340}, 
    {     0.00000012751,  0.03041331624,      217.23124870110}, 
    {     0.00000014006,  3.68870470760,       16.04163511000}, 
    {     0.00000014718,  1.08540409163,       49.50880430180}, 
    {     0.00000017579,  5.05617037261,      564.85505531580}, 
    {     0.00000012945,  1.53551413817,      218.92816973050}, 
    {     0.00000013528,  4.80158552555,       72.77586099720}, 
    {     0.00000012546,  3.43007050169,      958.57677783100}, 
    {     0.00000013034,  0.56491831473,     1171.87587326900}, 
    {     0.00000012452,  3.29205788475,      902.70518605380}, 
    {     0.00000011963,  1.41057536904,       55.77101804070}, 
    {     0.00000016470,  2.04067746898,      411.62033734900}, 
    {     0.00000015604,  1.53457514224,      833.55266177900}, 
    {     0.00000014914,  3.42772092084,       19.01058052660}, 
    {     0.00000012040,  5.17744918756,      135.33610313300}, 
    {     0.00000014349,  4.18933467558,       89.33876096900}, 
    {     0.00000015553,  3.54672509714,      113.87784205160}, 
    {     0.00000015574,  5.92871386562,      778.41478318470}, 
    {     0.00000015424,  2.12697366276,      106.27416795630}, 
    {     0.00000011957,  1.43314130608,      455.87257437380}, 
    {     0.00000015933,  5.49557852242,      513.07988101300}, 
    {     0.00000013562,  4.11426797137,       95.22846769240}, 
    {     0.00000012063,  0.20881650176,       65.87476231750}, 
    {     0.00000015093,  1.86345091876,        7.70424783180}, 
    {     0.00000015832,  3.42498484109,       79.51690098250}, 
    {     0.00000011492,  4.65187455620,      149.61138124440}, 
    {     0.00000014516,  3.35209961643,       19.64371997300}, 
    {     0.00000011406,  1.31085455047,       63.62402371880}, 
    {     0.00000012043,  0.01569453703,      397.39324334740}, 
    {     0.00000014157,  1.87440535402,     6283.07584999140}, 
    {     0.00000011355,  0.19026820825,        5.62907429250}, 
    {     0.00000014109,  0.09348109699,     6133.51265285680}, 
    {     0.00000011659,  0.84853578994,        5.10780943070}, 
    {     0.00000011052,  0.47607339293,      150.08446199640}, 
    {     0.00000013908,  5.65514309520,      639.89728631400}, 
    {     0.00000011505,  5.19475642280,     1182.92157353290}, 
    {     0.00000011492,  2.05801478182,      149.51501302480}, 
    {     0.00000014974,  3.54838066958,      252.65597135320}, 
    {     0.00000011550,  4.78304722906,      334.29048449040}, 
    {     0.00000010671,  4.67373109923,      149.72325582900}, 
    {     0.00000010855,  4.52379396618,      453.94615868080}, 
    {     0.00000014218,  0.08018756427,      240.38643081190}, 
    {     0.00000011896,  1.40803197220,       26.02355379090}, 
    {     0.00000013388,  0.76174926716,       37.87240320690}, 
    {     0.00000010860,  4.40226202285,       57.14361616440}, 
    {     0.00000010722,  5.34547451937,      331.20966448920}, 
    {     0.00000012796,  3.70341837855,       67.07735073550}, 
    {     0.00000013353,  0.86919663716,       22.89454967990}, 
    {     0.00000010568,  5.80969806479,      193.65537546500}, 
    {     0.00000010324,  2.99970080363,      525.75881183150}, 
    {     0.00000011331,  3.11771273798,       93.90405367850}, 
    {     0.00000014310,  1.06766336398,      477.91579079180}, 
    {     0.00000010296,  3.81447463840,      180.16199464630}, 
    {     0.00000012341,  4.62813430525,     1894.41906467650}, 
    {     0.00000011464,  0.93530139587,      121.84272231430}, 
    {     0.00000012833,  0.31985851817,      474.94684537520}, 
    {     0.00000012455,  2.84950981207,      184.09414790940}, 
    {     0.00000011730,  1.07977388266,      363.51668387840}, 
    {     0.00000010287,  6.03277961834,       43.24084506850}, 
    {     0.00000011395,  4.25533440684,      181.05576652360}, 
    {     0.00000010426,  1.46990536801,       80.41067285980}, 
    {     0.00000010020,  6.22580063292,       84.18276742850}, 
    {     0.00000013895,  3.46343536260,      157.26744496640}, 
    {     0.00000009893,  2.72218970897,      384.05992122310}, 
    {     0.00000010719,  2.47554935503,      140.65636088480}, 
    {     0.00000010964,  3.74557708007,      494.26624244250}, 
    {     0.00000012104,  2.69878200554,      369.45457471160}, 
    {     0.00000009686,  0.00697580080,       40.16002506730}, 
    {     0.00000012385,  1.71007866936,      229.08009811710}, 
    {     0.00000012577,  4.66630955474,       64.69910614990}, 
    {     0.00000010650,  1.78642598254,      252.08652238160}, 
    {     0.00000011653,  5.70662425749,       39.09624348430}, 
    {     0.00000011004,  3.58723041577,      449.28029223480}, 
    {     0.00000010454,  2.81847601796,     1246.65747183630}, 
    {     0.00000009326,  0.97605558757,      109.31254934210}, 
    {     0.00000009261,  5.19861935669,      749.20983565610}, 
    {     0.00000009811,  3.72249796639,      233.90602325750}, 
    {     0.00000010264,  6.08657486312,      156.15547927360}, 
    {     0.00000012406,  0.76207998570,      122.47586176070}, 
    {     0.00000010249,  2.86919673355,      189.18070548070}, 
    {     0.00000012671,  6.19797274264,      149.82382956550}, 
    {     0.00000009589,  1.00839074495,      393.46109008430}, 
    {     0.00000009106,  5.53296926826,      133.10087089930}, 
    {     0.00000010449,  1.23520879648,      148.59998928810}, 
    {     0.00000009923,  5.65994205559,       42.53826965290}, 
    {     0.00000012370,  5.29602370320,       20.49505323490}, 
    {     0.00000010304,  3.56303132976,      619.29035849450}, 
    {     0.00000011103,  5.89715087659,      832.58945393250}, 
    {     0.00000009313,  3.00333916453,      754.83890994860}, 
    {     0.00000010342,  5.50503668014,      460.53844081980}, 
    {     0.00000012219,  3.17057317997,       30.05628079050}, 
    {     0.00000008998,  5.82877688374,      248.46318565920}, 
    {     0.00000010082,  1.91119048650,       25.06034594440}, 
    {     0.00000010991,  0.05720554764,       54.28654533240}, 
    {     0.00000008638,  5.49106676064,      448.68959140380}, 
    {     0.00000009390,  1.32674472289,        9.40116886120}, 
    {     0.00000009621,  5.69090299390,       73.88782669000}, 
    {     0.00000010975,  4.40051429814,       63.84777288800}, 
    {     0.00000008365,  3.26943610840,      172.19711438360}, 
    {     0.00000009674,  4.27052644727,      282.66406803390}, 
    {     0.00000010770,  0.19304986906,      463.50738623640}, 
    {     0.00000010666,  1.42510087091,      268.43697403230}, 
    {     0.00000010567,  2.61602525339,      446.31134681820}, 
    {     0.00000008495,  5.03708799595,      370.93904741990}, 
    {     0.00000009888,  4.25430313596,      602.98809095360}, 
    {     0.00000010101,  5.04200998723,      241.87090352020}, 
    {     0.00000008890,  2.53320746730,      271.40591944890}, 
    {     0.00000009080,  0.99121734894,        6.90109867970}, 
    {     0.00000010416,  4.96315418372,       97.67614824720}, 
    {     0.00000008790,  3.05434837439,      291.26208774300}, 
    {     0.00000007936,  5.71233384542,      541.53981451060}, 
    {     0.00000010152,  1.90464684114,       91.45637312370}, 
    {     0.00000007939,  0.88279344814,      154.97982310600}, 
    {     0.00000008212,  0.00845991197,       76.42612997000}, 
    {     0.00000007965,  2.36308659035,      196.62432088160}, 
    {     0.00000008948,  4.31891786278,      469.13646052890}, 
    {     0.00000008460,  0.14600703561,      262.47783133970}, 
    {     0.00000009878,  0.61245182735,      308.31511480930}, 
    {     0.00000009120,  5.03217831219,      450.45594840240}, 
    {     0.00000010276,  3.58321573131,      842.15068148810}, 
    {     0.00000008153,  4.60445400464,       69.67378913660}, 
    {     0.00000010625,  2.28659627239,      194.28851491140}, 
    {     0.00000007552,  4.86800510971,     1097.09427470170}, 
    {     0.00000009019,  0.69841869766,      685.47393735270}, 
    {     0.00000007451,  5.67442696266,      337.80194662820}, 
    {     0.00000008011,  4.33417263028,      302.09533968580}, 
    {     0.00000009132,  1.09206046595,       93.79217909390}, 
    {     0.00000009342,  4.16662386065,       15.49911838880}, 
    {     0.00000007411,  3.04632695464,        7.42236354150}, 
    {     0.00000010072,  1.18952866918,      621.73803904930}, 
    {     0.00000008913,  1.33679256423,        0.26063243090}, 
    {     0.00000008189,  3.16576794671,       32.71640966640}, 
    {     0.00000007850,  4.37236255826,      464.47059408290}, 
    {     0.00000008734,  2.03651704284,      149.40313844020}, 
    {     0.00000007745,  0.14834225031,     1404.08497549710}, 
    {     0.00000009037,  3.53203542312,      636.66770846650}, 
    {     0.00000010212,  2.58904966897,      711.44930703380}, 
    {     0.00000008569,  2.47926109895,      497.44763618020}, 
    {     0.00000009591,  1.33938357595,      142.97091499560}, 
    {     0.00000007613,  1.86876737547,       31.65262808340}, 
    {     0.00000008723,  5.88916926012,       82.20396210880}, 
    {     0.00000008997,  2.37079010824,       76.15419669100}, 
    {     0.00000007128,  6.24450383630,      376.19561469690}, 
    {     0.00000009686,  5.67475763163,       98.35747180340}, 
    {     0.00000009993,  4.91667894523,      829.62050851590}, 
    {     0.00000007745,  4.87945477576,      310.17209453310}, 
    {     0.00000009812,  3.78656280821,      838.21852822500}, 
    {     0.00000008785,  6.14514661123,       17.63798240290}, 
    {     0.00000009500,  6.02030079251,      916.93228005540}, 
    {     0.00000008440,  5.06400284478,        1.37259812370}, 
    {     0.00000009802,  1.92874890805,       62.77269045690}, 
    {     0.00000007059,  5.91499106809,       74.14845912090}, 
    {     0.00000007016,  1.52544072246,      679.25416222920}, 
    {     0.00000009577,  1.44268080407,      763.43692965770}, 
    {     0.00000009562,  1.97733085047,      703.63318461740}, 
    {     0.00000007059,  1.94098053303,       75.41473801370}, 
    {     0.00000009214,  0.88741799785,      362.86229257260}, 
    {     0.00000006823,  5.11460794174,      107.49800823370}, 
    {     0.00000007148,  1.73466140387,     1190.78588005910}, 
    {     0.00000009073,  4.31998777457,       16.15350969460}, 
    {     0.00000009126,  3.74417362577,        4.66586644600}, 
    {     0.00000007923,  4.64511540440,      232.42155054920}, 
    {     0.00000008828,  1.08177391234,      412.58354519550}, 
    {     0.00000009169,  3.25102587429,      155.50108796780}, 
    {     0.00000007624,  0.88232424215,      459.36278465220}, 
    {     0.00000008200,  1.51866334745,    10063.72234907640}, 
    {     0.00000008005,  6.13208431788,      745.27768239300}, 
    {     0.00000008579,  2.37726234500,       75.67537044460}, 
    {     0.00000007597,  2.63491731877,      657.16276170140}, 
    {     0.00000006398,  0.61376490225,       73.24894174920}, 
    {     0.00000007149,  1.33917289544,      236.87496867410}, 
    {     0.00000006577,  4.82504547981,     1072.71525231350}, 
    {     0.00000006380,  3.20688120531,       73.34530996880}, 
    {     0.00000007506,  0.67400214407,      228.79821382680}, 
    {     0.00000007451,  3.06064473161,      171.65459766240}, 
    {     0.00000006361,  6.05108999867,       95.97922721780}, 
    {     0.00000007086,  4.88497877319,     6531.66165626500}, 
    {     0.00000006522,  4.01431695520,      118.87377689770}, 
    {     0.00000006236,  1.08169162104,      143.93412284210}, 
    {     0.00000007200,  1.19830150903,     1617.38407093510}, 
    {     0.00000006373,  3.27411945280,      116.53797092750}, 
    {     0.00000006150,  0.03921300469,      627.36711334180}, 
    {     0.00000008664,  5.60425824325,     2810.92146160520}, 
    {     0.00000007635,  4.06598468585,        4.73530241520}, 
    {     0.00000006147,  4.16482048084,     1300.99220127850}, 
    {     0.00000007471,  0.45174255163,      192.80404220310}, 
    {     0.00000008148,  3.11700641874,    10213.28554621100}, 
    {     0.00000008603,  3.80404544682,    25558.21217647960}, 
    {     0.00000007593,  2.86863623528,      406.10313764110}, 
    {     0.00000007725,  3.05989382335,      341.99473232220}, 
    {     0.00000007063,  5.35078594952,       73.03649342810}, 
    {     0.00000006762,  1.94867196735,      288.73508531110}, 
    {     0.00000006102,  2.06174377751,       73.97844941520}, 
    {     0.00000006993,  1.24520005325,      400.16524680790}, 
    {     0.00000007856,  3.11320541136,       81.68269724700}, 
    {     0.00000006731,  0.00424999029,      572.22923474750}, 
    {     0.00000006688,  0.03046234361,       90.28071695610}, 
    {     0.00000007766,  2.87448427459,       79.44746501330}, 
    {     0.00000007668,  1.71124875127,      104.52906281710}, 
    {     0.00000008317,  2.40731767085,      674.80074410430}, 
    {     0.00000006793,  1.29774355388,       22.63391724900}, 
    {     0.00000007732,  1.44266849755,      131.92521473170}, 
    {     0.00000006034,  0.96635268225,      476.31944349890}, 
    {     0.00000006000,  3.24980736635,       76.78733613740}, 
    {     0.00000006375,  1.37050567525,       75.15410558280}, 
    {     0.00000005861,  4.31971360878,       86.63044798330}, 
    {     0.00000007190,  3.21396773403,       71.15826184490}, 
    {     0.00000006303,  2.24129466051,     1310.39337013970}, 
    {     0.00000006628,  1.99043744200,        1.59634729290}, 
    {     0.00000006263,  3.47620738623,      346.39996633730}, 
    {     0.00000006081,  1.26599890520,       61.44827644300}, 
    {     0.00000007312,  5.48372849636,       50.66320861000}, 
    {     0.00000007300,  5.26774051203,      285.63301345050}, 
    {     0.00000005727,  2.39389303582,    20277.00789528740}, 
    {     0.00000007776,  5.47416512352,      416.77633088950}, 
    {     0.00000005693,  1.13593628568,      445.34813897170}, 
    {     0.00000005794,  2.43359359889,      180.79513409270}, 
    {     0.00000006927,  4.19296597477,      525.23754696970}, 
    {     0.00000007681,  5.64147063245,      549.72844394250}, 
    {     0.00000006680,  5.36285833774,      452.46168597250}, 
    {     0.00000007677,  0.71278975356,       44.07092647100}, 
    {     0.00000007734,  5.72717526802,      154.29849954980}, 
    {     0.00000005932,  3.22993254909,       73.45718455340}, 
    {     0.00000005683,  3.65029666464,      442.37919355510}, 
    {     0.00000005788,  2.17544248991,        2.28762186040}, 
    {     0.00000006685,  4.84971092730,      148.81243760920}, 
    {     0.00000005797,  0.51568102763,      149.30256470370}, 
    {     0.00000007739,  3.23104533276,      589.49471013490}, 
    {     0.00000007474,  2.47202834062,      321.76031151820}, 
    {     0.00000006106,  0.81922621826,       89.59939339990}, 
    {     0.00000005522,  1.83812319711,      375.39246554480}, 
    {     0.00000006706,  5.23367324742,      769.81676347560}, 
    {     0.00000006168,  4.58379993316,      137.55428902420}, 
    {     0.00000007210,  2.56243122515,      375.67434983510}, 
    {     0.00000006777,  0.50997508166,     1147.49685088080}, 
    {     0.00000006590,  3.39794943072,      389.68899551560}, 
    {     0.00000006376,  0.24081237769,      881.50755740330}, 
    {     0.00000005829,  6.04973118199,      172.45774681450}, 
    {     0.00000005827,  2.19507738696,        8.90683624980}, 
    {     0.00000005305,  1.97785611200,      150.31395666000}, 
    {     0.00000005706,  1.66973662153,       70.04629615210}, 
    {     0.00000005422,  1.21990761182,      332.17287233570}, 
    {     0.00000006818,  1.98954025696,      105.38039607900}, 
    {     0.00000007235,  2.78896876234,      748.09786996330}, 
    {     0.00000006360,  0.36304095923,       74.40909155180}, 
    {     0.00000005612,  3.49886328040,      102.52332524700}, 
    {     0.00000006581,  4.48256802747,       31.23193695810}, 
    {     0.00000006268,  3.59621382047,      488.84961647110}, 
    {     0.00000006360,  0.66780746624,      272.58157561650}, 
    {     0.00000006673,  0.77536194908,     6069.77675455340}, 
    {     0.00000005279,  4.27436629709,       11.15757484850}, 
    {     0.00000005611,  2.40776057824,     1286.01434775150}, 
    {     0.00000005900,  0.51262679903,      285.11174858870}, 
    {     0.00000005898,  5.26174074234,      757.80785536520}, 
    {     0.00000005385,  1.77116775784,      139.48070471720}, 
    {     0.00000006198,  0.83056505252,     1507.17774971570}, 
    {     0.00000005425,  1.93107713343,       40.84134862350}, 
    {     0.00000006091,  5.18564204379,      487.10451133190}, 
    {     0.00000005134,  2.61122038772,      194.17664032680}, 
    {     0.00000005505,  1.31212823209,      883.79517926370}, 
    {     0.00000005687,  1.96943472998,      394.35486196160}, 
    {     0.00000006304,  3.02157380188,      442.75170057060}, 
    {     0.00000005027,  4.45266598835,       12.00890811040}, 
    {     0.00000005204,  3.39869589191,     1400.15282223400}, 
    {     0.00000006542,  2.31977509408,      328.24071907260}, 
    {     0.00000004969,  6.27367198215,        0.16005869440}, 
    {     0.00000005019,  2.43585264336,      742.99006053260}, 
    {     0.00000005505,  0.32307346790,       40.58071619260}, 
    {     0.00000006432,  2.21948959433,     9999.98645077300}, 
    {     0.00000006932,  1.71722830737,      378.90392768260}, 
    {     0.00000005187,  3.04429850681,     1083.76095257740}, 
    {     0.00000004893,  6.06127550285,      980.66817835880}, 
    {     0.00000005791,  3.94061476239,      550.13783421970}, 
    {     0.00000005054,  5.63164324182,      164.12035953630}, 
    {     0.00000005481,  4.36493293939,      233.53351624200}, 
    {     0.00000005326,  0.06980162504,      336.83873878170}, 
    {     0.00000006675,  4.68809907572,      312.19908396260}, 
    {     0.00000005777,  2.24316510899,      230.93707784090}, 
    {     0.00000004907,  2.96039463510,      361.37781986430}, 
    {     0.00000006636,  0.34415075720,      511.59540830470}, 
    {     0.00000006333,  0.96579519801,      249.94765836750}, 
    {     0.00000006468,  3.02580538093,      298.23262239190}, 
    {     0.00000005096,  4.22435065058,       65.38042970610}, 
    {     0.00000005159,  3.77051984159,       57.25549074900}, 
    {     0.00000004974,  1.21594265105,      455.06942522170}, 
    {     0.00000005785,  5.06114337982,      216.26804085460}, 
    {     0.00000004960,  4.72806210230,      454.74930783290}, 
    {     0.00000005619,  2.27500441196,      227.52618943960}, 
    {     0.00000005161,  2.79823920744,      217.44369702220}, 
    {     0.00000004791,  4.40314095945,      853.19638175200}, 
    {     0.00000005450,  6.00971547441,       25.12978191360}, 
    {     0.00000005094,  3.96693309174,     1066.49547719000}, 
    {     0.00000006485,  3.02825531498,      167.72244439930}, 
    {     0.00000005396,  5.62885554221,      418.52143602870}, 
    {     0.00000005048,  2.46802064424,      987.56927703850}, 
    {     0.00000006152,  0.79853332272,     2274.54683263650}, 
    {     0.00000006507,  1.72872754258,      125.18417474640}, 
    {     0.00000004734,  0.64940724791,      119.39504175950}, 
    {     0.00000005785,  4.31238502962,      374.49869366750}, 
    {     0.00000006209,  4.78522319194,      270.18207917150}, 
    {     0.00000005381,  5.50204905208,      632.78373931320}, 
    {     0.00000004921,  1.43037646364,       73.13706716460}, 
    {     0.00000004596,  0.55370404346,       35.68535508300}, 
    {     0.00000005076,  1.34845106372,      455.02124111190}, 
    {     0.00000005730,  3.30386575677,       88.27497938600}, 
    {     0.00000005070,  4.59616483078,      454.79749194270}, 
    {     0.00000004547,  3.81754661073,     1329.30337692980}, 
    {     0.00000006213,  2.58827935033,      544.50875992720}, 
    {     0.00000004825,  6.08615762909,      304.12232911530}, 
    {     0.00000004824,  6.00481294702,      226.79247625670}, 
    {     0.00000005528,  5.69752791882,      548.44091319030}, 
    {     0.00000006054,  0.84188900289,       10.08249241740}, 
    {     0.00000005426,  2.44848284229,      531.97858695500}, 
    {     0.00000005047,  2.74537299312,      423.62924545940}, 
    {     0.00000006017,  0.11706831045,      149.04193227280}, 
    {     0.00000005671,  4.76092767065,      491.81856188770}, 
    {     0.00000005866,  6.20513223441,      772.78570889220}, 
    {     0.00000005334,  2.49860553733,     1131.19458333990}, 
    {     0.00000004766,  0.19527580548,      380.38840039090}, 
    {     0.00000004562,  0.55717668871,      253.45912050530}, 
    {     0.00000005777,  4.22586873011,      208.84567731310}, 
    {     0.00000005257,  4.72122908918,      535.32003938710}, 
    {     0.00000004406,  3.42864201394,      144.89733068860}, 
    {     0.00000005174,  1.37808288211,      520.12973753900}, 
    {     0.00000004469,  1.67012643165,     1261.63532536330}, 
    {     0.00000004331,  2.64717426456,     1517.26024213310}, 
    {     0.00000004802,  2.60569463520,      177.30492381430}, 
    {     0.00000005206,  0.97973969441,      128.43500445330}, 
    {     0.00000004368,  3.36272561974,     1503.24559645260}, 
    {     0.00000004329,  2.73534631925,      289.56516671360}, 
    {     0.00000004480,  1.66847193407,      357.44566660120}, 
    {     0.00000005386,  5.84886051674,      268.69760646320}, 
    {     0.00000005293,  1.36761627543,      271.61836777000}, 
    {     0.00000005277,  0.77780731413,     1670.07426897460}, 
    {     0.00000004812,  4.95769337401,      545.47196777370}, 
    {     0.00000005895,  2.03979596386,        8.59801970910}, 
    {     0.00000004410,  3.23960763864,      973.55463135800}, 
    {     0.00000004201,  6.02802824632,      204.70107572890}, 
    {     0.00000004947,  5.50324549674,      365.90067395840}, 
    {     0.00000004553,  2.77414446606,      147.96684984170}, 
    {     0.00000005351,  1.81217833246,      521.09294538550}, 
    {     0.00000004218,  0.73689779266,     1321.43907040360}, 
    {     0.00000005016,  1.91636964972,      535.91074021810}, 
    {     0.00000005188,  1.30753762651,      436.81380973740}, 
    {     0.00000005686,  2.54348150001,      501.37978944330}, 
    {     0.00000004126,  3.00605697657,      136.06981631590}, 
    {     0.00000004341,  3.74899549978,      263.02034806090}, 
    {     0.00000004976,  2.82755706922,      360.41461201780}, 
    {     0.00000005360,  3.99155865541,       92.41958097020}, 
    {     0.00000004935,  5.04375067678,      697.80716836880}, 
    {     0.00000004129,  1.50064332826,       71.86083726050}, 
    {     0.00000004825,  2.90964137048,      551.10104206620}, 
    {     0.00000005036,  4.66411186577,      305.60680182360}, 
    {     0.00000004587,  4.78553156868,       95.93104310800}, 
    {     0.00000005054,  5.41201072891,      758.77106321170}, 
    {     0.00000005012,  4.50266403787,      635.96513305090}, 
    {     0.00000005151,  0.41217186078,      968.13800538660}, 
    {     0.00000004247,  0.65406696565,      920.86443331850}, 
    {     0.00000005150,  1.13490701556,      310.97524368520}, 
    {     0.00000004941,  2.84565061722,      406.95447090300}, 
    {     0.00000004569,  5.19758291396,       10.29494073850}, 
    {     0.00000004259,  5.53167973839,      184.98791978670}, 
    {     0.00000004604,  2.51643176466,      962.50893109410}, 
    {     0.00000004409,  1.59455204572,      367.59759498780}, 
    {     0.00000005105,  1.26007002216,      971.10695080320}, 
    {     0.00000004500,  6.15657007891,     1052.26838318840}, 
    {     0.00000003968,  0.07377679014,       77.70235987410}, 
    {     0.00000003900,  1.66467970991,      945.24345570670}, 
    {     0.00000004137,  4.19706074841,       25.27279426550}, 
    {     0.00000004237,  2.80797873442,      213.95348674380}, 
    {     0.00000003899,  4.28674267073,      224.23292111730}, 
    {     0.00000005030,  6.24112139947,     1162.47470440780}, 
    {     0.00000004967,  2.58649417006,      358.40887444770}, 
    {     0.00000003859,  2.72333630141,      818.57480825200}, 
    {     0.00000004889,  2.50485923786,      355.74874557180}, 
    {     0.00000004626,  6.00420830249,      421.18156490460}, 
    {     0.00000004765,  4.37822799323,      117.36805233000}, 
    {     0.00000003919,  4.81677862044,      893.35640681930}, 
    {     0.00000004287,  3.15207047069,      846.08283475120}, 
    {     0.00000003941,  0.04342429962,     1235.61177157240}, 
    {     0.00000003816,  2.42145744929,      348.84764689210}, 
    {     0.00000004756,  1.32234737789,      238.90195810360}, 
    {     0.00000004077,  5.68854469970,      695.55642977010}, 
    {     0.00000003842,  0.37429373380,      774.48262992160}, 
    {     0.00000004674,  0.08112657673,     1366.21257229020}, 
    {     0.00000005313,  4.38472090135,      689.61853893690}, 
    {     0.00000004578,  0.36908312831,      168.31314523030}, 
    {     0.00000004827,  1.26561568753,      170.76082578510}, 
    {     0.00000004636,  5.93439675803,      148.19059901090}, 
    {     0.00000005128,  0.17600223269,      433.71173787680}, 
    {     0.00000004291,  3.12693688865,      377.41945497430}, 
    {     0.00000003927,  5.59942396205,     1048.33622992530}, 
    {     0.00000004226,  6.24596640453,      448.97147569410}, 
    {     0.00000003776,  1.78756451192,       71.70077856610}, 
    {     0.00000003850,  2.72007090628,      151.85081899500}, 
    {     0.00000004561,  0.07201979569,     2349.32843120380}, 
    {     0.00000004291,  5.39929372298,      523.75307426140}, 
    {     0.00000004143,  0.17158866287,      735.87651353180}, 
    {     0.00000003694,  1.44652002583,       48.91810347080}, 
    {     0.00000003728,  1.69745141654,      984.71220620650}, 
    {     0.00000004173,  4.01017634093,      195.77298761970}, 
    {     0.00000004986,  1.03560339271,      224.45667028650}, 
    {     0.00000004031,  0.92145122185,       76.00543884470}, 
    {     0.00000004097,  3.51219407937,       72.49397670690}, 
    {     0.00000003812,  4.41246815759,     1511.32235129990}, 
    {     0.00000004098,  2.39702785276,      239.16259053450}, 
    {     0.00000003751,  5.81981147475,      450.71658083330}, 
    {     0.00000003657,  1.41388494440,      117.31986822020}, 
    {     0.00000004373,  4.08948598951,       75.43598987310}, 
    {     0.00000004765,  4.44775874782,       51.88704888740}, 
    {     0.00000003700,  2.04103813925,       63.21463344160}, 
    {     0.00000004436,  5.76580545650,      836.52160719560}, 
    {     0.00000004648,  2.07482117651,     1106.65550225730}, 
    {     0.00000004854,  5.26337784504,      601.50361824530}, 
    {     0.00000003736,  1.46595907948,      138.62937145530}, 
    {     0.00000004304,  3.03122452327,     1109.62444767390}, 
    {     0.00000004020,  0.59697361731,       91.24392480260}, 
    {     0.00000004937,  5.49417275871,      976.73602509570}, 
    {     0.00000003719,  0.11762341199,     1031.87390369000}, 
    {     0.00000004036,  2.09041185441,      325.38364824060}, 
    {     0.00000004373,  3.76648561161,       74.12720726150}, 
    {     0.00000004545,  1.35255134812,       41.75637236020}, 
    {     0.00000004172,  0.75349427039,     1500.06420271490}, 
    {     0.00000004190,  5.82534911413,      346.44815044710}, 
    {     0.00000003784,  0.83700163181,      827.92358748650}, 
    {     0.00000004454,  1.87402712883,      141.17762574660}, 
    {     0.00000004853,  0.95917381603,       58.17051448570}, 
    {     0.00000004409,  0.16608106044,      630.33605875840}, 
    {     0.00000003597,  1.02560564655,      515.46387109300}, 
    {     0.00000004822,  3.83570312464,      163.57784281510}, 
    {     0.00000004021,  5.68447974866,        3.49021027840}, 
    {     0.00000004244,  3.75845344717,      733.42883297700}, 
    {     0.00000003933,  4.55157642432,      240.12579838100}, 
    {     0.00000004421,  1.51263319894,     1610.27052393430}, 
    {     0.00000003390,  4.00215380112,       74.99404688840}, 
    {     0.00000004556,  3.41531360523,     1140.38330388000}, 
    {     0.00000004171,  0.76417016678,      623.43496007870}, 
    {     0.00000003997,  5.74857613262,     6212.22640468720}, 
    {     0.00000004540,  3.21454634514,      761.74000862830}, 
    {     0.00000004232,  0.83887267580,      176.65053250850}, 
    {     0.00000004098,  1.41920746453,      559.69906177530}, 
    {     0.00000004553,  1.09016692751,      561.88610989920}, 
    {     0.00000003828,  4.08837921098,      268.95823889410}, 
    {     0.00000003598,  5.35099971703,      394.94556279260}, 
    {     0.00000003484,  5.54596330164,      594.91133610630}, 
    {     0.00000003564,  1.57868308864,      354.99798604640}, 
    {     0.00000004279,  2.35436288262,      562.66800719190}, 
    {     0.00000003896,  4.66682485035,       71.92452773530}, 
    {     0.00000004485,  4.71272827101,      731.94436026870}, 
    {     0.00000003398,  1.62086348540,      941.31130244360}, 
    {     0.00000003299,  5.13632919725,      477.00076705510}, 
    {     0.00000004623,  2.72836206211,     6244.94281435360}, 
    {     0.00000003308,  2.60386718967,       14.81779483260}, 
    {     0.00000003435,  2.96178781224,      995.64603188580}, 
    {     0.00000003980,  3.73613153043,      673.31627139600}, 
    {     0.00000003623,  0.12701520068,       49.17873590170}, 
    {     0.00000004377,  0.27353840833,      469.72716135990}, 
    {     0.00000003255,  1.24513640154,       82.64590509350}, 
    {     0.00000003323,  4.51516827363,      454.86118241750}, 
    {     0.00000003320,  1.42938752044,      454.95755063710}, 
    {     0.00000003495,  5.61859895107,     1116.00428149180}, 
    {     0.00000003593,  5.35238853915,       57.51612317990}, 
    {     0.00000004196,  1.04465999471,      743.79320968470}, 
    {     0.00000003512,  6.09122971288,       70.58881287330}, 
    {     0.00000003814,  2.49565462974,     6204.36209816100}, 
    {     0.00000003828,  4.39752166068,      586.31331639720}, 
    {     0.00000003924,  1.10707044380,      686.95841006100}, 
    {     0.00000003356,  6.26211053275,      447.20511869550}, 
    {     0.00000003639,  4.85097208169,      138.40562228610}, 
    {     0.00000003518,  0.52105043625,      262.80789973980}, 
    {     0.00000003671,  1.99667387765,      511.53171782990}, 
    {     0.00000004167,  1.61938375536,      576.16138801060}, 
    {     0.00000003263,  2.27802067614,      295.19424100610}, 
    {     0.00000003215,  0.64628330219,      887.72733252680}, 
    {     0.00000003232,  2.20615118349,       68.63125941300}, 
    {     0.00000003279,  3.50509705814,      256.42806592190}, 
    {     0.00000003718,  3.27473813045,      454.64873409640}, 
    {     0.00000003638,  2.63250736806,      455.16999895820}, 
    {     0.00000003459,  3.18851975154,      377.68008740520}, 
    {     0.00000003772,  0.88810300052,    10142.43610090680}, 
    {     0.00000003669,  4.11456655271,      409.92341631960}, 
    {     0.00000003530,  4.02075420346,      388.20452280730}, 
    {     0.00000003163,  1.65300792599,      765.88461021250}, 
    {     0.00000003568,  5.95965909592,      460.84725736050}, 
    {     0.00000003188,  1.74587038709,       18.91000679010}, 
    {     0.00000003305,  5.77382040863,       10.52443540210}, 
    {     0.00000004026,  2.48487699537,      531.17543780290}, 
    {     0.00000003345,  4.15802505352,     1515.77576942480}, 
    {     0.00000003644,  1.78909340323,      251.17149864490}, 
    {     0.00000003525,  2.56091667232,    78114.14622758799}, 
    {     0.00000003147,  5.05814757549,     1521.40484371730}, 
    {     0.00000003155,  0.65831540442,       74.04788538440}, 
    {     0.00000004180,  1.16833674800,      514.56435372130}, 
    {     0.00000003255,  1.96741940264,       58.73996345730}, 
    {     0.00000003212,  3.18682610058,     1512.80682400820}, 
    {     0.00000003486,  0.22630227172,       36.53668834490}, 
    {     0.00000003997,  5.58144993177,       57.79800747020}, 
    {     0.00000003628,  2.42977552434,      230.82520325630}, 
    {     0.00000003884,  5.65770848460,       94.42531854030}, 
    {     0.00000003485,  3.26177495276,       36.76043751410}, 
    {     0.00000003506,  6.26633354904,      545.27502581760}, 
    {     0.00000003187,  1.62296832026,      138.46931276090}, 
    {     0.00000003934,  2.86731965547,      832.06818907070}, 
    {     0.00000003115,  5.67364420834,       73.55775828990}, 
    {     0.00000003721,  2.55626754637,      279.48267429620}, 
    {     0.00000003171,  4.85529878165,      138.56568098050}, 
    {     0.00000003108,  3.14860474691,       72.54636633360}, 
    {     0.00000003777,  5.94890597104,      873.17017012510}, 
    {     0.00000004357,  4.15105623366,    10175.15251057320}, 
    {     0.00000003525,  4.80316435970,      429.77958461370}, 
    {     0.00000003382,  1.45717307307,     5983.94945572220}, 
    {     0.00000004161,  5.39091883238,     1363.24362687360}, 
    {     0.00000003537,  4.29176088936,       36.17548217750}, 
    {     0.00000003115,  0.59873966282,      273.85360000370}, 
    {     0.00000003457,  3.94796907904,      444.82687410990}, 
    {     0.00000003593,  3.91831549069,    10134.57179438060}, 
    {     0.00000003700,  0.67445695843,       73.93026530540}, 
    {     0.00000003547,  5.63096398237,      440.89472084680}, 
    {     0.00000003622,  1.10742531477,     2250.16781024830}, 
    {     0.00000003562,  3.80604468765,     1525.33699698040}, 
    {     0.00000003330,  1.76480149289,       78.97438426130}, 
    {     0.00000003013,  0.69171521367,      210.85141488320}, 
    {     0.00000003241,  3.65013641564,      335.77495719870}, 
    {     0.00000003032,  5.77852412826,      612.17681149370}, 
    {     0.00000003978,  4.58297442673,      898.77303279070}, 
    {     0.00000003337,  4.81258545559,      597.35901666110}, 
    {     0.00000003141,  3.11768616608,     6607.92772754060}, 
    {     0.00000003696,  1.76581280127,      384.58118608490}, 
    {     0.00000003577,  3.95434949639,      179.31066138440}, 
    {     0.00000003020,  5.04193408020,      197.79997704920}, 
    {     0.00000004082,  3.52781255989,      402.21916848780}, 
    {     0.00000003454,  3.41560919175,      912.78767847120}, 
    {     0.00000003697,  0.89932694516,       75.63293182920}, 
    {     0.00000003238,  1.15084522701,      104.83787935780}, 
    {     0.00000003374,  0.40981508151,      677.76968952090}, 
    {     0.00000003500,  4.46985063604,       46.47042291600}, 
    {     0.00000003111,  1.88860295507,       34.20088237470}, 
    {     0.00000003953,  0.25645102865,      517.16079212240}, 
    {     0.00000003194,  4.56998602897,     1385.17496870700}, 
    {     0.00000003931,  1.09338513303,      388.46515523820}, 
    {     0.00000002930,  4.88144353120,      455.66012605270}, 
    {     0.00000003180,  1.03370427552,      885.43971066640}, 
    {     0.00000003235,  5.09681747179,      464.99185894470}, 
    {     0.00000003173,  5.68964342749,        4.19278569400}, 
    {     0.00000003181,  2.87968862974,     9914.15915194180}, 
    {     0.00000003355,  5.45857968674,       73.08467753790}, 
    {     0.00000003951,  5.81493541571,      586.37700687200}, 
    {     0.00000002899,  5.12928266291,      448.31708438830}, 
    {     0.00000002903,  1.06370870134,      454.15860700190}, 
    {     0.00000003706,  2.47342147635,       64.25716316520}, 
    {     0.00000003649,  1.90256590579,       31.54075349880}, 
    {     0.00000003360,  4.99299052479,      143.34342201110}, 
    {     0.00000003657,  4.53797912903,      676.28521681260}, 
    {     0.00000003488,  5.62713714766,     3189.56475685690}, 
    {     0.00000002940,  4.33606107945,    78263.70942472259}, 
    {     0.00000003309,  3.10770680369,      519.60847267720}, 
    {     0.00000003781,  4.30315299354,      164.54105066160}, 
    {     0.00000004030,  4.41794838679,      772.58876693610}, 
    {     0.00000003058,  4.84465787968,      221.16340196420}, 
    {     0.00000002867,  5.17129632099,      346.18751801620}, 
    {     0.00000003842,  1.87994191354,      299.71709510020}, 
    {     0.00000002844,  4.34268503622,      262.05714021440}, 
    {     0.00000003724,  4.94511644698,      984.48845703730}, 
    {     0.00000003216,  5.70775867303,       14.66903698630}, 
    {     0.00000002923,  0.37358823115,        6.48040755440}, 
    {     0.00000002931,  0.78809830626,      540.05534180230}, 
    {     0.00000003707,  4.14868763219,     6136.48159827340}, 
    {     0.00000003931,  5.52289695589,     6171.64568849460}, 
    {     0.00000002830,  2.11705330414,       34.53095077480}, 
    {     0.00000003348,  3.08775772849,      245.49424024260}, 
    {     0.00000003394,  2.49196845335,      260.36021918500}, 
    {     0.00000003378,  3.82658652472,    25936.85547173129}, 
    {     0.00000003041,  2.14503983522,     6604.95878212400}, 
    {     0.00000003657,  6.02755271763,      340.88276662940}, 
    {     0.00000002818,  4.44508352472,      369.34270012700}, 
    {     0.00000002865,  3.21935127992,        3.82027867850}, 
    {     0.00000003738,  5.38309514127,      980.14691349700}, 
    {     0.00000002797,  5.97725967979,     2014.02655475710}, 
    {     0.00000003280,  0.74832416123,      422.71422172270}, 
    {     0.00000003511,  1.92497000013,      343.47920503050}, 
    {     0.00000002962,  2.29867992492,      661.15860543930}, 
    {     0.00000003603,  2.72183511139,      508.62646288810}, 
    {     0.00000003620,  5.57691156197,    10066.69129449300}, 
    {     0.00000003306,  6.20620840278,       11.56696512570}, 
    {     0.00000003279,  6.13563821647,      276.07178589490}, 
    {     0.00000002823,  1.19859134883,     1119.18567522950}, 
    {     0.00000003302,  5.46042536571,      302.37722397610}, 
    {     0.00000002747,  4.57476263020,      226.63241756230}, 
    {     0.00000003814,  3.13695930196,      901.95442652840}, 
    {     0.00000002707,  0.46257342768,     1458.47209456600}, 
    {     0.00000003402,  4.84131712548,      714.67888488130}, 
    {     0.00000003346,  1.90971738740,       44.61344319220}, 
    {     0.00000002960,  5.31788128818,     1467.07011427510}, 
    {     0.00000003062,  1.93542241882,      987.78172535960}, 
    {     0.00000003045,  4.24065596268,      170.17012495410}, 
    {     0.00000003504,  4.10521239427,     6280.10690457480}, 
    {     0.00000002674,  1.01129308948,      582.38116313410}, 
    {     0.00000003584,  3.12196206765,      108.72184851110}, 
    {     0.00000002975,  0.13746189123,     9987.45627780080}, 
    {     0.00000002634,  5.61201014857,      412.37109687440}, 
    {     0.00000003702,  0.66231252049,    10101.85538471420}, 
    {     0.00000003526,  4.42297802934,      322.61164478010}, 
    {     0.00000003261,  4.39228048501,       75.37229939830}, 
    {     0.00000002939,  3.26319979871,      130.55261660800}, 
    {     0.00000003295,  3.98758407636,      488.58898404020}, 
    {     0.00000002737,  3.15826692829,      683.02625679790}, 
    {     0.00000002915,  1.47424610987,      680.05731138130}, 
    {     0.00000002624,  0.47879556723,       29.22619938800}, 
    {     0.00000002678,  1.28275200438,      236.19364511790}, 
    {     0.00000003678,  3.46436124301,    26468.03090953420}, 
    {     0.00000002598,  2.16996571956,      191.31956949480}, 
    {     0.00000002943,  3.58544468129,    12489.88562870720}, 
    {     0.00000002720,  1.24094972893,      989.05374974680}, 
    {     0.00000002894,  2.26999120840,     1615.89959822680}, 
    {     0.00000002985,  4.93091159917,      132.57960603750}, 
    {     0.00000002579,  1.27635624544,     1034.84284910660}, 
    {     0.00000002711,  1.25250599577,    52250.58788171570}, 
    {     0.00000002917,  5.69857391789,      688.65533109040}, 
    {     0.00000003483,  1.97113718781,      655.93892142400}, 
    {     0.00000003280,  1.75059058234,      683.98946464440}, 
    {     0.00000003260,  3.46047977615,       74.19089773630}, 
    {     0.00000002936,  2.61715717878,      115.36231475990}, 
    {     0.00000003200,  0.66316490563,      457.35704708210}, 
    {     0.00000002565,  3.47443238116,     2042.49778910280}, 
    {     0.00000003158,  4.58160924364,    12492.85457412380}, 
    {     0.00000002719,  2.89546184370,       27.72047482030}, 
    {     0.00000003373,  5.52806001629,    10210.31660079440}, 
    {     0.00000002600,  0.31946397676,       85.93917341580}, 
    {     0.00000002619,  4.43681016724,      949.17560896980}, 
    {     0.00000003290,  1.35055242247,      515.67631941410}, 
    {     0.00000003180,  4.49938964982,      694.83822295220}, 
    {     0.00000002586,  4.09771865336,     1448.91086701040}, 
    {     0.00000002574,  5.47692668053,      246.97871295090}, 
    {     0.00000003001,  3.24181300229,     1618.86854364340}, 
    {     0.00000003009,  3.16728117117,      385.75684225250}, 
    {     0.00000002675,  4.91608217296,      754.03576079650}, 
    {     0.00000002535,  0.13831089527,      591.94239068970}, 
    {     0.00000003319,  5.98200177347,      533.83556667880}, 
    {     0.00000003307,  3.31452419197,      732.97125859000}, 
    {     0.00000002975,  5.72770980032,     1011.42703456490}, 
    {     0.00000003460,  2.59999470578,      267.58564077040}, 
    {     0.00000002857,  4.11031053901,     2267.43328563570}, 
    {     0.00000002754,  0.78792218586,      229.45260513260}, 
    {     0.00000003422,  6.18592254593,      281.48841186630}, 
    {     0.00000003495,  0.17224634960,      371.52974825090}, 
    {     0.00000002547,  4.45612695304,      901.22071334550}, 
    {     0.00000002476,  1.55163657371,     1234.12729886410}, 
    {     0.00000003380,  3.46612468213,      283.62727588040}, 
    {     0.00000002593,  1.42286075943,      141.69889060840}, 
    {     0.00000002665,  2.98397830634,      250.60204967330}, 
    {     0.00000002424,  3.87508350406,       70.63699698310}, 
    {     0.00000002458,  4.65895339908,      392.65794093220}, 
    {     0.00000002877,  5.47506403197,     1436.54075273260}, 
    {     0.00000002948,  3.49876539234,      123.01837848190}, 
    {     0.00000002739,  6.05181954433,      161.41204655060}, 
    {     0.00000002361,  5.34825180906,      318.67949151700}, 
    {     0.00000003221,  1.06289254235,      388.72578766910}, 
    {     0.00000002715,  1.28980431988,      108.98248094200}, 
    {     0.00000002392,  2.58938442749,      156.67674413540}, 
    {     0.00000002313,  5.57068624384,       29.79564835960}, 
    {     0.00000002351,  3.65378596351,      112.39336934330}, 
    {     0.00000002768,  5.42256168790,      482.25733433210}, 
    {     0.00000002731,  2.33677247572,      273.15102458810}, 
    {     0.00000003230,  5.65661970187,      134.37289528650}, 
    {     0.00000002685,  5.03687735302,      763.22448133660}, 
    {     0.00000002816,  5.71804752798,      327.43756992050}, 
    {     0.00000002608,  3.11386505876,      578.44900987100}, 
    {     0.00000002371,  3.52034351878,        3.62333672240}, 
    {     0.00000002260,  6.23958645351,      400.57463708510}, 
    {     0.00000003089,  5.69639540598,      537.39521292640}, 
    {     0.00000002840,  0.03011890351,      563.37058260750}, 
    {     0.00000002430,  4.24536997427,       27.74172667970}, 
    {     0.00000002300,  2.44747995452,      107.91869935900}, 
    {     0.00000002756,  0.44285569281,      255.83736509090}, 
    {     0.00000002255,  3.38467700412,     1257.70317210020}, 
    {     0.00000002260,  3.85026258012,      753.14198891920}, 
    {     0.00000002598,  0.43155550046,      175.42669223110}, 
    {     0.00000002319,  6.27990804405,      493.04240216510}, 
    {     0.00000002579,  1.76841912074,      710.74673161820}, 
    {     0.00000002323,  5.19875505188,      380.23964254460}, 
    {     0.00000002426,  0.96570848986,      225.30800354840}, 
    {     0.00000002182,  3.63636403703,      178.13500521680}, 
    {     0.00000002713,  0.64055715691,      424.15051032120}, 
    {     0.00000002850,  5.36388642993,       44.09217833040}, 
    {     0.00000002174,  1.36737239358,      526.50957135690}, 
    {     0.00000002230,  0.18624095003,      309.27832265580}, 
    {     0.00000002691,  3.12857199475,       36.90919536040}, 
    {     0.00000002356,  4.70736394167,     1297.06004801540}, 
    {     0.00000002705,  3.96315420875,      466.75821594330}, 
    {     0.00000002120,  4.00527978646,       78.92620015150}, 
    {     0.00000002790,  4.69333575335,      845.88589279510}, 
    {     0.00000002790,  3.15560752049,      696.32269566050}, 
    {     0.00000002082,  4.28436571612,     1134.16352875650}, 
    {     0.00000002650,  1.97955054585,      421.22974901440}, 
    {     0.00000002350,  2.27006566559,      280.21638747910}, 
    {     0.00000002757,  3.97088429501,      566.33952802410}, 
    {     0.00000002400,  2.08287192901,     3116.26763099790}, 
    {     0.00000002091,  4.86268336295,     1222.27844944810}, 
    {     0.00000002402,  4.59336971395,      569.04784100980}, 
    {     0.00000002053,  4.50782983699,     2045.46673451940}, 
    {     0.00000002585,  3.01434261062,       30.59879751170}, 
    {     0.00000002362,  0.28351250494,    25863.55834587229}, 
    {     0.00000002296,  2.43545418785,    52252.07235442399}, 
    {     0.00000002296,  4.03915647243,    52102.50915728939}, 
    {     0.00000002480,  4.82872104445,      702.14871190910}, 
    {     0.00000002394,  2.71842287880,      688.44288276930}, 
    {     0.00000002598,  5.52873150583,      207.36120460480}, 
    {     0.00000002726,  2.73636031357,      320.32402291970}, 
    {     0.00000002686,  3.13615031711,      161.72086309130}, 
    {     0.00000002651,  4.31467866101,      639.63665388310}, 
    {     0.00000001999,  3.81218083941,      122.05517063540}, 
    {     0.00000002454,  4.63684196748,     1012.91150727320}, 
    {     0.00000001998,  4.34234332604,      343.21857259960}, 
    {     0.00000001982,  1.04358448861,       76.31425538540}, 
    {     0.00000002651,  4.50494915824,     6209.77872413240}, 
    {     0.00000002315,  2.16329763901,      380.01589337540}, 
    {     0.00000002012,  0.58027132344,      530.65417294110}, 
    {     0.00000001987,  2.34515279356,      768.85355562910}, 
    {     0.00000002062,  5.14612272595,       68.30119101290}, 
    {     0.00000001998,  4.72846905297,       76.21788716580}, 
    {     0.00000002501,  1.46803291637,       95.27665180220}, 
    {     0.00000002564,  2.20950808655,      566.60016045500}, 
    {     0.00000002569,  1.68642117040,      749.58234267160}, 
    {     0.00000002047,  4.43426104911,      229.34073054800}, 
    {     0.00000002226,  1.08954827693,      383.30916169770}, 
    {     0.00000002046,  3.37543676127,     1055.44977692610}, 
    {     0.00000001954,  2.49907098662,      313.94418910180}, 
    {     0.00000002177,  3.00048235729,      317.87634236490}, 
    {     0.00000002238,  0.97968512796,      147.55745956450}, 
    {     0.00000002148,  0.16770637484,      112.65400177420}, 
    {     0.00000002350,  5.77036099171,      304.23420369990}, 
    {     0.00000002183,  5.58654428071,      428.08266358430}, 
    {     0.00000002063,  5.64116701319,       73.66963287450}, 
    {     0.00000002535,  1.13554897110,      140.96517742550}, 
    {     0.00000002445,  0.65211381551,      271.66655187980}, 
    {     0.00000002072,  2.29027742046,      696.51963761660}, 
    {     0.00000002080,  1.24910729957,      311.28406022590}, 
    {     0.00000001912,  3.75992027324,      528.72775724810}, 
    {     0.00000002063,  2.21480458793,       75.89356426010}, 
    {     0.00000002107,  4.64640498877,      150.36634628670}, 
    {     0.00000001883,  5.29259430554,      381.09097580650}, 
    {     0.00000002562,  1.42062915032,      551.21291665080}, 
    {     0.00000002062,  0.46104612533,      386.06565879320}, 
    {     0.00000001916,  5.84122649523,      481.73606947030}, 
    {     0.00000002333,  4.77162438255,      347.93262315540}, 
    {     0.00000002156,  2.11521771652,     1250.58962509940}, 
    {     0.00000002347,  1.97105922216,      188.23874949360}, 
    {     0.00000002034,  5.51423990497,      678.36039035190}, 
    {     0.00000002321,  3.54031153946,      103.98654609590}, 
    {     0.00000001833,  5.62091026321,      840.66620877980}, 
    {     0.00000002378,  6.00073785450,      664.12755085590}, 
    {     0.00000001896,  2.15809918048,      379.16456011350}, 
    {     0.00000001809,  5.61397062326,       14.22709400160}, 
    {     0.00000002262,  4.58517690940,      430.53034413910}, 
    {     0.00000001933,  0.42376762202,      915.44780734710}, 
    {     0.00000001933,  5.10325064461,     1065.01100448170}, 
    {     0.00000002083,  4.96820157485,      294.30046912880}, 
    {     0.00000001797,  2.39655065767,      311.93845153170}, 
    {     0.00000001797,  0.79284837309,      461.50164866630}, 
    {     0.00000001865,  1.13583348993,      739.05790726950}, 
    {     0.00000001865,  5.81531651252,      888.62110440410}, 
    {     0.00000001793,  5.78804613930,      625.88264063350}, 
    {     0.00000001947,  5.79903258109,      257.39127376840}, 
    {     0.00000002462,  3.95916783110,       26.82670294300}, 
    {     0.00000002317,  0.68746265782,      625.99451521810}, 
    {     0.00000002107,  0.10366607161,     1002.75957888660}, 
    {     0.00000002174,  4.30981640926,      221.89711514710}, 
    {     0.00000001883,  4.16371906934,      213.18722085340}, 
    {     0.00000001991,  2.15389092541,      507.59956456680}, 
    {     0.00000001810,  3.70831888738,      539.25219265020}, 
    {     0.00000001991,  5.06761957393,      255.57673266000}, 
    {     0.00000001812,  0.78741962695,      151.26011816400}, 
    {     0.00000001964,  2.71891117329,     1024.21783996800}, 
    {     0.00000002252,  4.45925757192,      598.53467282870}, 
    {     0.00000001804,  2.34130589983,       80.93193772160}, 
    {     0.00000001854,  0.13193495049,     1396.97142849630}, 
    {     0.00000001854,  4.81141797308,     1546.53462563090}, 
    {     0.00000002186,  2.58979636823,       76.52670370650}, 
    {     0.00000001763,  5.59121902178,      947.69113626150}, 
    {     0.00000001763,  0.91173599918,      798.12793912690}, 
    {     0.00000001816,  0.95956155095,      156.04360468900}, 
    {     0.00000002202,  2.18092416439,      583.86563584240}, 
    {     0.00000001910,  2.64138421542,      498.19839570560}, 
    {     0.00000001910,  4.24508650001,      348.63519857100}, 
    {     0.00000002215,  2.45791819477,      154.55913198070}, 
    {     0.00000002322,  6.16493439544,     3340.61242669980}, 
    {     0.00000001895,  2.02396634720,      467.43953949950}, 
    {     0.00000001943,  4.41537853646,      185.57862061770}, 
    {     0.00000001738,  2.44168217704,      913.00012679230}, 
    {     0.00000002046,  2.19760587122,      882.99203011160}, 
    {     0.00000001830,  1.16794111151,       47.27357206810}, 
    {     0.00000002143,  5.26070898677,       42.06518890090}, 
    {     0.00000002200,  5.89750938920,    10139.98842035200}, 
    {     0.00000001677,  1.72367555591,      975.03910406630}, 
    {     0.00000001677,  3.26140378877,     1124.60230120090}, 
    {     0.00000001776,  5.05356646709,      956.28915597060}, 
    {     0.00000002115,  3.10908283877,       84.86409098470}, 
    {     0.00000002116,  4.50159315432,      269.07011347870}, 
    {     0.00000001770,  2.96002469436,     1459.95656727430}, 
    {     0.00000001807,  3.84800342064,      529.57909051000}, 
    {     0.00000001870,  2.93365111310,     1208.05135544650}, 
    {     0.00000001870,  4.47137934596,     1357.61455258110}, 
    {     0.00000001891,  1.70111414825,      190.66517818900}, 
    {     0.00000002060,  5.06581864584,    26013.12154300690}, 
    {     0.00000001835,  4.71120582490,       76.10601258120}, 
    {     0.00000002020,  1.67687010626,      354.78553772530}, 
    {     0.00000001733,  2.43404581799,      187.27554164710}, 
    {     0.00000001641,  0.46152323273,      303.05854753230}, 
    {     0.00000001671,  0.67572104809,      154.67100656530}, 
    {     0.00000001696,  3.15463633411,      398.28701522470}, 
    {     0.00000001968,  5.83082526219,      195.40048060420}, 
    {     0.00000002230,  1.76801946880,      624.51004250980}, 
    {     0.00000002151,  3.33296618401,      552.69738935910}, 
    {     0.00000001674,  3.34095983797,      316.65250208750}, 
    {     0.00000002029,  2.07844879451,      199.85389872910}, 
    {     0.00000002029,  0.47474650993,      349.41709586370}, 
    {     0.00000002114,  3.86984575671,       81.26200612170}, 
    {     0.00000002147,  5.63931772550,      590.83042499690}, 
    {     0.00000001706,  0.73548513365,      961.02445838580}, 
    {     0.00000001706,  2.33918741824,      811.46126125120}, 
    {     0.00000001822,  1.64784768077,      473.46237266690}, 
    {     0.00000001822,  3.25154996536,      323.89917553230}, 
    {     0.00000001909,  5.58002039864,     6134.99712556510}, 
    {     0.00000002061,  3.34168764903,        6.85291456990}, 
    {     0.00000001846,  4.33154014750,     1396.22066897090}, 
    {     0.00000001879,  4.21685982495,       52.14768131830}, 
    {     0.00000001937,  2.04746615092,      367.85822741870}, 
    {     0.00000001937,  3.58519438379,      517.42142455330}, 
    {     0.00000001884,  1.88048876898,       12.15766595670}, 
    {     0.00000001602,  1.46373302224,      325.95309721220}, 
    {     0.00000001754,  4.23029342972,      539.09213395580}, 
    {     0.00000001645,  6.23273743453,      782.34693644780}, 
    {     0.00000002153,  1.61615068478,      587.86147958030}, 
    {     0.00000001702,  2.46774061252,      407.47573576480}, 
    {     0.00000001602,  4.95996654045,      487.15269544170}, 
    {     0.00000001576,  3.95360340011,     2077.76245306050}, 
    {     0.00000001576,  2.41587516724,     1928.19925592590}, 
    {     0.00000001576,  5.44388861190,      532.13864564940}, 
    {     0.00000001880,  1.41060159000,      575.26761613330}, 
    {     0.00000001880,  6.09008461260,      724.83081326790}, 
    {     0.00000001596,  5.33991691502,       34.62157350000}, 
    {     0.00000001624,  1.21716384102,      475.51629434680}, 
    {     0.00000001803,  0.60015233109,      529.80283967920}, 
    {     0.00000001662,  3.50151803039,      484.70501488690}, 
    {     0.00000001735,  1.01657070139,      196.88495331250}, 
    {     0.00000001584,  0.28218018153,     1811.77315958300}, 
    {     0.00000001804,  6.08380488717,      188.65944061890}, 
    {     0.00000001758,  0.53211549640,      550.88859374510}, 
    {     0.00000001758,  2.06984372926,      700.45179087970}, 
    {     0.00000001573,  5.38350153220,      461.12914165080}, 
    {     0.00000001667,  0.24230138722,      556.51766803760}, 
    {     0.00000001559,  6.02213221899,      343.73983746140}, 
    {     0.00000001796,  5.78444078662,      525.49817940060}, 
    {     0.00000001563,  0.80617444410,      563.63121503840}, 
    {     0.00000001603,  4.38109882376,       59.59129671920}, 
    {     0.00000001606,  1.83958629336,     1349.75024605490}, 
    {     0.00000001606,  3.44328857794,     1200.18704892030}, 
    {     0.00000001665,  3.75333799201,      764.70895404490}, 
    {     0.00000001665,  2.14963570742,      914.27215117950}, 
    {     0.00000001741,  0.81651703967,      548.24397123420}, 
    {     0.00000001766,  2.00418474011,      495.96316347190}, 
    {     0.00000001980,  4.53192980595,     1054.92851206430}, 
    {     0.00000001980,  2.99420157308,      905.36531492970}, 
    {     0.00000002146,  2.25428923199,       67.92868399740}, 
    {     0.00000001560,  3.27821444787,     1208.94512732380}, 
    {     0.00000001695,  2.26284891229,      493.30303459600}, 
    {     0.00000001940,  4.17311496384,      981.63138620530}, 
    {     0.00000002135,  5.07005192745,      245.54242435240}, 
    {     0.00000001604,  4.06884840529,     1136.45115061690}, 
    {     0.00000001703,  2.08965979965,      274.58731318660}, 
    {     0.00000001678,  0.30302488401,     1297.86319716750}, 
    {     0.00000002086,  3.24437004031,      516.04882642960}, 
    {     0.00000001505,  0.38622833840,      509.08403727510}, 
    {     0.00000001631,  0.44359079978,      806.72595883600}, 
    {     0.00000001544,  4.38766645261,      206.70681329900}, 
    {     0.00000001495,  4.52648520007,      234.49672408850}, 
    {     0.00000001549,  0.99024664404,      834.07392664080}, 
    {     0.00000001549,  5.73570371835,      684.51072950620}, 
    {     0.00000002013,  5.61129200002,       81.63451313720}, 
    {     0.00000001950,  0.19680015179,      118.07062774560}, 
    {     0.00000001943,  5.23985037412,       14.55716240170}, 
    {     0.00000001483,  0.49824817575,     1020.82820342610}, 
    {     0.00000001483,  2.03597640861,     1170.39140056070}, 
    {     0.00000001482,  4.41190841719,      170.71264167530}, 
    {     0.00000001902,  2.07103832540,       15.19030184810}, 
    {     0.00000001493,  2.13656720330,       10.93382567930}, 
    {     0.00000001702,  2.78478335260,      844.59836204290}, 
    {     0.00000001914,  6.05987746357,     1211.23274918420}, 
    {     0.00000002038,  1.60297482666,     6588.42201938410}, 
    {     0.00000001689,  3.06284907974,        0.80314915210}, 
    {     0.00000001685,  0.28381539862,      521.61421024730}, 
    {     0.00000001734,  3.45650791724,     1895.90353738480}, 
    {     0.00000001636,  1.62858153403,      164.38099196720}, 
    {     0.00000001602,  0.20642761616,       64.48665782880}, 
    {     0.00000001800,  2.99044739237,      101.60830151030}, 
    {     0.00000001867,  2.92532022361,     6060.21552699780}, 
    {     0.00000001822,  4.31796502202,      934.19775544280}, 
    {     0.00000001660,  5.69708947634,     1291.43097372290}, 
    {     0.00000002000,  5.18442514436,      452.20105354160}, 
    {     0.00000001573,  2.39570178134,      614.83694036960}, 
    {     0.00000001446,  6.12512087543,      568.29708148440}, 
    {     0.00000001446,  4.58739264257,      418.73388434980}, 
    {     0.00000001432,  1.97954511274,      504.56118318100}, 
    {     0.00000001578,  4.62126447177,      669.69293467360}, 
    {     0.00000001773,  3.00675487512,       16.98359109710}, 
    {     0.00000001514,  0.35161589106,      403.70364119610}, 
    {     0.00000001888,  3.89724586598,     1440.99417085750}, 
    {     0.00000001900,  3.58215504368,     3192.53370227350}, 
    {     0.00000001747,  4.07850521042,     6346.81174829480}, 
    {     0.00000001747,  2.54077697756,     6197.24855116020}, 
    {     0.00000001683,  1.92235280620,      181.64646735460}, 
    {     0.00000001587,  4.99761782220,     6057.24658158120}, 
    {     0.00000001889,  0.62618826487,     1129.71011063160}, 
    {     0.00000001753,  1.82324191014,     1020.02505427400}, 
    {     0.00000001753,  3.36097014300,     1169.58825140860}, 
    {     0.00000001407,  3.87667893220,      904.18965876210}, 
    {     0.00000001658,  0.17315209135,      170.01006625970}, 
    {     0.00000001612,  4.71519560888,      370.04527554260}, 
    {     0.00000001456,  5.78909667336,      415.66436519670}, 
    {     0.00000001472,  3.92804806651,      212.33588759150}, 
    {     0.00000001776,  5.89527317383,     1593.80819769900}, 
    {     0.00000001776,  4.29157088924,     1743.37139483360}, 
    {     0.00000001398,  2.89266999881,      376.94637422230}, 
    {     0.00000001936,  3.02716801943,    10518.63171560370}, 
    {     0.00000001423,  1.34276219051,      302.74973099160}, 
    {     0.00000001929,  4.65175583668,     2199.76523406920}, 
    {     0.00000001930,  3.81505372582,      543.91805909620}, 
    {     0.00000001581,  4.28040315071,      375.93498226600}, 
    {     0.00000001621,  2.21372960034,      362.03221117010}, 
    {     0.00000001629,  4.08549980424,      340.51025961390}, 
    {     0.00000001756,  1.24206336045,      555.66633477570}, 
    {     0.00000001391,  4.05514082167,      623.22251175760}, 
    {     0.00000001480,  0.85968170103,      557.03893289940}, 
    {     0.00000001421,  0.13443282384,     1523.69246557770}, 
    {     0.00000001421,  1.73813510842,     1374.12926844310}, 
    {     0.00000001399,  1.64961108641,      356.27001043360}, 
    {     0.00000001847,  1.78123333872,    25939.82441714789}, 
    {     0.00000001466,  0.75306338987,        2.00573757010}, 
    {     0.00000001461,  3.67524662572,      139.17188817650}, 
    {     0.00000001453,  4.69267570928,      746.76215510130}, 
    {     0.00000001450,  3.85293024011,      907.37105249980}, 
    {     0.00000001369,  1.34933149459,     1130.23137549340}, 
    {     0.00000001420,  2.79221953555,      396.54191008550}, 
};


static const struct vsop uranus_radius_r1[RADIUS_R1] = {
    {     0.01479896629,  3.67205697578,       74.78159856730}, 
    {     0.00071212143,  6.22600975161,       63.73589830340}, 
    {     0.00068627160,  6.13411179902,      149.56319713460}, 
    {     0.00020857554,  5.24625848960,       11.04570026390}, 
    {     0.00021468362,  2.60175716374,       76.26607127560}, 
    {     0.00024059369,  3.14159265359,        0.00000000000}, 
    {     0.00011405056,  0.01849738017,       70.84944530420}, 
    {     0.00007496797,  0.42361355955,       73.29712585900}, 
    {     0.00004243606,  1.41691058162,       85.82729883120}, 
    {     0.00003505951,  2.58348117401,      138.51749687070}, 
    {     0.00003228800,  5.25495561645,        3.93215326310}, 
    {     0.00003926833,  3.15526349399,       71.81265315070}, 
    {     0.00003059899,  0.15323842112,        1.48447270830}, 
    {     0.00003578254,  2.31157935775,      224.34479570190}, 
    {     0.00002564235,  0.98078549108,      148.07872442630}, 
    {     0.00002429191,  3.99450740432,       52.69019803950}, 
    {     0.00001644830,  2.65310351864,      127.47179660680}, 
    {     0.00001583569,  1.43049534360,       78.71375183040}, 
    {     0.00001413380,  4.57461623347,      202.25339517410}, 
    {     0.00001489724,  2.67568435302,       56.62235130260}, 
    {     0.00001403280,  1.36986207457,       77.75054398390}, 
    {     0.00001227894,  1.04699377171,       62.25142559510}, 
    {     0.00001507836,  5.06019185241,      151.04766984290}, 
    {     0.00000991944,  2.17181655850,       65.22037101170}, 
    {     0.00001032728,  0.26473484111,      131.40394986990}, 
    {     0.00000861752,  5.05508815872,      351.81659230870}, 
    {     0.00000744512,  3.07725212553,       35.16409022120}, 
    {     0.00000603966,  0.90716451094,      984.60033162190}, 
    {     0.00000647014,  4.47286717163,       70.32818044240}, 
    {     0.00000574672,  3.23069145540,      447.79581952650}, 
    {     0.00000687477,  2.49910872963,       77.96299230500}, 
    {     0.00000623247,  0.86227007749,        9.56122755560}, 
    {     0.00000527867,  5.15141241909,        2.96894541660}, 
    {     0.00000561872,  2.71781314149,      462.02291352810}, 
    {     0.00000530530,  5.91685160971,      213.29909543800}, 
    {     0.00000459886,  4.22296426568,       12.53017297220}, 
    {     0.00000494251,  0.46321800530,      145.63104387150}, 
    {     0.00000487371,  0.70688896635,      380.12776796000}, 
    {     0.00000380709,  3.85094436388,        3.18139373770}, 
    {     0.00000444185,  2.15555848995,       67.66805156650}, 
    {     0.00000338646,  2.53719277381,       18.15924726470}, 
    {     0.00000372951,  5.05141758574,      529.69096509460}, 
    {     0.00000348335,  1.74875375735,       71.60020482960}, 
    {     0.00000405615,  1.22950417858,       22.09140052780}, 
    {     0.00000268994,  6.24204805310,      340.77089204480}, 
    {     0.00000255860,  2.95699944505,       84.34282612290}, 
    {     0.00000259244,  3.92085033287,       59.80374504030}, 
    {     0.00000224702,  3.90949421678,      160.60889739850}, 
    {     0.00000221874,  3.64708443278,      137.03302416240}, 
    {     0.00000254339,  3.50524488134,       38.13303563780}, 
    {     0.00000238200,  2.04842095939,      269.92144674060}, 
    {     0.00000272459,  3.38353829996,      222.86032299360}, 
    {     0.00000200600,  1.24854381161,       69.36497259590}, 
    {     0.00000234216,  0.27861629739,      108.46121608020}, 
    {     0.00000188802,  4.41158620525,      265.98929347750}, 
    {     0.00000212138,  0.68012161063,      111.43016149680}, 
    {     0.00000205992,  1.53361539719,      284.14854074220}, 
    {     0.00000196457,  4.77133840382,      299.12639426920}, 
    {     0.00000153201,  5.21574674133,      209.36694217490}, 
    {     0.00000163544,  4.34120077587,       33.67961751290}, 
    {     0.00000150382,  1.98905719076,       54.17467074780}, 
    {     0.00000136927,  0.40354426815,      195.13984817330}, 
    {     0.00000117521,  0.39618046394,       87.31177153950}, 
    {     0.00000128577,  2.40591376513,       39.61750834610}, 
    {     0.00000104684,  2.91746030897,      134.58534360760}, 
    {     0.00000103870,  1.81603765254,       72.33391801250}, 
    {     0.00000106087,  0.17146170085,       79.23501669220}, 
    {     0.00000106822,  0.69945014388,        2.44768055480}, 
    {     0.00000094904,  4.02460487466,       82.85835341460}, 
    {     0.00000104645,  4.43615418997,      305.34616939270}, 
    {     0.00000093832,  5.01799603662,       51.20572533120}, 
    {     0.00000103733,  2.57520994669,      191.20769491020}, 
    {     0.00000106820,  1.22984965801,      225.82926841020}, 
    {     0.00000093580,  3.09257295667,       77.22927912210}, 
    {     0.00000097607,  3.81404159560,      152.53214255120}, 
    {     0.00000084782,  5.72500693196,       68.84370773410}, 
    {     0.00000077488,  0.08155105577,       45.57665103870}, 
    {     0.00000076047,  4.20422198550,       73.81839072080}, 
    {     0.00000086387,  0.53091293351,      145.10977900970}, 
    {     0.00000075755,  3.78546185557,       75.74480641380}, 
    {     0.00000077592,  1.63627982289,      479.28838891550}, 
    {     0.00000084780,  0.61510586137,      116.42609634290}, 
    {     0.00000100494,  4.93994320097,      120.35824960600}, 
    {     0.00000071979,  4.30613043603,      565.11568774670}, 
    {     0.00000071236,  2.38119498898,       60.76695288680}, 
    {     0.00000071539,  3.93757368948,      153.49535039770}, 
    {     0.00000084837,  5.55880391517,      344.70304530790}, 
    {     0.00000063516,  1.93751130249,       41.64449777560}, 
    {     0.00000071587,  3.71204011090,      408.43894361130}, 
    {     0.00000061914,  3.90141588459,        4.45341812490}, 
    {     0.00000065088,  1.55911828467,      106.97674337190}, 
    {     0.00000060091,  0.60112111486,       74.89347315190}, 
    {     0.00000061828,  4.39028435621,      453.42489381900}, 
    {     0.00000063246,  4.18799696764,      184.72728735580}, 
    {     0.00000062339,  3.23753339104,      422.66603761290}, 
    {     0.00000054893,  3.72792577723,        7.11354700080}, 
    {     0.00000052457,  6.08632045364,      404.50679034820}, 
    {     0.00000053071,  3.51022280941,      125.98732389850}, 
    {     0.00000059034,  1.55684840494,      456.39383923560}, 
    {     0.00000058831,  5.33573241567,      220.41264243880}, 
    {     0.00000052838,  5.20104115605,      358.93013930950}, 
    {     0.00000052878,  4.44628349017,      426.59819087600}, 
    {     0.00000055201,  1.60181891958,       14.97785352700}, 
    {     0.00000050997,  0.52968367981,      490.33408917940}, 
    {     0.00000049541,  4.25523625544,        5.41662597140}, 
    {     0.00000051389,  0.37029408817,      206.18554843720}, 
    {     0.00000051834,  1.75478067650,        8.07675484730}, 
    {     0.00000056742,  0.83891135620,      146.59425171800}, 
    {     0.00000049107,  0.94051631401,       99.16062095550}, 
    {     0.00000045714,  5.34241750716,      152.74459087230}, 
    {     0.00000048197,  1.97584360072,      288.08069400530}, 
    {     0.00000044024,  3.03717070644,       20.60692781950}, 
    {     0.00000049092,  5.84636334727,      112.91463420510}, 
    {     0.00000041989,  0.04895666240,      128.95626931510}, 
    {     0.00000048335,  3.62867663323,       81.00137369080}, 
    {     0.00000041451,  2.33805925587,      277.03499374140}, 
    {     0.00000040161,  5.09672112780,       35.42472265210}, 
    {     0.00000041968,  2.50991447143,       24.37902238820}, 
    {     0.00000038204,  3.61405134343,      173.94221952280}, 
    {     0.00000038414,  2.06063652881,      333.65734504400}, 
    {     0.00000042597,  1.26088737300,     1514.29129671650}, 
    {     0.00000038855,  0.74315611802,      347.88443904560}, 
    {     0.00000038552,  4.95041145803,       92.94084583200}, 
    {     0.00000033234,  1.38358507432,       74.66972398270}, 
    {     0.00000033788,  3.68407945156,       66.91729204110}, 
    {     0.00000039054,  5.49702926560,      200.76892246580}, 
    {     0.00000031786,  0.54344835858,      203.73786788240}, 
    {     0.00000033322,  6.26106483857,     1059.38193018920}, 
    {     0.00000030806,  2.53797566903,      977.48678462110}, 
    {     0.00000030059,  0.19481253674,      387.24131496080}, 
    {     0.00000029120,  5.44130853027,       58.10682401090}, 
    {     0.00000028997,  3.10546504714,      991.71387862270}, 
    {     0.00000027827,  0.36512476794,       80.19822453870}, 
    {     0.00000035694,  3.72852678524,       96.87299909510}, 
    {     0.00000032516,  4.38447867630,      221.37585028530}, 
    {     0.00000026840,  1.35294770385,        0.96320784650}, 
    {     0.00000031276,  0.79566551587,      373.01422095920}, 
    {     0.00000025922,  3.45840169631,      144.14657116320}, 
    {     0.00000031032,  2.06301188151,      230.56457082540}, 
    {     0.00000030278,  0.71358545978,      109.94568878850}, 
    {     0.00000024834,  3.04814439142,       14.01464568050}, 
    {     0.00000025206,  5.12301274564,       81.37388070630}, 
    {     0.00000027765,  4.75859307922,      415.55249061210}, 
    {     0.00000025582,  2.56904012503,      522.57741809380}, 
    {     0.00000024351,  2.20288762433,      628.85158605010}, 
    {     0.00000024132,  5.67351884701,      443.86366626340}, 
    {     0.00000025491,  1.78473889586,      143.62530630140}, 
    {     0.00000024065,  0.67010805340,       46.20979048510}, 
    {     0.00000025679,  5.43185950755,      546.95644048200}, 
    {     0.00000024624,  3.30585050808,      617.80588578620}, 
    {     0.00000024242,  5.59897471399,       32.19514480460}, 
    {     0.00000022390,  4.82189515313,      135.54855145410}, 
    {     0.00000027179,  2.02720095476,      536.80451209540}, 
    {     0.00000021973,  4.59216176679,      241.61027108930}, 
    {     0.00000022055,  4.61793641919,      391.17346822390}, 
    {     0.00000020834,  0.24550904041,      465.95506679120}, 
    {     0.00000027275,  2.15420645259,      140.00196957900}, 
    {     0.00000023632,  4.94972840898,      561.18353448360}, 
    {     0.00000021149,  5.27166890173,      159.12442469020}, 
    {     0.00000023328,  3.80624099549,       55.13787859430}, 
    {     0.00000020015,  1.30330553666,      518.64526483070}, 
    {     0.00000024853,  0.53398556310,      181.75834193920}, 
    {     0.00000020058,  4.88841177982,      909.81873305460}, 
    {     0.00000019193,  1.31168318333,      543.02428721890}, 
    {     0.00000020801,  0.91178178054,       76.47851959670}, 
    {     0.00000018990,  4.67975156701,       98.89998852460}, 
    {     0.00000019667,  0.66620464883,       66.70484372000}, 
    {     0.00000025922,  4.52830002662,      454.90936652730}, 
    {     0.00000018833,  6.08042451630,      103.09277421860}, 
    {     0.00000021624,  1.23560892029,       41.10198105440}, 
    {     0.00000018091,  0.96586313214,       55.65914345610}, 
    {     0.00000021264,  4.19514315520,      329.72519178090}, 
    {     0.00000018717,  5.77529020491,      142.44965013380}, 
    {     0.00000019415,  4.31464975363,        6.21977512350}, 
    {     0.00000023318,  5.83851945854,      297.64192156090}, 
    {     0.00000016657,  6.09418922673,      211.81462272970}, 
    {     0.00000016201,  2.49044081792,       61.28821774860}, 
    {     0.00000020158,  3.16239645425,      186.21176006410}, 
    {     0.00000016004,  2.97277766861,       81.89514556810}, 
    {     0.00000019202,  6.01151966247,      155.78297225810}, 
    {     0.00000017468,  4.82367359029,      273.10284047830}, 
    {     0.00000015141,  3.65588411554,      472.17484191470}, 
    {     0.00000018451,  3.47623430315,       36.64856292950}, 
    {     0.00000016303,  0.13085990583,      554.06998748280}, 
    {     0.00000018634,  0.23919770714,       23.57587323610}, 
    {     0.00000014358,  2.69393539884,       70.11573212130}, 
    {     0.00000015190,  2.43789398876,      486.40193591630}, 
    {     0.00000014488,  0.14254642208,      235.39049596580}, 
    {     0.00000013868,  5.09135892763,       29.20494752860}, 
    {     0.00000014406,  1.56741430063,      110.20632121940}, 
    {     0.00000015722,  4.25156109914,      146.38180339690}, 
    {     0.00000017435,  1.95393343617,      835.03713448730}, 
    {     0.00000013691,  1.63831110433,       92.04707395470}, 
    {     0.00000013239,  2.85690648081,       49.50880430180}, 
    {     0.00000012541,  2.92111856784,       60.55450456570}, 
    {     0.00000012594,  3.20935822266,      100.38446123290}, 
    {     0.00000014937,  0.32571457437,      259.50888592310}, 
    {     0.00000012827,  2.77958172785,      105.49227066360}, 
    {     0.00000012323,  3.36427641421,      440.68227252570}, 
    {     0.00000015261,  0.25477631378,      258.87574647670}, 
    {     0.00000012061,  0.08834689678,      157.63995198190}, 
    {     0.00000012881,  0.30715003179,      124.29040286910}, 
    {     0.00000010930,  3.41396817201,       33.13710079170}, 
    {     0.00000011062,  4.99201784219,      604.47256366190}, 
    {     0.00000010713,  3.88653353837,      767.36908292080}, 
    {     0.00000010435,  5.25417558285,      264.50482076920}, 
    {     0.00000012860,  4.80794300903,      114.39910691340}, 
    {     0.00000011561,  2.60450140190,      166.82867252200}, 
    {     0.00000010926,  0.64149188846,      558.00214074590}, 
    {     0.00000012320,  4.33795118362,       16.67477455640}, 
    {     0.00000009947,  0.67247104431,       31.49256938900}, 
    {     0.00000011298,  0.96114335836,      373.90799283650}, 
    {     0.00000012150,  1.91679035087,      378.64329525170}, 
    {     0.00000012229,  0.70508380884,      218.40690486870}, 
    {     0.00000010319,  0.18138367123,      275.55052103310}, 
    {     0.00000010753,  5.74480767273,       88.11492069160}, 
    {     0.00000009402,  0.67913169059,      353.30106501700}, 
    {     0.00000010651,  2.32656568944,      132.88842257820}, 
    {     0.00000009113,  2.99457723392,      681.54178408960}, 
    {     0.00000010788,  2.62866889129,      154.01661525950}, 
    {     0.00000009169,  4.79284571455,      216.48048917570}, 
    {     0.00000009121,  0.77801335714,       67.35923502580}, 
    {     0.00000009222,  0.73831686735,      129.91947716160}, 
    {     0.00000010633,  0.37523847853,      699.70103135430}, 
    {     0.00000009637,  2.88664912193,       67.88049988760}, 
    {     0.00000008646,  6.12261673260,      150.52640498110}, 
    {     0.00000008601,  2.20126464880,      342.25536475310}, 
    {     0.00000009283,  3.02854870998,      162.09337010680}, 
    {     0.00000009178,  1.49445512725,       19.64371997300}, 
    {     0.00000010072,  3.56581375513,      278.51946644970}, 
    {     0.00000009455,  3.06088366945,      149.67507171920}, 
    {     0.00000009786,  2.43713607191,       75.30286342910}, 
    {     0.00000009167,  5.33037538537,      152.01087768940}, 
    {     0.00000008844,  5.26389220400,       80.71948940050}, 
    {     0.00000008017,  4.71822595860,      106.01353552540}, 
    {     0.00000010094,  0.78601062380,      339.28641933650}, 
    {     0.00000008813,  0.01616162779,       42.58645376270}, 
    {     0.00000007821,  0.61192552414,      135.33610313300}, 
    {     0.00000008193,  2.59644466423,      469.13646052890}, 
    {     0.00000008571,  5.69112316506,      760.25553592000}, 
    {     0.00000009277,  1.97750611607,      147.11551657980}, 
    {     0.00000007482,  2.64377659424,        5.93789083320}, 
    {     0.00000008699,  0.54050826161,       66.18357885820}, 
    {     0.00000009761,  2.59090843673,       50.40257617910}, 
    {     0.00000007547,  5.94593031762,       97.41551581630}, 
    {     0.00000007597,  5.80197876381,      450.97721326420}, 
    {     0.00000008669,  3.69932904987,      300.61086697750}, 
    {     0.00000007728,  1.95146228634,      180.27386923090}, 
    {     0.00000007309,  4.98689362574,      117.91056905120}, 
    {     0.00000008195,  2.30281777892,      254.94359321360}, 
    {     0.00000007536,  1.47100575256,       32.24332891440}, 
    {     0.00000008473,  1.27680705707,       39.35687591520}, 
    {     0.00000007026,  0.68091865104,      874.39401040250}, 
    {     0.00000007389,  4.09295183164,       92.30770638560}, 
    {     0.00000007314,  5.04313738379,      756.32338265690}, 
    {     0.00000008454,  1.22026161161,       79.44746501330}, 
    {     0.00000008732,  1.34335847863,       48.75804477640}, 
    {     0.00000008700,  0.17463519061,       43.12897048390}, 
    {     0.00000008187,  4.29619724129,      624.91943278700}, 
    {     0.00000006941,  5.42054028600,      610.69233878540}, 
    {     0.00000006816,  3.90452052962,      480.77286162380}, 
    {     0.00000006753,  6.03251850119,      350.33211960040}, 
    {     0.00000006692,  4.78230287697,      142.66209845490}, 
    {     0.00000007025,  1.27885740826,       68.56182344380}, 
    {     0.00000006824,  1.36436524169,      291.26208774300}, 
    {     0.00000006900,  3.33848530676,       68.18931642830}, 
    {     0.00000007254,  3.18927739209,      268.43697403230}, 
    {     0.00000007635,  4.81180010568,      312.45971639350}, 
    {     0.00000008135,  1.99010407624,      692.58748435350}, 
    {     0.00000006310,  5.42075206842,       88.79624424780}, 
    {     0.00000006477,  1.05239284135,      685.47393735270}, 
    {     0.00000007121,  5.79764411155,      468.24268865160}, 
    {     0.00000006320,  2.58497126634,      458.09076026500}, 
    {     0.00000006775,  2.59596588927,      282.66406803390}, 
    {     0.00000006222,  5.68982546821,      113.87784205160}, 
    {     0.00000008525,  0.00581798397,      227.31374111850}, 
    {     0.00000006520,  3.99093726386,       42.53826965290}, 
    {     0.00000006435,  1.03721543099,      365.90067395840}, 
    {     0.00000008153,  4.04274797388,      183.24281464750}, 
    {     0.00000006039,  4.35471040863,       19.12245511120}, 
    {     0.00000008149,  1.12461637867,       69.15252427480}, 
    {     0.00000006151,  2.78303783800,      121.84272231430}, 
    {     0.00000007815,  0.55588235015,      296.15744885260}, 
    {     0.00000005989,  4.98445156091,      184.09414790940}, 
    {     0.00000006379,  0.16323583721,      228.27694896500}, 
    {     0.00000006269,  4.22014121556,      119.50691634410}, 
    {     0.00000005982,  5.44774666431,       17.52610781830}, 
    {     0.00000005870,  0.36534808613,      148.59998928810}, 
    {     0.00000005868,  5.39245291119,       95.38852638680}, 
    {     0.00000005906,  0.97697194245,       13.33332212430}, 
    {     0.00000005780,  0.17831781847,      458.84151979040}, 
    {     0.00000005719,  4.74598221436,      248.72381809010}, 
    {     0.00000005534,  4.24741728108,       75.53235809270}, 
    {     0.00000005630,  2.81567861587,      154.97982310600}, 
    {     0.00000006260,  3.52991762509,      285.63301345050}, 
    {     0.00000006919,  3.31432622158,      306.83064210100}, 
    {     0.00000006087,  4.04640130992,      271.40591944890}, 
    {     0.00000006866,  1.34299237220,        7.86430652620}, 
    {     0.00000005586,  5.33279407873,      920.86443331850}, 
    {     0.00000006528,  0.45565192064,      106.27416795630}, 
    {     0.00000005586,  0.29304653043,      173.68158709190}, 
    {     0.00000005353,  2.49825965802,       24.11838995730}, 
    {     0.00000006205,  5.27879491339,      120.99138905240}, 
    {     0.00000005974,  3.62786821437,      189.72322220190}, 
    {     0.00000005176,  3.69984512887,      778.41478318470}, 
    {     0.00000005240,  4.14231460056,       89.75945209430}, 
    {     0.00000005172,  1.54846732288,      193.65537546500}, 
    {     0.00000006360,  0.35370738254,      411.62033734900}, 
    {     0.00000005260,  1.26005665335,      267.47376618580}, 
    {     0.00000006906,  4.88299482194,      419.48464387520}, 
    {     0.00000006332,  5.25617761055,       58.31927233200}, 
    {     0.00000005993,  4.70505278581,      298.23262239190}, 
    {     0.00000005507,  2.72405080404,      986.08480433020}, 
    {     0.00000004936,  6.07953205967,      134.06407874580}, 
    {     0.00000005469,  6.21635608230,       91.45637312370}, 
    {     0.00000004846,  5.66714115710,       90.82323367730}, 
    {     0.00000004870,  1.24431497533,       25.60286266560}, 
    {     0.00000006149,  1.88362168986,      397.39324334740}, 
    {     0.00000005154,  3.37555501409,      831.10498122420}, 
    {     0.00000005253,  1.85387498292,      114.94162363460}, 
    {     0.00000005163,  0.49175608455,       16.46232623530}, 
    {     0.00000004670,  0.85077620511,      403.02231763990}, 
    {     0.00000004688,  4.94827397388,      902.70518605380}, 
    {     0.00000005005,  1.40309022449,        6.15033915430}, 
    {     0.00000005217,  0.27521357608,      192.69216761850}, 
    {     0.00000006177,  2.78454594522,      198.32124191100}, 
    {     0.00000005014,  5.57665259095,      451.94042111070}, 
    {     0.00000004580,  2.47734499363,       31.23193695810}, 
    {     0.00000005129,  3.23528704150,      109.31254934210}, 
    {     0.00000005740,  0.95870813397,      483.22054217860}, 
    {     0.00000004369,  6.21847573079,      207.88246946660}, 
    {     0.00000004425,  2.74721673213,      823.99143422340}, 
    {     0.00000004299,  0.66587852826,      210.33015002140}, 
    {     0.00000004527,  1.87365819890,       44.72531777680}, 
    {     0.00000004484,  1.03729827686,      606.76018552230}, 
    {     0.00000004135,  0.41031273891,      180.16199464630}, 
    {     0.00000004646,  5.82325024322,      905.88657979150}, 
    {     0.00000004086,  4.84914558939,      124.50285119020}, 
    {     0.00000004486,  0.35223479841,      457.87831194390}, 
    {     0.00000004318,  1.68857333749,      309.27832265580}, 
    {     0.00000005151,  2.90867214997,       28.31117565130}, 
    {     0.00000004061,  3.32301396744,      107.49800823370}, 
    {     0.00000004332,  1.41872733238,       25.12978191360}, 
    {     0.00000004944,  5.87125173636,      303.86169668440}, 
    {     0.00000004407,  5.28748850470,      449.28029223480}, 
    {     0.00000004180,  1.67985859496,        7.42236354150}, 
    {     0.00000003977,  3.22662754639,      639.89728631400}, 
    {     0.00000005415,  2.15030495019,      187.69623277240}, 
    {     0.00000004217,  0.73382717079,      497.44763618020}, 
    {     0.00000004875,  0.88184557385,      255.05546779820}, 
    {     0.00000004758,  4.60909386948,      258.02441321480}, 
    {     0.00000005337,  2.36556705745,      477.80391620720}, 
    {     0.00000004456,  1.74674336635,       95.97922721780}, 
    {     0.00000004138,  3.80344455465,      460.53844081980}, 
    {     0.00000003843,  4.02615028031,      104.00779795530}, 
    {     0.00000005032,  0.36645338967,      123.53964334370}, 
    {     0.00000003780,  2.89085160996,       27.08733537390}, 
    {     0.00000004309,  4.77464606019,      463.50738623640}, 
    {     0.00000003779,  3.05636034284,      142.14083359310}, 
    {     0.00000004357,  3.73616179561,      376.19561469690}, 
    {     0.00000003705,  2.47343159576,       25.27279426550}, 
    {     0.00000004232,  4.31629167726,      446.31134681820}, 
    {     0.00000003576,  2.55404008547,        6.59228213900}, 
    {     0.00000003685,  3.26448469664,      170.76082578510}, 
    {     0.00000003575,  4.31199276037,      572.22923474750}, 
    {     0.00000004496,  2.10358455875,      838.21852822500}, 
    {     0.00000003716,  0.20018583737,      394.35486196160}, 
    {     0.00000003846,  5.81080745080,      586.31331639720}, 
    {     0.00000003527,  4.05179036599,      433.71173787680}, 
    {     0.00000003524,  3.75716903766,      473.06861379200}, 
    {     0.00000003501,  4.44564884600,      384.05992122310}, 
    {     0.00000003636,  2.12955997197,       73.18525127440}, 
    {     0.00000003841,  5.28811045359,       43.28902917830}, 
    {     0.00000003928,  4.26291422687,      196.62432088160}, 
    {     0.00000003702,  3.86923731076,      981.63138620530}, 
    {     0.00000003445,  2.10100539423,      316.39186965660}, 
    {     0.00000003432,  2.97356096189,      535.91074021810}, 
    {     0.00000004312,  0.38740046308,      988.53248488500}, 
    {     0.00000003867,  2.08559458308,      457.35704708210}, 
    {     0.00000003353,  4.19681836937,      114.13847448250}, 
    {     0.00000004128,  3.06165703137,      377.15882254340}, 
    {     0.00000003545,  4.41886084391,     1293.87865427770}, 
    {     0.00000003309,  3.54050386234,      520.12973753900}, 
    {     0.00000003337,  6.23473900765,     9947.05568153210}, 
    {     0.00000004527,  4.61192905449,       47.06112374700}, 
    {     0.00000003523,  2.00908999163,       47.69426319340}, 
    {     0.00000003370,  3.65249455401,      976.00231191280}, 
    {     0.00000003290,  6.13529735100,       34.20088237470}, 
    {     0.00000003253,  5.22413528932,      425.11371816770}, 
    {     0.00000003461,  5.18605119393,      993.19835133100}, 
    {     0.00000003712,  2.53410725291,      237.67811782620}, 
    {     0.00000003240,  3.56995183051,       17.26547538740}, 
    {     0.00000003362,  1.26285882591,      233.90602325750}, 
    {     0.00000003606,  1.94705146379,      661.09491496450}, 
    {     0.00000003182,  0.36603315110,      449.49274055590}, 
    {     0.00000003427,  6.03153107557,      199.28444975750}, 
    {     0.00000003169,  2.55715329118,     6133.51265285680}, 
    {     0.00000003994,  4.53148620187,      916.93228005540}, 
    {     0.00000004413,  4.14550138614,      219.89137757700}, 
    {     0.00000003600,  4.16003477661,      214.78356814630}, 
    {     0.00000004193,  4.26425258521,      381.61224066830}, 
    {     0.00000003846,  3.76849990033,        8.59801970910}, 
    {     0.00000003183,  3.15317674552,       15.19030184810}, 
    {     0.00000003350,  5.63661413371,      444.82687410990}, 
    {     0.00000003780,  5.35722293289,      328.24071907260}, 
    {     0.00000003166,  2.16351748263,      983.11585891360}, 
    {     0.00000003930,  2.09444900058,      653.98136796370}, 
    {     0.00000003585,  1.24517449239,      162.89651925890}, 
    {     0.00000003527,  1.89208045227,      280.96714700450}, 
    {     0.00000003282,  1.91872815218,     2349.32843120380}, 
    {     0.00000003076,  4.77282170585,      820.05928096030}, 
    {     0.00000003399,  5.35259772941,      141.69889060840}, 
    {     0.00000003269,  0.52855777633,      450.45594840240}, 
    {     0.00000003582,  1.60170266832,     1587.58842257550}, 
    {     0.00000003044,  0.84602343274,       30.71067209630}, 
    {     0.00000003616,  6.16820602029,      171.65459766240}, 
    {     0.00000003007,  4.69605806277,      978.97125732940}, 
    {     0.00000003528,  4.79818282081,      406.95447090300}, 
    {     0.00000002980,  2.17792323043,      597.35901666110}, 
    {     0.00000002977,  0.69478628170,      294.30046912880}, 
    {     0.00000003411,  1.18022650672,      167.72244439930}, 
    {     0.00000004049,  3.15153850922,      833.55266177900}, 
    {     0.00000003725,  5.84743216544,     6058.73105428950}, 
    {     0.00000003242,  0.63525153286,      141.48644228730}, 
    {     0.00000003683,  1.86888555615,      371.52974825090}, 
    {     0.00000003877,  1.44138798341,      346.18751801620}, 
    {     0.00000003142,  2.26934250738,      517.16079212240}, 
    {     0.00000004077,  0.07273073033,     1190.03512053370}, 
    {     0.00000002893,  3.53141229605,       94.42531854030}, 
    {     0.00000003020,  2.64998251178,       20.44686912510}, 
    {     0.00000003110,  1.11431255827,     1044.40407666220}, 
    {     0.00000002836,  0.62522723719,      749.20983565610}, 
    {     0.00000002898,  4.11830043593,      600.54041039880}, 
    {     0.00000002819,  4.72400465237,      122.47586176070}, 
    {     0.00000003572,  1.96375884146,      372.42352012820}, 
    {     0.00000002801,  3.99301180541,    10063.72234907640}, 
    {     0.00000002806,  3.85026986935,      133.10087089930}, 
    {     0.00000002791,  6.24681129336,      908.33426034630}, 
    {     0.00000003466,  3.43275071793,       82.64590509350}, 
    {     0.00000003725,  1.68366366742,      683.98946464440}, 
    {     0.00000003763,  3.28247771799,      432.81796599950}, 
    {     0.00000003493,  0.98765698465,     9988.94075050910}, 
    {     0.00000003523,  5.12512607932,      105.38039607900}, 
    {     0.00000003432,  2.80483162230,      764.18768918310}, 
    {     0.00000002733,  0.42373696972,      354.99798604640}, 
    {     0.00000003041,  5.75641149588,      409.92341631960}, 
    {     0.00000003379,  5.47448876584,     1396.22066897090}, 
    {     0.00000003102,  0.41684444831,      521.09294538550}, 
    {     0.00000002863,  0.41519700992,      894.84087952760}, 
    {     0.00000003128,  5.23384180625,      424.15051032120}, 
    {     0.00000002688,  3.59170326422,      621.73803904930}, 
    {     0.00000002848,  2.16605887838,      216.92243216040}, 
    {     0.00000002673,  1.60411606116,      136.06981631590}, 
    {     0.00000003414,  4.93712749827,     1140.38330388000}, 
    {     0.00000002653,  5.10283251074,      118.02244363580}, 
    {     0.00000002730,  4.22647867347,      990.22940591440}, 
    {     0.00000003113,  5.23808775951,      417.03696332040}, 
    {     0.00000003289,  4.26401031509,      544.50875992720}, 
    {     0.00000003100,  5.47928527930,      701.18550406260}, 
    {     0.00000002785,  5.19343849093,      144.89733068860}, 
    {     0.00000002605,  4.82136791856,      362.86229257260}, 
    {     0.00000003183,  4.76078229245,      294.67297614430}, 
    {     0.00000003550,  3.82073713802,      511.53171782990}, 
    {     0.00000002641,  3.49997209213,      293.18850343600}, 
    {     0.00000002788,  1.54956737675,       28.57180808220}, 
    {     0.00000002897,  0.37376102831,      582.38116313410}, 
    {     0.00000002615,  2.25516923974,       74.99404688840}, 
    {     0.00000003582,  1.27992264402,      987.56927703850}, 
    {     0.00000003115,  5.10929689813,      459.05396811150}, 
    {     0.00000002589,  1.83177157042,      657.16276170140}, 
    {     0.00000002539,  4.14968938109,       74.73341445750}, 
    {     0.00000002797,  2.82242772664,     2036.86871481030}, 
    {     0.00000002688,  2.16500211397,      262.80789973980}, 
    {     0.00000002817,  6.06679932038,      374.49869366750}, 
    {     0.00000002539,  0.46036497385,       74.82978267710}, 
    {     0.00000002504,  3.52394801700,     1183.67233305830}, 
    {     0.00000002565,  1.64023845161,       73.40900044360}, 
    {     0.00000002663,  4.23321349902,      421.18156490460}, 
    {     0.00000003019,  1.62290757266,      414.06801790380}, 
    {     0.00000002793,  2.00644423849,       75.04223099820}, 
    {     0.00000003253,  2.43153394317,       98.35747180340}, 
    {     0.00000002883,  2.41875736533,        4.66586644600}, 
    {     0.00000002553,  1.25909246207,      670.49608382570}, 
    {     0.00000003135,  1.96936617667,      842.15068148810}, 
    {     0.00000002604,  3.87350462519,       74.03083904190}, 
    {     0.00000002510,  3.35948960782,      464.99185894470}, 
    {     0.00000003050,  1.81077971280,      331.20966448920}, 
    {     0.00000003005,  0.81031349171,       73.88782669000}, 
    {     0.00000002701,  5.89709637826,      525.23754696970}, 
    {     0.00000003110,  6.14956891318,      118.87377689770}, 
    {     0.00000002774,  6.26134027482,     1022.31267613440}, 
    {     0.00000002402,  4.38353347008,     1303.27982313890}, 
    {     0.00000002800,  2.60339313269,       74.52096613640}, 
    {     0.00000003005,  0.76247280223,       75.67537044460}, 
    {     0.00000002434,  4.94784679430,      969.62247809490}, 
    {     0.00000002630,  0.62894209942,      227.52618943960}, 
    {     0.00000002669,  0.73340228210,       73.08467753790}, 
    {     0.00000002465,  1.30648773380,       77.06922042770}, 
    {     0.00000002395,  2.76580569447,      768.85355562910}, 
    {     0.00000002753,  5.59058621175,      388.72578766910}, 
    {     0.00000003230,  0.01981320255,      881.50755740330}, 
    {     0.00000003008,  5.65955463660,     1969.20066324380}, 
    {     0.00000003008,  0.91409756228,     2118.76386037840}, 
    {     0.00000002465,  0.26629856014,       72.49397670690}, 
    {     0.00000002313,  3.37979302623,      286.59622129700}, 
    {     0.00000002272,  2.77069357318,      515.46387109300}, 
    {     0.00000002579,  4.80372721669,      103.35340664950}, 
    {     0.00000002360,  4.12736987374,       74.62153987290}, 
    {     0.00000002220,  2.17920233841,      491.81856188770}, 
    {     0.00000002498,  1.19812774743,      383.09671337660}, 
    {     0.00000002981,  3.15769661969,     1887.30551767570}, 
    {     0.00000002570,  3.13859674290,      229.08009811710}, 
    {     0.00000002355,  0.48259604722,       74.94165726170}, 
    {     0.00000002228,  1.42452148910,     6219.33995168800}, 
    {     0.00000002184,  5.18000549953,       59.28248017850}, 
    {     0.00000002319,  2.10326941903,       11.15757484850}, 
    {     0.00000002724,  3.48225905765,       10.29494073850}, 
    {     0.00000002162,  3.61282527361,       22.63391724900}, 
    {     0.00000002232,  3.98572942665,       68.63125941300}, 
    {     0.00000002390,  2.47806087593,      177.87437278590}, 
    {     0.00000002199,  0.22998162264,      217.23124870110}, 
    {     0.00000002915,  5.18526716284,      218.92816973050}, 
    {     0.00000002875,  2.77889026188,      184.98791978670}, 
    {     0.00000002865,  0.62015957113,     1411.19852249790}, 
    {     0.00000002298,  3.95654643159,       26.02355379090}, 
    {     0.00000002318,  1.21463632824,      291.70403072770}, 
    {     0.00000002560,  1.48802298081,     1055.44977692610}, 
    {     0.00000002796,  5.59819583385,      260.99335863140}, 
    {     0.00000002492,  4.25519394022,      149.45132255000}, 
    {     0.00000002007,  6.11892578566,       63.62402371880}, 
    {     0.00000002110,  3.59139003023,      256.42806592190}, 
    {     0.00000002198,  4.46404375855,      524.06189080210}, 
    {     0.00000002706,  0.80150714262,       89.00869256890}, 
    {     0.00000002410,  2.28619111368,       74.26033370550}, 
    {     0.00000002102,  3.18561308775,      635.96513305090}, 
    {     0.00000002006,  1.30247563131,      385.75684225250}, 
    {     0.00000002304,  3.60550712225,      115.88357962170}, 
    {     0.00000001899,  2.42426868365,      273.85360000370}, 
    {     0.00000002119,  5.98199852906,      559.69906177530}, 
    {     0.00000002152,  5.30772822745,        2.00573757010}, 
    {     0.00000002447,  5.10278930542,      205.22234059070}, 
    {     0.00000001962,  1.45399000044,       80.41067285980}, 
    {     0.00000001895,  3.30475087405,       46.47042291600}, 
    {     0.00000001942,  1.79179369066,      346.39996633730}, 
    {     0.00000001850,  5.74338030118,      175.16605980020}, 
    {     0.00000001848,  2.74750349182,      429.77958461370}, 
    {     0.00000001848,  1.20977525896,      280.21638747910}, 
    {     0.00000002220,  1.12912931401,      323.50541665740}, 
    {     0.00000001839,  3.58086367470,      327.43756992050}, 
    {     0.00000001839,  4.86693953738,      507.59956456680}, 
    {     0.00000001848,  5.26302620499,       81.68269724700}, 
    {     0.00000001996,  4.36291795113,     1812.52391910840}, 
    {     0.00000001893,  0.10622820999,       93.90405367850}, 
    {     0.00000002368,  2.77235858734,      477.00076705510}, 
    {     0.00000001891,  2.25571301508,        4.73530241520}, 
    {     0.00000001792,  1.59759408430,      832.58945393250}, 
    {     0.00000001792,  3.20129636889,      683.02625679790}, 
    {     0.00000002092,  0.32766195745,      343.21857259960}, 
    {     0.00000001792,  5.80267442975,      779.89925589300}, 
    {     0.00000001726,  3.18023607065,      332.17287233570}, 
    {     0.00000001831,  3.75183606052,      469.72716135990}, 
    {     0.00000001831,  5.28956429339,      619.29035849450}, 
    {     0.00000001721,  0.80119805379,     1432.39615114840}, 
    {     0.00000001721,  2.33892628665,     1581.95934828300}, 
    {     0.00000001978,  1.74196451080,      331.32153907380}, 
    {     0.00000001895,  5.31311179301,      253.57099508990}, 
    {     0.00000001758,  2.96038070029,     1596.18644228460}, 
    {     0.00000001758,  1.42265246742,     1446.62324515000}, 
    {     0.00000002109,  0.73357181364,      758.77106321170}, 
    {     0.00000001911,  0.46392477628,     1589.07289528380}, 
    {     0.00000001960,  5.98949067581,     1392.28851570780}, 
    {     0.00000001960,  1.31000765322,     1242.72531857320}, 
    {     0.00000001833,  6.18306213718,      535.32003938710}, 
    {     0.00000002195,  0.42296220916,      703.63318461740}, 
    {     0.00000001815,  5.00776376696,      255.83736509090}, 
    {     0.00000001890,  0.32598438166,      221.16340196420}, 
    {     0.00000001864,  2.68023304080,      405.99126305650}, 
    {     0.00000002065,  6.09002439734,      763.43692965770}, 
    {     0.00000002065,  4.55229616447,      613.87373252310}, 
    {     0.00000001610,  4.91408185660,      115.36231475990}, 
    {     0.00000001823,  5.54014516908,      357.44566660120}, 
    {     0.00000001620,  2.90668209411,      609.20786607710}, 
    {     0.00000001604,  3.64436334999,       30.05628079050}, 
    {     0.00000001578,  6.12288879129,      423.62924545940}, 
    {     0.00000001754,  3.29214293116,     1515.77576942480}, 
    {     0.00000001819,  6.21015313585,      215.43795945210}, 
    {     0.00000001679,  2.61674435978,      181.05576652360}, 
    {     0.00000001907,  5.52030331800,      602.98809095360}, 
    {     0.00000001520,  1.94954212244,     1228.49822457160}, 
    {     0.00000001520,  0.34583983785,     1378.06142170620}, 
    {     0.00000001538,  4.79041960434,      543.91805909620}, 
    {     0.00000001518,  3.84678636307,       14.22709400160}, 
    {     0.00000001851,  4.61165114292,      774.48262992160}, 
    {     0.00000001520,  3.24071154201,       39.09624348430}, 
    {     0.00000001647,  5.88231739154,      398.87771605570}, 
    {     0.00000001471,  1.35595542925,      481.73606947030}, 
    {     0.00000001469,  5.56206799884,      301.41401612960}, 
    {     0.00000001474,  1.58634608266,      274.06604832480}, 
    {     0.00000001480,  6.05250894033,      194.28851491140}, 
    {     0.00000001473,  0.67726919761,      539.25219265020}, 
    {     0.00000001472,  3.07440978254,       50.66320861000}, 
    {     0.00000001564,  5.43230552977,      459.36278465220}, 
    {     0.00000001468,  5.20182042843,      130.44074202340}, 
    {     0.00000001802,  2.75155368399,       30.59879751170}, 
    {     0.00000001483,  2.08618845205,       69.67378913660}, 
    {     0.00000001433,  3.35897454068,      267.58564077040}, 
    {     0.00000001801,  6.06701083819,      210.85141488320}, 
    {     0.00000001473,  1.65632386952,     1052.26838318840}, 
    {     0.00000001392,  3.13732434239,      369.08206769610}, 
    {     0.00000001502,  0.28443439725,      495.96316347190}, 
    {     0.00000001403,  4.98324477005,       35.68535508300}, 
    {     0.00000001404,  3.16559098208,      255.57673266000}, 
    {     0.00000001456,  5.36560710378,     6283.07584999140}, 
    {     0.00000001412,  0.68968780108,      348.84764689210}, 
    {     0.00000001589,  4.89344411716,     1366.21257229020}, 
    {     0.00000001426,  5.72934799733,      335.14181775230}, 
    {     0.00000001469,  4.66006940636,      893.35640681930}, 
    {     0.00000001469,  6.26377169094,      743.79320968470}, 
    {     0.00000001668,  1.29876086261,     1673.25566271230}, 
    {     0.00000001668,  2.90246314719,     1523.69246557770}, 
    {     0.00000001526,  5.93140614398,     1662.96072197380}, 
    {     0.00000001373,  4.85710108204,       61.44827644300}, 
    {     0.00000001366,  4.78315200862,      470.69036920640}, 
    {     0.00000001390,  5.76987164020,       79.88940799800}, 
    {     0.00000001461,  3.00376275716,      632.78373931320}, 
};


static const struct vsop uranus_radius_r2[RADIUS_R2] = {
    {     0.00022439899,  0.69953310903,       74.78159856730}, 
    {     0.00004726838,  1.69896897296,       63.73589830340}, 
    {     0.00001681383,  4.64842242588,       70.84944530420}, 
    {     0.00001433633,  3.52135281258,      149.56319713460}, 
    {     0.00001649477,  3.09669484042,       11.04570026390}, 
    {     0.00000769974,  0.00000000000,        0.00000000000}, 
    {     0.00000461159,  0.76667185672,        3.93215326310}, 
    {     0.00000500193,  6.17218448634,       76.26607127560}, 
    {     0.00000390377,  4.49603136758,       56.62235130260}, 
    {     0.00000389972,  5.52663268311,       85.82729883120}, 
    {     0.00000292283,  0.20370820668,       52.69019803950}, 
    {     0.00000272269,  3.84735375210,      138.51749687070}, 
    {     0.00000286451,  3.53449822561,       73.29712585900}, 
    {     0.00000205341,  3.24759155116,       78.71375183040}, 
    {     0.00000219349,  1.96433948894,      131.40394986990}, 
    {     0.00000215812,  0.84820922453,       77.96299230500}, 
    {     0.00000129040,  2.08142441038,        3.18139373770}, 
    {     0.00000148716,  4.89757177249,      127.47179660680}, 
    {     0.00000117642,  4.93417950365,      447.79581952650}, 
    {     0.00000112873,  1.01358614296,      462.02291352810}, 
    {     0.00000099082,  6.15736951949,      224.34479570190}, 
    {     0.00000091634,  0.68110922044,       18.15924726470}, 
    {     0.00000089537,  0.23396296581,      202.25339517410}, 
    {     0.00000088475,  2.93078580361,       62.25142559510}, 
    {     0.00000113471,  4.78996247308,      145.63104387150}, 
    {     0.00000103857,  3.58561861261,       71.60020482960}, 
    {     0.00000061854,  3.29891157272,      351.81659230870}, 
    {     0.00000057828,  4.90530751807,       22.09140052780}, 
    {     0.00000064448,  3.38789169908,        1.48447270830}, 
    {     0.00000071110,  6.10490045777,      454.90936652730}, 
    {     0.00000050920,  3.86475363643,       65.22037101170}, 
    {     0.00000063666,  3.96437325595,       67.66805156650}, 
    {     0.00000059151,  5.54929939724,        9.56122755560}, 
    {     0.00000048713,  3.74773116593,      269.92144674060}, 
    {     0.00000044010,  1.92372120641,       59.80374504030}, 
    {     0.00000042677,  2.61696151844,      151.04766984290}, 
    {     0.00000044556,  5.90316779799,       71.81265315070}, 
    {     0.00000042421,  6.13638530320,      284.14854074220}, 
    {     0.00000037328,  5.91300114911,      984.60033162190}, 
    {     0.00000042329,  2.08837866544,       12.53017297220}, 
    {     0.00000036234,  5.40331180090,       77.75054398390}, 
    {     0.00000031472,  4.58140053324,      148.07872442630}, 
    {     0.00000031469,  2.26119541579,      195.13984817330}, 
    {     0.00000027151,  3.53245541147,      209.36694217490}, 
    {     0.00000028313,  4.57742211849,       77.22927912210}, 
    {     0.00000026135,  0.65832277309,      120.35824960600}, 
    {     0.00000024371,  5.86680470366,       69.36497259590}, 
    {     0.00000023072,  1.04150250909,       84.34282612290}, 
    {     0.00000022686,  1.71276605718,      160.60889739850}, 
    {     0.00000027909,  4.91450005237,      277.03499374140}, 
    {     0.00000020958,  2.20247784200,       45.57665103870}, 
    {     0.00000020277,  2.30684759993,        2.44768055480}, 
    {     0.00000016889,  4.75579457418,      213.29909543800}, 
    {     0.00000016616,  1.85435119988,      340.77089204480}, 
    {     0.00000017053,  4.37207842060,       54.17467074780}, 
    {     0.00000016086,  3.65914337666,      152.74459087230}, 
    {     0.00000014838,  5.44395102901,      408.43894361130}, 
    {     0.00000013872,  3.38531100870,      358.93013930950}, 
    {     0.00000013344,  5.24928235077,      137.03302416240}, 
    {     0.00000013276,  1.26302583053,      134.58534360760}, 
    {     0.00000012700,  3.02323882509,       92.94084583200}, 
    {     0.00000013615,  1.53192294040,      422.66603761290}, 
    {     0.00000012387,  1.33244915199,       51.20572533120}, 
    {     0.00000016450,  0.40355823582,      265.98929347750}, 
    {     0.00000012052,  5.08792165794,      191.20769491020}, 
    {     0.00000011443,  2.05677650023,        7.11354700080}, 
    {     0.00000012762,  4.42146478775,       87.31177153950}, 
    {     0.00000012158,  3.23645294871,      116.42609634290}, 
    {     0.00000011636,  4.65085291428,       41.64449777560}, 
    {     0.00000011612,  4.17982719132,       60.55450456570}, 
    {     0.00000011692,  3.73284551397,      220.41264243880}, 
    {     0.00000010313,  0.35141402139,       70.32818044240}, 
    {     0.00000011316,  1.07773417628,       72.33391801250}, 
    {     0.00000009522,  3.05257396853,        2.96894541660}, 
    {     0.00000009279,  2.43997351068,      565.11568774670}, 
    {     0.00000008993,  5.18841032660,      225.82926841020}, 
    {     0.00000010284,  1.18602188589,      344.70304530790}, 
    {     0.00000008847,  6.00863947318,        5.41662597140}, 
    {     0.00000008508,  5.24741470219,      347.88443904560}, 
    {     0.00000008322,  3.71500823381,       14.97785352700}, 
    {     0.00000008276,  2.27407098373,      299.12639426920}, 
    {     0.00000008064,  5.71681525179,       55.13787859430}, 
    {     0.00000007829,  0.90269701074,      222.86032299360}, 
    {     0.00000008335,  4.48600419464,       70.11573212130}, 
    {     0.00000008489,  3.91174796200,      333.65734504400}, 
    {     0.00000008708,  5.81537952972,      153.49535039770}, 
    {     0.00000010194,  5.97791997034,       35.16409022120}, 
    {     0.00000009652,  0.38887666466,      415.55249061210}, 
    {     0.00000007106,  1.50598488470,      991.71387862270}, 
    {     0.00000008055,  2.25812279923,      206.18554843720}, 
    {     0.00000006468,  2.99863142327,      380.12776796000}, 
    {     0.00000006393,  1.16861809920,       96.87299909510}, 
    {     0.00000008976,  6.05363032396,      146.38180339690}, 
    {     0.00000006131,  0.05596259493,       99.16062095550}, 
    {     0.00000005803,  0.79879069877,      142.44965013380}, 
    {     0.00000005816,  4.63029217647,       49.50880430180}, 
    {     0.00000005557,  0.63854330387,       58.10682401090}, 
    {     0.00000005869,  2.21418083323,       80.19822453870}, 
    {     0.00000005162,  4.36457872885,      977.48678462110}, 
    {     0.00000005428,  0.85181859845,      546.95644048200}, 
    {     0.00000005750,  2.48104577171,      373.01422095920}, 
    {     0.00000005766,  0.34229026122,      536.80451209540}, 
    {     0.00000005924,  5.48443563529,       76.47851959670}, 
    {     0.00000005154,  4.81339702575,      387.24131496080}, 
    {     0.00000005325,  3.72411790512,       23.57587323610}, 
    {     0.00000005037,  5.06388596602,      440.68227252570}, 
    {     0.00000005209,  4.09574144962,      132.88842257820}, 
    {     0.00000005790,  3.39593613152,      458.09076026500}, 
    {     0.00000005007,  4.25821411688,      522.57741809380}, 
    {     0.00000005114,  0.49645581730,       60.76695288680}, 
    {     0.00000005027,  6.15248489670,       39.61750834610}, 
    {     0.00000005183,  3.25775152471,      561.18353448360}, 
    {     0.00000004603,  1.69268338637,      152.53214255120}, 
    {     0.00000004566,  0.46068888813,       33.13710079170}, 
    {     0.00000005302,  1.83522660093,      124.29040286910}, 
    {     0.00000004454,  2.30288945184,      312.45971639350}, 
    {     0.00000005766,  0.66069155760,       38.13303563780}, 
    {     0.00000004255,  3.58596694157,      479.28838891550}, 
    {     0.00000004315,  1.64104755836,      128.95626931510}, 
    {     0.00000004190,  4.37674804409,       79.23501669220}, 
    {     0.00000005756,  0.87494010124,       20.60692781950}, 
    {     0.00000005409,  0.87333646247,       81.89514556810}, 
    {     0.00000005124,  1.40551554367,      144.14657116320}, 
    {     0.00000004045,  6.07362424621,       19.64371997300}, 
    {     0.00000003994,  5.77048046468,      288.08069400530}, 
    {     0.00000004987,  2.99179430284,       29.20494752860}, 
    {     0.00000003870,  4.43713601497,      141.69889060840}, 
    {     0.00000003811,  3.15820960943,      159.12442469020}, 
    {     0.00000004553,  0.01384318412,      298.23262239190}, 
    {     0.00000003737,  5.28319518103,      353.30106501700}, 
    {     0.00000003742,  2.67921642406,      426.59819087600}, 
    {     0.00000003939,  5.27301148162,      521.09294538550}, 
    {     0.00000005065,  4.09433474334,      111.43016149680}, 
    {     0.00000003861,  1.34394383700,      535.32003938710}, 
    {     0.00000003619,  5.10070043677,      490.33408917940}, 
    {     0.00000004385,  0.62057680100,      827.17282796110}, 
    {     0.00000003645,  0.34509016266,       33.67961751290}, 
    {     0.00000003558,  2.51710360898,      258.87574647670}, 
    {     0.00000003919,  0.62079541541,      152.01087768940}, 
    {     0.00000003576,  3.24526237368,      230.56457082540}, 
    {     0.00000003469,  0.79054323335,      983.11585891360}, 
    {     0.00000004530,  2.86839686392,      129.91947716160}, 
    {     0.00000003648,  5.59395544992,      774.48262992160}, 
    {     0.00000003440,  4.71254994607,        6.90109867970}, 
    {     0.00000003513,  4.49630054276,      376.19561469690}, 
    {     0.00000004521,  2.05472247761,      404.50679034820}, 
    {     0.00000003336,  0.89628904042,      469.13646052890}, 
    {     0.00000003274,  3.86236880159,       42.53826965290}, 
    {     0.00000003201,  2.76459652868,      248.72381809010}, 
    {     0.00000003184,  0.07709843451,     1514.29129671650}, 
    {     0.00000003783,  5.29835962126,      369.08206769610}, 
    {     0.00000003119,  1.27526406087,      200.76892246580}, 
    {     0.00000003266,  2.24754480216,       73.81839072080}, 
    {     0.00000003055,  2.60120354408,      433.71173787680}, 
    {     0.00000003051,  4.54953369151,      980.66817835880}, 
    {     0.00000003472,  4.93521260607,      411.62033734900}, 
    {     0.00000003531,  4.49372794858,      881.50755740330}, 
    {     0.00000003284,  5.59170577331,      472.17484191470}, 
    {     0.00000003049,  3.68906777491,       16.67477455640}, 
    {     0.00000003015,  6.02967446446,      291.26208774300}, 
    {     0.00000003755,  3.12587747560,      108.46121608020}, 
    {     0.00000003467,  2.17484439267,      554.06998748280}, 
    {     0.00000003138,  0.52367930477,     1094.80665284130}, 
    {     0.00000003257,  2.49339546514,      451.72797278960}, 
    {     0.00000002886,  2.44887846041,      135.33610313300}, 
    {     0.00000002965,  0.39294995530,       25.27279426550}, 
    {     0.00000002794,  5.32964924523,      125.98732389850}, 
    {     0.00000002814,  1.70481689541,      639.89728631400}, 
    {     0.00000002777,  5.94801147914,       89.75945209430}, 
    {     0.00000002831,  2.52728803131,      867.28046340170}, 
    {     0.00000002779,  0.48501334493,      305.34616939270}, 
    {     0.00000002872,  0.77434367967,      486.40193591630}, 
    {     0.00000002857,  4.71106805785,      218.92816973050}, 
    {     0.00000003081,  4.10993868704,      146.59425171800}, 
    {     0.00000002763,  4.27510031656,      350.33211960040}, 
    {     0.00000003365,  3.67691210011,      661.09491496450}, 
    {     0.00000002925,  1.43646759644,      381.61224066830}, 
    {     0.00000002802,  3.11122994722,      216.48048917570}, 
    {     0.00000002756,  4.62672498840,     1357.61455258110}, 
    {     0.00000003450,  2.12911756067,      685.47393735270}, 
    {     0.00000002646,  3.81808560938,      550.88859374510}, 
    {     0.00000002584,  5.63009428967,       24.37902238820}, 
    {     0.00000002740,  1.85885336732,      529.69096509460}, 
    {     0.00000002606,  4.36605237304,     1080.57955883970}, 
    {     0.00000002438,  3.04265976382,      391.17346822390}, 
    {     0.00000002446,  5.73846381540,      535.91074021810}, 
    {     0.00000002471,  4.18140104280,      235.39049596580}, 
    {     0.00000002568,  1.09886876369,      913.00012679230}, 
    {     0.00000002346,  1.88690998393,       82.85835341460}, 
    {     0.00000002301,  0.27116254930,        7.86430652620}, 
    {     0.00000003053,  5.35047433775,      681.54178408960}, 
    {     0.00000002290,  2.49218620138,      203.73786788240}, 
    {     0.00000002325,  0.52844013308,       14.22709400160}, 
    {     0.00000002258,  0.03156617730,      398.28701522470}, 
    {     0.00000002160,  6.01811980506,      140.00196957900}, 
    {     0.00000002328,  3.12607654898,      273.10284047830}, 
    {     0.00000002139,  4.33383273131,       91.45637312370}, 
    {     0.00000002723,  1.24464892033,      166.82867252200}, 
    {     0.00000002053,  4.32434381120,      515.46387109300}, 
    {     0.00000002398,  5.90144270960,       79.44746501330}, 
    {     0.00000002222,  4.80208391464,      268.43697403230}, 
    {     0.00000002310,  0.48180017719,       14.01464568050}, 
    {     0.00000002022,  5.85402756377,      271.40591944890}, 
    {     0.00000002521,  3.23111737258,      901.95442652840}, 
    {     0.00000002369,  2.40985582671,       73.08467753790}, 
    {     0.00000002034,  0.47496124187,     2043.98226181110}, 
    {     0.00000001955,  6.21237525891,      384.05992122310}, 
    {     0.00000001954,  3.38054663002,      820.05928096030}, 
    {     0.00000001867,  5.32253331194,       31.49256938900}, 
    {     0.00000002416,  0.06420209890,      419.48464387520}, 
    {     0.00000001762,  5.77200578500,     1589.07289528380}, 
    {     0.00000001762,  4.23427755214,     1439.50969814920}, 
    {     0.00000001925,  0.79521713622,      184.09414790940}, 
    {     0.00000002204,  0.52846501316,      278.51946644970}, 
    {     0.00000002228,  4.32684227036,       66.91729204110}, 
    {     0.00000001679,  5.14179135334,     1059.38193018920}, 
    {     0.00000001706,  1.54289098759,      234.49672408850}, 
    {     0.00000001625,  5.07314285147,      100.38446123290}, 
    {     0.00000001609,  6.16926697458,     1119.18567522950}, 
    {     0.00000002033,  3.53119363701,      109.94568878850}, 
    {     0.00000002129,  1.22429037482,      184.72728735580}, 
    {     0.00000001717,  2.42144217711,      678.36039035190}, 
    {     0.00000001717,  3.95917040998,      827.92358748650}, 
    {     0.00000001810,  0.05278694247,       17.26547538740}, 
    {     0.00000001585,  1.88716701489,        4.45341812490}, 
    {     0.00000001577,  5.35894329524,     1894.41906467650}, 
    {     0.00000001523,  3.77627435709,      181.05576652360}, 
    {     0.00000001534,  0.19778048653,      135.54855145410}, 
    {     0.00000001506,  2.95864025543,      849.26422848890}, 
    {     0.00000001506,  1.35493797085,      998.82742562350}, 
    {     0.00000001722,  5.00518792666,      699.70103135430}, 
    {     0.00000001722,  3.46745969379,      550.13783421970}, 
    {     0.00000001643,  5.86122302822,       89.00869256890}, 
    {     0.00000001520,  1.42254433373,        0.21244832110}, 
    {     0.00000001529,  0.77073213979,      329.72519178090}, 
    {     0.00000001458,  5.90775641818,      147.11551657980}, 
    {     0.00000001792,  1.11686829848,      453.42489381900}, 
    {     0.00000001498,  2.61145675790,      365.90067395840}, 
    {     0.00000001793,  2.14241351007,      211.81462272970}, 
    {     0.00000001580,  5.57997675255,      785.52833018550}, 
    {     0.00000001580,  4.04224851969,      635.96513305090}, 
    {     0.00000001835,  4.31480288855,      465.95506679120}, 
    {     0.00000001407,  4.94842057032,       74.89347315190}, 
    {     0.00000001403,  5.15016124506,      180.16199464630}, 
    {     0.00000001420,  2.60452620081,       95.38852638680}, 
    {     0.00000001383,  5.95287019467,       74.66972398270}, 
    {     0.00000001382,  2.10457236484,      458.84151979040}, 
    {     0.00000001513,  1.88475439191,     1051.51762366300}, 
    {     0.00000001368,  5.67966974902,       66.70484372000}, 
};


static const struct vsop uranus_radius_r3[RADIUS_R3] = {
    {     0.00001164663,  4.73440180792,       74.78159856730}, 
    {     0.00000212363,  3.34268349684,       63.73589830340}, 
    {     0.00000196315,  2.98101237100,       70.84944530420}, 
    {     0.00000104707,  0.95789279555,       11.04570026390}, 
    {     0.00000071681,  0.02528295071,       56.62235130260}, 
    {     0.00000072719,  0.99479831041,      149.56319713460}, 
    {     0.00000054933,  2.59936585639,        3.93215326310}, 
    {     0.00000034026,  3.82319495878,       76.26607127560}, 
    {     0.00000032081,  3.59825177872,      131.40394986990}, 
    {     0.00000029569,  3.44303690664,       85.82729883120}, 
    {     0.00000036377,  5.65035573026,       77.96299230500}, 
    {     0.00000027625,  0.42885477377,        3.18139373770}, 
    {     0.00000027552,  2.55709855563,       52.69019803950}, 
    {     0.00000024740,  5.14634979896,       78.71375183040}, 
    {     0.00000019382,  5.13444064222,       18.15924726470}, 
    {     0.00000015767,  0.37116951743,      447.79581952650}, 
    {     0.00000015441,  5.57271837433,      462.02291352810}, 
    {     0.00000015035,  3.84415419523,       73.29712585900}, 
    {     0.00000015450,  2.97572514360,      145.63104387150}, 
    {     0.00000017788,  0.00000000000,        0.00000000000}, 
    {     0.00000015958,  5.19915553861,       71.60020482960}, 
    {     0.00000010780,  6.02554585112,      138.51749687070}, 
    {     0.00000010347,  3.60350847669,      224.34479570190}, 
    {     0.00000007612,  1.47668980969,        1.48447270830}, 
    {     0.00000008140,  2.61444086595,       22.09140052780}, 
    {     0.00000007107,  5.43946774526,      269.92144674060}, 
    {     0.00000006459,  4.37142319461,      284.14854074220}, 
    {     0.00000006817,  0.01485937330,      151.04766984290}, 
    {     0.00000007811,  0.29898229022,      127.47179660680}, 
    {     0.00000005768,  4.22672716677,      373.01422095920}, 
    {     0.00000005105,  1.81797461354,      202.25339517410}, 
    {     0.00000004692,  2.78404575440,      120.35824960600}, 
    {     0.00000005071,  0.76641679640,       62.25142559510}, 
    {     0.00000004133,  1.88879300710,      209.36694217490}, 
    {     0.00000005201,  4.15791319343,      195.13984817330}, 
    {     0.00000003946,  1.83105030444,       72.33391801250}, 
    {     0.00000003582,  3.92592140377,      124.29040286910}, 
    {     0.00000004340,  3.99626115302,        9.56122755560}, 
    {     0.00000003739,  1.50894993813,      148.07872442630}, 
    {     0.00000003436,  1.99291271003,       65.22037101170}, 
    {     0.00000003835,  1.15614639932,      153.49535039770}, 
    {     0.00000003593,  0.94897593272,       92.94084583200}, 
    {     0.00000003950,  1.85721204646,      152.74459087230}, 
    {     0.00000003277,  1.40881404192,      351.81659230870}, 
    {     0.00000003058,  5.76662885271,      160.60889739850}, 
    {     0.00000002719,  5.64780369357,      134.58534360760}, 
    {     0.00000002800,  0.79480255927,      572.22923474750}, 
    {     0.00000002727,  6.00569967758,       12.53017297220}, 
    {     0.00000002524,  3.05071097098,      387.24131496080}, 
    {     0.00000002662,  1.98593312104,      450.97721326420}, 
    {     0.00000002391,  1.62282528307,      358.93013930950}, 
    {     0.00000002570,  2.81202618885,      213.29909543800}, 
    {     0.00000002291,  4.81424601791,      536.80451209540}, 
    {     0.00000002213,  2.20360299816,      465.95506679120}, 
    {     0.00000002345,  3.89530188536,       76.47851959670}, 
    {     0.00000001990,  6.00348345539,       77.22927912210}, 
    {     0.00000001836,  0.86993337572,      288.08069400530}, 
    {     0.00000002233,  4.20038854663,       45.57665103870}, 
    {     0.00000001745,  4.28595550732,       67.66805156650}, 
    {     0.00000001715,  5.36211200127,       84.34282612290}, 
    {     0.00000001640,  5.46719808619,      309.27832265580}, 
    {     0.00000001640,  3.86349580161,      458.84151979040}, 
    {     0.00000001728,  3.60055588821,       81.89514556810}, 
    {     0.00000001483,  3.46836166107,       59.80374504030}, 
    {     0.00000001463,  3.58895839694,      347.88443904560}, 
    {     0.00000001415,  1.82816992630,      497.44763618020}, 
    {     0.00000001399,  5.26616832831,      909.81873305460}, 
    {     0.00000001399,  3.66246604373,     1059.38193018920}, 
    {     0.00000001401,  4.64442933182,       96.87299909510}, 
};


static const struct vsop uranus_radius_r4[RADIUS_R4] = {
    {     0.00000053224,  3.00468894529,       74.78159856730}, 
    {     0.00000009887,  1.91399083603,       56.62235130260}, 
    {     0.00000007008,  5.08677527404,       11.04570026390}, 
    {     0.00000006718,  5.39509675772,      149.56319713460}, 
    {     0.00000003855,  5.18994119112,      131.40394986990}, 
    {     0.00000003316,  1.22839100759,       85.82729883120}, 
    {     0.00000002664,  0.44064577837,       63.73589830340},
    {     0.00000002309,  0.92380720934,      145.63104387150},
    {     0.00000002383,  6.21390585593,      358.93013930950},
    {     0.00000002288,  2.23425399117,      440.68227252570},
    {     0.00000002472,  3.28269448244,       18.15924726470},
    {     0.00000002837,  3.14159265359,        0.00000000000},
};


/* Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87
 * Calculate uranus rectangular heliocentric ecliptical coordinates
 * for given julian day. Values are in UA.
 * params : Julian day, rect coords */
void get_uranus_helio_coords(double JD, double * X, double * Y, double * Z)
{
	double t, t2, t3, t4, t5;
	double L0, L1, L2, L3, L4;
	double B0, B1, B2, B3;
	double R0, R1, R2, R3, R4;
	double L,B,R;

	/* get julian ephemeris day */
	t = (JD - 2451545.0) / 365250;
	t2 = t * t;
	t3 = t2 * t;
	t4 = t3 * t;
	t5 = t4 * t;

	/* calc L series */
	L0 = calc_series (uranus_longitude_l0, LONG_L0, t);
	L1 = calc_series (uranus_longitude_l1, LONG_L1, t);
	L2 = calc_series (uranus_longitude_l2, LONG_L2, t);
	L3 = calc_series (uranus_longitude_l3, LONG_L3, t);
	L4 = calc_series (uranus_longitude_l4, LONG_L4, t);
	L = (L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4);

	/* calc B series */
	B0 = calc_series (uranus_latitude_b0, LAT_B0, t);
	B1 = calc_series (uranus_latitude_b1, LAT_B1, t);
	B2 = calc_series (uranus_latitude_b2, LAT_B2, t);
	B3 = calc_series (uranus_latitude_b3, LAT_B3, t);
	B = (B0 + B1 * t + B2 * t2 + B3 * t3);

	/* calc R series */
	R0 = calc_series (uranus_radius_r0, RADIUS_R0, t);
	R1 = calc_series (uranus_radius_r1, RADIUS_R1, t);
	R2 = calc_series (uranus_radius_r2, RADIUS_R2, t);
	R3 = calc_series (uranus_radius_r3, RADIUS_R3, t);
	R4 = calc_series (uranus_radius_r4, RADIUS_R4, t);
	R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4);

	/* change to fk5 reference frame */
	vsop87_to_fk5(&L, &B, JD);

	/* convert to rectangular coord */
	sphe_to_rect(L, B, R, X, Y, Z);
}
