/*package org.stegosuite.ui.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stegosuite.image.format.ImageFormat;
import org.stegosuite.image.util.FileUtils;
import org.stegosuite.model.exception.SteganoEmbedException;
import org.stegosuite.model.exception.SteganoExtractException;
import org.stegosuite.model.exception.SteganoImageException;
import org.stegosuite.model.payload.Payload;
import org.stegosuite.model.payload.block.Block;
import org.stegosuite.model.payload.block.FileBlock;
import org.stegosuite.model.payload.block.MessageBlock;
import org.stegosuite.ui.gui.embedding.Embedding;
import org.stegosuite.ui.gui.embedding.EmbeddingFactory;

import com.beust.jcommander.JCommander;

import ch.qos.logback.classic.Level;

public class Cli {

	private String[] args;
	private Arguments arguments;
	private static final Logger LOG = LoggerFactory.getLogger(Cli.class);

	public Cli(String[] s) {
		args = s;
		parseCli();
	}

	private void parseCli() {
		arguments = new Arguments();
		JCommander jCommander = new JCommander(arguments, args);
		jCommander.setProgramName("stegosuite");
		if (arguments.isVerbose()) {
			ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger) LoggerFactory
					.getLogger(Logger.ROOT_LOGGER_NAME);
			rootLogger.setLevel(Level.DEBUG);
		}
		if (arguments.isEmbed()) {
			embed();
		} else if (arguments.isExtract()) {
			extract();
		} else if (arguments.isHelp()) {
			jCommander.usage();
			return;
		}
	}

	private void embed() {
		String steganogramPath = arguments.getSteganogramPath();
		String filePath = arguments.getFilePath();

		Payload payload = new Payload();
		payload.getBlocks().add(new MessageBlock(arguments.getMessage()));
		if (filePath != null) {
			payload.getBlocks().add(new FileBlock(filePath));
		}

		payload.setSteganoPassword(arguments.getSecretKey());
		payload.setEncryptionPassword(arguments.getSecretKey());

		File steganogramFile = new File(steganogramPath);
		String extension = FileUtils.getFileExtension(steganogramPath);
		ImageFormat image = ImageFormat.newInstance(extension);
		if (image == null) {
			String supportedFormats = String.join(", ", ImageFormat.getRegisteredImageExtensions().keySet());
			LOG.error("Error: Currently only these file types are supported: {}", supportedFormats);
			return;
		}

		Embedding embedding = EmbeddingFactory.getEmbedding(image);
		embedding.setPointFilter(1);
		if (arguments.isDisableNoiseDetection()) {
			embedding.setPointFilter(0);
		}

		try {
			image.load(steganogramFile);
			embedding.embed(payload, (embeddingMethod, embeddedImage) -> {
				try {
					String outputPath = FileUtils.addFileNameSuffix(steganogramFile.getAbsolutePath(), "_embed");
					embeddedImage.save(new File(outputPath));
				} catch (SteganoImageException e) {
					e.printStackTrace();
				}
			});
		} catch (SteganoEmbedException e) {
			e.printStackTrace();
		} catch (SteganoImageException e) {
			e.printStackTrace();
		}
	}

	private void extract() {
		String filePath = arguments.getSteganogramPath();

		Payload payload = new Payload();
		payload.setSteganoPassword(arguments.getSecretKey());
		payload.setEncryptionPassword(arguments.getSecretKey());

		String extension = FileUtils.getFileExtension(filePath);
		ImageFormat image = ImageFormat.newInstance(extension);
		if (image == null) {
			LOG.error("Error: Currently only gif and bmp file types are supported.");
			return;
		}

		File file = new File(filePath);
		try {
			image.load(file);
			Embedding embedding = EmbeddingFactory.getEmbedding(image);
			embedding.setPointFilter(1);
			if (arguments.isDisableNoiseDetection()) {
				embedding.setPointFilter(0);
			}
			embedding.extract(payload, (embeddingMethod) -> {
				for (Block block : payload.getBlocks()) {
					if (block.getIdentifier() == FileBlock.IDENTIFIER) {
						String outPath = FileUtils.changeFileName(filePath, ((FileBlock) block).getFileName());
						LOG.debug("Outputpath: {}", outPath);
						try {
							Files.write(Paths.get(outPath), ((FileBlock) block).getFileContent(),
									StandardOpenOption.CREATE);
						} catch (IOException e) {
							e.printStackTrace();
						}
					} else if (block.getIdentifier() == MessageBlock.IDENTIFIER) {
						LOG.info("Extracted message:{}", ((MessageBlock) block).getMessage());
					}
				}
			});
		} catch (SteganoExtractException e) {
			e.printStackTrace();
		} catch (SteganoImageException e) {
			e.printStackTrace();
		}
	}
}*/
