#!/bin/sh
# @(#)cc-config.sh	1.1 02/01/27 Copyright 2002 J. Schilling
###########################################################################
# Written 2002 by J. Schilling
###########################################################################
# Configuration script called to verify system default C-compiler.
# It tries to fall back to GCC if the system default could not be found.
###########################################################################
#@@C@@
###########################################################################

CC=$1
echo "Trying to find $CC"
#
# There are old shells that don't support the 'type' builtin.
# For this reason it is not a simple task to find out whether
# this compiler exists and works.
#
# First try to run the default C-compiler without args
#
$CC > /dev/null 2>&1
if [ $? = 0 ]; then
	echo "Found $CC"
	echo "Creating empty '$2'"
	:> $2
	exit
fi

#
# Now try to run the default C-compiler and check whether it creates
# any output (usualla an error message).
#
# This test will fail if the shell does redirect the error message
# "cc: not found". All shells I tested send this message to the stderr
# stream the shell itself is attached to and only redirects the output
# from the command. As there may no outout if there is no binary, this
# prooves the existence of the default compiler.
#
ccout=`$CC 2>&1`
if [ -n "$ccout" ]; then
	echo "Found $CC"
	echo "Creating empty '$2'"
	:> $2
	exit
fi

echo 'Trying to find GCC'

gcc -v 2> /dev/null && CC=gcc

if [ ".$CC" = ".$1" ]; then
	echo "GCC not found, keeping current global default"
	echo "Creating empty '$2'"
	:> $2
else
	echo "Found $CC"
	echo "Making $CC the default compiler in '$2'"
	echo DEFCCOM=$CC > $2
fi
